/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.validation.core;

import com.nxp.s32ds.ext.ide.validation.core.LaunchConfigurationMarker;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;

public class CdtLaunchConfigurationChecker {
    private static final String CONFIGURATION_PROJECT_NAME_ATTR = "org.eclipse.cdt.launch.PROJECT_ATTR";
    private static final String FILE_SEARCH = "launch";
    public static final String ATTR_MAPPED_RESOURCE = "org.eclipse.debug.core.MAPPED_RESOURCE_PATHS";
    public static final String ATTR_PRG_NAME = "org.eclipse.cdt.launch.PROGRAM_NAME";
    public static final String LAUTERBACH_DELEGATE = "com.lauterbach.trace32.debug.internal.core.T32LaunchConfigurationDelegate";

    public static IStatus checkLaunchConfiguration(IResource resource, IProgressMonitor monitor) {
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            ICProjectDescription desc = CCorePlugin.getDefault().getProjectDescription(project, true);
            if (desc != null) {
                try {
                    List<IFile> listLaunchFiles = CdtLaunchConfigurationChecker.launchFilesFinder((IContainer)resource);
                    return CdtLaunchConfigurationChecker.launchVaidation(listLaunchFiles, project, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private static IStatus launchVaidation(List<IFile> listLaunchFiles, IProject project, IProgressMonitor monitor) {
        MultiStatus ms = new MultiStatus("com.nxp.s32ds.validation.project", 0, new String(), null);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        for (IFile launchFile : listLaunchFiles) {
            if (!launchFile.exists()) continue;
            ILaunchConfiguration launchConfiguration = launchManager.getLaunchConfiguration(launchFile);
            try {
                boolean isValid = true;
                if (!CdtLaunchConfigurationChecker.isValidProjectNameAttribute(launchConfiguration, project.getName())) {
                    isValid = false;
                }
                if (!CdtLaunchConfigurationChecker.isValidProjectMappedResources(launchConfiguration, project.getName())) {
                    isValid = false;
                }
                if (!isValid) {
                    if (LaunchConfigurationMarker.containsMarker((IResource)launchFile)) continue;
                    ms.add(LaunchConfigurationMarker.createMarker((IResource)launchFile, (IProject)project, (String)project.getName()));
                    continue;
                }
                LaunchConfigurationMarker.delete((IResource)launchFile);
            }
            catch (CoreException e) {
                if (e.getMessage().contains(LAUTERBACH_DELEGATE)) {
                    LaunchConfigurationMarker.delete((IResource)launchFile);
                    LaunchConfigurationMarker.createMarkerProblem((IResource)launchFile, (IProject)project, (String)"missing specification of a launch type 'com.lauterbach.trace32.debug.internal.core.T32LaunchConfigurationDelegate' (missing plug-in)");
                    continue;
                }
                ms.add(e.getStatus());
            }
        }
        return ms;
    }

    private static boolean isValidProjectNameAttribute(ILaunchConfiguration launchConfiguration, String validValue) throws CoreException {
        boolean result = true;
        String projectNameAttribute = launchConfiguration.getAttribute(CONFIGURATION_PROJECT_NAME_ATTR, "");
        if (!projectNameAttribute.isEmpty()) {
            result = validValue.equals(projectNameAttribute);
        }
        return result;
    }

    private static boolean isValidProjectMappedResources(ILaunchConfiguration launchConfiguration, String validValue) throws CoreException {
        boolean result = true;
        List listMapedResources = launchConfiguration.getAttribute(ATTR_MAPPED_RESOURCE, new ArrayList());
        if (!listMapedResources.isEmpty()) {
            Optional<String> optResult = listMapedResources.stream().filter(e -> e.endsWith(validValue)).findAny();
            result = optResult.isPresent();
        }
        return result;
    }

    private static List<IFile> launchFilesFinder(IContainer container) throws CoreException {
        IResource[] members;
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            String fileExtension;
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                files.addAll(CdtLaunchConfigurationChecker.launchFilesFinder((IContainer)member));
            } else if (member instanceof IFile && (fileExtension = (file = (IFile)member).getFileExtension()) != null && fileExtension.contains(FILE_SEARCH)) {
                files.add(file);
            }
            ++n2;
        }
        return files;
    }
}

