/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp.interchange;

import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpVariables;
import com.nxp.s32ds.gte.isp.Import;
import com.nxp.s32ds.gte.isp.IspBuffer;
import com.nxp.s32ds.gte.isp.IspChannel;
import com.nxp.s32ds.gte.isp.IspDataType;
import com.nxp.s32ds.gte.isp.IspEngine;
import com.nxp.s32ds.gte.isp.IspFactory;
import com.nxp.s32ds.gte.isp.IspFdmaTransfer;
import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.gte.isp.IspIpuEngine;
import com.nxp.s32ds.gte.isp.IspMipiEngine;
import com.nxp.s32ds.gte.isp.IspOtherEngine;
import com.nxp.s32ds.gte.isp.IspPortIn;
import com.nxp.s32ds.gte.isp.IspPortOut;
import com.nxp.s32ds.gte.isp.IspTypeCamera;
import com.nxp.s32ds.gte.isp.IspTypeEng;
import com.nxp.s32ds.gte.isp.IspTypeIpu;
import com.nxp.s32ds.gte.isp.IspTypeMipi;
import com.nxp.s32ds.gte.isp.IspTypePortIn;
import com.nxp.s32ds.gte.isp.IspTypeViu;
import com.nxp.s32ds.gte.isp.IspTypeViuCamera;
import com.nxp.s32ds.gte.isp.IspViuEngine;
import com.nxp.s32ds.gte.isp.interchange.InterChangeActivator;
import com.nxp.s32ds.mdt.vpt.isp.core.vsdk.IspVsdkHelper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.osgi.service.log.LogService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IspDomParser {
    private static final String BUFFER_POSTFIX = "Buffer";
    private static final String ZERO = "0";
    private static final String DEFAULT_ONE = "1";
    private static final String ISPGRAPH = "com.freescale.VisGuiTool.GuiTool_ISP_MetaModel:ISP_GraphClass";
    private static final String GRAPH_KRN_DIR = "kernelsRootDirectory";
    private static final String GRAPH_NR_IMG_LN = "nrImage_Lines";
    private static final String HEADER = "headers";
    private static final String HEADER_USR_DEF = "userDefined";
    private static final String HEADER_PATH = "path";
    private static final String ENGINE = "engines";
    private static final String ID = "xmi:id";
    private static final String ENGINE_NAME = "name";
    private static final String XMI_TYPE = "xmi:type";
    private static final String ENGINE_INDEX = "engineIndex";
    private static final String ENGINE_PROCSTEPS = "nrProcessingSteps";
    private static final String ENGINE_PARAMS = "parameters";
    private static final String ENGINE_KERNEL = "kernel";
    private static final String ENGINE_TYPE_IPU = "com.freescale.VisGuiTool.GuiTool_ISP_MetaModel:ISP_IPU_Engine";
    private static final String ENGINE_TYPE_MIPI = "com.freescale.VisGuiTool.GuiTool_ISP_MetaModel:ISP_MIPI_Engine";
    private static final String ENGINE_TYPE_OTHER = "com.freescale.VisGuiTool.GuiTool_ISP_MetaModel:ISP_Other_Engine";
    private static final String ENGINE_TYPE_VIU = "com.freescale.VisGuiTool.GuiTool_ISP_MetaModel:ISP_VIU_Engine";
    private static final String ENGINE_TYPE = "engineType";
    private static final String ENGINE_OTHER_NR_LINES = "nrImage_Lines";
    private static final String ENGINE_MIPI_NRINPUT_IMG_LINES = "NrInputImageLines";
    private static final String ENGINE_MIPI_ATT_CAMERA = "attachedCameras";
    private static final String CAMERA_TYPE = "cameraType";
    private static final String PORTIN = "inports";
    private static final String PORTIN_DATATPYE = "dataType";
    private static final String PORTIN_LN_INCR = "lineIncrement";
    private static final String PORTIN_INDEX = "index";
    private static final String PORTIN_LN_START_PRC = "nrLines_StartProcessing";
    private static final String PORTIN_NR_READ_PX = "nrReadPixels";
    private static final String PORTIN_NR_PX_SKIPP = "nrPixels_Skipped";
    private static final String PORTIN_FIRST_LINE = "nrFirstLine";
    private static final String PORTIN_TYPE = "isp_portType";
    private static final String PORTIN_SOURCE = "source";
    private static final String PORTOUT = "outport";
    private static final String PORTOUT_PX_TRANSF = "nrPixelsToTransfer";
    private static final String PORTOUT_DATATYPE = "dataType";
    private static final String PORTOUT_OFFSET = "Offset";
    private static final String PORTOUT_INDEX = "index";
    private static final String BUFFER = "buffers";
    private static final String BUFFER_XSIZE = "xSize";
    private static final String BUFFER_YSIZE = "ySize";
    private static final String BUFFER_STRIDE = "stride";
    private static final String BUFFER_DATATYPE = "dataType";
    private static final String BUFFER_LINE_INC = "lineIncrement";
    private static final String BUFFER_DDR_TYPE = "com.freescale.VisGuiTool.GuiTool_ISP_MetaModel:ISP_DDRBuffer";
    private static final String BUFFER_TYPE = "xmi:type";
    private static final String CHANNEL = "channels";
    private static final String CHANNEL_NMB = "number";
    private static final String CHANNEL_FDMA = "fdma";
    private static final String FDMA = "fdmas";
    private static final String FDMA_NAME = "name";
    private static final String FDMA_PX_TRANSF = "nrPixelsToTransfer";
    private static final String FDMA_NR_LINE_START = "nrLines_StartProcessing";
    private static final String FDMA_NR_FIRST_LINE = "nrFirstLine";
    private static final String FDMA_LINE_INC = "lineIncrement";
    private static final String FDMA_SOURCE = "source";
    private static final String FDMA_TARGET = "target";
    private static final String OUTCONNECTORS = "outConnectors";
    private static final String OUTCONNECTORS_SRC = "source";
    private static final String OUTCONNECTORS_TRG = "target";
    private final Map<String, EObject> mapParsedObjects = new HashMap<String, EObject>();
    private final File file;
    private final IspGraph ispGraph;
    List<IspFdmaTransfer> lstFdmaFromDiagram = new ArrayList<IspFdmaTransfer>();

    IspDomParser(File file, IspGraph ispGraph) {
        this.file = file;
        this.ispGraph = ispGraph;
        this.lstFdmaFromDiagram.clear();
    }

    public void parse() throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(this.file.getAbsolutePath());
        doc.getDocumentElement().normalize();
        String nameModel = this.file.getName();
        int index = nameModel.lastIndexOf(46);
        if (index != -1) {
            this.ispGraph.setName(nameModel.substring(0, index));
        } else {
            this.ispGraph.setName(nameModel);
        }
        NodeList nListGraph = doc.getElementsByTagName(ISPGRAPH);
        IspDomParser.setGraphAttributes(nListGraph, this.ispGraph);
        NodeList nListEngines = doc.getElementsByTagName(ENGINE);
        List<IspEngine> lstEngines = this.getEngines(nListEngines);
        NodeList nListBuffers = doc.getElementsByTagName(BUFFER);
        List<IspBuffer> lstBuffers = this.getBuffers(nListBuffers);
        NodeList nListHeaders = doc.getElementsByTagName(HEADER);
        List<Import> lstHeaders = this.getImports(nListHeaders);
        NodeList nListFdma = doc.getElementsByTagName(FDMA);
        this.lstFdmaFromDiagram.addAll(this.getFdmaTransfer(nListFdma));
        NodeList nListConnetors = doc.getElementsByTagName(OUTCONNECTORS);
        this.connectPortOutToBuffer(nListConnetors);
        NodeList nListPortIn = doc.getElementsByTagName(PORTIN);
        this.connectPortInToChannel(nListPortIn);
        NodeList nListChannels = doc.getElementsByTagName(CHANNEL);
        this.connectChannelToFdma(nListChannels);
        this.connectFdmaToDdrBuffer(nListFdma);
        this.ispGraph.getEngines().addAll(lstEngines);
        this.ispGraph.getBuffers().addAll(lstBuffers);
        this.ispGraph.getHeaders().addAll(lstHeaders);
        this.ispGraph.getFdmas().addAll(this.lstFdmaFromDiagram);
    }

    private static void setGraphAttributes(NodeList nListGraph, IspGraph ispGraph) {
        int i = 0;
        while (i < nListGraph.getLength()) {
            Node nodeGraph = nListGraph.item(i);
            if (nodeGraph.getNodeType() == 1) {
                Element eElement = (Element)nodeGraph;
                String kernelDir = eElement.getAttribute(GRAPH_KRN_DIR);
                ispGraph.setKernelsRootDirectory(kernelDir);
                String nrImgLine = eElement.getAttribute("nrImage_Lines");
                ispGraph.setNrImageLines(nrImgLine);
            }
            ++i;
        }
    }

    private List<IspEngine> getEngines(NodeList listEngines) {
        ArrayList<IspEngine> listEngins = new ArrayList<IspEngine>();
        int i = 0;
        while (i < listEngines.getLength()) {
            block20: {
                IspIpuEngine engine;
                Element eElement;
                Node nodeEngine;
                block22: {
                    String typeEngine;
                    block24: {
                        block23: {
                            String typeMipiEngine;
                            block21: {
                                nodeEngine = listEngines.item(i);
                                if (nodeEngine.getNodeType() != 1) break block20;
                                eElement = (Element)nodeEngine;
                                typeEngine = eElement.getAttribute("xmi:type");
                                engine = null;
                                if (!typeEngine.equals(ENGINE_TYPE_IPU)) break block21;
                                IspIpuEngine ipuEngine = IspFactory.eINSTANCE.createIspIpuEngine();
                                String typeIpuEngine = eElement.getAttribute(ENGINE_TYPE);
                                if (typeIpuEngine != null && !typeIpuEngine.isEmpty()) {
                                    ipuEngine.setEngineType(IspTypeIpu.valueOf((String)typeIpuEngine));
                                }
                                ipuEngine.setKernel(eElement.getAttribute(ENGINE_KERNEL));
                                ipuEngine.setNrProcessingSteps(eElement.getAttribute(ENGINE_PROCSTEPS));
                                ipuEngine.setParameters(eElement.getAttribute(ENGINE_PARAMS));
                                engine = ipuEngine;
                                break block22;
                            }
                            if (!typeEngine.equals(ENGINE_TYPE_MIPI)) break block23;
                            IspMipiEngine mipiEngine = IspFactory.eINSTANCE.createIspMipiEngine();
                            mipiEngine.setNrInputLineImages(IspDomParser.resolveStringValue(eElement.getAttribute(ENGINE_MIPI_NRINPUT_IMG_LINES)));
                            String attCamera = eElement.getAttribute(ENGINE_MIPI_ATT_CAMERA);
                            if (!attCamera.isEmpty()) {
                                mipiEngine.setAttachedCameras(eElement.getAttribute(ENGINE_MIPI_ATT_CAMERA));
                            }
                            if ((typeMipiEngine = eElement.getAttribute(ENGINE_TYPE)) != null && !typeMipiEngine.isEmpty()) {
                                mipiEngine.setEngineType(IspTypeMipi.valueOf((String)typeMipiEngine));
                            } else {
                                mipiEngine.setEngineType(IspTypeMipi.MIPICSI0);
                            }
                            String typeMipiCamera = eElement.getAttribute(CAMERA_TYPE);
                            if (typeMipiCamera.isEmpty()) {
                                mipiEngine.setCameraType(IspTypeCamera.CSI_SONY224.getName());
                            } else {
                                mipiEngine.setCameraType("CSI_" + typeMipiCamera);
                            }
                            engine = mipiEngine;
                            break block22;
                        }
                        if (!typeEngine.equals(ENGINE_TYPE_OTHER)) break block24;
                        IspOtherEngine otherEngine = IspFactory.eINSTANCE.createIspOtherEngine();
                        String typeOtherEngine = eElement.getAttribute(ENGINE_TYPE);
                        if (typeOtherEngine != null && !typeOtherEngine.isEmpty()) {
                            IspTypeEng type = IspTypeEng.getByName((String)typeOtherEngine);
                            otherEngine.setEngineType(type);
                        }
                        String nrImage = eElement.getAttribute("nrImage_Lines");
                        otherEngine.setNrImage(nrImage);
                        engine = otherEngine;
                        break block22;
                    }
                    if (!typeEngine.equals(ENGINE_TYPE_VIU)) break block20;
                    IspViuEngine viuEngine = IspFactory.eINSTANCE.createIspViuEngine();
                    String type = eElement.getAttribute(ENGINE_TYPE);
                    IspTypeViu ispTypeViu = IspTypeViu.get((String)type);
                    if (ispTypeViu == null) {
                        ispTypeViu = IspTypeViu.VIU0;
                    }
                    viuEngine.setEngineType(ispTypeViu);
                    String nrInputImageLines = IspDomParser.resolveStringValue(eElement.getAttribute(ENGINE_MIPI_NRINPUT_IMG_LINES));
                    viuEngine.setNrInputLineImages(nrInputImageLines);
                    String attribute = eElement.getAttribute(CAMERA_TYPE);
                    if (attribute == null || attribute.trim().isEmpty()) {
                        viuEngine.setCameraType(IspTypeViuCamera.VIU_OV10635.getLiteral());
                    } else {
                        viuEngine.setCameraType("VIU_" + attribute);
                    }
                    engine = viuEngine;
                }
                String idEngine = eElement.getAttribute(ID);
                String engineIngdex = eElement.getAttribute(ENGINE_INDEX);
                if (engineIngdex != null && !engineIngdex.isEmpty()) {
                    engine.setEngineIndex(Integer.valueOf(engineIngdex).intValue());
                }
                engine.setName(eElement.getAttribute("name"));
                NodeList listChild = nodeEngine.getChildNodes();
                int j = 0;
                while (j < listChild.getLength()) {
                    Node nodePort = listChild.item(j);
                    if (nodePort.getNodeType() == 1) {
                        Element eElm = (Element)nodePort;
                        if (nodePort.getNodeName().equals(PORTIN)) {
                            IspPortIn portIn = this.getPortIn(eElm);
                            portIn.setContainingNode((IspEngine)engine);
                            engine.getPortIn().add((Object)portIn);
                        } else if (nodePort.getNodeName().equals(PORTOUT)) {
                            IspPortOut portOut = this.getPortOut(eElm);
                            engine.getPortOut().add((Object)portOut);
                        }
                    }
                    ++j;
                }
                this.mapParsedObjects.put(idEngine, (EObject)engine);
                listEngins.add((IspEngine)engine);
            }
            ++i;
        }
        return listEngins;
    }

    private IspPortIn getPortIn(Element eElement) {
        IspPortIn portIn = IspFactory.eINSTANCE.createIspPortIn();
        String portId = eElement.getAttribute(ID);
        String portDataType = eElement.getAttribute("dataType");
        if (portDataType != null && !portDataType.isEmpty()) {
            portIn.setDataType(IspDataType.valueOf((String)portDataType));
        }
        String index = eElement.getAttribute("index");
        portIn.setIndex(Integer.valueOf(IspDomParser.resolveStringValue(index)).intValue());
        portIn.setLineIncrement(IspDomParser.resolveStringValueWithDefault(eElement.getAttribute("lineIncrement")));
        String nrFirstLine = eElement.getAttribute("nrFirstLine");
        portIn.setNrFirstLine(IspDomParser.resolveStringValue(nrFirstLine));
        String nrLinesStartProcessing = eElement.getAttribute("nrLines_StartProcessing");
        portIn.setNrLinesStartProcessing(IspDomParser.resolveStringValueWithDefault(nrLinesStartProcessing));
        String nrPxSkipped = eElement.getAttribute(PORTIN_NR_PX_SKIPP);
        portIn.setNrPixelsSkipped(IspDomParser.resolveStringValue(nrPxSkipped));
        String nrPxRead = eElement.getAttribute(PORTIN_NR_READ_PX);
        portIn.setNrReadPixels(IspDomParser.resolveStringValue(nrPxRead));
        String portType = eElement.getAttribute(PORTIN_TYPE);
        if (portType != null && !portType.isEmpty()) {
            portIn.setPortType(IspTypePortIn.valueOf((String)portType));
        }
        this.mapParsedObjects.put(portId, (EObject)portIn);
        return portIn;
    }

    private IspPortOut getPortOut(Element eElement) {
        IspPortOut portOut = IspFactory.eINSTANCE.createIspPortOut();
        String portId = eElement.getAttribute(ID);
        String portDataType = eElement.getAttribute("dataType");
        if (portDataType != null && !portDataType.isEmpty()) {
            portOut.setDataType(IspDataType.valueOf((String)portDataType));
        }
        String portIndex = eElement.getAttribute("index");
        portOut.setIndex(Integer.valueOf(IspDomParser.resolveStringValue(portIndex)).intValue());
        String nrPixToTransf = eElement.getAttribute("nrPixelsToTransfer");
        portOut.setNrPixelsToTransfer(IspDomParser.resolveStringValue(nrPixToTransf));
        String offset = eElement.getAttribute(PORTOUT_OFFSET);
        portOut.setOffset(IspDomParser.resolveStringValue(offset));
        this.mapParsedObjects.put(portId, (EObject)portOut);
        return portOut;
    }

    private List<IspBuffer> getBuffers(NodeList nListBuffer) {
        ArrayList<IspBuffer> lstBuffers = new ArrayList<IspBuffer>();
        int i = 0;
        while (i < nListBuffer.getLength()) {
            Node nodeBuffer = nListBuffer.item(i);
            if (nodeBuffer.getNodeType() == 1) {
                Element eElement = (Element)nodeBuffer;
                String bufferType = eElement.getAttribute("xmi:type");
                Object buffer = null;
                buffer = bufferType.equals(BUFFER_DDR_TYPE) ? IspFactory.eINSTANCE.createIspDdrBuffer() : IspFactory.eINSTANCE.createIspBuffer();
                String bufferID = eElement.getAttribute(ID);
                String bufferDataType = eElement.getAttribute("dataType");
                if (bufferDataType != null && !bufferDataType.isEmpty()) {
                    buffer.setDataType(IspDataType.valueOf((String)bufferDataType));
                }
                String bufferInc = eElement.getAttribute("lineIncrement");
                buffer.setLineIncrement(IspDomParser.resolveStringValueWithDefault(bufferInc));
                buffer.setStride(IspDomParser.resolveStringValue(eElement.getAttribute(BUFFER_STRIDE)));
                buffer.setXSize(IspDomParser.resolveStringValue(eElement.getAttribute(BUFFER_XSIZE)));
                buffer.setYSize(IspDomParser.resolveStringValue(eElement.getAttribute(BUFFER_YSIZE)));
                NodeList listChild = nodeBuffer.getChildNodes();
                int j = 0;
                while (j < listChild.getLength()) {
                    Node nodeChannel = listChild.item(j);
                    if (nodeChannel.getNodeType() == 1 && nodeChannel.getNodeName().equals(CHANNEL)) {
                        IspChannel channel = this.getChannel(nodeChannel);
                        buffer.getChannels().add((Object)channel);
                    }
                    ++j;
                }
                this.mapParsedObjects.put(bufferID, (EObject)buffer);
                lstBuffers.add((IspBuffer)buffer);
            }
            ++i;
        }
        return lstBuffers;
    }

    private IspChannel getChannel(Node nodeChannel) {
        Element eElement = (Element)nodeChannel;
        IspChannel channel = IspFactory.eINSTANCE.createIspChannel();
        String channelID = eElement.getAttribute(ID);
        String channelNumb = eElement.getAttribute(CHANNEL_NMB);
        channel.setNumber(Integer.valueOf(IspDomParser.resolveStringValue(channelNumb)).intValue());
        this.mapParsedObjects.put(channelID, (EObject)channel);
        return channel;
    }

    private List<Import> getImports(NodeList nListHeaders) {
        ArrayList<Import> lstImports = new ArrayList<Import>();
        int i = 0;
        while (i < nListHeaders.getLength()) {
            Node nodeImport = nListHeaders.item(i);
            if (nodeImport.getNodeType() == 1) {
                Element eElement = (Element)nodeImport;
                String isDef = eElement.getAttribute(HEADER_USR_DEF);
                Import ispImport = IspFactory.eINSTANCE.createImport();
                ispImport.setUserDefined(Boolean.parseBoolean(isDef));
                ispImport.setPath(eElement.getAttribute(HEADER_PATH));
                this.mapParsedObjects.put(eElement.getAttribute(ID), (EObject)ispImport);
                lstImports.add(ispImport);
            }
            ++i;
        }
        return lstImports;
    }

    private List<IspFdmaTransfer> getFdmaTransfer(NodeList nListFdma) {
        int i = 0;
        while (i < nListFdma.getLength()) {
            Node nodeFdma = nListFdma.item(i);
            if (nodeFdma.getNodeType() == 1) {
                Element eElement = (Element)nodeFdma;
                IspFdmaTransfer ispFdma = IspFactory.eINSTANCE.createIspFdmaTransfer();
                String fdmaId = eElement.getAttribute(ID);
                ispFdma.setLineIncrement(IspDomParser.resolveStringValueWithDefault(eElement.getAttribute("lineIncrement")));
                String name = eElement.getAttribute("name");
                ispFdma.setName(name);
                String firstLine = eElement.getAttribute("nrFirstLine");
                ispFdma.setNrFirstLine(IspDomParser.resolveStringValue(firstLine));
                String lineStartPrc = eElement.getAttribute("nrLines_StartProcessing");
                ispFdma.setNrLinesStartProcessing(IspDomParser.resolveStringValueWithDefault(lineStartPrc));
                String pxToTransfer = eElement.getAttribute("nrPixelsToTransfer");
                ispFdma.setNrPixelsToTransfer(IspDomParser.resolveStringValue(pxToTransfer));
                this.mapParsedObjects.put(fdmaId, (EObject)ispFdma);
                this.lstFdmaFromDiagram.add(ispFdma);
            }
            ++i;
        }
        return this.lstFdmaFromDiagram;
    }

    private void connectPortOutToBuffer(NodeList nListConnetors) {
        int i = 0;
        while (i < nListConnetors.getLength()) {
            Node nodeConnector = nListConnetors.item(i);
            if (nodeConnector.getNodeType() == 1) {
                Element eElement = (Element)nodeConnector;
                String idSource = eElement.getAttribute("source");
                String idTarget = eElement.getAttribute("target");
                IspPortOut portOut = (IspPortOut)this.mapParsedObjects.get(idSource);
                IspBuffer buffer = (IspBuffer)this.mapParsedObjects.get(idTarget);
                if (portOut != null && buffer != null) {
                    String nameBuff = String.valueOf(portOut.getContainingNode().getName()) + BUFFER_POSTFIX + portOut.getIndex();
                    buffer.setName(nameBuff);
                    portOut.setBuffer(buffer);
                    buffer.getPortOut().add((Object)portOut);
                }
            }
            ++i;
        }
    }

    private void connectPortInToChannel(NodeList nListPortIn) {
        int i = 0;
        while (i < nListPortIn.getLength()) {
            Node nodePortIn = nListPortIn.item(i);
            if (nodePortIn.getNodeType() == 1) {
                Element eElement = (Element)nodePortIn;
                String portId = eElement.getAttribute(ID);
                String portSrc = eElement.getAttribute("source");
                IspPortIn portIn = (IspPortIn)this.mapParsedObjects.get(portId);
                IspChannel channel = (IspChannel)this.mapParsedObjects.get(portSrc);
                if (portIn != null && channel != null) {
                    portIn.setSource(channel);
                    channel.setBufferToNode(portIn);
                }
            }
            ++i;
        }
    }

    private void connectChannelToFdma(NodeList nListChannels) {
        int i = 0;
        while (i < nListChannels.getLength()) {
            Node nodeChannel = nListChannels.item(i);
            if (nodeChannel.getNodeType() == 1) {
                Element eElement = (Element)nodeChannel;
                String channelId = eElement.getAttribute(ID);
                String channelFdma = eElement.getAttribute(CHANNEL_FDMA);
                IspFdmaTransfer fdma = (IspFdmaTransfer)this.mapParsedObjects.get(channelFdma);
                IspChannel channel = (IspChannel)this.mapParsedObjects.get(channelId);
                if (fdma != null && channel != null) {
                    IspFdmaTransfer ispFdma = channel.getFdma();
                    ispFdma = fdma;
                    ispFdma.getSource().add((Object)channel);
                }
            }
            ++i;
        }
    }

    private void connectFdmaToDdrBuffer(NodeList nListFdma) {
        int i = 0;
        while (i < nListFdma.getLength()) {
            Node nodeFdma = nListFdma.item(i);
            if (nodeFdma.getNodeType() == 1) {
                Element eElement = (Element)nodeFdma;
                String idFdma = eElement.getAttribute(ID);
                String srcFdma = eElement.getAttribute("source");
                String trgFdma = eElement.getAttribute("target");
                IspFdmaTransfer ispFdma = (IspFdmaTransfer)this.mapParsedObjects.get(idFdma);
                IspChannel ispChannel = (IspChannel)this.mapParsedObjects.get(srcFdma);
                IspBuffer ispBuffer = (IspBuffer)this.mapParsedObjects.get(trgFdma);
                if (ispFdma != null) {
                    if (ispChannel != null) {
                        ispFdma.getSource().add((Object)ispChannel);
                    }
                    if (ispBuffer != null) {
                        ispBuffer.setName(String.valueOf(ispFdma.getName()) + BUFFER_POSTFIX);
                        ispFdma.getTarget().add((Object)ispBuffer);
                    }
                }
            }
            ++i;
        }
    }

    public void resolvePath() {
        block5: {
            RcpVariable vsdkVariable = IspVsdkHelper.getInstance().getVsdkVariable();
            try {
                Path modelPath = Paths.get(this.file.getAbsolutePath(), new String[0]);
                if (!this.ispGraph.getHeaders().isEmpty()) {
                    EList lstHeaders = this.ispGraph.getHeaders();
                    for (Import it : lstHeaders) {
                        Path pathToHeader = modelPath.getParent().resolve(Paths.get(it.getPath(), new String[0])).normalize();
                        String relativePath = RcpVariables.INSTANCE.relativize(vsdkVariable, pathToHeader);
                        it.setPath(relativePath);
                        it.setFileName(pathToHeader.getFileName().toString());
                    }
                }
                if (!this.ispGraph.getKernelsRootDirectory().isEmpty()) {
                    Path pathToKernelRoot = modelPath.getParent().resolve(Paths.get(this.ispGraph.getKernelsRootDirectory(), new String[0]));
                    String relativePath = RcpVariables.INSTANCE.relativize(vsdkVariable, pathToKernelRoot);
                    this.ispGraph.setKernelsRootDirectory(relativePath);
                }
            }
            catch (CoreException e) {
                LogService logger = InterChangeActivator.getLogger();
                if (logger == null) break block5;
                logger.log(1, e.getMessage(), (Throwable)e);
            }
        }
    }

    private static String resolveStringValue(String value) {
        if (value == null || value.isEmpty()) {
            return ZERO;
        }
        return value;
    }

    private static String resolveStringValueWithDefault(String value) {
        if (value == null || value.isEmpty()) {
            return DEFAULT_ONE;
        }
        return value;
    }
}

