/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.collateral.internal.core.handlers;

import com.nxp.s32ds.cle.ide.collateral.internal.core.CollateralCoreActivator;
import com.nxp.s32ds.cle.ide.collateral.internal.core.handlers.CollateralManifestParserHandler;
import com.nxp.s32ds.cle.ide.collateral.internal.core.handlers.Messages;
import com.nxp.s32ds.cle.ide.collateral.internal.core.marker.CollateralManifestMarker;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CollateralLoadHandler {
    public static void loadFromFile(Map.Entry<String, SoftwareManagerComponent> entry) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (CollateralCoreActivator.getDefault().getCollateralRegistry() == null) {
            CollateralCoreActivator.getDefault().logError(Messages.CollateralLoadHandler_NotExistCollateralService);
            CollateralManifestMarker.createMarker((IResource)workspaceRoot, Messages.CollateralLoadHandler_NotExistCollateralService);
            return;
        }
        if (entry.getKey() == null) {
            CollateralCoreActivator.getDefault().logError(Messages.CollateralLoadHandler_PathIsNull);
            CollateralManifestMarker.createMarker((IResource)workspaceRoot, Messages.CollateralLoadHandler_PathIsNull);
            return;
        }
        if (entry.getValue() == null) {
            String message = Messages.bind((String)Messages.CollateralLoadHandler_ManifestInComponentIsNull, (Object)entry.getKey());
            CollateralCoreActivator.getDefault().logError(message);
            CollateralManifestMarker.createMarker((IResource)workspaceRoot, message);
            return;
        }
        IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        File file = null;
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            CollateralManifestParserHandler dh = new CollateralManifestParserHandler();
            file = new File(stringVariableManager.performStringSubstitution(entry.getKey()));
            if (!file.exists()) {
                String message = Messages.bind((String)Messages.CollateralLoadHandler_PathIsNotExist, (Object)entry.getKey());
                CollateralCoreActivator.getDefault().logError(message);
                CollateralManifestMarker.createMarker((IResource)workspaceRoot, message);
                return;
            }
            try {
                Throwable message = null;
                Object var7_13 = null;
                try (FileInputStream is = new FileInputStream(file);){
                    saxParser.parse((InputStream)is, (DefaultHandler)dh);
                    dh.updateCollateralRegistry();
                }
                catch (Throwable throwable) {
                    if (message == null) {
                        message = throwable;
                    } else if (message != throwable) {
                        message.addSuppressed(throwable);
                    }
                    throw message;
                }
            }
            catch (IOException e) {
                CollateralManifestMarker.createMarker((IResource)workspaceRoot, e.getMessage());
                CollateralCoreActivator.getDefault().logError(e.getMessage());
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            if (file != null) {
                CollateralManifestMarker.createMarker((IResource)workspaceRoot, file.getAbsolutePath(), e.getMessage());
                CollateralCoreActivator.getDefault().logError(file + e.getMessage());
            } else {
                CollateralCoreActivator.getDefault().logError(e.getMessage());
                CollateralManifestMarker.createMarker((IResource)workspaceRoot, e.getMessage());
            }
        }
        catch (CoreException e) {
            CollateralManifestMarker.createMarker((IResource)workspaceRoot, e.getMessage());
            CollateralCoreActivator.getDefault().logError(e.getMessage());
        }
    }
}

