/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources.path;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import com.nxp.s32ds.ext.ide.resources.ResourcesActivator;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectDirectoryFileSystemValidator
implements IValidator {
    public static final String ID = "project.directory.validator";

    public IStatus validate(Object path) {
        if (path instanceof String) {
            Path fullPath = Paths.get((String)path, new String[0]);
            if (Files.exists(fullPath, new LinkOption[0])) {
                String message = NLS.bind((String)ResourcesMessages.ProjectNameValidator_e_name_already_exists, (Object)fullPath.toString());
                return new Status(4, "com.nxp.s32ds.ext.ide.resources", message);
            }
            if (!this.canCreate(fullPath)) {
                String message = NLS.bind((String)ResourcesMessages.ProjectNameValidator_e_cant_write, (Object)fullPath.toString());
                return new Status(4, "com.nxp.s32ds.ext.ide.resources", message);
            }
            return Status.OK_STATUS;
        }
        return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ProjectPathValidator_invalid_path);
    }

    private boolean canCreate(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                IFileStore fs = EFS.getStore((URI)path.toUri());
                IFileInfo f = fs.fetchInfo();
                if (f.exists() && f.isDirectory()) {
                    return !f.getAttribute(2);
                }
            }
            catch (CoreException e) {
                ResourcesActivator.log(e.getStatus());
            }
        } else if (path.toAbsolutePath().getParent() != null) {
            return this.canCreate(path.toAbsolutePath().getParent());
        }
        return false;
    }
}

