/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources.path;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import java.nio.file.Paths;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class PathLengthValidator
implements IValidator {
    private static final boolean IS_WIN = Platform.getOS().equals("win32");
    private static final int MAX_PATH_WIN = 240;
    private static final int MAX_NAME_LINUX = 234;
    private static final int MAX_INT_DEPTH = 50;
    public static final String ID = "path.lengs.validator";

    public IStatus validate(Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            return Paths.get(strValue, new String[0]).isAbsolute() ? this.checkLength(strValue) : this.checkLengthForProjectName(strValue);
        }
        return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ResourceNameValidator_e_name_invalid);
    }

    private IStatus checkLength(String projectPath) {
        int indexProj1 = projectPath.lastIndexOf(92) + 1;
        int indexProj2 = projectPath.lastIndexOf(47) + 1;
        int lastIndex = Math.max(indexProj1, indexProj2);
        String wsPath = projectPath.substring(0, lastIndex - 1);
        String projectName = projectPath.substring(lastIndex);
        return this.validatePath(projectName, wsPath);
    }

    private IStatus checkLengthForProjectName(String projectName) {
        String wsPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        return this.validatePath(projectName, wsPath);
    }

    private IStatus validatePath(String projectName, String wsPath) {
        if (IS_WIN) {
            int pathLength = wsPath.length() + projectName.length() + 1 + 50 + projectName.length();
            if (pathLength > 240) {
                return new Status(4, "com.nxp.s32ds.ext.ide.resources", NLS.bind((String)ResourcesMessages.ProjectNameLong_win, (Object)(wsPath.length() % 2 == 0 ? (pathLength - 240) / 2 + 1 : (pathLength - 240) / 2)));
            }
        } else if (projectName.length() > 234) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", NLS.bind((String)ResourcesMessages.ProjectNameLong_Linux, (Object)(projectName.length() - 234)));
        }
        return Status.OK_STATUS;
    }
}

