/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import java.util.Arrays;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ResourceNameValidator
implements IValidator {
    public static char[] SPECIAL_CHARACTERS = new char[]{'<', '>', ':', '/', '\\', '|', '?', '*', '\"', '@', '#', '=', ';', '%'};
    private static final String[] INVALID_RESOURCE_BASENAMES;
    private static final String[] INVALID_RESOURCE_FULLNAMES;
    public static final String ID = "resource.name.validator";

    static {
        if (ResourceNameValidator.isWindowsPlatform()) {
            INVALID_RESOURCE_BASENAMES = new String[]{"aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn", "model"};
            Arrays.sort(INVALID_RESOURCE_BASENAMES);
            INVALID_RESOURCE_FULLNAMES = new String[]{"clock$"};
        } else {
            INVALID_RESOURCE_BASENAMES = new String[]{"model"};
            INVALID_RESOURCE_FULLNAMES = new String[0];
        }
    }

    private static boolean isWindowsPlatform() {
        String osName = System.getProperty("os.name", "undefined").toLowerCase();
        return osName.indexOf("win") >= 0;
    }

    public IStatus validate(Object projName) {
        if (projName instanceof String) {
            String name = (String)projName;
            IStatus result = this.doValidate(name);
            if (!result.isOK()) {
                String msg = NLS.bind((String)ResourcesMessages.ResourceNameValidator_e_name_resource_invalid, (Object)name);
                return new Status(result.getSeverity(), result.getPlugin(), result.getCode(), msg, result.getException());
            }
            return result;
        }
        return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ResourceNameValidator_e_name_invalid);
    }

    private IStatus doValidate(String segment) {
        IStatus result = this.validateName(segment);
        if (!result.isOK()) {
            return result;
        }
        char[] chars = SPECIAL_CHARACTERS;
        int i = 0;
        while (i < chars.length) {
            if (segment.indexOf(chars[i]) != -1) {
                String pattern = ResourcesMessages.ResourceNameValidator_e_name_invalid_character;
                String message = NLS.bind((String)pattern, (Object)String.valueOf(chars[i]), (Object)segment);
                return new Status(4, "com.nxp.s32ds.ext.ide.resources", message);
            }
            ++i;
        }
        return result;
    }

    private IStatus validateName(String segment) {
        if (segment == null) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ResourceNameValidator_e_name_invalid);
        }
        if (segment.length() == 0) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", Messages.resources_nameEmpty);
        }
        if (!this.isNameValid(segment)) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ResourceNameValidator_e_name_invalid);
        }
        return Status.OK_STATUS;
    }

    private boolean isNameValid(String name) {
        String basename;
        if (name.equals(".") || name.equals("..")) {
            return false;
        }
        int length = name.length();
        if (length == 0) {
            return false;
        }
        char lastChar = name.charAt(length - 1);
        if (lastChar == '.') {
            return false;
        }
        if (Character.isWhitespace(lastChar)) {
            return false;
        }
        int dot = name.indexOf(46);
        String string = basename = dot == -1 ? name : name.substring(0, dot);
        if (Arrays.binarySearch(INVALID_RESOURCE_BASENAMES, basename.toLowerCase()) >= 0) {
            return false;
        }
        return Arrays.binarySearch(INVALID_RESOURCE_FULLNAMES, name.toLowerCase()) < 0;
    }
}

