/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.enums;

import com.nxp.s32ds.ext.orbit.c.CParseException;
import com.nxp.s32ds.ext.orbit.c.enums.CEnums;
import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpVariables;
import com.nxp.s32ds.mdt.icf.internal.enums.IcfEnumsActivator;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;

public class IcfEnum {
    private final RcpVariable variable;
    private final String pathToHeader;
    private final String enumName;
    private List<String> lastNames;
    private Path lastVariablePath;

    public IcfEnum(RcpVariable variable, String pathToHeader, String enumName) {
        if (variable == null) {
            throw new IllegalArgumentException("variable is null.");
        }
        if (pathToHeader == null) {
            throw new IllegalArgumentException("pathToHeader is null.");
        }
        if (enumName == null) {
            throw new IllegalArgumentException("enumName is null.");
        }
        this.variable = variable;
        this.pathToHeader = pathToHeader;
        this.enumName = enumName;
    }

    public List<String> getNames() {
        Path variablePath;
        try {
            variablePath = RcpVariables.INSTANCE.getPath(this.variable);
        }
        catch (CoreException e) {
            IcfEnumsActivator.getInstance().log(e.getStatus());
            return Collections.emptyList();
        }
        if (variablePath.equals(this.lastVariablePath) && this.lastNames != null) {
            return this.lastNames;
        }
        this.lastVariablePath = variablePath;
        this.lastNames = null;
        Path realPathToHeader = variablePath.resolve(this.pathToHeader);
        try {
            this.lastNames = Collections.unmodifiableList(this.scanNames(realPathToHeader));
        }
        catch (CoreException e) {
            IcfEnumsActivator.getInstance().log(e.getStatus());
            this.lastNames = Collections.emptyList();
        }
        return this.lastNames;
    }

    protected List<String> scanNames(Path path) throws CoreException {
        return IcfEnum.scanNames(path, this.enumName);
    }

    public static List<String> scanNames(Path pathToHeader, String enumName) throws CoreException {
        try {
            return CEnums.scanNames((Path)pathToHeader, (String)enumName);
        }
        catch (CParseException e) {
            throw new CoreException(IcfEnumsActivator.getInstance().createError(e.getMessage(), e));
        }
    }
}

