/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.isp.internal.ui.wizards;

import com.nxp.s32ds.vgt.vpt.isp.internal.ui.Messages;
import com.nxp.s32ds.vgt.vpt.isp.internal.ui.wizards.IspProjectWizardPage;
import com.nxp.s32ds.vgt.vpt.isp.internal.ui.wizards.mvc.ImportSourcesMvc;
import com.nxp.s32ds.vgt.vpt.isp.internal.ui.wizards.mvc.IspGraphDiagramMvc;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class IspImportWizardPage
extends IspProjectWizardPage {
    public static final int ISPGRAPH_DIAGRAM = 5;
    private IspGraphDiagramMvc ispDiagramMvc;
    private ImportSourcesMvc importSourcesMvc;

    public IspImportWizardPage() {
        super("IspImportWizardPage");
        this.setTitle(Messages.IspImportWizardPage_isp_import_wizard);
        this.setDescription(Messages.IspImportWizardPage_isp_import_wizard_desc);
        this.ispDiagramMvc = new IspGraphDiagramMvc(this.projectNameMvc);
        this.importSourcesMvc = new ImportSourcesMvc();
        this.importSourcesMvc.setImportSources(true);
        this.setHelpContextId("com.nxp.s32ds.vgt.ide.ui.ImportIspWizardContextHelpId");
    }

    @Override
    protected void createContent(Composite parent) {
        this.ispDiagramMvc.create(parent, this.fontMetrics);
        super.createContent(parent);
        this.importSourcesMvc.create(parent, this.fontMetrics);
    }

    protected boolean validatePage() {
        String ispGraphDiagram = this.ispDiagramMvc.getIspGraphDiagram();
        if (ispGraphDiagram == null) {
            this.setErrorMessage(null);
            this.setMessage(Messages.IspImportWizardPage_diagram_file_must_be_specified);
            return false;
        }
        if (!ispGraphDiagram.endsWith(".ispgraph_diagram")) {
            this.setErrorMessage(NLS.bind((String)Messages.IspImportNewProjectCreationWizardPage_should_have_ext, (Object)".ispgraph_diagram"));
            return false;
        }
        return super.validatePage();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.ispDiagramMvc.setFocus();
        }
    }

    public Path getDiagramPath() {
        String ispGraphDiagram = this.ispDiagramMvc.getIspGraphDiagram();
        if (ispGraphDiagram == null) {
            return null;
        }
        return Paths.get(ispGraphDiagram, new String[0]);
    }

    public boolean importSources() {
        return this.importSourcesMvc.isImportSources();
    }
}

