/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.isp.internal.ui.wizards;

import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.gte.isp.design.IspDataFlowRepresenter;
import com.nxp.s32ds.gte.isp.design.IspProgramDescriptor;
import com.nxp.s32ds.gte.isp.interchange.IspInterchange;
import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import com.nxp.s32ds.vgt.ide.core.VgtIdeCore;
import com.nxp.s32ds.vgt.ide.core.VgtRepresenter;
import com.nxp.s32ds.vgt.ide.ui.VgtIdeUi;
import com.nxp.s32ds.vgt.ide.ui.wizards.VgtProjectWizardPageChangeListener;
import com.nxp.s32ds.vgt.vpt.isp.internal.ui.Messages;
import com.nxp.s32ds.vgt.vpt.isp.internal.ui.wizards.ExtFileVisitor;
import com.nxp.s32ds.vgt.vpt.isp.internal.ui.wizards.IspImportWizardPage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class IspImportModelWizard
extends BasicNewProjectResourceWizard
implements VgtProjectWizardPageChangeListener {
    private IspImportWizardPage projectPage;
    private IspProgramDescriptor descriptor = new IspProgramDescriptor();
    IspDataFlowRepresenter representer = new IspDataFlowRepresenter();

    public IspImportModelWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.IspImportModelWizard_isp_graph_tool_project);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.projectPage = new IspImportWizardPage();
        this.projectPage.addPageChangeListener(this);
        this.addPage((IWizardPage)this.projectPage);
    }

    public boolean performFinish() {
        final Path diagramPath = this.projectPage.getDiagramPath();
        final boolean importSources = this.projectPage.importSources();
        final IWorkingSet[] selectedWorkingSets = this.projectPage.getSelectedWorkingSets();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        IspImportModelWizard.this.doFinish(selectedWorkingSets, diagramPath, importSources, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.IspImportModelWizard_error, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(IWorkingSet[] selectedWorkingSets, Path diagramPath, boolean importSources, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.IspImportModelWizard_loading, (Object)diagramPath.getFileName().toString()), 2);
        SubMonitor spm = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IspGraph semanticRoot = this.representer.createSemanticModel((VgtDescriptor)this.descriptor);
        spm.beginTask(Messages.IspImportModelWizard_import_from_old_model, -1);
        IStatus status = IspInterchange.ispInterchangeImpoter((File)diagramPath.toFile(), (IspGraph)semanticRoot);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        IProject projectHandle = this.createNewProject(selectedWorkingSets, monitor);
        IspImportModelWizard.getOrCreateFolder(monitor, projectHandle, "model");
        VgtIdeUi.createModelingResources((EObject)semanticRoot, (String)this.representer.getSemanticFileName((VgtDescriptor)this.descriptor), null, (String)this.representer.getGeneratorFileName((VgtDescriptor)this.descriptor), (String)this.representer.getRepresentationFileName((VgtDescriptor)this.descriptor), (List)this.representer.getViewpointNames(), (IProject)projectHandle, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
        ModelingProjectManager.INSTANCE.convertToModelingProject(projectHandle, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)10));
        if (importSources) {
            Path exampleDirectory = diagramPath.getParent().getParent();
            ExtFileVisitor srcVisitor = new ExtFileVisitor("\\.h$|\\.c$|\\.gdt$");
            try {
                Files.walkFileTree(exampleDirectory, srcVisitor);
            }
            catch (IOException e) {
                status = new Status(4, "com.nxp.s32ds.vgt.vpt.isp.ui", NLS.bind((String)Messages.IspImportModelWizard_error_during_scaning_0_directory, (Object)exampleDirectory.toString()), (Throwable)e);
                throw new CoreException(status);
            }
            if (srcVisitor.files.size() > 0) {
                IspImportModelWizard.importFiles(IspImportModelWizard.getOrCreateFolder(monitor, projectHandle, "src"), srcVisitor.files, monitor);
            }
        }
        VgtIdeCore.addDisabledMdtBuilder((VgtRepresenter)this.representer, (VgtDescriptor)this.descriptor, (EObject)semanticRoot, (IProgressMonitor)monitor);
        VgtIdeUi.createLaunchConfiguration((VgtRepresenter)this.representer, (VgtDescriptor)this.descriptor, (EObject)semanticRoot, (IProgressMonitor)monitor);
    }

    private static void importFiles(IFolder folder, List<Path> files, IProgressMonitor monitor) throws CoreException {
        for (Path path : files) {
            try {
                IFile file = folder.getFile(path.getFileName().toString());
                if (file.exists()) continue;
                file.create(Files.newInputStream(path, StandardOpenOption.READ), false, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, "com.nxp.s32ds.vgt.vpt.isp.ui", NLS.bind((String)Messages.IspImportModelWizard_cannot_copy_file_0_into_1, (Object)path.toString(), (Object)folder), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
    }

    private static IFolder getOrCreateFolder(IProgressMonitor monitor, IProject created, String name) throws CoreException {
        IFolder folder = created.getFolder(name);
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
        return folder;
    }

    private IProject createNewProject(final IWorkingSet[] selectedWorkingSets, IProgressMonitor monitor) throws CoreException {
        final IProject projectHandle = this.projectPage.getProjectHandle();
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    VgtIdeUi.createProject((IProject)projectHandle, (URI)IspImportModelWizard.this.projectPage.getLocationURI(), (IWorkingSet[])selectedWorkingSets, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)30));
                }
                finally {
                    monitor.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(create, monitor);
        return projectHandle;
    }

    public void pageChanged(int id) {
        switch (id) {
            case 1: {
                this.descriptor.hostProjectChanged(this.projectPage.getProjectName());
                break;
            }
            case 3: {
                this.descriptor.setTargetProjectName(this.projectPage.getTargetProject());
                break;
            }
            case 4: {
                this.descriptor.setStaticSequencer(String.valueOf(this.projectPage.isEmitStaticSequencer()));
                break;
            }
        }
    }
}

