/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.isp.internal.ui.wizards;

import com.nxp.s32ds.ext.ide.core.IProjectParticipant;
import com.nxp.s32ds.gte.isp.design.IspDataFlowRepresenter;
import com.nxp.s32ds.gte.isp.design.IspDesign;
import com.nxp.s32ds.gte.isp.design.IspProgramDescriptor;
import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import com.nxp.s32ds.vgt.ide.core.VgtRepresenter;
import com.nxp.s32ds.vgt.ide.ui.operations.VgtProjectConfigurator;
import com.nxp.s32ds.vgt.ide.ui.operations.VgtProjectCreationRunnable;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkingSet;

public class IspDataFlowWizardParticipant
implements IProjectParticipant,
VgtProjectConfigurator {
    public static String ISP_FOLDER_DEFAULT = "A53_gen";

    public String getId() {
        return IspDesign.ISP_DESIGN_VIEWPOINT;
    }

    protected String getGraphEnableParameterId() {
        return "ispCoProcessorGraphEnable";
    }

    protected String getStaticSequencerEnableParameterId() {
        return "ispCoProcessorStaticSequencerEnable";
    }

    protected IspDataFlowRepresenter getRepresenter() {
        return new IspDataFlowRepresenter();
    }

    public IStatus configure(VgtDescriptor descriptor, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public boolean isApplicable(Map<String, String> context) {
        String graphEnableParameterId = this.getGraphEnableParameterId();
        String graphEnabledStr = context.get(graphEnableParameterId);
        boolean graphEnabled = Boolean.parseBoolean(graphEnabledStr);
        return graphEnabled;
    }

    public IWorkspaceRunnable participate(Map<String, String> context, IProject target) {
        String targetName = target.getName();
        String projectName = String.valueOf(targetName) + '_' + this.getId();
        IProject projectHandle = target.getWorkspace().getRoot().getProject(projectName);
        IspDataFlowRepresenter representer = this.getRepresenter();
        IspProgramDescriptor descriptor = representer.createGraphDescriptor();
        descriptor.hostProjectChanged(targetName);
        descriptor.setTargetFolderName(ISP_FOLDER_DEFAULT);
        String staticSequencer = context.get(this.getStaticSequencerEnableParameterId());
        descriptor.setStaticSequencer(staticSequencer);
        URI targetLocation = target.getLocationURI();
        URI projectLocation = null;
        if (targetLocation != null) {
            projectLocation = URIUtil.toURI((String)(String.valueOf(URIUtil.toDecodedString((URI)targetLocation)) + '_' + this.getId()), (boolean)false);
        }
        IWorkingSet[] workingSets = null;
        VgtProjectCreationRunnable operation = new VgtProjectCreationRunnable((VgtRepresenter)representer, (VgtDescriptor)descriptor, projectHandle, target, projectLocation, workingSets);
        operation.addConfigurator((VgtProjectConfigurator)this);
        return operation;
    }
}

