/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.isp.internal.ui.wizards;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ExtFileVisitor
extends SimpleFileVisitor<Path> {
    private final Set<String> names = new HashSet<String>();
    final List<Path> files = new ArrayList<Path>();
    private final Matcher matcher;

    ExtFileVisitor(String ext) {
        this.matcher = Pattern.compile(ext).matcher("");
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        String name;
        if (Files.isRegularFile(file, new LinkOption[0]) && this.matcher.reset(name = file.getFileName().toString().toLowerCase()).find() && !this.names.contains(name)) {
            this.names.add(name);
            this.files.add(file);
        }
        return FileVisitResult.CONTINUE;
    }
}

