/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.isp.internal.ui.dialogs;

import com.nxp.s32ds.vgt.vpt.isp.internal.ui.dialogs.ResourceSelectionTreeContentProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class IspResourceSelectionDialog
extends ElementTreeSelectionDialog {
    private static final IStatus STATUS_ERROR = new Status(4, "com.nxp.s32ds.vgt.vpt.isp.ui", 0, "", null);
    private final String[] extensions;
    private final RESOURCE_TYPE resType;
    private final ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            if (selection.length == 1 && (IspResourceSelectionDialog.this.resType == RESOURCE_TYPE.FILE ? selection[0] instanceof IFile && IspResourceSelectionDialog.this.checkExtension(((IFile)selection[0]).getFileExtension()) : IspResourceSelectionDialog.this.resType == RESOURCE_TYPE.FOLDER && selection[0] instanceof IContainer)) {
                return Status.OK_STATUS;
            }
            return STATUS_ERROR;
        }
    };

    public IspResourceSelectionDialog(String title, String message, String[] type) {
        this(title, message, type, RESOURCE_TYPE.FOLDER);
    }

    public IspResourceSelectionDialog(String title, String message, String[] type, RESOURCE_TYPE typeResource) {
        super(Display.getDefault().getActiveShell(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (ITreeContentProvider)new ResourceSelectionTreeContentProvider());
        this.extensions = type;
        this.resType = typeResource;
        this.setTitle(title);
        this.setMessage(message);
        this.setInput(this.computeInput());
        this.setValidator(this.validator);
    }

    private Object[] computeInput() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                projects[i].refreshLocal(2, null);
            }
            catch (CoreException e) {
                this.setMessage(e.getMessage());
            }
            ++i;
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(1, null);
        }
        catch (CoreException e) {
            this.setMessage(e.getMessage());
        }
        ArrayList<IProject> openProjects = new ArrayList<IProject>(projects.length);
        int i2 = 0;
        while (i2 < projects.length) {
            if (projects[i2].isOpen()) {
                openProjects.add(projects[i2]);
            }
            ++i2;
        }
        return openProjects.toArray();
    }

    private boolean checkExtension(String name) {
        if (name.equals("*")) {
            return true;
        }
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IContainer getSelectedProject() {
        Object[] result = this.getResult();
        if (result != null && this.resType == RESOURCE_TYPE.FOLDER && result.length > 0 && result[0] instanceof IContainer) {
            return (IContainer)result[0];
        }
        return null;
    }

    public IFile getSelectedFiles() {
        Object[] result = this.getResult();
        if (this.resType == RESOURCE_TYPE.FILE && result.length > 0 && result[0] instanceof IFile) {
            return (IFile)result[0];
        }
        return null;
    }

    public static enum RESOURCE_TYPE {
        FILE,
        FOLDER;

    }
}

