/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.internal.c.defines;

import com.nxp.s32ds.ext.emf.cache.EmfCacheManager;
import com.nxp.s32ds.ext.emf.cache.UriRegistryKey;
import com.nxp.s32ds.ext.orbit.c.defines.CDefine;
import com.nxp.s32ds.ext.orbit.c.defines.CExternalDefine;
import com.nxp.s32ds.ext.orbit.c.defines.impl.CDefineImpl;
import com.nxp.s32ds.ext.orbit.c.includes.CInclude;
import com.nxp.s32ds.ext.orbit.c.includes.impl.CIncludeImpl;
import com.nxp.s32ds.mdt.ide.c.defines.MdtCDefineRegistry;
import com.nxp.s32ds.mdt.ide.c.defines.MdtCDefineRegistryHelper;
import com.nxp.s32ds.mdt.ide.c.defines.MdtCDefineRegistryManager;
import com.nxp.s32ds.mdt.ide.c.evaluation.MdtCDefineEvaluator;
import com.nxp.s32ds.mdt.ide.internal.c.MdtCActivator;
import com.nxp.s32ds.mdt.ide.internal.c.defines.MdtCDefineRegistryImpl;
import com.nxp.s32ds.mdt.ide.internal.c.defines.MdtCIncludeDefineParser;
import com.nxp.s32ds.mdt.ide.internal.c.defines.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class MdtCDefineRegistryManagerImpl<T extends EObject>
implements MdtCDefineRegistryManager<T> {
    private final WeakHashMap<UriRegistryKey, MdtCDefineRegistryImpl<T>> registriesMap = new WeakHashMap();
    private final MdtCDefineRegistryHelper<T> helper;

    public MdtCDefineRegistryManagerImpl(MdtCDefineRegistryHelper<T> helper) {
        this.helper = helper;
    }

    @Override
    public List<CInclude> getIncludes(T root) {
        return this.helper.getIncludes(root);
    }

    @Override
    public List<CDefine> getUserDefines(T root) {
        return this.helper.getUserDefines(root);
    }

    @Override
    public MdtCDefineRegistryImpl<T> getDefineRegistry(T eObject) {
        MdtCDefineRegistryImpl registry = (MdtCDefineRegistryImpl)EmfCacheManager.INSTANCE.getRelatedObject(eObject, this.registriesMap, () -> new MdtCDefineRegistryImpl<T>(this.helper));
        return this.updateIfNeeds(eObject, registry);
    }

    private MdtCDefineRegistryImpl<T> updateIfNeeds(T root, MdtCDefineRegistryImpl<T> registry) {
        List<CInclude> includes = this.helper.getIncludes(root);
        int importsHash = MdtCDefineRegistryManagerImpl.calculateIncludesHash(includes);
        if (importsHash == registry.getIncludesHash()) {
            return registry;
        }
        registry.clear();
        ArrayList<CExternalDefine> externalDefines = new ArrayList<CExternalDefine>();
        for (CInclude include : includes) {
            externalDefines.addAll(MdtCIncludeDefineParser.parse(include));
        }
        registry.setExternalDefines(externalDefines);
        registry.setIncludesHash(importsHash);
        return registry;
    }

    private static int calculateIncludesHash(List<CInclude> includes) {
        ArrayList<String> strings = new ArrayList<String>();
        for (CInclude include : includes) {
            strings.add(include.getPath());
        }
        return strings.hashCode();
    }

    @Override
    public IStatus canAddIncludeFile(T root, String file) {
        Collection<CExternalDefine> parseResult;
        try {
            parseResult = MdtCIncludeDefineParser.parseWithStatus((CInclude)new CIncludeImpl(file));
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            return MdtCActivator.getInstance().createStatus(status.getSeverity(), NLS.bind((String)Messages.MdtCDefineRegistryManagerImpl_cannot_add_include_0, (Object)status.getMessage()));
        }
        MdtCDefineRegistry defineRegistry = this.getDefineRegistry((EObject)root);
        ArrayList<CExternalDefine> defines = new ArrayList<CExternalDefine>(((MdtCDefineRegistryImpl)defineRegistry).getExternalDefines());
        defines.addAll(parseResult);
        return MdtCDefineRegistryManagerImpl.checkEvaluation(defines);
    }

    @Override
    public IStatus canAddDefine(T root, CDefine define) {
        MdtCDefineRegistry defineRegistry = this.getDefineRegistry((EObject)root);
        ArrayList<CExternalDefine> defines = new ArrayList<CExternalDefine>(((MdtCDefineRegistryImpl)defineRegistry).getExternalDefines());
        defines.addAll(this.helper.getUserDefines(root));
        defines.add((CExternalDefine)define);
        return MdtCDefineRegistryManagerImpl.checkEvaluation(defines);
    }

    @Override
    public IStatus canModifyDefine(T root, String name, String newName, String newValue) {
        MdtCDefineRegistry defineRegistry = this.getDefineRegistry((EObject)root);
        ArrayList<CExternalDefine> defines = new ArrayList<CExternalDefine>(((MdtCDefineRegistryImpl)defineRegistry).getExternalDefines());
        List userDefines = this.helper.getUserDefines(root).stream().map(d -> {
            if (d.getName().equals(name)) {
                return new CDefineImpl(newName, newValue);
            }
            return d;
        }).collect(Collectors.toList());
        defines.addAll(userDefines);
        return MdtCDefineRegistryManagerImpl.checkEvaluation(defines);
    }

    private static IStatus checkEvaluation(List<CDefine> defines) {
        if (!MdtCDefineEvaluator.INSTANCE.isActivated()) {
            return Status.OK_STATUS;
        }
        IStatus status = MdtCDefineEvaluator.INSTANCE.checkScript(defines);
        if (status.isOK()) {
            return status;
        }
        return MdtCActivator.getInstance().createWarning(status.getMessage());
    }
}

