/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.c.evaluation;

import com.nxp.s32ds.ext.orbit.c.defines.CDefine;
import com.nxp.s32ds.ext.orbit.c.defines.evaluate.CDefineEvaluateException;
import com.nxp.s32ds.ext.orbit.c.defines.evaluate.CDefineEvaluator;
import com.nxp.s32ds.mdt.ide.internal.c.MdtCActivator;
import com.nxp.s32ds.mdt.ide.internal.c.evaluation.MdtDefineEvaluatorEmfCache;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class MdtCDefineEvaluator {
    public static final MdtCDefineEvaluator INSTANCE = new MdtCDefineEvaluator();
    private final CDefineEvaluator evaluator;
    private final MdtDefineEvaluatorEmfCache<EObject> cache = new MdtDefineEvaluatorEmfCache();

    protected MdtCDefineEvaluator(CDefineEvaluator evaluator) {
        this.evaluator = evaluator;
        if (!this.isActivated()) {
            MdtCActivator.getInstance().logError("Java script engine not found. Evaluation of expressions will not be performed.");
        }
    }

    private MdtCDefineEvaluator() {
        this(new CDefineEvaluator());
    }

    public boolean isActivated() {
        return this.evaluator.isActivated();
    }

    public String buildConstantsScript(List<CDefine> defines) {
        return this.evaluator.buildConstantsScript(defines);
    }

    public <T extends EObject> int evalInteger(T root, String script) throws CoreException {
        return this.eval(root, script, s -> this.evaluator.evalInteger(s));
    }

    public <T extends EObject> double evalDouble(T root, String script) throws CoreException {
        return this.eval(root, script, s -> this.evaluator.evalDouble(s));
    }

    private <T extends EObject, R extends Number> R eval(T root, String script, EvalFunction<R> f) throws CoreException {
        Object value = this.cache.getRegistry(root).getValue(script, s -> {
            try {
                return f.eval((String)s);
            }
            catch (CDefineEvaluateException e) {
                return new CoreException(MdtCActivator.getInstance().createError(e.getMessage(), e));
            }
        });
        if (value instanceof CoreException) {
            throw (CoreException)((Object)value);
        }
        return (R)((Number)value);
    }

    public <T extends EObject> IStatus checkScript(T root, List<CDefine> defines) {
        try {
            this.evalInteger(root, this.buildValidationScript(defines));
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public IStatus checkScript(List<CDefine> defines) {
        try {
            this.evaluator.evalInteger(this.buildValidationScript(defines));
        }
        catch (CDefineEvaluateException e) {
            return MdtCActivator.getInstance().createError(e.getMessage());
        }
        return Status.OK_STATUS;
    }

    protected String buildValidationScript(List<CDefine> defines) {
        return String.valueOf(this.buildConstantsScript(defines)) + "\n0";
    }

    @FunctionalInterface
    private static interface EvalFunction<T extends Number> {
        public T eval(String var1) throws CDefineEvaluateException;
    }
}

