/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.provider.DNodeContainerItemProvider;
import org.eclipse.sirius.diagram.provider.DNodeListItemProvider;
import org.eclipse.sirius.diagram.provider.DiagramItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DDiagramElementContainerLabelItemProvider;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.DiagramElementsSelectionDialogPatternMatcher;
import org.eclipse.sirius.diagram.ui.tools.internal.providers.FilteredTreeContentProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline.OutlineLabelProvider;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class DiagramElementsSelectionDialog {
    private static final Function<Object, Void> DO_NOTHING = new Function<Object, Void>(){

        public Void apply(Object from) {
            return null;
        }
    };
    protected CustomTreeSelectionDialog dialog;
    protected DDiagram diagram;
    protected FilteringMode mode = FilteringMode.SHOW_ALL;
    private final String title;
    private final String message;
    private Predicate<Object> isSelected = Predicates.alwaysTrue();
    private Predicate<Object> isGrayed = Predicates.alwaysFalse();
    private Function<Object, Void> selectedAction = DO_NOTHING;
    private Function<Object, Void> deselectedAction = DO_NOTHING;
    private FilteredTreeContentProvider contentProvider;

    public DiagramElementsSelectionDialog(String title, String message) {
        this.title = title;
        this.message = message;
    }

    public void setSelectionPredicate(Predicate<Object> isSelectedPredicate) {
        this.isSelected = isSelectedPredicate;
    }

    public void setGrayedPredicate(Predicate<Object> isGrayedPredicate) {
        this.isGrayed = isGrayedPredicate != null ? isGrayedPredicate : Predicates.alwaysFalse();
    }

    private Set<Object> getAllChildren(Object parent) {
        Object[] children;
        HashSet<Object> result = new HashSet<Object>();
        Object[] objectArray = children = this.contentProvider.getChildren(parent);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            result.add(element);
            result.addAll(this.getAllChildren(element));
            ++n2;
        }
        return result;
    }

    public void setSelectedAction(Function<Object, Void> selectedAction) {
        this.selectedAction = selectedAction;
    }

    public void setDeselectedAction(Function<Object, Void> deselectedAction) {
        this.deselectedAction = deselectedAction;
    }

    public boolean open(Shell parent, DDiagram ddiagram, boolean includeNodeLabel) {
        boolean result = false;
        this.diagram = ddiagram;
        this.initContentProvider(includeNodeLabel);
        Set<Object> allSelectedElements = Collections.unmodifiableSet(this.getAllSelectedElements());
        Option<Set<Object>> response = this.askUserForNewSelection(parent, allSelectedElements);
        if (response.some()) {
            Set selectedAfter = (Set)response.get();
            this.applyRequestedChanges(allSelectedElements, selectedAfter);
            assert (selectedAfter.equals(allSelectedElements));
            result = true;
        }
        this.diagram = null;
        this.dialog = null;
        this.contentProvider = null;
        return result;
    }

    protected void initContentProvider(boolean includeLabel) {
        AdapterFactory adapterFactory = this.getAdapterFactory(includeLabel);
        Predicate predicate = Predicates.instanceOf(DDiagramElement.class);
        if (includeLabel) {
            predicate = Predicates.or((Predicate)predicate, (Predicate)Predicates.instanceOf(AbstractDDiagramElementLabelItemProvider.class));
        }
        this.contentProvider = new FilteredTreeContentProvider(adapterFactory, (Predicate<Object>)predicate);
    }

    protected Set<Object> getAllSelectedElements() {
        Set<Object> treeElements = this.getAllChildren(this.diagram);
        return Sets.newHashSet((Iterator)Iterators.filter(treeElements.iterator(), (Predicate)Predicates.and(this.isSelected, (Predicate)Predicates.not(this.isGrayed))));
    }

    protected Option<Set<Object>> askUserForNewSelection(Shell parent, Set<Object> initialSelection) {
        this.setupDialog(parent, initialSelection);
        int result = this.dialog.open();
        if (result == 0) {
            Set<Object> selectedAfter = this.getElementsSelectedAfter();
            return Options.newSome(selectedAfter);
        }
        return Options.newNone();
    }

    protected void setupDialog(Shell parent, Set<Object> initialSelection) {
        this.dialog = new CustomTreeSelectionDialog(parent, (ILabelProvider)new SelectionDialogLabelProvider(), (ITreeContentProvider)this.contentProvider);
        this.dialog.setTitle(this.title);
        String msg = this.message;
        if (!Predicates.alwaysFalse().equals(this.isGrayed)) {
            StringBuilder sb = new StringBuilder(this.message);
            sb.append("\n");
            sb.append(Messages.DiagramElementsSelectionDialog_grayedElementDialogMessage);
            msg = sb.toString();
        }
        this.dialog.setMessage(msg);
        this.dialog.setInput(this.diagram);
        this.dialog.addFilter(new ModeFilter());
        this.dialog.setInitialElementSelections(Lists.newArrayList(initialSelection));
    }

    protected Set<Object> getElementsSelectedAfter() {
        HashSet selectedElements = Sets.newHashSet();
        for (Object obj : this.dialog.checkedElements) {
            if (obj instanceof DDiagramElement) {
                selectedElements.add(obj);
                continue;
            }
            if (!(obj instanceof AbstractDDiagramElementLabelItemProvider)) continue;
            selectedElements.add(obj);
        }
        return selectedElements;
    }

    protected void applyRequestedChanges(Set<Object> selectedBefore, Set<Object> selectedAfter) {
        for (Object dde : Sets.difference(selectedBefore, selectedAfter)) {
            this.deselectedAction.apply(dde);
        }
        for (Object dde : Sets.difference(selectedAfter, selectedBefore)) {
            this.selectedAction.apply(dde);
        }
    }

    private AdapterFactory getAdapterFactory(boolean includeLabel) {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ViewpointItemProviderAdapterFactory());
        factories.add((Object)new DiagramItemProviderWithLabelAdapterFactory(includeLabel));
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    protected final class CustomTreeSelectionDialog
    extends CheckedTreeSelectionDialog {
        protected DiagramElementsSelectionDialogPatternMatcher patternMatcher;
        private final Set<Object> checkedElements;

        private CustomTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
            this.checkedElements = Sets.newHashSet();
            this.patternMatcher = new DiagramElementsSelectionDialogPatternMatcher("");
        }

        public void setInitialSelections(Object[] selectedElements) {
            this.setInitialElementSelections(Lists.newArrayList((Object[])selectedElements));
        }

        public void setInitialElementSelections(List selectedElements) {
            ArrayList filteredSeletection = Lists.newArrayList((Iterable)Iterables.filter((Iterable)selectedElements, (Predicate)Predicates.not((Predicate)DiagramElementsSelectionDialog.this.isGrayed)));
            this.checkedElements.addAll(filteredSeletection);
            super.setInitialElementSelections((List)filteredSeletection);
        }

        public Set<Object> getCheckedElements() {
            return this.checkedElements;
        }

        protected CheckboxTreeViewer createTreeViewer(Composite parent) {
            this.setInput(null);
            CheckboxTreeViewer treeViewer = super.createTreeViewer(parent);
            treeViewer.setUseHashlookup(true);
            treeViewer.setInput((Object)DiagramElementsSelectionDialog.this.diagram);
            return treeViewer;
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.getTreeViewer().setCheckStateProvider(new ICheckStateProvider(){

                public boolean isGrayed(Object element) {
                    return DiagramElementsSelectionDialog.this.isGrayed.apply(element);
                }

                public boolean isChecked(Object element) {
                    return CustomTreeSelectionDialog.this.checkedElements.contains(element);
                }
            });
            this.getTreeViewer().addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (!DiagramElementsSelectionDialog.this.isGrayed.apply(event.getElement())) {
                        if (event.getChecked()) {
                            CustomTreeSelectionDialog.this.checkedElements.add(event.getElement());
                        } else {
                            CustomTreeSelectionDialog.this.checkedElements.remove(event.getElement());
                        }
                    }
                }
            });
            return result;
        }

        protected Label createMessageArea(Composite composite) {
            Label createMessageArea = super.createMessageArea(composite);
            this.createSelectionButtonsAfterMessageArea(composite);
            this.createRegexpTypeZone(composite);
            return createMessageArea;
        }

        protected Composite createSelectionButtons(Composite composite) {
            Composite buttonComposite = new Composite(composite, 131072){

                public Point computeSize(int wHint, int hHint, boolean b) {
                    return super.computeSize(0, 0, b);
                }
            };
            buttonComposite.setVisible(false);
            return buttonComposite;
        }

        protected Composite createSelectionButtonsAfterMessageArea(Composite composite) {
            Composite buttonComposite = new Composite(composite, 131072);
            GridLayout layout = new GridLayout();
            layout.numColumns = 7;
            layout.makeColumnsEqualWidth = false;
            buttonComposite.setLayout((Layout)layout);
            buttonComposite.setFont(composite.getFont());
            GridData data = new GridData(640);
            data.grabExcessHorizontalSpace = true;
            composite.setData((Object)data);
            new Label(buttonComposite, 16384).setText(Messages.CustomTreeSelectionDialog_showLabelText);
            final Combo choices = new Combo(buttonComposite, 8);
            choices.add(FilteringMode.SHOW_ALL.getName());
            choices.add(FilteringMode.SHOW_ONLY_CHECKED_ELEMENTS.getName());
            choices.add(FilteringMode.SHOW_ONLY_UNCHECKED_ELEMENTS.getName());
            choices.select(0);
            choices.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    switch (choices.getSelectionIndex()) {
                        case 0: {
                            CustomTreeSelectionDialog.this.updateFilteringMode(FilteringMode.SHOW_ALL);
                            break;
                        }
                        case 1: {
                            CustomTreeSelectionDialog.this.updateFilteringMode(FilteringMode.SHOW_ONLY_CHECKED_ELEMENTS);
                            break;
                        }
                        case 2: {
                            CustomTreeSelectionDialog.this.updateFilteringMode(FilteringMode.SHOW_ONLY_UNCHECKED_ELEMENTS);
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
            });
            data = new GridData(640);
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 2;
            choices.setLayoutData((Object)data);
            data = new GridData(768);
            data.grabExcessHorizontalSpace = true;
            this.addButton(buttonComposite, Messages.CustomTreeSelectionDialog_checkAllButtonTooltip, DiagramUIPlugin.getPlugin().getBundledImage("icons/enabled_co.gif"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTreeSelectionDialog.this.checkAll();
                    if (choices.getSelectionIndex() == 1) {
                        CustomTreeSelectionDialog.this.updateFilteringMode(FilteringMode.SHOW_ONLY_CHECKED_ELEMENTS);
                    } else if (choices.getSelectionIndex() == 2) {
                        CustomTreeSelectionDialog.this.updateFilteringMode(FilteringMode.SHOW_ONLY_UNCHECKED_ELEMENTS);
                    }
                }
            }).setLayoutData((Object)data);
            this.addButton(buttonComposite, Messages.CustomTreeSelectionDialog_uncheckAllButtonTooltip, DiagramUIPlugin.getPlugin().getBundledImage("icons/disabled_co.gif"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTreeSelectionDialog.this.uncheckAll();
                    if (choices.getSelectionIndex() == 1) {
                        CustomTreeSelectionDialog.this.updateFilteringMode(FilteringMode.SHOW_ONLY_CHECKED_ELEMENTS);
                    } else if (choices.getSelectionIndex() == 2) {
                        CustomTreeSelectionDialog.this.updateFilteringMode(FilteringMode.SHOW_ONLY_UNCHECKED_ELEMENTS);
                    }
                }
            }).setLayoutData((Object)data);
            this.addButton(buttonComposite, Messages.CustomTreeSelectionDialog_expandAllButtonTooltip, DiagramUIPlugin.getPlugin().getBundledImage("icons/expandall.gif"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTreeSelectionDialog.this.expandAll();
                }
            }).setLayoutData((Object)data);
            this.addButton(buttonComposite, Messages.CustomTreeSelectionDialog_collapaseAllTooltip, DiagramUIPlugin.getPlugin().getBundledImage("icons/collapseall.gif"), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CustomTreeSelectionDialog.this.collapseAll();
                }
            }).setLayoutData((Object)data);
            return buttonComposite;
        }

        private void createRegexpTypeZone(Composite composite) {
            Group expregGroup = new Group(composite, 0);
            expregGroup.setText(Messages.CustomTreeSelectionDialog_regexpTitle);
            GridLayout expregLayout = new GridLayout();
            expregGroup.setLayout((Layout)expregLayout);
            expregGroup.setFont(composite.getFont());
            expregGroup.setLayoutData((Object)new GridData(768));
            Label explanationsLabel = new Label((Composite)expregGroup, 0);
            explanationsLabel.setText(Messages.CustomTreeSelectionDialog_regexpExplanations);
            Text regularExpressionText = new Text((Composite)expregGroup, 2048);
            regularExpressionText.setToolTipText(Messages.CustomTreeSelectionDialog_regexpTooltip);
            regularExpressionText.setLayoutData((Object)new GridData(768));
            regularExpressionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String typedRegex = ((Text)e.getSource()).getText();
                    CustomTreeSelectionDialog.this.setPatternMatcher(new DiagramElementsSelectionDialogPatternMatcher(typedRegex));
                    CustomTreeSelectionDialog.this.updateFilteringMode(((CustomTreeSelectionDialog)CustomTreeSelectionDialog.this).DiagramElementsSelectionDialog.this.mode);
                }
            });
        }

        public void setPatternMatcher(DiagramElementsSelectionDialogPatternMatcher patternMatcher) {
            this.patternMatcher = patternMatcher;
        }

        private Button addButton(Composite parent, String toolTipText, Image image, SelectionListener action) {
            Button button = new Button(parent, 8);
            button.setToolTipText(toolTipText);
            button.setImage(image);
            button.addSelectionListener(action);
            return button;
        }

        private void checkAll() {
            Object root = this.getTreeViewer().getInput();
            this.setRecursiveState(root, true);
        }

        private void uncheckAll() {
            Object root = this.getTreeViewer().getInput();
            this.setRecursiveState(root, false);
        }

        private void setRecursiveState(Object element, boolean state) {
            this.getTreeViewer().setChecked(element, state);
            if (!DiagramElementsSelectionDialog.this.isGrayed.apply(element)) {
                if (state) {
                    this.checkedElements.add(element);
                } else {
                    this.checkedElements.remove(element);
                }
            }
            Object[] objectArray = DiagramElementsSelectionDialog.this.contentProvider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.setRecursiveState(child, state);
                ++n2;
            }
        }

        private void expandAll() {
            this.getTreeViewer().expandAll();
        }

        private void collapseAll() {
            this.getTreeViewer().collapseAll();
        }

        public void updateFilteringMode(FilteringMode filteringMode) {
            DiagramElementsSelectionDialog.this.mode = filteringMode;
            this.refresh();
            this.getTreeViewer().expandAll();
            this.getTreeViewer().setAllChecked(false);
            for (Object element : this.checkedElements) {
                this.getTreeViewer().setChecked(element, true);
            }
        }

        public boolean isMatchingExpregOrHasMatchingExpregDescendantsCheckedMode(Object element) {
            Predicate isCheckedElementPredicate = Predicates.in(this.checkedElements);
            Predicate<Object> isMatchinExpregPredicate = this.getRegexpMatchPredicate();
            return this.isOrHasDescendant(element, (Predicate<Object>)Predicates.and((Predicate)isCheckedElementPredicate, isMatchinExpregPredicate));
        }

        public boolean isMatchingExpregOrHasMatchingExpregDescendantsUncheckedMode(Object element) {
            Predicate isUncheckedElementPredicate = Predicates.not((Predicate)Predicates.in(this.checkedElements));
            Predicate<Object> isMatchinExpregPredicate = this.getRegexpMatchPredicate();
            return this.isOrHasDescendant(element, (Predicate<Object>)Predicates.and((Predicate)isUncheckedElementPredicate, isMatchinExpregPredicate));
        }

        public boolean isMatchingExpregOrHasMatchingExpregDescendantsAllMode(Object element) {
            return this.isOrHasDescendant(element, this.getRegexpMatchPredicate());
        }

        public boolean isOrHasDescendant(Object element, final Predicate<Object> pred) {
            boolean matches = pred.apply(element);
            if (matches) {
                return true;
            }
            return Iterables.any(Arrays.asList(DiagramElementsSelectionDialog.this.contentProvider.getChildren(element)), (Predicate)new Predicate<Object>(){

                public boolean apply(Object input) {
                    return CustomTreeSelectionDialog.this.isOrHasDescendant(input, (Predicate<Object>)pred);
                }
            });
        }

        public void refresh() {
            this.getTreeViewer().refresh();
        }

        public Predicate<Object> getRegexpMatchPredicate() {
            return this.patternMatcher.getMatchPredicate();
        }
    }

    private class DiagramItemProviderWithLabelAdapterFactory
    extends DiagramItemProviderAdapterFactory {
        private final HashMap<Object, DDiagramElementContainerLabelItemProvider> labelItemProviders = Maps.newHashMap();
        private boolean includeLabel;

        DiagramItemProviderWithLabelAdapterFactory(boolean includeLabel) {
            this.includeLabel = includeLabel;
        }

        private Collection<Object> completeChildren(Object object, Collection<Object> children, AdapterFactory adapterFactory) {
            Collection<Object> result = children;
            if (this.includeLabel && object instanceof DDiagramElementContainer) {
                ArrayList<Object> resultTemp = new ArrayList<Object>();
                if (this.labelItemProviders.get(object) == null) {
                    this.labelItemProviders.put(object, new DDiagramElementContainerLabelItemProvider(adapterFactory, (DDiagramElementContainer)object));
                }
                resultTemp.add((Object)this.labelItemProviders.get(object));
                resultTemp.addAll(children);
                result = resultTemp;
            } else if (this.labelItemProviders.get(object) != null) {
                this.labelItemProviders.remove(object).dispose();
            }
            return result;
        }

        @Override
        public Adapter createDNodeContainerAdapter() {
            if (this.dNodeContainerItemProvider == null) {
                this.dNodeContainerItemProvider = new DNodeContainerItemProvider((AdapterFactory)this){

                    public Collection<?> getChildren(Object object) {
                        Collection result = super.getChildren(object);
                        return DiagramItemProviderWithLabelAdapterFactory.this.completeChildren(object, result, this.adapterFactory);
                    }
                };
            }
            return this.dNodeContainerItemProvider;
        }

        @Override
        public Adapter createDNodeListAdapter() {
            if (this.dNodeListItemProvider == null) {
                this.dNodeListItemProvider = new DNodeListItemProvider((AdapterFactory)this){

                    public Collection<?> getChildren(Object object) {
                        Collection result = super.getChildren(object);
                        return DiagramItemProviderWithLabelAdapterFactory.this.completeChildren(object, result, this.adapterFactory);
                    }
                };
            }
            return this.dNodeListItemProvider;
        }
    }

    protected static enum FilteringMode {
        SHOW_ALL(Messages.FilteringMode_allElements),
        SHOW_ONLY_CHECKED_ELEMENTS(Messages.FilteringMode_onlyCheckedElements),
        SHOW_ONLY_UNCHECKED_ELEMENTS(Messages.FilteringMode_onlyUncheckedElements);

        private final String name;

        private FilteringMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private class ModeFilter
    extends ViewerFilter {
        private ModeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean show = true;
            switch (DiagramElementsSelectionDialog.this.mode) {
                case SHOW_ALL: {
                    show = DiagramElementsSelectionDialog.this.dialog.isMatchingExpregOrHasMatchingExpregDescendantsAllMode(element);
                    break;
                }
                case SHOW_ONLY_CHECKED_ELEMENTS: {
                    show = DiagramElementsSelectionDialog.this.dialog.isMatchingExpregOrHasMatchingExpregDescendantsCheckedMode(element);
                    break;
                }
                case SHOW_ONLY_UNCHECKED_ELEMENTS: {
                    show = DiagramElementsSelectionDialog.this.dialog.isMatchingExpregOrHasMatchingExpregDescendantsUncheckedMode(element);
                    break;
                }
                default: {
                    show = true;
                }
            }
            boolean isNonDangling = true;
            if (show) {
                DDiagramElement underlyingDDiagramElement = null;
                if (element instanceof DDiagramElement) {
                    underlyingDDiagramElement = (DDiagramElement)element;
                } else if (element instanceof AbstractDDiagramElementLabelItemProvider && ((AbstractDDiagramElementLabelItemProvider)((Object)element)).getDiagramElementTarget().some()) {
                    underlyingDDiagramElement = (DDiagramElement)((AbstractDDiagramElementLabelItemProvider)((Object)element)).getDiagramElementTarget().get();
                }
                isNonDangling = underlyingDDiagramElement != null && underlyingDDiagramElement.eResource() != null ? underlyingDDiagramElement.getTarget() != null && underlyingDDiagramElement.getTarget().eResource() != null : false;
            }
            return show && isNonDangling;
        }
    }

    private class SelectionDialogLabelProvider
    extends OutlineLabelProvider
    implements IColorProvider {
        private SelectionDialogLabelProvider() {
        }

        public Color getForeground(Object element) {
            Color foreground = null;
            if (DiagramElementsSelectionDialog.this.isGrayed.apply(element)) {
                foreground = VisualBindingManager.getDefault().getColorFromName("light_gray");
            }
            return foreground;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

