/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;

public class SiriusWrapLabelWithAttachment
extends SiriusWrapLabel {
    private int location;
    private Polyline attachment;

    public SiriusWrapLabelWithAttachment(int location, Polyline attachment) {
        this.location = location;
        this.attachment = attachment;
    }

    @Override
    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.attachment.isVisible()) {
            this.setAttachmentLocation();
        }
    }

    private boolean displayNoteAttachment() {
        return DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiPreferencesKeys.PREF_SHOW_LINK_EDGE_LABEL_ON_SELECTION.name());
    }

    protected void setAttachmentLocation() {
        PointList ptList = ((Connection)this.getParent()).getPoints();
        Point referencePointOnEdge = PointListUtilities.calculatePointRelativeToLine((PointList)ptList, (int)0, (int)this.location, (boolean)true);
        Rectangle labelBounds = this.getBounds();
        Point midTop = new Point(labelBounds.x + labelBounds.width / 2, labelBounds.y);
        Point midBottom = new Point(labelBounds.x + labelBounds.width / 2, labelBounds.y + labelBounds.height);
        Point midLeft = new Point(labelBounds.x, labelBounds.y + labelBounds.height / 2);
        Point midRight = new Point(labelBounds.x + labelBounds.width, labelBounds.y + labelBounds.height / 2);
        Point startPoint = midTop;
        int x = labelBounds.x + labelBounds.width / 2 - referencePointOnEdge.x;
        int y = labelBounds.y + labelBounds.height / 2 - referencePointOnEdge.y;
        startPoint = y > 0 && y > x && y > -x ? midTop : (y < 0 && y < x && y < -x ? midBottom : (x < 0 && y > x && y < -x ? midRight : midLeft));
        if (this.attachment.getPoints().size() == 0 || !startPoint.equals((Object)this.attachment.getStart())) {
            this.attachment.setStart(startPoint);
        }
        if (!referencePointOnEdge.equals((Object)this.attachment.getEnd())) {
            this.attachment.setEnd(referencePointOnEdge);
        }
    }

    public void showAttachment() {
        if (this.attachment != null && this.displayNoteAttachment()) {
            this.attachment.setVisible(true);
        }
    }

    public void hideAttachment() {
        if (this.attachment != null) {
            this.attachment.setVisible(false);
        }
    }
}

