/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import java.io.File;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateEngine2;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReadXML
extends ProcessRunner {
    protected static final DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        File file = new File(args[0].getSimpleValue());
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new ProcessFailureException("Error reading file: " + file);
        }
        String elem = args[1].getSimpleValue();
        String mode = args[2].getName();
        try {
            Document doc = dbFactory.newDocumentBuilder().parse(file);
            doc.getDocumentElement().normalize();
            Map macros = template.getValueStore();
            Map map = TemplateEngine.getSharedDefaults();
            NodeList nList = doc.getElementsByTagName(elem);
            if (nList.getLength() < 1) {
                throw new ProcessFailureException("XML Element not found: " + elem + " in file " + file);
            }
            Element el = (Element)nList.item(0);
            ProcessArgument[][] processArgumentArray = args[2].getComplexArrayValue();
            int n = processArgumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessArgument[] pa = processArgumentArray[n2];
                String value = null;
                String name = pa[0].getSimpleValue();
                String var = pa[1].getSimpleValue();
                if (var != null) {
                    if (mode.equals("attr")) {
                        value = el.getAttribute(name);
                    } else if (mode.equals("text")) {
                        NodeList nl = el.getChildNodes();
                        int i = 0;
                        while (i < nl.getLength()) {
                            if (name.equals(nl.item(i).getNodeName())) {
                                value = nl.item(i).getTextContent();
                                break;
                            }
                            ++i;
                        }
                    } else {
                        throw new ProcessFailureException("Bad data mode: " + mode);
                    }
                    macros.put(var, value);
                    map.put(var, value);
                }
                ++n2;
            }
            TemplateEngine2.getDefault().updateSharedDefaults(template);
        }
        catch (Exception exception) {
            throw new ProcessFailureException("Cannot parse file: " + file);
        }
    }
}

