/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.ContextStyle;
import com.freescale.s32ds.cross.core.model.IModelSDK;
import com.freescale.s32ds.cross.core.model.ISDKFilterInfo;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.AbstractSmartFilter;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.wizard.S32DSMultiProjectWizard;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.page1.S32DSMultiPageOne;
import com.freescale.s32ds.cross.wizard.page2.GridManager;
import com.freescale.s32ds.cross.wizard.page2.IPage2Manager;
import com.freescale.s32ds.cross.wizard.page2.MemoryMinimumChecker;
import com.freescale.s32ds.cross.wizard.page2.Page2Utils;
import com.freescale.s32ds.cross.wizard.page2.TableManager;
import com.nxp.s32ds.cle.cdt.internal.ui.wizards.Messages;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class S32DSMultiPageTwo
extends WizardPage {
    private static final int PAGE_FULL_WIDTH = 700;
    private static final int PAGE_ROW_HEIGHT = 25;
    private final ProcessorContext processorContext;
    private String projectName = "";
    private IPage2Manager pageManager;
    protected final S32DSMultiPageOne firstPage;

    public S32DSMultiPageTwo(String pageName, S32DSMultiProjectWizard w, ProcessorContext processorContext) {
        super(pageName);
        this.setWizard(w);
        this.setPageComplete(false);
        this.setTitle(NLS.bind((String)Messages.S32DSMultiPageTwo_title, (Object)processorContext.getProcessor().getName()));
        this.setDescription(Messages.S32DSMultiPageTwo_description);
        this.processorContext = processorContext;
        processorContext.initData();
        this.firstPage = this.getWizard().getStartingPage();
        this.initSdksLists();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        ContextStyle style = this.processorContext.getContextDefinition().getStyle();
        this.pageManager = ContextStyle.TABLE == style ? new TableManager(this.processorContext, this, composite) : new GridManager(this.processorContext, this, composite);
        this.pageManager.createContents(700, 25);
        this.initializeDialogUnits((Control)parent);
        composite.pack();
        this.setPageComplete(this.pageManager.isAnyChecked());
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean fpuSupport = this.processorContext.containsParameter("fpu");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), S32DSWizardPlugin.makeHelpContextId(this.getWizard().getType(), 2, fpuSupport, this.processorContext.getProcessor()));
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getStartingPage();
    }

    public S32DSMultiProjectWizard getWizard() {
        return (S32DSMultiProjectWizard)super.getWizard();
    }

    public void disableUI() {
        this.pageManager.setEnabled(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().setFocus();
        }
    }

    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            return this.checkSdkPresence();
        }
        return false;
    }

    public boolean validatePage() {
        String memoryError = MemoryMinimumChecker.getMinMemoryError(this.processorContext);
        if (memoryError != null) {
            this.setErrorMessage(memoryError);
            return false;
        }
        if (!this.pageManager.isAnyChecked()) {
            String coreNatureDescription = this.getWizard().getContext().isExecutable() ? Messages.S32DSMultiPageTwo_core : Messages.S32DSMultiPageTwo_core_type;
            this.setErrorMessage(NLS.bind((String)Messages.S32DSMultiPageTwo_choose_any_core_to_continue, (Object)coreNatureDescription));
            return false;
        }
        for (ProjectContext ctx : this.getWizard().getContext().getResultProjectContexts()) {
            if (!(ctx instanceof CProjectMasterContext)) continue;
            CProjectMasterContext pc = (CProjectMasterContext)ctx;
            for (IModelSDK sdk : pc.getSdkList()) {
                AbstractSmartFilter filter = this.createFilter(pc);
                if (!(sdk instanceof ISDK) || filter.acceptOptions((ISDK)sdk)) continue;
                this.setErrorMessage(NLS.bind((String)Messages.S32DSMultiPageTwo_sdk_does_not_fit_to_params, (Object)sdk.getName()));
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        if (this.pageManager != null) {
            this.pageManager.update();
        }
    }

    private boolean checkSdkPresence() {
        String processSDKTag = this.getProcessSdkTag();
        if (processSDKTag != null && !processSDKTag.isEmpty()) {
            for (ProjectContext ctx : this.getWizard().getContext().getResultProjectContexts()) {
                CProjectMasterContext pc;
                if (!(ctx instanceof CProjectMasterContext) || !(pc = (CProjectMasterContext)ctx).getSdkList().isEmpty()) continue;
                this.setErrorMessage(Messages.S32DSMultiPageTwo_sdk_not_specified);
                return false;
            }
        }
        return true;
    }

    private void initSdksLists() {
        String processSDKTag = this.getProcessSdkTag();
        if (processSDKTag != null && !processSDKTag.isEmpty()) {
            for (ProjectContext ctx : this.getWizard().getContext().getResultProjectContexts()) {
                if (!(ctx instanceof CProjectMasterContext)) continue;
                CProjectMasterContext pc = (CProjectMasterContext)ctx;
                AbstractSmartFilter filter = this.createFilter(pc);
                List sdkList = SDKUtils.filter((ISDKFilter)filter);
                List sdkListbyProcessTag = (List)SDKUtils.groupSdksByTag((List)sdkList).get(processSDKTag);
                pc.setSdkList(sdkListbyProcessTag);
            }
        }
    }

    private String getProcessSdkTag() {
        ProcessorData pd = this.processorContext.getProcessor();
        if (pd != null) {
            return pd.getSdkTag();
        }
        return "";
    }

    private AbstractSmartFilter createFilter(final CProjectMasterContext pc) {
        return new AbstractSmartFilter(){

            public IFilterOptions options() {
                return FilterOptions.createFilter((ISDKFilterInfo)Page2Utils.createSDKFilterInfo((CProjectContext)pc));
            }

            public boolean accept(ISDK sdk) {
                return true;
            }
        };
    }
}

