/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.ISDKFilterInfo;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ValueType;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.sdk.ui.SDKDialogCellEditor;
import com.freescale.s32ds.cross.wizard.page2.MemorySpinnerAdapter;
import com.freescale.s32ds.cross.wizard.page2.Page2AbstractManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class Page2Utils {
    private static final int KILO = 1024;
    private static final int INCREMENT = 32;
    private static final int PAGE_INCR = 128;
    private static final String OX = "0x";

    public static String getCommonLabelValue(Parameter parameter, CProjectContext projectContext) {
        Object value = projectContext.getValue(parameter.getTag());
        if (parameter.getValueType() == ValueType.LONG) {
            return Page2Utils.getLongDisplayValue(value);
        }
        return value != null ? value.toString() : "null";
    }

    public static String getLongDisplayValue(Object value) {
        String str = value instanceof Long ? Long.toHexString((Long)value) : value.toString();
        return Page2Utils.formatLongTextValue(str);
    }

    public static String formatLongTextValue(String v) {
        if (!v.isEmpty() && !v.startsWith(OX)) {
            v = OX + v;
        }
        return v;
    }

    public static Button createChecbox(CProjectContext projectContext, String text, boolean checked, SelectionListener selectionListener, Composite parent) {
        Button b = new Button(parent, 32);
        b.setText(text);
        b.setSelection(checked);
        b.addSelectionListener(selectionListener);
        return b;
    }

    public static Label createLabel(String text, Composite parent) {
        return Page2Utils.createLabel(text, text, parent);
    }

    public static Label createLabel(String text, String tooltip, Composite parent) {
        Label label = new Label(parent, 64);
        label.setToolTipText(tooltip);
        label.setText(text);
        return label;
    }

    public static Text createText(String text, Composite parent) {
        Text txt = new Text(parent, 0);
        txt.setText(text);
        txt.setEditable(false);
        return txt;
    }

    public static Control createSDKDialog(CProjectContext projectContext, SDKDialogCellEditor.SDKDialogEditorListener listener, Composite parent) {
        return SDKDialogCellEditor.getControl((Composite)parent, (CProjectContext)projectContext, (ISDKFilterInfo)Page2Utils.createSDKFilterInfo(projectContext), (SDKDialogCellEditor.SDKDialogEditorListener)listener);
    }

    public static ISDKFilterInfo createSDKFilterInfo(final CProjectContext projectContext) {
        ISDKFilterInfo filterInfo = new ISDKFilterInfo(){

            public CoreNatureData getCurrenCoreNature() {
                return projectContext.getCoreNature();
            }

            public ProcessorData getProcessor() {
                return projectContext.getProcessor();
            }

            public IToolChain[] getToolchain() {
                IProjectType[] definedProjectTypes;
                ArrayList<IToolChain> toolChains = new ArrayList<IToolChain>();
                String buildArtifactProjectTypeId = projectContext.getTargetProjectTypeId();
                IProjectType[] iProjectTypeArray = definedProjectTypes = ManagedBuildManager.getDefinedProjectTypes();
                int n = definedProjectTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectType pt = iProjectTypeArray[n2];
                    IBuildPropertyValue buildArtefactType = pt.getBuildArtefactType();
                    if (buildArtefactType != null && buildArtefactType.getId().equals(buildArtifactProjectTypeId)) {
                        IConfiguration[] iConfigurationArray = pt.getConfigurations();
                        int n3 = iConfigurationArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfiguration cgf = iConfigurationArray[n4];
                            toolChains.add(cgf.getToolChain());
                            ++n4;
                        }
                    }
                    ++n2;
                }
                return toolChains.toArray(new IToolChain[toolChains.size()]);
            }

            public String getLanguage() {
                return projectContext.getStringValue("language");
            }
        };
        return filterInfo;
    }

    public static Control createCombo(CProjectContext projectContext, Parameter parameter, SelectionListener listener, Composite parent) {
        DataSet dataSet = projectContext.getDataSet(parameter.getTag());
        Combo combo = new Combo(parent, 12);
        Page2Utils.setComboData(combo, dataSet);
        Point p = combo.computeSize(-1, 0x1000000);
        combo.setSize(p);
        combo.addSelectionListener(listener);
        return combo;
    }

    public static Spinner createSpinner(CProjectContext projectContext, Parameter parameter, Page2AbstractManager page2Manager, Composite parent) {
        Spinner spinner = new Spinner(parent, 8);
        spinner.setMinimum(0);
        spinner.setMaximum(Integer.MAX_VALUE);
        spinner.setIncrement(32);
        spinner.setPageIncrement(128);
        Page2Utils.setSpinnerData(spinner, projectContext.getLongValue(parameter.getTag()));
        MemorySpinnerAdapter spinnerAdapter = new MemorySpinnerAdapter(page2Manager, spinner, projectContext, parameter.getTag());
        spinner.addSelectionListener((SelectionListener)spinnerAdapter);
        spinner.addKeyListener((KeyListener)spinnerAdapter);
        return spinner;
    }

    public static void setComboData(Combo combo, DataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        String selection = combo.getText();
        combo.removeAll();
        int index = -1;
        List datas = dataSet.getElements();
        int i = 0;
        while (i < datas.size()) {
            String name = ((ConfigurationData)datas.get(i)).getName();
            combo.add(name);
            if (index < 0 && name.equals(selection)) {
                index = i;
            }
            ++i;
        }
        combo.select(index < 0 || index > datas.size() - 1 ? 0 : index);
    }

    public static void setSpinnerData(Spinner spinner, long lv) {
        int v = (int)lv / 1024;
        spinner.setSelection(v);
    }
}

