/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.DebuggerSupport;
import com.freescale.s32ds.cross.core.LaunchSetup;
import com.freescale.s32ds.cross.core.lingvo.Lingvo;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.debugger.registry.core.ArchetypeDebuggerConfigurationDescriptors;
import com.nxp.s32ds.cle.ide.debugger.registry.descriptor.ArchetypeDebuggerLaunchConfigurationDescriptor;
import com.nxp.s32ds.ext.ide.launch.core.LaunchConfigurationSupportConstants;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class LaunchConfigUtil {
    private static final String ARCHETYPE_LAUNCHCONFIGURATION_DEFINITION = "archetype.launchconfiguration";
    private static final int MPC5777M_CORE_COUNT = 3;
    public static final Lingvo LINGVO = new Lingvo();
    private static final String ATTR_PRJ_ATTR = "org.eclipse.cdt.launch.PROJECT_ATTR";
    private static final String ATTR_PRG_NAME = "org.eclipse.cdt.launch.PROGRAM_NAME";
    private static final String ATTR_PPC_DEV = "com.pemicro.debug.gdbjtag.ppc.PE.DEVICE_NAME";
    private static final String ATTR_PPC_NUM = "com.pemicro.debug.gdbjtag.ppc.selectedCoreNumber";
    private static final String ATTR_SEG_DEV = "ilg.gnuarmeclipse.debug.gdbjtag.jlink.gdbServerDeviceName";
    static LaunchSetup data = null;
    private static final int NUM_NAMES = 2;
    private static final String[][] MPC_DATA;
    private static final Map<String, DebuggerSupport> debuggers;

    static {
        String[][] stringArrayArray = new String[5][];
        stringArrayArray[0] = new String[]{"MPC564", "C", "Z4", "Z0"};
        stringArrayArray[1] = new String[]{"MPC574", "G", "Z4", "Z4", "Z2"};
        stringArrayArray[2] = new String[]{"MPC577", "K", "Z4", "Z7", "Z7"};
        stringArrayArray[3] = new String[]{"MPC577", "M", "Z4", "Z7", "Z7"};
        String[] stringArray = new String[5];
        stringArray[0] = "S32R274";
        stringArray[2] = "Z4";
        stringArray[3] = "Z7";
        stringArray[4] = "Z7";
        stringArrayArray[4] = stringArray;
        MPC_DATA = stringArrayArray;
        debuggers = new HashMap<String, DebuggerSupport>();
    }

    public static void setConfigurationDefaults(ILaunchConfigurationWorkingCopy config, IProject project, CoreData core, File program, int coreNum) {
        data = new LaunchSetup();
        String deviceId = core.getProcessor().getDevice();
        if (deviceId != null && !deviceId.isEmpty()) {
            data.setDeviceId(deviceId);
        } else {
            data.setDeviceId(core.getProcessor().getId());
        }
        data.setCoreKindName(core.getCoreKind().getName());
        data.setProject(project);
        data.setCoreId(core.getId());
        data.setProcessorId(core.getProcessor().getId());
        data.setFamilyId(core.getProcessor().getFamily().getId());
        data.setProgramName(program.getName());
        data.setProgramPath(program.getPath().toString());
        LaunchConfigUtil.setConfigurationDefaults(config, data, coreNum);
    }

    private static String extractDeviceId(String processorName) {
        int indexOfSpace = processorName.indexOf(" ");
        if (indexOfSpace > 0) {
            return processorName.substring(0, indexOfSpace);
        }
        return processorName;
    }

    public static void setConfigurationDefaults(ILaunchConfigurationWorkingCopy config, LaunchSetup data, int coreNum) {
        try {
            LaunchConfigUtil.processWithDebuggerSupport(config, data);
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e.getStatus());
            return;
        }
        LaunchConfigUtil.setCommonProjectAttributes(config, data.getProject(), data.getProgramName());
        if (LaunchConfigUtil.isSupportedPowerProcessor(data.getProcessorId())) {
            LaunchConfigUtil.setPowerAttributes(config, data.getProcessorId(), coreNum);
        } else if (LaunchConfigUtil.isSupportedARMProcessor(data.getProcessorId())) {
            String targetProcessorId = LINGVO.mapToLingvo(data.getProcessorId(), "pemicro.Target");
            if (targetProcessorId == null) {
                S32DSWizardPlugin.logWarning(String.format(Messages.ImportExeWizard_ArmIsNotInTheLingvo, new Object[0]));
                return;
            }
            LaunchConfigUtil.setArmAttributes(config, data.getDeviceId(), data.getProcessorId(), targetProcessorId, data.getCoreId());
        } else {
            S32DSWizardPlugin.logWarning(String.format(Messages.ImportExeWizard_NeitherArmNorPower, data.getProcessorId()));
        }
    }

    private static void setArmAttributes(ILaunchConfigurationWorkingCopy config, String deviceId, String procId, String targetProcessorId, String coreId) {
        config.setAttribute(ATTR_SEG_DEV, LINGVO.mapToLingvo(procId, "segger.Target"));
    }

    private static void setPowerAttributes(ILaunchConfigurationWorkingCopy config, String procId, int assumedCoreNum) {
        if ("MPC5777M".equals(procId)) {
            assumedCoreNum = 3 - assumedCoreNum;
        }
        if (assumedCoreNum <= 0) {
            assumedCoreNum = 1;
        }
        config.setAttribute(ATTR_PPC_DEV, procId);
        config.setAttribute(ATTR_PPC_NUM, assumedCoreNum);
    }

    private static void setCommonProjectAttributes(ILaunchConfigurationWorkingCopy config, IProject project, String programName) {
        config.setContainer((IContainer)project.getProject());
        config.setMappedResources(new IResource[]{project.getProject()});
        config.setAttribute(ATTR_PRJ_ATTR, project.getProject().getName());
        config.setAttribute(ATTR_PRG_NAME, programName);
        config.setAttribute("process_factory_id", "org.eclipse.cdt.dsf.gdb.GdbProcessFactory");
    }

    public static int calcCoreIndex(String proc, String core) {
        if (proc != null && core != null) {
            proc = proc.toUpperCase();
            core = core.toUpperCase();
            String[][] stringArray = MPC_DATA;
            int n = MPC_DATA.length;
            int n2 = 0;
            while (n2 < n) {
                String[] data = stringArray[n2];
                if (proc.startsWith(data[0]) && (data[1] == null || proc.endsWith(data[1]))) {
                    int i = 2;
                    while (i < data.length) {
                        if (core.equals(data[i])) {
                            return --i;
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        return 1;
    }

    private static boolean isSupportedARMProcessor(String proc) {
        if (proc == null || proc.isEmpty()) {
            return false;
        }
        return (proc = proc.toLowerCase().trim()).startsWith("skeaz") || proc.startsWith("keaz") || proc.startsWith("mac") || proc.startsWith("s32k") || proc.startsWith("s32v") || proc.startsWith("s32g") || proc.startsWith("s32r") || proc.startsWith("s32s");
    }

    private static boolean isSupportedPowerProcessor(String proc) {
        if (proc == null || proc.isEmpty()) {
            return false;
        }
        return (proc = proc.toLowerCase().trim()).startsWith("mpc") || proc.startsWith("s32r");
    }

    private static void processWithDebuggerSupport(ILaunchConfigurationWorkingCopy config, LaunchSetup data) throws CoreException {
        String launchTypeIdentifier = config.getType().getIdentifier();
        ArchetypeDebuggerLaunchConfigurationDescriptor descriptor = ArchetypeDebuggerConfigurationDescriptors.getArchetypeDebugerConfigurationDescriptor((String)ARCHETYPE_LAUNCHCONFIGURATION_DEFINITION, (String)launchTypeIdentifier);
        LaunchConfigurationCreator configurationCreator = descriptor.getLaunchConfigurationCreator();
        if (configurationCreator != null) {
            HashMap<String, String> mapParams = new HashMap<String, String>();
            mapParams.put("com.nxp.s32ds.cle.runtime.component.registry.component.id", data.getProgramName());
            mapParams.put("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", data.getCoreId());
            mapParams.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", data.getDeviceId());
            mapParams.put("com.nxp.s32ds.cle.runtime.hardware.registry.family.id", data.getFamilyId());
            mapParams.put(LaunchConfigurationSupportConstants.PROJECT_KEY, (String)data.getProject());
            mapParams.put("projectName", data.getProject().getName());
            mapParams.put("projectExecutable", data.getProgramPath());
            configurationCreator.setupLaunchConfigurationWorkingCopy(config, mapParams);
        } else {
            LaunchConfigUtil.compatibilityCofigurationSuppoprt(config, data);
        }
    }

    private static void compatibilityCofigurationSuppoprt(ILaunchConfigurationWorkingCopy config, LaunchSetup data) throws CoreException {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extension = registry.getExtensionPoint("com.freescale.s32ds.cross.core", "Debugger");
        if (extension == null) {
            Activator.logWarning((String)"No Debugger Support Extensions found.");
            return;
        }
        IExtension[] iExtensionArray = extensions = extension.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                String id = cfgEl.getAttribute("id");
                if ("debugger".equals(cfgEl.getName()) && !debuggers.containsKey(id)) {
                    try {
                        DebuggerSupport support = (DebuggerSupport)cfgEl.createExecutableExtension("support");
                        debuggers.put(id, support);
                    }
                    catch (CoreException e) {
                        debuggers.put(id, null);
                        Activator.log((IStatus)new Status(2, "com.freescale.s32ds.cross.core", "Debugger " + id + " support error: " + e.getMessage()));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        DebuggerSupport support = LaunchConfigUtil.findSupport(config, data);
        if (support != null) {
            support.setup(config, data);
        } else {
            Activator.log((IStatus)new Status(2, "com.freescale.s32ds.cross.core", "Suuport class not found for type " + config.getType().getIdentifier()));
        }
    }

    private static DebuggerSupport findSupport(ILaunchConfigurationWorkingCopy config, LaunchSetup data) {
        for (DebuggerSupport ds : debuggers.values()) {
            if (ds == null) continue;
            try {
                if (!ds.isSupported(config.getType().getIdentifier(), data)) continue;
                return ds;
            }
            catch (CoreException e) {
                Activator.logWarning((String)e.getMessage());
            }
        }
        return null;
    }
}

