/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.core.lingvo.Lingvo;
import com.freescale.s32ds.cross.wizard.EmbSysSettingsUtil;
import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.imports.IImportConverter;
import com.freescale.s32ds.cross.wizard.imports.ImportConvertorHolder;
import com.freescale.s32ds.cross.wizard.imports.ImportPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.templateengine.CreateProjectProgressMonitor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizard;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ImportWizard
extends ExternalProjectImportWizard {
    private static final String CREATION_PROBLEM = Messages.ImportWizard_CreateProblem;
    private static final String QUOTE = "\"";
    private static final String ART = "artifactName=\"";
    private static final FileSystemStructureProvider FSS_PROV = FileSystemStructureProvider.INSTANCE;
    private static final String CPROJECT = ".cproject";
    private static final String PROJECT = ".project";
    private static final String CONFIG = "<configuration";
    private static final String NAME = "name=\"";
    private static final String QUESTION = "?";
    private static final String GREATER = ">";
    private static final String MCPU = ".mcpu.";
    private static final char SL = '/';
    private static final char BSL = '\\';
    private static final char QT = '\"';
    private static final int CHR_QUOTE = 34;
    private static final int CHR_AMP = 38;
    protected ImportPage page;
    private String proc = null;
    private String core = null;
    protected List<ImportConvertorHolder> convs = new ArrayList<ImportConvertorHolder>();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.wizard.ImportToS32DSConvertor");
        if (ep != null) {
            this.convs.clear();
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    ImportConvertorHolder c = new ImportConvertorHolder(ce);
                    if (c.isReady && this.convertorFits(c)) {
                        this.convs.add(c);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ImportWizard_ImportToS32DS);
        this.page = new ImportPage(this.convs);
        this.setDefaultPageImageDescriptor(this.page.IMG);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        String locationStr = this.page.getLocation();
        String fn = String.valueOf(locationStr) + File.separator + CPROJECT;
        File proj = new File(fn);
        String err = null;
        ImportConvertorHolder imp = null;
        if (proj.exists()) {
            for (ImportConvertorHolder c : this.convs) {
                err = ((IImportConverter)c.clazz).fits(locationStr, this.page.isStrict(), this.page.isPE());
                if (err != null) continue;
                imp = c;
                break;
            }
        } else {
            err = String.valueOf(Messages.ImportWizard_NoProjectDetected) + fn;
        }
        if (err != null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            String s = err;
            shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.ImportWizard_ProjectImportFailure, (String)(String.valueOf(s) + Messages.ImportWizard_ChooseAnother)));
            return false;
        }
        if (imp == null) {
            return false;
        }
        return this.createProject(new File(String.valueOf(locationStr) + File.separator + PROJECT), (IImportConverter)imp.clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createProject(File file, IImportConverter clazz) {
        try {
            String ein;
            Path path = new Path(file.getPath());
            String projectName = this.page.getProjectName();
            IWorkspace wsp = ResourcesPlugin.getWorkspace();
            IProject prj = wsp.getRoot().getProject(projectName);
            IProjectDescription description = this.page.isDefaultLocation((IPath)path) ? wsp.newProjectDescription(projectName) : wsp.loadProjectDescription((IPath)path);
            description.setName(projectName);
            File importSource = null;
            URI uri = description.getLocationURI();
            if (this.page.needCopy()) {
                if (uri != null) {
                    IStatus result = ResourcesPlugin.getWorkspace().validateProjectLocationURI(prj, uri);
                    if (!result.isOK()) {
                        throw new InvocationTargetException(new CoreException(result));
                    }
                    importSource = new File(uri);
                    description = this.createProjectDescription(projectName, wsp, description);
                } else {
                    S32DSWizardPlugin.logWarning(String.valueOf(Messages.ImportWizard_ProjectExists) + description);
                }
            }
            String aus = String.valueOf(ImportPage.WORKSPACE) + '/' + this.page.getProjectName();
            String string = ein = uri == null ? aus : new File(uri).getPath();
            if (!this.convert(ein, aus, clazz, this.page.needCopy())) {
                return false;
            }
            IProjectDescription finalDesc = description;
            WorkspaceModifyOperation op = this.createWorkspaceModifyOperation(prj, finalDesc);
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException e) {
                S32DSWizardPlugin.log(e);
                return false;
            }
            catch (InvocationTargetException e) {
                this.processError(projectName, e);
                return false;
            }
            if (this.page.needCopy() && importSource != null) {
                this.importOperationToImportProjectFiles(clazz, prj, importSource);
            }
            ProjectSettings.createHWPrefs((IProject)prj, (String)this.getProc(), (String)this.getCore());
            this.setDescriptionData(prj);
            prj.refreshLocal(2, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)new CreateProjectProgressMonitor()));
            return true;
        }
        catch (Exception e) {
            S32DSWizardPlugin.log(e);
            ErrorDialog.openError((Shell)this.getShell(), (String)CREATION_PROBLEM, (String)e.getMessage(), null);
            return false;
        }
    }

    private void processError(String projectName, InvocationTargetException e) {
        S32DSWizardPlugin.log(e);
        Throwable t = e.getTargetException();
        if (t instanceof CoreException) {
            if (((CoreException)t).getStatus().getCode() == 275) {
                MessageDialog.open((int)1, (Shell)this.getShell(), (String)CREATION_PROBLEM, (String)NLS.bind((String)Messages.ImportWizard_NameConflict, (Object)projectName), (int)0x10000000);
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)CREATION_PROBLEM, null, (IStatus)((CoreException)t).getStatus());
            }
        }
    }

    private WorkspaceModifyOperation createWorkspaceModifyOperation(final IProject prj, final IProjectDescription finalDesc) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", 2000);
                prj.create(finalDesc, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                prj.open(128, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
            }
        };
        return op;
    }

    private void importOperationToImportProjectFiles(IImportConverter clazz, IProject prj, File importSource) throws InvocationTargetException, InterruptedException {
        List<String> configs = this.listConfigs(FSS_PROV.getChildren((Object)importSource));
        configs.add(CPROJECT);
        configs.add(PROJECT);
        List filesToImport = FSS_PROV.getChildren((Object)importSource).stream().filter(f -> !this.isEnds(configs, f.getPath())).collect(Collectors.toList());
        new ImportOperation(prj.getFullPath(), importSource, (IImportStructureProvider)FSS_PROV, (IOverwriteQuery)this.page, filesToImport){
            {
                this.setContext(ImportWizard.this.getShell());
                this.setOverwriteResources(true);
                this.setCreateContainerStructure(false);
                this.run((IProgressMonitor)new CreateProjectProgressMonitor());
            }
        };
        Thread.sleep(100L);
        clazz.postProcess(prj.getFullPath().toString());
    }

    private IProjectDescription createProjectDescription(String projectName, IWorkspace wsp, IProjectDescription description) {
        IProjectDescription desc = wsp.newProjectDescription(projectName);
        desc.setBuildSpec(description.getBuildSpec());
        desc.setComment(description.getComment());
        desc.setDynamicReferences(description.getDynamicReferences());
        desc.setNatureIds(description.getNatureIds());
        desc.setReferencedProjects(description.getReferencedProjects());
        return desc;
    }

    private boolean isEnds(List<String> ends, String text) {
        for (String s : ends) {
            if (!text.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    private List<String> listConfigs(List<File> lst) {
        ArrayList<String> result = new ArrayList<String>();
        if (lst != null && !lst.isEmpty()) {
            block7: for (File f : lst) {
                if (!CPROJECT.equals(f.getName())) continue;
                try {
                    Throwable throwable = null;
                    Object var6_7 = null;
                    try (FileInputStream fis = new FileInputStream(f);){
                        byte[] b = new byte[fis.available()];
                        fis.read(b);
                        fis.close();
                        String s = new String(b);
                        b = null;
                        int n = s.indexOf(CONFIG);
                        while (n > 0) {
                            int m = s.indexOf(NAME, n);
                            if (m <= n || s.substring(n, m).contains(GREATER)) continue block7;
                            int k = s.indexOf(34, m += NAME.length());
                            if (k > m) {
                                result.add(new String(s.substring(m, k)));
                            }
                            n = s.indexOf(CONFIG, m);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private void setDescriptionData(IProject p) throws CoreException {
        Lingvo lingvo = new Lingvo();
        ICProjectDescription cd = CoreModel.getDefault().getProjectDescription(p);
        new HashMap<String, String>(lingvo){
            {
                this.put("register_architecture", lingvo.mapToLingvo(ImportWizard.this.core, "cw.Name"));
                this.put("register_vendor", EmbSysSettingsUtil.getVendor(lingvo.mapToLingvo(ImportWizard.this.getProc(), "cw.Name")));
                this.put("register_chip", lingvo.mapToLingvo(ImportWizard.this.getProc(), "cw.Name"));
                this.put("register_board", "---  none ---");
            }
        }.forEach((arg_0, arg_1) -> ((ICStorageElement)cd.getStorage("org.eclipse.embsys", true)).setAttribute(arg_0, arg_1));
        CoreModel.getDefault().setProjectDescription(p, cd, true, null);
    }

    private boolean convert(String ein, String aus, IImportConverter clazz, boolean needCopy) {
        IToolChain tc = this.page.getToolchain();
        String tcs = null;
        if (tc != null) {
            tcs = " superClass=\"" + tc.getId() + ".debug\">";
        }
        String cpro = String.valueOf(File.separator) + CPROJECT;
        try {
            String fn = String.valueOf(ein) + cpro;
            File proj = new File(fn);
            if (proj.exists()) {
                boolean isPE = new File(String.valueOf(ein) + File.separator + "ProcessorExpert.pe").exists();
                if (needCopy) {
                    File out = new File(String.valueOf(aus) + cpro);
                    ImportWizard.copy(proj, out);
                    fn = out.getPath();
                    proj = out;
                }
                File bak = new File(String.valueOf(fn) + ".bak");
                bak.delete();
                FileInputStream fis = new FileInputStream(proj);
                byte[] b = new byte[fis.available()];
                fis.read(b);
                fis.close();
                String s = new String(b);
                b = null;
                proj.renameTo(bak);
                int n = ein.replace('\\', '/').lastIndexOf(47);
                String oldName = n < 0 ? ein : ein.substring(n + 1);
                n = aus.replace('\\', '/').lastIndexOf(47);
                String newName = n < 0 ? aus : aus.substring(n + 1);
                s = s.replace(ART + oldName + QUOTE, ART + newName + QUOTE);
                s = clazz.convert(s, tcs, isPE, ein.replace('\\', '/'));
                proj = new File(String.valueOf(needCopy ? aus : ein) + cpro);
                FileOutputStream fos = new FileOutputStream(proj);
                byte[] bs = s.getBytes();
                fos.write(bs);
                fos.close();
                this.setCoreAndProc(clazz, s);
            }
        }
        catch (Exception e) {
            S32DSWizardPlugin.log(e, Arrays.toString(e.getStackTrace()));
        }
        return true;
    }

    private void setCoreAndProc(IImportConverter clazz, String s) {
        this.setProc(clazz.toS32DSproc(this.obtainProc(s)));
        this.setCore(clazz.toS32DScore(this.obtainCore(s)));
    }

    private String obtainProc(String s) {
        int x = s.indexOf(".ld");
        if (x > 0 && (s.charAt(x + 3) == '\"' || s.charAt(x + 3) == '&')) {
            int i = x - 1;
            while (i >= 0) {
                char c = s.charAt(i);
                if (c == '\"' || c == '/' || c == '\\') {
                    String z = s.substring(i + 1, x - 1);
                    if ((x = z.indexOf(95)) > 0) {
                        z = z.substring(0, x);
                    }
                    return z;
                }
                --i;
            }
        }
        return QUESTION;
    }

    private String obtainCore(String s) {
        int x = 0;
        while (x < s.length()) {
            char c;
            int y = s.indexOf(MCPU, x);
            if (y <= -1 || (c = s.charAt(x = y + MCPU.length())) >= '0' && c <= '9' || (y = s.indexOf(34, x)) <= -1) continue;
            String core = s.substring(x, y);
            return core;
        }
        return QUESTION;
    }

    private static void copy(File from, File to) {
        try {
            to.getParentFile().mkdirs();
            Files.copy(from.toPath(), to.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            S32DSWizardPlugin.log(e);
        }
    }

    public void showMsg(String h, String s) {
        Shell shell = EclipseUtils.getShell();
        shell.getDisplay().syncExec(() -> MessageDialog.openWarning((Shell)shell, (String)h, (String)s));
    }

    protected boolean convertorFits(ImportConvertorHolder c) {
        return true;
    }

    public String getProc() {
        return this.proc;
    }

    public void setProc(String proc) {
        this.proc = proc;
    }

    public String getCore() {
        return this.core;
    }

    public void setCore(String core) {
        this.core = core;
    }
}

