/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.nxp.s32ds.ext.rcp.databinding.ValidationDescriptors;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.ui.importexecutable.AbstractImportExecutableWizard;
import org.eclipse.cdt.debug.ui.importexecutable.ImportExecutablePageTwo;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ImportExePage2
extends ImportExecutablePageTwo {
    private static final String SRC_KEY = "SRC_KEY";
    private static final int BUTTON_WIDTH = 80;
    private static final int TEXT_WIDTH = 200;
    private String source = "";
    private Text config = null;
    private final List<String> LAUNCH_CFGS;
    Collection<IValidator> nameValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.name.validators");
    Collection<IValidator> pathValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.path.validators");
    private final CompositeValidator compositeNameValidator = new CompositeValidator(new ArrayList<IValidator>(this.nameValidators));
    private final CompositeValidator compositePathValidator = new CompositeValidator(new ArrayList<IValidator>(this.pathValidators));

    protected ImportExePage2(AbstractImportExecutableWizard wizard) {
        super(wizard);
        ArrayList<String> lst = new ArrayList<String>();
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration cfg = iLaunchConfigurationArray[n2];
                lst.add(cfg.getName());
                ++n2;
            }
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
        this.LAUNCH_CFGS = Collections.unmodifiableList(lst);
    }

    public ICProject getExistingCProject() {
        return super.getExistingCProject();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Control[] children = parent.getChildren();
        Composite c = (Composite)((Composite)children[children.length - 1]).getChildren()[0];
        boolean isDebuggerFound = false;
        Control[] controlArray = c.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control cc = controlArray[n2];
            if (cc instanceof Composite) {
                this.setDebugger(cc);
                isDebuggerFound = true;
            }
            if (isDebuggerFound && cc instanceof Text) {
                this.config = (Text)cc;
            }
            ++n2;
        }
        new Label(c, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        Label l = new Label(c, 0);
        l.setText(Messages.ImportExePage2_source_path);
        l.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Text t = new Text(c, 2060);
        GridData d = new GridData(4, 0x1000000, true, false);
        d.minimumWidth = 200;
        d.widthHint = 200;
        t.setLayoutData((Object)d);
        Button b = new Button(c, 8);
        b.setText(Messages.ImportExePage2_browse);
        d = new GridData(4, 0x1000000, true, false);
        d.minimumWidth = 80;
        d.widthHint = 80;
        b.setLayoutData((Object)d);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ImportExePage2.this.getShell(), 0x10000000);
                dialog.setText(Messages.ImportExePage2_folder_select);
                dialog.setMessage(Messages.ImportExePage2_specify_src_folder);
                dialog.setFilterPath(InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support").get(ImportExePage2.SRC_KEY, ""));
                String res = dialog.open();
                if (res != null) {
                    ImportExePage2.this.source = new Path(res).makeAbsolute().toOSString();
                    t.setText(ImportExePage2.this.source);
                    ImportExePage2.this.savePref(ImportExePage2.SRC_KEY, ImportExePage2.this.source);
                }
            }
        });
        b = new Button(c, 8);
        b.setText(Messages.ImportExePage2_clear);
        d = new GridData(4, 0x1000000, true, false);
        d.minimumWidth = 80;
        d.widthHint = 80;
        b.setLayoutData((Object)d);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExePage2.this.source = "";
                t.setText(ImportExePage2.this.source);
            }
        });
    }

    private void setDebugger(Control cc) {
        Control[] controlArray = ((Composite)cc).getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            if (ctrl instanceof Combo) {
                String[] items = ((Combo)ctrl).getItems();
                int position = 0;
                int i = 0;
                while (i < items.length) {
                    if (items[i].startsWith("GDB PEM")) {
                        position = i;
                        break;
                    }
                    ++i;
                }
                ((Combo)ctrl).select(position);
                break;
            }
            ++n2;
        }
    }

    private void savePref(String key, String val) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support");
        prefs.put(key, val);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            SDKSupportPlugin.error((Throwable)e);
        }
    }

    public String getSource() {
        return this.source;
    }

    public boolean isPageComplete() {
        if (this.isCreateNewProjectSelected()) {
            IStatus nameStatus = this.compositeNameValidator.validate((Object)this.getNewProjectName());
            if (!nameStatus.isOK()) {
                this.setErrorMessage(nameStatus.getMessage());
                return false;
            }
            String pathStr = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + "/" + this.getNewProjectName() + "/";
            IStatus pathStatus = this.compositePathValidator.validate((Object)pathStr);
            if (!pathStatus.isOK()) {
                this.setErrorMessage(pathStatus.getMessage());
                return false;
            }
        }
        if (this.config != null) {
            String name = this.config.getText().trim();
            try {
                DebugPlugin.getDefault().getLaunchManager().isValidLaunchConfigurationName(name);
            }
            catch (IllegalArgumentException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
            IProject existedProject = this.getExistingCProject() == null ? null : this.getExistingCProject().getProject();
            String pathStr = String.valueOf(existedProject == null ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() : existedProject.getProject().getLocation().toOSString()) + "/" + this.getNewProjectName() + "/";
            Path path = new Path(pathStr);
            IValidator validator = ValidationDescriptors.getValidatorByValidatorId((String)"launch.name.validator");
            IStatus validationResult = validator.validate((Object)(path + "/" + name));
            if (!validationResult.isOK()) {
                this.setErrorMessage(validationResult.getMessage());
                return false;
            }
            for (String s : this.LAUNCH_CFGS) {
                if (!name.equals(s)) continue;
                this.setErrorMessage(String.format(Messages.ImportExePage2_launch_cfg_exists, name));
                return false;
            }
        }
        return super.isPageComplete();
    }
}

