/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cross.wizard.Messages;
import com.nxp.s32ds.ext.rcp.databinding.ValidationDescriptors;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public abstract class AbstractImportPage
extends WizardDataTransferPage {
    protected static final String LOCALDISK = "Local Disk";
    protected static final String USERHOME = "user.home";
    protected static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    protected static final String WORKSPACE = ROOT.getLocation().toString();
    protected static final String NEW_PROJ_NAME = Messages.AbstractImportPage_NewProjectName;
    protected static final String SEARCH_PROJ = Messages.AbstractImportPage_SearchForProjects;
    protected static final String FROM_CUR_DIR = Messages.AbstractImportPage_FromUserDirectory;
    protected String msg;
    protected Text projectName;
    protected Canvas projectType;
    protected Image projectImage;
    protected Text location;
    protected boolean projectNameSetByUser;
    Collection<IValidator> nameValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.name.validators");
    private final CompositeValidator compositeNameValidator = new CompositeValidator(new ArrayList<IValidator>(this.nameValidators));

    public AbstractImportPage(String title, String desc) {
        super(title);
        this.setTitle(title);
        this.setDescription(desc);
    }

    public String getProjectName() {
        return this.projectName.getText().trim();
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
    }

    protected Text setText(Composite parent, String s) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(s);
        Text t = new Text((Composite)group, 2048);
        t.setLayoutData((Object)new GridData(4, 4, true, true));
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractImportPage.this.validatePage();
                if (AbstractImportPage.this.getProjectName().isEmpty()) {
                    AbstractImportPage.this.projectNameSetByUser = false;
                }
            }
        });
        return t;
    }

    protected void addProjectNameSelector(Composite parent) {
        this.projectName = this.setText(parent, NEW_PROJ_NAME);
        this.projectName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AbstractImportPage.this.projectNameSetByUser = true;
            }
        });
        this.projectType = new Canvas(this.projectName.getParent(), 0);
        this.projectType.setLayoutData((Object)new GridData(20, 20));
        this.projectType.addPaintListener(e -> {
            if (this.projectImage != null) {
                e.gc.drawImage(this.projectImage, 2, 2);
            } else {
                e.gc.fillRectangle(1, 1, 20, 20);
            }
        });
    }

    protected void validatePage() {
        this.projectImage = null;
        this.projectType.setToolTipText("");
        IStatus status = this.compositeNameValidator.validate((Object)this.getProjectName());
        this.msg = status.isOK() ? null : status.getMessage();
    }

    protected void addSearch(Composite comp) {
        String curr = System.getProperty(USERHOME);
        if (curr == null) {
            return;
        }
        Group g = new Group(comp, 2048);
        g.setLayoutData((Object)new GridData(4, 128, true, false));
        g.setLayout((Layout)new GridLayout(2, false));
        g.setText(SEARCH_PROJ);
        Button b0 = new Button((Composite)g, 16);
        b0.setText(NLS.bind((String)FROM_CUR_DIR, (Object)curr));
        b0.setData((Object)curr);
        b0.setLayoutData((Object)new GridData(4, 128, true, false));
        b0.setSelection(true);
        if (curr.length() > 1 && curr.charAt(1) == ':') {
            FileSystemView fsv = FileSystemView.getFileSystemView();
            File[] fileArray = File.listRoots();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File path = fileArray[n2];
                if (LOCALDISK.equals(fsv.getSystemTypeDescription(path))) {
                    Label lb = new Label((Composite)g, 0);
                    lb.setLayoutData((Object)new GridData(131072, 128, true, false));
                    b0 = new Button((Composite)g, 16);
                    b0.setText(String.valueOf(Messages.AbstractImportPage_FromHardDisk) + path.toString());
                    b0.setLayoutData((Object)new GridData(4, 128, true, false));
                    b0.setData((Object)path.toString());
                }
                ++n2;
            }
        }
        Button b = new Button((Composite)g, 8);
        b.setLayoutData((Object)new GridData(131072, 4, false, false));
        b.setText(Messages.AbstractImportPage_search);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control[] controlArray = ((Button)e.widget).getParent().getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object path;
                    Control c = controlArray[n2];
                    if (c instanceof Button && ((Button)c).getSelection() && (path = c.getData()) instanceof String) {
                        AbstractImportPage.this.callSearch((String)path);
                        break;
                    }
                    ++n2;
                }
            }
        });
    }

    public abstract void callSearch(String var1);
}

