/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard;

import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.utils.ExtensionUtils;
import com.freescale.s32ds.cross.wizard.IWizardParticipant;
import com.freescale.s32ds.cross.wizard.WizardArtifactType;
import com.nxp.s32ds.ext.ide.core.IProjectParticipant;
import com.nxp.s32ds.ext.ide.core.IProjectParticipantService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.HelpSystem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class S32DSWizardPlugin
extends AbstractUIPlugin {
    private static String productVersion;
    public static final String PLUGIN_ID = "com.freescale.s32ds.cross.wizard";
    public static final String PT_PARTICIPANTS = "participants";
    public static final String PT_PARTICIPANTS_PARTICIPANT = "participant";
    public static final String PT_PARTICIPANT_CLASS = "class";
    private static S32DSWizardPlugin plugin;
    private List<IWizardParticipant> wizardParticipants;
    private List<IProjectParticipant> projectParticipants;

    public static String makeHelpContextId(WizardArtifactType type, int page) {
        return S32DSWizardPlugin.makeHelpContextId(type, page, true, null);
    }

    public static String makeHelpContextId(WizardArtifactType type, int page, boolean fpuSupport, ProcessorData processorData) {
        StringBuilder sb = new StringBuilder();
        sb.append("com.freescale.s32ds.cross.wizard.NEW_" + (Object)((Object)type) + "_WIZ_PAGE" + page);
        if (processorData != null) {
            sb.append("_");
            sb.append(processorData.getId());
        } else if (page == 2 && type == WizardArtifactType.LIBRARY) {
            sb.append(fpuSupport ? "_with" : "_without");
            sb.append("_fpu");
        }
        sb.append("_context");
        String contextId = sb.toString();
        if (HelpSystem.getContext((String)contextId) != null) {
            return contextId;
        }
        if (processorData == null) {
            S32DSWizardPlugin.logWarning("Help for context " + contextId + " is missing.");
            return contextId;
        }
        return S32DSWizardPlugin.makeHelpContextId(type, page, fpuSupport, null);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.wizardParticipants = ExtensionUtils.getExecutableExtensions((String)PLUGIN_ID, (String)PT_PARTICIPANTS, (String)PT_PARTICIPANTS_PARTICIPANT, (String)PT_PARTICIPANT_CLASS, IWizardParticipant.class);
        IProjectParticipantService pps = (IProjectParticipantService)context.getService(context.getServiceReference(IProjectParticipantService.class));
        this.projectParticipants = pps.getParticipants();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.wizardParticipants != null) {
            this.wizardParticipants.clear();
            this.wizardParticipants = null;
        }
        if (this.projectParticipants != null) {
            this.projectParticipants.clear();
            this.projectParticipants = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static String getProductVersion() {
        if (productVersion != null) {
            return productVersion;
        }
        IProduct product = Platform.getProduct();
        String result = "";
        if (product != null) {
            URL url = product.getDefiningBundle().getResource("about.mappings");
            try {
                InputStream inputStream = url.openConnection().getInputStream();
                Properties properties = new Properties();
                properties.load(inputStream);
                String v = properties.getProperty("1");
                String b = properties.getProperty("0");
                if (v != null && !v.isEmpty()) {
                    result = result.concat("v" + v + " ");
                }
                if (b != null && !b.isEmpty()) {
                    result = result.concat("b" + b + " ");
                }
            }
            catch (IOException e) {
                S32DSWizardPlugin.log(e);
            }
        }
        productVersion = result;
        return productVersion;
    }

    public static S32DSWizardPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        S32DSWizardPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getMessage(), e);
        S32DSWizardPlugin.log((IStatus)status);
    }

    public static void log(Throwable e, String message) {
        Status status = new Status(4, PLUGIN_ID, message, e);
        S32DSWizardPlugin.log((IStatus)status);
    }

    public static void logWarning(String warningMessage) {
        Status status = new Status(2, PLUGIN_ID, warningMessage);
        S32DSWizardPlugin.log((IStatus)status);
    }

    public List<IProjectParticipant> getProjectParticipants() {
        if (this.wizardParticipants == null) {
            return Collections.emptyList();
        }
        return new ArrayList<IProjectParticipant>(this.projectParticipants);
    }

    public List<IWizardParticipant> getWizardParticipants() {
        if (this.wizardParticipants == null) {
            return Collections.emptyList();
        }
        return new ArrayList<IWizardParticipant>(this.wizardParticipants);
    }
}

