/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard;

import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.backend.FakeWizard;
import com.freescale.s32ds.cross.wizard.backend.IWizardWithData;
import com.freescale.s32ds.cross.wizard.backend.WizardBackend;
import com.freescale.s32ds.cross.wizard.template.TemplateUtils;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.cdt.codan.core.CodanCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSWizardHandler;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.wizard.IWizard;
import org.osgi.service.prefs.BackingStoreException;

public class S32DSWizardHandler
extends MBSWizardHandler {
    private final CProjectContext projectContext;

    public S32DSWizardHandler(String name, WizardBackend backend, CProjectContext projectContext) {
        super(name, null, (IWizard)new FakeWizard(backend));
        this.projectContext = projectContext;
    }

    public IToolChain[] getSelectedToolChains() {
        ProcessorContext processorContext = this.projectContext.getProcessorContext();
        List ts = processorContext.getSelectedToolChains();
        return ts.toArray(new IToolChain[ts.size()]);
    }

    public CfgHolder[] getCfgItems(boolean defaults) {
        String toolChainId;
        Template template = this.projectContext.getTargetTemplate();
        boolean isAPU = this.projectContext.getValue("apuCoProcessorEnable") == null ? false : (Boolean)this.projectContext.getValue("apuCoProcessorEnable");
        boolean isISP = this.projectContext.getValue("ispCoProcessorEnable") == null ? false : (Boolean)this.projectContext.getValue("ispCoProcessorEnable");
        String projectTypeId = template.getTemplateInfo().getProjectType();
        IProjectType projectType = S32DSWizardHandler.findProjectType(projectTypeId, toolChainId = template.getTemplateInfo().getToolChainIds()[0]);
        if (projectType != null) {
            IConfiguration[] configurations = this.filterConfigs(projectType.getConfigurations(), isAPU, isISP);
            return CfgHolder.cfgs2items((IConfiguration[])configurations);
        }
        IToolChain toolChain = this.projectContext.getRegistry().getToolChain(toolChainId);
        IConfiguration conf = ManagedBuildManager.getFirstExtensionConfiguration((IToolChain)toolChain);
        return CfgHolder.cfgs2items((IConfiguration[])new IConfiguration[]{conf});
    }

    IConfiguration[] filterConfigs(IConfiguration[] configurations, boolean isAPU, boolean isISP) {
        return (IConfiguration[])Stream.of(configurations).filter(c -> {
            String cfgId = c.getId();
            if ("com.freescale.s32ds.vision.gnu.arm.cortexa.elf".equals(cfgId) || "com.freescale.s32ds.vision.gnu.arm.linux.cortexa.elf".equals(cfgId) || "com.nxp.s32ds.cle.arm.mbs.arm64.linux.elf".equals(cfgId) || "com.nxp.s32ds.cle.arm.mbs.arm64.linux.test.elf".equals(cfgId) || "com.nxp.s32ds.cle.arm.mbs.arm64.bare.elf".equals(cfgId)) {
                return true;
            }
            if (isAPU && !isISP) {
                return "com.freescale.s32ds.vision.apu.elf".equals(cfgId) || "com.freescale.s32ds.vision.apu.emu".equals(cfgId) || "com.freescale.s32ds.vision.apu.acf".equals(cfgId) || "com.freescale.s32ds.vision.linux.apu.acf".equals(cfgId) || "com.freescale.s32ds.vision.linux.apu.elf".equals(cfgId) || "com.freescale.s32ds.vision.linux.arm64.apu.elf".equals(cfgId) || "com.freescale.s32ds.vision.linux.apu.emu".equals(cfgId) || "com.freescale.s32ds.vision.linux.arm64.apu.test.emu".equals(cfgId) || "com.freescale.s32ds.vision.linux.arm64.apu.emu".equals(cfgId);
            }
            if (isISP && !isAPU) {
                return "com.freescale.s32ds.vision.isp.elf".equals(cfgId) || "com.freescale.s32ds.vision.linux.isp.elf".equals(cfgId) || "com.freescale.s32ds.vision.linux.arm64.isp.elf".equals(cfgId);
            }
            if (isISP && isAPU) {
                return "com.freescale.s32ds.vision.apu.elf".equals(cfgId) || "com.freescale.s32ds.vision.isp.elf".equals(cfgId) || "com.freescale.s32ds.vision.apu.acf".equals(cfgId) || "com.freescale.s32ds.vision.linux.apu.acf".equals(cfgId) || "com.freescale.s32ds.vision.linux.apu.elf".equals(cfgId) || "com.freescale.s32ds.vision.linux.arm64.apu.elf".equals(cfgId) || "com.freescale.s32ds.vision.linux.isp.elf".equals(cfgId) || "com.freescale.s32ds.vision.linux.arm64.isp.elf".equals(cfgId);
            }
            return true;
        }).toArray(IConfiguration[]::new);
    }

    private static IProjectType findProjectType(String projectTypeId, String toolChainId) {
        IProjectType[] iProjectTypeArray = ManagedBuildManager.getDefinedProjectTypes();
        int n = iProjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectType pt = iProjectTypeArray[n2];
            if (pt.getBuildArtefactType() == null || pt.getBuildArtefactType().getId() == null) {
                S32DSWizardPlugin.logWarning("ProjectType " + pt.getId() + " has null build artefact type");
            } else if (pt.getBuildArtefactType().getId().equals(projectTypeId)) {
                IConfiguration[] iConfigurationArray = pt.getConfigurations();
                int n3 = iConfigurationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IToolChain parentTlch;
                    IConfiguration conf = iConfigurationArray[n4];
                    IToolChain tlch = conf.getToolChain();
                    if (tlch != null && (parentTlch = tlch.getSuperClass()) != null && parentTlch.getId().equals(toolChainId)) {
                        return pt;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    protected void doTemplatesPostProcess(IProject project) {
        TemplateUtils.processTemplate(this.cfgs, (IWizardWithData)this.getWizard(), this.projectContext, project);
    }

    protected void doCustom(IProject newProject) {
        this.setLaunchMethodForCheckersOptions(newProject);
    }

    private void setLaunchMethodForCheckersOptions(IProject newProject) {
        ProjectScope projectScope = new ProjectScope(newProject);
        IEclipsePreferences projectNode = projectScope.getNode(CodanCorePlugin.getDefault().getBundle().getSymbolicName());
        if (projectNode != null) {
            projectNode.putBoolean("onBuild", false);
            projectNode.putBoolean("inEditor", false);
            try {
                projectNode.flush();
            }
            catch (BackingStoreException e) {
                S32DSWizardPlugin.log(e);
            }
        }
    }
}

