/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.c.ui;

import com.nxp.s32ds.ext.rcp.jface.ValueValidator;
import com.nxp.s32ds.mdt.ide.c.defines.MdtCDefineRegistryManager;
import com.nxp.s32ds.mdt.ide.c.internal.ui.MdtCUiActivator;
import com.nxp.s32ds.mdt.ide.c.internal.ui.Messages;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class CIncludeSelectionDialogValidator<T extends EObject>
implements ValueValidator<String> {
    private final Set<String> pathes;
    private final T root;
    private final MdtCDefineRegistryManager<T> registryManager;

    public CIncludeSelectionDialogValidator(T root, MdtCDefineRegistryManager<T> registryManager) {
        this.root = root;
        this.registryManager = registryManager;
        this.pathes = registryManager.getIncludes(root).stream().map(i -> i.getPath()).collect(Collectors.toSet());
    }

    public IStatus validate(String include) {
        if (this.pathes.contains(include)) {
            return MdtCUiActivator.getInstance().createError(NLS.bind((String)Messages.CIncludeSelectionDialogValidator_graph_already_references_to_the_file_0, (Object)include));
        }
        return this.registryManager.canAddIncludeFile(this.root, include);
    }
}

