/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.c.ui;

import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.ext.rcp.jface.ConfirmationDialog;
import com.nxp.s32ds.ext.rcp.jface.DialogWidgetsUtil;
import com.nxp.s32ds.ext.rcp.jface.ValueValidator;
import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpVariables;
import com.nxp.s32ds.ext.rcp.variables.RcpWorkspaceLocVariable;
import com.nxp.s32ds.mdt.ide.c.internal.ui.MdtCUiActivator;
import com.nxp.s32ds.mdt.ide.c.internal.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class CIncludeSelectionDialog
extends StatusDialog {
    private Text fileField;
    private String file;
    private Button workspaceButton;
    private Button fileSystemButton;
    private final ValueValidator<String> validator;
    private final RcpVariable vsdkVariable;

    public CIncludeSelectionDialog(Shell parent, ValueValidator<String> validator, RcpVariable vsdkVariable, String file) {
        super(parent);
        this.setTitle(Messages.CIncludeSelectionDialog_select_include);
        this.setStatusLineAboveButtons(true);
        this.validator = validator;
        this.vsdkVariable = vsdkVariable;
        this.file = file;
    }

    public CIncludeSelectionDialog(Shell parent, ValueValidator<String> validator, RcpVariable vsdkVariable) {
        this(parent, validator, vsdkVariable, null);
    }

    @Deprecated
    public int open() {
        throw new IllegalStateException("Use getFile method");
    }

    public String getFile() {
        if (super.open() != 0) {
            return null;
        }
        return this.file;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Group composite = new Group(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label label = new Label((Composite)composite, 0);
        label.setText(Messages.CIncludeSelectionDialog_add_include_file);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.fileField = new Text((Composite)composite, 2048);
        if (this.file != null) {
            this.fileField.setText(this.file);
        }
        this.fileField.setEnabled(false);
        this.fileField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CIncludeSelectionDialog.this.validate();
            }
        });
        gridData = new GridData();
        gridData.widthHint = 600;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.fileField.setLayoutData((Object)gridData);
        Composite buttonComposite = new Composite((Composite)composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)gridData);
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.workspaceButton = DialogWidgetsUtil.createPushButton((Composite)buttonComposite, (String)Messages.CIncludeSelectionDialog_browse_workspace, (GridData)gridData);
        this.workspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CIncludeSelectionDialog.this.handleBrowseWorkspaceButtonPressed();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fileSystemButton = DialogWidgetsUtil.createPushButton((Composite)buttonComposite, (String)Messages.CIncludeSelectionDialog_browse_file_system, (GridData)gridData);
        this.fileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CIncludeSelectionDialog.this.handleBrowseFileSystemButtonPressed();
            }
        });
        this.updateStatus(MdtCUiActivator.getInstance().createError(null));
        this.setHelpAvailable(false);
        return composite;
    }

    protected void handleBrowseWorkspaceButtonPressed() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(Messages.CIncludeSelectionDialog_select_include_from_workspace);
        dialog.setMessage(Messages.CIncludeSelectionDialog_select_include_to_add);
        dialog.setEmptyListMessage(Messages.CIncludeSelectionDialog_no_file_to_select);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        List collectFiles = Collections.emptyList();
        try {
            collectFiles = WorkspaceResources.collectFiles((String[])new String[]{"h", "hpp"});
        }
        catch (CoreException e) {
            dialog.setMessage(e.getStatus().getMessage());
            MdtCUiActivator.getInstance().log(e.getStatus());
        }
        final HashSet<IResource> resources = new HashSet<IResource>();
        for (IFile file : collectFiles) {
            resources.addAll(CIncludeSelectionDialog.collect(file));
        }
        dialog.setAllowMultiple(false);
        dialog.setInitialSelection(null);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || !(selection[0] instanceof IFile)) {
                    return MdtCUiActivator.getInstance().createError(Messages.CIncludeSelectionDialog_select_a_file);
                }
                return MdtCUiActivator.OK_STATUS_EMPTY_MSSAGE;
            }
        });
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return resources.contains(element);
            }
        });
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            RcpWorkspaceLocVariable projectVariable = new RcpWorkspaceLocVariable(resource.getProject().getName());
            this.setFile(RcpVariables.INSTANCE.prependVariable((RcpVariable)projectVariable, resource.getProjectRelativePath().toPortableString()));
        }
    }

    private void handleBrowseFileSystemButtonPressed() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.CIncludeSelectionDialog_select_include_from_file_system);
        dialog.setFilterNames(new String[]{Messages.CIncludeSelectionDialog_includes_filter_name, Messages.CIncludeSelectionDialog_all_files_filter_name});
        dialog.setFilterExtensions(new String[]{"*.h;*.hpp", "*.*"});
        try {
            dialog.setFilterPath(RcpVariables.INSTANCE.getPath(this.vsdkVariable).toString());
            String file = dialog.open();
            if (file != null) {
                this.setFile(RcpVariables.INSTANCE.relativize(this.vsdkVariable, file));
            }
        }
        catch (CoreException e) {
            this.notifyPathError(e);
        }
    }

    private void setFile(String arg) {
        this.file = arg;
        if (arg == null || arg.trim().isEmpty()) {
            this.fileField.setText("");
        } else {
            this.fileField.setText(arg);
        }
    }

    public void validate() {
        IStatus validationStatus;
        if (this.validator != null && !(validationStatus = this.validator.validate((Object)this.file)).isOK()) {
            this.updateStatus(validationStatus);
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    private static Collection<IResource> collect(IFile file) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IFile current = file;
        while (current != null) {
            result.add((IResource)current);
            if (current instanceof IProject) {
                return result;
            }
            current = current.getParent();
        }
        return result;
    }

    private void notifyPathError(CoreException e) {
        MdtCUiActivator.getInstance().log(e.getStatus());
        ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CIncludeSelectionDialog_error, (String)Messages.CIncludeSelectionDialog_cannot_resolve_path, (IStatus)e.getStatus());
    }

    protected void okPressed() {
        IStatus status = this.getStatus();
        if (!status.isOK() && !ConfirmationDialog.confirmContinuation((IStatus)status, (String)Messages.CDefineEditorDialog_continue_anyway)) {
            return;
        }
        super.okPressed();
    }
}

