/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.c.ui;

import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidator;
import com.nxp.s32ds.ext.rcp.jface.KeyValueValidator;
import com.nxp.s32ds.mdt.ide.c.defines.MdtCDefineRegistryManager;
import com.nxp.s32ds.mdt.ide.c.internal.ui.MdtCUiActivator;
import com.nxp.s32ds.mdt.ide.c.internal.ui.Messages;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public abstract class CDefineEditorDialogValidatorBase<T extends EObject>
implements KeyValueValidator<String, String> {
    private static final CIdentifierValidator C_IDENTIFIER_VALIDATOR = new CIdentifierValidator();
    protected final T root;
    protected final MdtCDefineRegistryManager<T> registryManager;
    protected String currentName;
    private final Set<String> names;

    public CDefineEditorDialogValidatorBase(T root, MdtCDefineRegistryManager<T> registryManager, String currentName) {
        this.root = root;
        this.registryManager = registryManager;
        this.currentName = currentName;
        this.names = registryManager.getUserDefines(root).stream().map(i -> i.getName()).filter(n -> !n.equals(currentName)).collect(Collectors.toSet());
    }

    public IStatus validate(String name, String value) {
        if (this.names.contains(name)) {
            return MdtCUiActivator.getInstance().createError(NLS.bind((String)Messages.CDefineEditorDialogValidator_0, (Object)name));
        }
        IStatus status = C_IDENTIFIER_VALIDATOR.validate((Object)name);
        if (!status.isOK()) {
            return status;
        }
        IStatus iStatus = this.validateEvaluation(name, value);
        if (iStatus.isOK()) {
            return iStatus;
        }
        return MdtCUiActivator.getInstance().createWarning(iStatus.getMessage());
    }

    protected abstract IStatus validateEvaluation(String var1, String var2);
}

