/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.clt;

import com.nxp.s32ds.ext.emf.clt.CltEmfControlFlowException;
import com.nxp.s32ds.ext.emf.clt.Messages;
import com.nxp.s32ds.ext.rcp.license.cll.CLL;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import org.eclipse.osgi.util.NLS;

public class CltEmfVersionChecker {
    private static String PRODUCT_NAME = "S32DS_2018_R1";
    private static String ACTIVATED_FEATURE_NAME = "Activated";
    private static String ACTIVATED_FEATURE_VERSION = "1.0";

    public void verifyLicense() throws CltEmfControlFlowException {
        ICLL cll;
        try {
            cll = CLL.loadCLL();
        }
        catch (Throwable ex) {
            throw new CltEmfControlFlowException(Messages.CltEmf_license_couldnot_int_checker, ex);
        }
        this.checkByProductAndFeature(cll, PRODUCT_NAME, ACTIVATED_FEATURE_NAME, ACTIVATED_FEATURE_VERSION);
    }

    private void checkByProductAndFeature(ICLL cll, String productName, String featureName, String featureVersion) throws CltEmfControlFlowException {
        CLLReason reason = cll.verifyLicenseAvailability(productName, featureName, featureVersion);
        if (reason != null && reason.isError()) {
            throw new CltEmfControlFlowException(NLS.bind((String)Messages.CltEmf_license_failed, (Object)reason.getErrorString()));
        }
    }
}

