/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.emf.clt;

import com.nxp.s32ds.ext.emf.clt.CltEmfControlFlowAdapter;
import com.nxp.s32ds.ext.emf.clt.CltEmfControlFlowException;
import com.nxp.s32ds.ext.emf.clt.CltEmfControlFlowListener;
import com.nxp.s32ds.ext.emf.clt.CltEmfProcessor;
import com.nxp.s32ds.ext.emf.clt.CltEmfValidator;
import com.nxp.s32ds.ext.orbit.cli.CliOption;
import com.nxp.s32ds.ext.orbit.cli.CliParsedOptions;
import com.nxp.s32ds.ext.orbit.clt.CltRunner;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public abstract class CltEmfRunner<T extends CltEmfProcessor>
extends CltRunner {
    private static final CliOption MODEL_PATH_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("path").isRequired(true).withDescription("the model for processing").create("model");
    private static final CliOption PROCESSOR_CLASS_NAME_OPTION = CLI.cliOptionBuilder().hasArgs(1).withArgName("classname").isRequired(true).withDescription("the class which is to perform processing").create("processor");
    private static final CliOption VALIDATE_OPTION = CLI.cliOptionBuilder().withDescription("validate before generation").create("validate");
    private static final CliOption IGNORE_VALIDATION_RESULT_OPTION = CLI.cliOptionBuilder().withDescription("ignore validation result").create("validationignore");
    private CltEmfControlFlowListener<T> controlFlowListener;
    private final Class<T> processorClass;

    public CltEmfRunner(Class<T> processorClass) {
        this.processorClass = processorClass;
    }

    public int run(CliParsedOptions cliParsedOptions) {
        Object emfProcessor;
        Class<?> realProcessorClass;
        String className;
        EObject eObject;
        block23: {
            block22: {
                block21: {
                    Resource resource;
                    block20: {
                        Path modelPath;
                        block19: {
                            block18: {
                                this.getControlFlowListener().beforeRun(cliParsedOptions);
                                modelPath = Paths.get(cliParsedOptions.getOptionValue("model"), new String[0]);
                                if (Files.exists(modelPath, new LinkOption[0])) break block18;
                                logger.error((Object)("The model path does not exist: " + modelPath));
                                return 1;
                            }
                            if (Files.isRegularFile(modelPath, new LinkOption[0])) break block19;
                            logger.error((Object)("The model path is not a file: " + modelPath));
                            return 1;
                        }
                        try {
                            this.getControlFlowListener().beforeLoadResource(cliParsedOptions, modelPath);
                            resource = this.load(URI.createFileURI((String)modelPath.toString()), this.createPackageRegistry(), this.createUriConverter());
                            this.getControlFlowListener().afterLoadResource(cliParsedOptions, resource);
                            EList errors = resource.getErrors();
                            if (errors.size() <= 0) break block20;
                            logger.error((Object)"Error of resource loading.");
                            for (Resource.Diagnostic diagnostic : errors) {
                                logger.error((Object)diagnostic.getMessage());
                            }
                            return 1;
                        }
                        catch (CltEmfControlFlowException e) {
                            logger.error((Object)e.getMessage());
                            return 1;
                        }
                    }
                    eObject = this.getEObject(cliParsedOptions, resource);
                    if (eObject != null) break block21;
                    logger.error((Object)"Cannot find EObject for processing.");
                    return 1;
                }
                if (!cliParsedOptions.hasOption("validate")) break block22;
                CltEmfValidator validator = this.createValidator(cliParsedOptions);
                this.getControlFlowListener().beforeValidation(cliParsedOptions, eObject);
                Diagnostic diagnostic = validator.validate(eObject);
                this.getControlFlowListener().afterValidation(cliParsedOptions, eObject, diagnostic);
                validator.logDagnostic(diagnostic);
                if (diagnostic.getSeverity() == 0 || cliParsedOptions.hasOption("validationignore")) break block22;
                logger.error((Object)"The model validation failed.");
                return 1;
            }
            className = cliParsedOptions.getOptionValue("processor");
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            try {
                realProcessorClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("Cannot load the processor class. Caused by:" + e.getMessage()), (Throwable)e);
                return 1;
            }
            if (this.processorClass.isAssignableFrom(realProcessorClass)) break block23;
            logger.error((Object)("The class " + className + " is not instance of " + CltEmfProcessor.class.getName()));
            return 1;
        }
        try {
            emfProcessor = this.createProcessor(cliParsedOptions, realProcessorClass);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot create instance of class " + className + " caused by:" + e.getMessage()), (Throwable)e);
            return 1;
        }
        this.getControlFlowListener().beforeProcess(cliParsedOptions, eObject, emfProcessor);
        try {
            emfProcessor.process(eObject);
        }
        catch (Exception e) {
            logger.error((Object)("Processing failed. Caused by:" + e.getMessage()), (Throwable)e);
            return 1;
        }
        this.getControlFlowListener().afterProcess(cliParsedOptions, eObject, emfProcessor);
        this.getControlFlowListener().afterRun(cliParsedOptions);
        return 0;
    }

    protected CltEmfControlFlowListener<T> createControlFlowListener() {
        return new CltEmfControlFlowAdapter();
    }

    protected URIConverter createUriConverter() {
        return null;
    }

    protected CltEmfValidator createValidator(CliParsedOptions cliParsedOptions) {
        return new CltEmfValidator();
    }

    protected T createProcessor(CliParsedOptions cliParsedOptions, Class<T> processorClass) throws Exception {
        return (T)((CltEmfProcessor)processorClass.newInstance());
    }

    protected abstract Map<String, Object> createPackageRegistry();

    protected Resource load(URI uri, Map<String, Object> packageRegistry, URIConverter converter) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resourceSet.getPackageRegistry().putAll(packageRegistry);
        resourceSet.getLoadOptions().put("ENCODING", StandardCharsets.UTF_8.name());
        if (converter != null) {
            resourceSet.setURIConverter(converter);
        }
        return resourceSet.getResource(uri, true);
    }

    protected EObject getEObject(CliParsedOptions cliParsedOptions, Resource resource) {
        return resource.getEObject("/");
    }

    protected String getName() {
        return "clt";
    }

    protected Set<CliOption> getOptions() {
        Set options = super.getOptions();
        options.add(MODEL_PATH_OPTION);
        options.add(PROCESSOR_CLASS_NAME_OPTION);
        options.add(VALIDATE_OPTION);
        options.add(IGNORE_VALIDATION_RESULT_OPTION);
        return options;
    }

    protected CltEmfControlFlowListener<T> getControlFlowListener() {
        if (this.controlFlowListener == null) {
            this.controlFlowListener = this.createControlFlowListener();
        }
        return this.controlFlowListener;
    }
}

