/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.debugger.pne;

import com.freescale.s32ds.cross.core.lingvo.Lingvo;
import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class PeMicroLaunchConfigurationSupport
implements LaunchConfigurationCreator {
    private static final Lingvo LINGVO = new Lingvo();
    private static final String DEBUGGER_ID = "pne";
    private static final String PNE_LAUNCH_CONFIGURATION_TYPE_ID = "com.pemicro.debug.gdbjtag.pne.launchConfigurationType";
    private static final String ATTR_PNE_DEB = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final String ATTR_PNE_DEV = "com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME";
    private static final String ATTR_PNE_NUM = "com.pemicro.debug.gdbjtag.pne.selectedCoreNumber";
    private static final String ATTR_PNE_RESET_DELAY = "com.pemicro.debug.gdbjtag.pne.ml.RESET_DELAY";
    private static final String ATTR_PNE_DO_RESET_DELAY = "com.pemicro.debug.gdbjtag.pne.ml.DO_RESET_DELAY";
    private static final String ATTR_PROJECT_ATTR = "org.eclipse.cdt.launch.PROJECT_ATTR";
    private static final String ATTR_PROGRAM_NAME = "org.eclipse.cdt.launch.PROGRAM_NAME";
    private static final String ATTR_DSF_GDB_PROCESS = "org.eclipse.cdt.dsf.gdb.GdbProcessFactory";
    private static final String LINGVO_PEMICRO_PROC = "pemicro.Target";

    private static String convertToPnEFamily(String familyId) {
        if (familyId.startsWith("SKEA") || familyId.startsWith("KEA")) {
            return "KEx";
        }
        if (familyId.startsWith("S32K1")) {
            return "S32K1xx";
        }
        if (familyId.startsWith("S32K2")) {
            return "S32K2xx";
        }
        if (familyId.startsWith("S32V")) {
            return "S32Vxxx";
        }
        if (familyId.startsWith("MAC57D5")) {
            return "MAC57D5xx";
        }
        return familyId;
    }

    private static int getIndex(String proc, String procId) {
        if (proc == null) {
            return -1;
        }
        String low = proc.toLowerCase();
        if (low.startsWith("s32v_cortexa53_a53")) {
            return 3;
        }
        if (low.startsWith("s32v_cortexm4")) {
            return 1;
        }
        if (low.startsWith("mac57d54h_m4")) {
            return 1;
        }
        if (low.startsWith("mac57d54h_a5")) {
            return 2;
        }
        if (low.startsWith("mac57d54h_m0plus")) {
            return 3;
        }
        if (low.startsWith("s9keaz")) {
            return -1;
        }
        if (low.startsWith("s32v234m100")) {
            return PeMicroLaunchConfigurationSupport.getIndexForCoreFromHW(procId);
        }
        if (low.startsWith("s32v232m80")) {
            return PeMicroLaunchConfigurationSupport.getIndexForCoreFromHW(procId);
        }
        if (low.startsWith("s32k276k2tv")) {
            return PeMicroLaunchConfigurationSupport.getIndexForCoreFromHW(procId);
        }
        if (low.startsWith("s32k286k2tv")) {
            return PeMicroLaunchConfigurationSupport.getIndexForCoreFromHW(procId);
        }
        return -1;
    }

    private static int getIndexForCoreFromHW(String id) {
        if (id == null) {
            return 1;
        }
        if ("S32V234_A53_0_0".equals(id)) {
            return 3;
        }
        if ("S32V234_A53_0_1".equals(id)) {
            return 4;
        }
        if ("S32V234_A53_1_0".equals(id)) {
            return 5;
        }
        if ("S32V234_A53_1_1".equals(id)) {
            return 6;
        }
        if (id.contains("A53") || "S32K276_K2TV_M7_0".equals(id)) {
            return 3;
        }
        if (id.contains("M4") || "S32K276_K2TV_M33_0".equals(id)) {
            return 1;
        }
        if ("S32K286_K2TV_M7_0".equals(id)) {
            return 2;
        }
        Optional<ProcessorData> proc = Hardware.instance().getModels().stream().map(HWModel::getProcessors).flatMap(Collection::stream).filter(c -> id.equals(c.getId())).findFirst();
        if (!proc.isPresent()) {
            return 1;
        }
        ProcessorData pd = proc.get();
        CoreData core = (CoreData)pd.getCores().get(0);
        return core.getIntValue("index", 1);
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        IResource launchResource;
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        ILaunchConfigurationType debugerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(PNE_LAUNCH_CONFIGURATION_TYPE_ID);
        if (debugerLaunchType == null) {
            IStatus errorStatus = LaunchConfigurationUtil.getUndefinedLaunchConfigurationTypeErrorStatus();
            throw new CoreException(errorStatus);
        }
        ILaunchConfigurationWorkingCopy workingCopy = null;
        IFolder container = project.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = project;
        }
        if ((launchResource = container.findMember(String.valueOf(component) + ".launch")) != null && launchResource.isAccessible()) {
            IStatus errorStatus = LaunchConfigurationUtil.getLaunchConfigurationExistsErrorStatus();
            throw new CoreException(errorStatus);
        }
        workingCopy = debugerLaunchType.newInstance((IContainer)container, component);
        workingCopy.setAttribute(ATTR_PROGRAM_NAME, String.valueOf(component) + ".elf");
        workingCopy.setAttribute(ATTR_PROJECT_ATTR, project.getName());
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workConfig, Map<String, Object> attributes) throws CoreException {
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        String familyId = LaunchConfigurationUtil.extractHardwareFamilyId(attributes);
        String coreId = LaunchConfigurationUtil.extractHardwareCoreId(attributes);
        String deviceId = LaunchConfigurationUtil.extractHardwareDeviceId(attributes);
        String targetProcessorId = LINGVO.mapToLingvo(coreId, LINGVO_PEMICRO_PROC);
        if (targetProcessorId == null) {
            targetProcessorId = LINGVO.mapToLingvo(deviceId, LINGVO_PEMICRO_PROC);
        }
        workConfig.setContainer((IContainer)project);
        workConfig.setMappedResources(new IResource[]{project});
        workConfig.setAttribute(ATTR_PROJECT_ATTR, project.getName());
        workConfig.setAttribute(ATTR_PROGRAM_NAME, component);
        workConfig.setAttribute("process_factory_id", ATTR_DSF_GDB_PROCESS);
        workConfig.setAttribute(ATTR_PNE_DO_RESET_DELAY, true);
        workConfig.setAttribute(ATTR_PNE_RESET_DELAY, "200");
        String gdbClientValue = LaunchConfigurationUtil.getGDBClientValue((String)coreId, (String)DEBUGGER_ID);
        workConfig.setAttribute(ATTR_PNE_DEB, gdbClientValue);
        int index = PeMicroLaunchConfigurationSupport.getIndex(targetProcessorId, coreId);
        workConfig.setAttribute(ATTR_PNE_NUM, index);
        String pneFamilyId = PeMicroLaunchConfigurationSupport.convertToPnEFamily(familyId);
        String device_name = "NXP_" + pneFamilyId + '_' + targetProcessorId;
        workConfig.setAttribute(ATTR_PNE_DEV, device_name);
    }
}

