/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.importexecutable;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.importexecutable.AbstractImportExecutableWizard;
import org.eclipse.cdt.debug.ui.importexecutable.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportExecutablePageOne
extends WizardPage {
    private static String previouslyBrowsedDirectory = "";
    private Text multipleExecutablePathField;
    private CheckboxTreeViewer executablesViewer;
    private File[] executables = new File[0];
    private String previouslySearchedDirectory;
    private Text singleExecutablePathField;
    private boolean selectSingleFile = true;
    private Button selectSingleButton;
    private Button selectSingleBrowseButton;
    private Button selectMultipleButton;
    private Button selectMultipleBrowseButton;
    private Button selectAll;
    private Button deselectAll;
    private Label selectMultipleTitle;
    private AbstractImportExecutableWizard wizard;
    private String[] supportedBinaryParserIds;
    private IBinaryParser[] supportedBinaryParsers;
    private IExtension[] binaryParserExtensions;
    private Combo binaryParserCombo;

    public ImportExecutablePageOne(AbstractImportExecutableWizard wizard) {
        super("ImportApplicationPageOne");
        this.wizard = wizard;
        this.setPageComplete(false);
        this.setTitle(wizard.getPageOneTitle());
        this.setDescription(wizard.getPageOneDescription());
        this.supportedBinaryParserIds = wizard.getDefaultBinaryParserIDs();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "BinaryParser");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            ArrayList<IExtension> extensionsInUse = new ArrayList<IExtension>();
            int i = 0;
            while (i < exts.length) {
                if (ImportExecutablePageOne.isExtensionVisible(exts[i])) {
                    extensionsInUse.add(exts[i]);
                }
                ++i;
            }
            this.binaryParserExtensions = extensionsInUse.toArray(new IExtension[extensionsInUse.size()]);
        }
        this.supportedBinaryParsers = new IBinaryParser[this.supportedBinaryParserIds.length];
        int i = 0;
        while (i < this.supportedBinaryParserIds.length) {
            int j = 0;
            while (j < this.binaryParserExtensions.length) {
                if (this.binaryParserExtensions[j].getUniqueIdentifier().equals(this.supportedBinaryParserIds[i])) {
                    this.supportedBinaryParsers[i] = this.instantiateBinaryParser(this.binaryParserExtensions[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public String[] getSupportedBinaryParserIds() {
        return this.supportedBinaryParserIds;
    }

    private void checkControlState() {
        this.selectSingleFile = this.selectSingleButton.getSelection();
        this.singleExecutablePathField.setEnabled(this.selectSingleFile);
        this.selectSingleBrowseButton.setEnabled(this.selectSingleFile);
        this.multipleExecutablePathField.setEnabled(!this.selectSingleFile);
        this.selectMultipleBrowseButton.setEnabled(!this.selectSingleFile);
        this.selectAll.setEnabled(!this.selectSingleFile);
        this.deselectAll.setEnabled(!this.selectSingleFile);
        this.selectMultipleTitle.setEnabled(!this.selectSingleFile);
    }

    private boolean collectExecutableFiles(Collection<File> files, File directory, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        File[] contents = directory.listFiles();
        monitor.subTask(directory.getPath());
        SubProgressMonitor sm = new SubProgressMonitor(monitor, -1);
        sm.beginTask(directory.getPath(), contents.length);
        int i = 0;
        while (i < contents.length) {
            if (monitor.isCanceled()) {
                return false;
            }
            File file = contents[i];
            sm.worked(1);
            if (contents[i].isDirectory()) {
                this.collectExecutableFiles(files, contents[i], monitor);
            } else if (file.isFile() && this.isBinary(file, false)) {
                files.add(file);
            }
            ++i;
        }
        sm.done();
        return true;
    }

    public void createControl(Composite parent) {
        GridLayout layout;
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        if (this.wizard.userSelectsBinaryParser()) {
            Composite binaryParserGroup = new Composite(workArea, 0);
            layout = new GridLayout(3, false);
            layout.numColumns = 3;
            layout.makeColumnsEqualWidth = false;
            layout.marginWidth = 0;
            binaryParserGroup.setLayout((Layout)layout);
            this.createSelectBinaryParser(binaryParserGroup);
        }
        Composite selectExecutableGroup = new Composite(workArea, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        selectExecutableGroup.setLayout((Layout)layout);
        selectExecutableGroup.setLayoutData((Object)new GridData(768));
        this.createSelectExecutable(selectExecutableGroup);
        this.createExecutablesRoot(selectExecutableGroup);
        this.createExecutablesList(workArea);
        Dialog.applyDialogFont((Control)workArea);
        this.selectSingleButton.setSelection(true);
        this.checkControlState();
        CDebugUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), ICDebugHelpContextIds.IMPORT_EXECUTABLE_PAGE_ONE);
    }

    private void createExecutablesList(Composite workArea) {
        this.selectMultipleTitle = new Label(workArea, 0);
        this.selectMultipleTitle.setText(this.wizard.getExecutableListLabel());
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.executablesViewer = new CheckboxTreeViewer(listComposite, 2048);
        GridData listData = new GridData(1808);
        this.executablesViewer.getControl().setLayoutData((Object)listData);
        this.executablesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ImportExecutablePageOne.this.executables;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.executablesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((File)element).getName();
            }
        });
        this.executablesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportExecutablePageOne.this.setPageComplete(ImportExecutablePageOne.this.executablesViewer.getCheckedElements().length > 0);
            }
        });
        this.executablesViewer.setInput((Object)this);
        this.executablesViewer.getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ImportExecutablePageOne.this.wizard.getExecutableListLabel();
            }
        });
        this.createSelectionButtons(listComposite);
    }

    private void createExecutablesRoot(Composite workArea) {
        this.selectMultipleButton = new Button(workArea, 16);
        this.selectMultipleButton.setText(Messages.ImportExecutablePageOne_SearchDirectory);
        this.selectMultipleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageOne.this.checkControlState();
                String selectedDirectory = ImportExecutablePageOne.this.multipleExecutablePathField.getText().trim();
                ImportExecutablePageOne.this.setErrorMessage(null);
                if (selectedDirectory.length() == 0) {
                    ImportExecutablePageOne.this.noFilesSelected();
                } else {
                    ImportExecutablePageOne.this.updateExecutablesList(selectedDirectory);
                }
            }
        });
        this.multipleExecutablePathField = new Text(workArea, 2048);
        this.multipleExecutablePathField.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.ImportExecutablePageOne_SearchDirectory;
            }
        });
        this.multipleExecutablePathField.setLayoutData((Object)new GridData(768));
        this.selectMultipleBrowseButton = new Button(workArea, 8);
        this.selectMultipleBrowseButton.setText(Messages.ImportExecutablePageOne_Browse);
        this.setButtonLayoutData(this.selectMultipleBrowseButton);
        this.selectMultipleBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageOne.this.handleLocationBrowseButtonPressed();
            }
        });
        this.multipleExecutablePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ImportExecutablePageOne.this.updateExecutablesList(ImportExecutablePageOne.this.multipleExecutablePathField.getText().trim());
            }
        });
    }

    private void createSelectBinaryParser(Composite workArea) {
        if (this.binaryParserExtensions.length == 0) {
            return;
        }
        Label label = new Label(workArea, 0);
        label.setText(Messages.ImportExecutablePageOne_SelectBinaryParser);
        this.binaryParserCombo = new Combo(workArea, 8);
        final IExtension[] exts = this.binaryParserExtensions;
        int i = 0;
        while (i < exts.length) {
            this.binaryParserCombo.add(exts[i].getLabel());
            if (this.supportedBinaryParserIds[0].equals(exts[i].getUniqueIdentifier())) {
                this.binaryParserCombo.select(i);
            }
            ++i;
        }
        this.binaryParserCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ((ImportExecutablePageOne)ImportExecutablePageOne.this).supportedBinaryParsers[0] = ImportExecutablePageOne.this.instantiateBinaryParser(exts[ImportExecutablePageOne.this.binaryParserCombo.getSelectionIndex()]);
                ((ImportExecutablePageOne)ImportExecutablePageOne.this).supportedBinaryParserIds[0] = exts[ImportExecutablePageOne.this.binaryParserCombo.getSelectionIndex()].getUniqueIdentifier();
                if (ImportExecutablePageOne.this.selectSingleFile) {
                    String path = ImportExecutablePageOne.this.singleExecutablePathField.getText();
                    if (path.length() > 0) {
                        ImportExecutablePageOne.this.validateExe(path);
                    }
                } else {
                    ImportExecutablePageOne.this.previouslySearchedDirectory = null;
                    ImportExecutablePageOne.this.updateExecutablesList(ImportExecutablePageOne.this.multipleExecutablePathField.getText().trim());
                }
            }
        });
        new Label(workArea, 0);
    }

    private static boolean isExtensionVisible(IExtension ext) {
        int i = 0;
        IConfigurationElement[] elements = ext.getConfigurationElements();
        if (i < elements.length) {
            IConfigurationElement[] children = elements[i].getChildren("filter");
            int j = 0;
            while (j < children.length) {
                String value;
                String name = children[j].getAttribute("name");
                if (name != null && name.equals("visibility") && (value = children[j].getAttribute("value")) != null && value.equals("private")) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    private IBinaryParser instantiateBinaryParser(IExtension ext) {
        IBinaryParser parser = null;
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement[] children = elements[i].getChildren("run");
            int j = 0;
            while (j < children.length) {
                try {
                    parser = (IBinaryParser)children[j].createExecutableExtension("class");
                }
                catch (CoreException e) {
                    CDebugUIPlugin.log(e);
                }
                ++j;
            }
            ++i;
        }
        return parser;
    }

    private void createSelectExecutable(Composite workArea) {
        this.selectSingleButton = new Button(workArea, 16);
        this.selectSingleButton.setText(Messages.ImportExecutablePageOne_SelectExecutable);
        this.selectSingleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageOne.this.checkControlState();
                if (ImportExecutablePageOne.this.selectSingleFile) {
                    if (ImportExecutablePageOne.this.singleExecutablePathField.getText().trim().length() == 0) {
                        ImportExecutablePageOne.this.noFilesSelected();
                    } else {
                        ImportExecutablePageOne.this.validateExe(ImportExecutablePageOne.this.singleExecutablePathField.getText());
                    }
                }
            }
        });
        this.singleExecutablePathField = new Text(workArea, 2048);
        this.singleExecutablePathField.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.ImportExecutablePageOne_SelectExecutable;
            }
        });
        this.singleExecutablePathField.setData("name", (Object)"singleExecutablePathField");
        this.singleExecutablePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportExecutablePageOne.this.validateExe(ImportExecutablePageOne.this.singleExecutablePathField.getText());
            }
        });
        this.singleExecutablePathField.setLayoutData((Object)new GridData(768));
        this.selectSingleBrowseButton = new Button(workArea, 8);
        this.selectSingleBrowseButton.setText(Messages.ImportExecutablePageOne_Browse);
        this.setButtonLayoutData(this.selectSingleBrowseButton);
        this.selectSingleBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ImportExecutablePageOne.this.getShell(), 0);
                ImportExecutablePageOne.this.wizard.setupFileDialog(dialog);
                String res = dialog.open();
                if (res != null) {
                    if (Platform.getOS().equals("macosx") && res.endsWith(".app")) {
                        Path macPath = new Path(res);
                        res = String.valueOf(res) + "/Contents/MacOS/" + macPath.lastSegment();
                        res = res.substring(0, res.length() - 4);
                    }
                    ImportExecutablePageOne.this.singleExecutablePathField.setText(res);
                }
            }
        });
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        this.selectAll = new Button(buttonsComposite, 8);
        this.selectAll.setText(Messages.ImportExecutablePageOne_SelectAll);
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageOne.this.executablesViewer.setAllChecked(true);
                ImportExecutablePageOne.this.setPageComplete(ImportExecutablePageOne.this.executables.length > 0);
            }
        });
        this.setButtonLayoutData(this.selectAll);
        this.deselectAll = new Button(buttonsComposite, 8);
        this.deselectAll.setText(Messages.ImportExecutablePageOne_DeselectAll);
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageOne.this.executablesViewer.setAllChecked(false);
                ImportExecutablePageOne.this.setPageComplete(false);
            }
        });
        this.setButtonLayoutData(this.deselectAll);
    }

    public String[] getSelectedExecutables() {
        String[] selectedExecutablePaths = new String[]{};
        if (this.selectSingleFile) {
            if (this.executables.length > 0) {
                selectedExecutablePaths = new String[]{this.executables[0].getAbsolutePath()};
            }
        } else {
            Object[] checkedFiles = this.executablesViewer.getCheckedElements();
            selectedExecutablePaths = new String[checkedFiles.length];
            int i = 0;
            while (i < checkedFiles.length) {
                selectedExecutablePaths[i] = ((File)checkedFiles[i]).getAbsolutePath();
                ++i;
            }
        }
        return selectedExecutablePaths;
    }

    protected void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.multipleExecutablePathField.getShell());
        dialog.setMessage(Messages.ImportExecutablePageOne_SelectADirectory);
        String dirName = this.multipleExecutablePathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() > 0 && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.multipleExecutablePathField.setText(previouslyBrowsedDirectory);
            this.updateExecutablesList(selectedDirectory);
        }
    }

    protected void noFilesSelected() {
        this.executables = new File[0];
        this.executablesViewer.refresh(true);
        this.executablesViewer.setAllChecked(false);
        this.previouslySearchedDirectory = "";
        this.setPageComplete(false);
    }

    protected void updateExecutablesList(final String path) {
        if (path == null || path.length() == 0) {
            return;
        }
        if (this.previouslySearchedDirectory != null && this.previouslySearchedDirectory.equals(path)) {
            return;
        }
        this.previouslySearchedDirectory = path;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.ImportExecutablePageOne_Searching, -1);
                    File directory = new File(path);
                    ImportExecutablePageOne.this.executables = new File[0];
                    if (directory.isDirectory()) {
                        ArrayList files = new ArrayList();
                        if (!ImportExecutablePageOne.this.collectExecutableFiles(files, directory, monitor)) {
                            return;
                        }
                        ImportExecutablePageOne.this.executables = files.toArray(new File[files.size()]);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        this.executablesViewer.refresh(true);
        this.executablesViewer.setAllChecked(true);
        this.setPageComplete(this.executables.length > 0);
    }

    private boolean isBinary(File file, IBinaryParser parser) {
        if (parser != null) {
            try {
                IBinaryParser.IBinaryFile bin = parser.getBinary((IPath)new Path(file.getAbsolutePath()));
                return bin != null && (bin.getType() == 2 || bin.getType() == 4);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    private boolean isBinary(File file, boolean checkOthers) {
        int i = 0;
        while (i < this.supportedBinaryParsers.length) {
            if (this.isBinary(file, this.supportedBinaryParsers[i])) {
                return true;
            }
            ++i;
        }
        if (checkOthers && this.binaryParserCombo != null) {
            i = 0;
            while (i < this.binaryParserExtensions.length) {
                IBinaryParser parser = this.instantiateBinaryParser(this.binaryParserExtensions[i]);
                if (this.isBinary(file, parser)) {
                    this.supportedBinaryParserIds[0] = this.binaryParserExtensions[i].getUniqueIdentifier();
                    this.supportedBinaryParsers[0] = parser;
                    this.binaryParserCombo.select(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void validateExe(String path) {
        this.setErrorMessage(null);
        this.setPageComplete(false);
        if (path.length() > 0) {
            File testFile = new File(path);
            if (testFile.exists()) {
                if (this.isBinary(testFile, true)) {
                    this.executables = new File[1];
                    this.executables[0] = testFile;
                    this.setPageComplete(true);
                } else {
                    this.setErrorMessage(Messages.ImportExecutablePageOne_NoteAnEXE);
                }
            } else {
                this.setErrorMessage(Messages.ImportExecutablePageOne_NoSuchFile);
            }
        }
    }
}

