/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.debuggerconsole;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.internal.ui.views.debuggerconsole.ConsoleMessages;
import org.eclipse.cdt.debug.internal.ui.views.debuggerconsole.DebuggerConsoleDropDownAction;
import org.eclipse.cdt.debug.internal.ui.views.debuggerconsole.DebuggerConsoleWorkbenchPart;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsole;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsoleManager;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsoleView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.PageSwitcher;

public class DebuggerConsoleView
extends PageBookView
implements IConsoleView,
IDebuggerConsoleView,
IConsoleListener,
IPropertyChangeListener {
    public static final String DEBUGGER_CONSOLE_VIEW_ID = "org.eclipse.cdt.debug.ui.debuggerConsoleView";
    public static final String DROP_DOWN_ACTION_ID = "org.eclipse.cdt.debug.ui.debuggerConsoleView.DebuggerConsoleDropDownAction";
    private IDebuggerConsole fActiveConsole;
    private Map<IDebuggerConsole, DebuggerConsoleWorkbenchPart> fConsoleToPart = new HashMap<IDebuggerConsole, DebuggerConsoleWorkbenchPart>();
    private Map<DebuggerConsoleWorkbenchPart, IDebuggerConsole> fPartToConsole = new HashMap<DebuggerConsoleWorkbenchPart, IDebuggerConsole>();
    private DebuggerConsoleDropDownAction fDisplayConsoleAction;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createActions();
        this.configureToolBar(this.getViewSite().getActionBars().getToolBarManager());
        IConsole[] consoles = this.getConsoleManager().getConsoles();
        this.consolesAdded(consoles);
        this.getConsoleManager().addConsoleListener(this);
        this.getViewSite().getActionBars().updateActionBars();
        this.initPageSwitcher();
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart dummyPart) {
        DebuggerConsoleWorkbenchPart part = (DebuggerConsoleWorkbenchPart)dummyPart;
        IDebuggerConsole console = this.fPartToConsole.get(part);
        IPageBookViewPage page = console.createDebuggerPage(this);
        this.initPage(page);
        page.createControl((Composite)this.getPageBook());
        console.addPropertyChangeListener(this);
        return new PageBookView.PageRec(dummyPart, (IPage)page);
    }

    protected void createActions() {
        this.fDisplayConsoleAction = new DebuggerConsoleDropDownAction(this);
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.add((IAction)this.fDisplayConsoleAction);
    }

    public void dispose() {
        super.dispose();
        this.getConsoleManager().removeConsoleListener(this);
        if (this.fDisplayConsoleAction != null) {
            this.fDisplayConsoleAction.dispose();
            this.fDisplayConsoleAction = null;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof IConsole && event.getProperty().equals("org.eclipse.jface.text") && source.equals(this.getCurrentConsole())) {
            this.updateTitle();
        }
    }

    private boolean isAvailable() {
        return this.getPageBook() != null && !this.getPageBook().isDisposed();
    }

    @Override
    public IDebuggerConsole getCurrentConsole() {
        return this.fActiveConsole;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        IDebuggerConsole recConsole = this.fPartToConsole.get(pageRec.part);
        if (recConsole != null && recConsole.equals(this.getCurrentConsole())) {
            return;
        }
        super.showPageRec(pageRec);
        this.fActiveConsole = recConsole;
        this.updateTitle();
    }

    protected Set<IDebuggerConsole> getConsoles() {
        return this.fConsoleToPart.keySet();
    }

    protected void updateTitle() {
        IDebuggerConsole console = this.getCurrentConsole();
        if (console == null) {
            this.setContentDescription(ConsoleMessages.ConsoleMessages_no_console);
        } else {
            String newName = console.getName();
            String oldName = this.getContentDescription();
            if (newName != null && !newName.equals(oldName)) {
                this.setContentDescription(newName);
            }
        }
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
        pageRecord.dispose();
        IConsole console = this.fPartToConsole.remove(part);
        this.fConsoleToPart.remove(console);
        console.removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fPartToConsole.isEmpty()) {
            this.fActiveConsole = null;
        }
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof DebuggerConsoleWorkbenchPart;
    }

    private IDebuggerConsoleManager getConsoleManager() {
        return CDebugUIPlugin.getDebuggerConsoleManager();
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    public void consolesAdded(IConsole[] consoles) {
        if (this.isAvailable()) {
            this.asyncExec(() -> {
                IConsole[] iConsoleArray2 = consoles;
                int n = consoles.length;
                int n2 = 0;
                while (n2 < n) {
                    IConsole console = iConsoleArray2[n2];
                    if (this.isAvailable()) {
                        IDebuggerConsole[] allConsoles;
                        IDebuggerConsole[] iDebuggerConsoleArray = allConsoles = this.getConsoleManager().getConsoles();
                        int n3 = allConsoles.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IDebuggerConsole registered = iDebuggerConsoleArray[n4];
                            if (registered.equals(console)) {
                                DebuggerConsoleWorkbenchPart part = new DebuggerConsoleWorkbenchPart(registered, this.getSite());
                                this.fConsoleToPart.put(registered, part);
                                this.fPartToConsole.put(part, registered);
                                IDebuggerConsole previouslyShown = this.getCurrentConsole();
                                this.partActivated(part);
                                if (previouslyShown == null) break;
                                this.display(previouslyShown);
                                break;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            });
        }
    }

    public void consolesRemoved(IConsole[] consoles) {
        if (this.isAvailable()) {
            this.asyncExec(() -> {
                IConsole[] iConsoleArray2 = consoles;
                int n = consoles.length;
                int n2 = 0;
                while (n2 < n) {
                    IConsole console = iConsoleArray2[n2];
                    if (this.isAvailable()) {
                        IDebuggerConsole[] available;
                        DebuggerConsoleWorkbenchPart part = this.fConsoleToPart.get(console);
                        if (part != null) {
                            this.partClosed(part);
                        }
                        if (this.getCurrentConsole() == null && (available = this.getConsoleManager().getConsoles()).length > 0) {
                            this.display(available[available.length - 1]);
                        }
                    }
                    ++n2;
                }
            });
        }
    }

    @Override
    public void display(IDebuggerConsole console) {
        if (console.equals(this.getCurrentConsole())) {
            return;
        }
        DebuggerConsoleWorkbenchPart part = this.fConsoleToPart.get(console);
        if (part != null) {
            this.partActivated(part);
            this.fActiveConsole.consoleSelected();
        }
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    private void asyncExec(Runnable r) {
        if (this.isAvailable()) {
            this.getPageBook().getDisplay().asyncExec(r);
        }
    }

    private void initPageSwitcher() {
        new PageSwitcher((IWorkbenchPart)this){

            public void activatePage(Object page) {
                DebuggerConsoleView.this.display((IDebuggerConsole)page);
            }

            public ImageDescriptor getImageDescriptor(Object page) {
                return ((IDebuggerConsole)page).getImageDescriptor();
            }

            public String getName(Object page) {
                return ((IDebuggerConsole)page).getName();
            }

            public Object[] getPages() {
                return DebuggerConsoleView.this.getConsoleManager().getConsoles();
            }

            public int getCurrentPageIndex() {
                IDebuggerConsole currentConsole = DebuggerConsoleView.this.getCurrentConsole();
                IDebuggerConsole[] consoles = DebuggerConsoleView.this.getConsoleManager().getConsoles();
                int i = 0;
                while (i < consoles.length) {
                    if (consoles[i].equals(currentConsole)) {
                        return i;
                    }
                    ++i;
                }
                return super.getCurrentPageIndex();
            }
        };
    }

    public void setAutoScrollLock(boolean scrollLock) {
    }

    public boolean getAutoScrollLock() {
        return false;
    }

    public void display(IConsole console) {
        if (console instanceof IDebuggerConsole) {
            this.display((IDebuggerConsole)console);
        }
    }

    public void setPinned(boolean pin) {
    }

    public void pin(IConsole console) {
    }

    public boolean isPinned() {
        return false;
    }

    public IConsole getConsole() {
        return this.getCurrentConsole();
    }

    public void warnOfContentChange(IConsole console) {
        assert (false);
    }

    public void setScrollLock(boolean scrollLock) {
    }

    public boolean getScrollLock() {
        return false;
    }

    public void setWordWrap(boolean wordWrap) {
    }

    public boolean getWordWrap() {
        return false;
    }
}

