/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.internal.ui.preferences.PreferenceMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.dialogs.EncodingFieldEditor;
import org.osgi.service.prefs.BackingStoreException;

public class CDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench fWorkbench;
    private EncodingFieldEditor fCharsetEditor;
    private EncodingFieldEditor fWideCharsetEditor;
    private PropertyChangeListener fPropertyChangeListener;
    private Button fShowBinarySourceFilesButton;

    public CDebugPreferencePage() {
        this.setPreferenceStore(CDebugUIPlugin.getDefault().getPreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
        this.setDescription(PreferenceMessages.getString("CDebugPreferencePage.3"));
    }

    protected Control createContents(Composite parent) {
        this.getWorkbench().getHelpSystem().setHelp(this.getControl(), ICDebugHelpContextIds.C_DEBUG_PREFERENCE_PAGE);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createCharsetSettingPreferences(composite);
        this.createSpacer(composite, 1);
        this.createBinarySettings(composite);
        this.setValues();
        return composite;
    }

    private void setValues() {
        String charset;
        String defaultWideCharset;
        PreferenceStore ps = new PreferenceStore();
        String defaultCharset = DefaultScope.INSTANCE.getNode("org.eclipse.cdt.debug.core").get(ICDebugConstants.PREF_DEBUG_CHARSET, null);
        if (defaultCharset != null) {
            ps.setDefault(ICDebugConstants.PREF_DEBUG_CHARSET, defaultCharset);
        }
        if ((defaultWideCharset = DefaultScope.INSTANCE.getNode("org.eclipse.cdt.debug.core").get(ICDebugConstants.PREF_DEBUG_WIDE_CHARSET, null)) != null) {
            ps.setDefault(ICDebugConstants.PREF_DEBUG_WIDE_CHARSET, defaultWideCharset);
        }
        if ((charset = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.core").get(ICDebugConstants.PREF_DEBUG_CHARSET, null)) != null) {
            ps.setValue(ICDebugConstants.PREF_DEBUG_CHARSET, charset);
        } else if (defaultCharset != null) {
            ps.setValue(ICDebugConstants.PREF_DEBUG_CHARSET, defaultCharset);
        }
        String wideCharset = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.core").get(ICDebugConstants.PREF_DEBUG_WIDE_CHARSET, null);
        if (wideCharset != null) {
            ps.setValue(ICDebugConstants.PREF_DEBUG_WIDE_CHARSET, wideCharset);
        } else if (defaultWideCharset != null) {
            ps.setValue(ICDebugConstants.PREF_DEBUG_WIDE_CHARSET, defaultWideCharset);
        }
        this.fCharsetEditor.setPreferenceStore((IPreferenceStore)ps);
        this.fCharsetEditor.load();
        this.fWideCharsetEditor.setPreferenceStore((IPreferenceStore)ps);
        this.fWideCharsetEditor.load();
        if (charset == null) {
            this.fCharsetEditor.loadDefault();
        }
        if (wideCharset == null) {
            this.fWideCharsetEditor.loadDefault();
        }
        this.fShowBinarySourceFilesButton.setSelection(Platform.getPreferencesService().getBoolean("org.eclipse.cdt.core", "org.eclipse.cdt.core.showSourceFilesInBinaries", true, null));
    }

    public void init(IWorkbench workbench) {
        this.fWorkbench = workbench;
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new PropertyChangeListener();
        }
        return this.fPropertyChangeListener;
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES, false);
    }

    public void dispose() {
        super.dispose();
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
    }

    private void createCharsetSettingPreferences(Composite parent) {
        Composite formatComposite = ControlFactory.createComposite((Composite)parent, (int)2);
        ((GridLayout)formatComposite.getLayout()).marginWidth = 0;
        ((GridLayout)formatComposite.getLayout()).marginHeight = 0;
        Composite charsetComposite = ControlFactory.createComposite((Composite)formatComposite, (int)1);
        this.fCharsetEditor = new EncodingFieldEditor(ICDebugConstants.PREF_DEBUG_CHARSET, "", PreferenceMessages.getString("CDebugPreferencePage.18"), charsetComposite);
        this.fCharsetEditor.setPropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
        Composite wideCharsetComposite = ControlFactory.createComposite((Composite)formatComposite, (int)1);
        this.fWideCharsetEditor = new EncodingFieldEditor(ICDebugConstants.PREF_DEBUG_WIDE_CHARSET, "", PreferenceMessages.getString("CDebugPreferencePage.16"), wideCharsetComposite);
        this.fWideCharsetEditor.setPropertyChangeListener((IPropertyChangeListener)this.getPropertyChangeListener());
    }

    private void createBinarySettings(Composite parent) {
        this.fShowBinarySourceFilesButton = this.createCheckButton(parent, PreferenceMessages.getString("CDebugPreferencePage.15"));
    }

    private Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 16416);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    public boolean performOk() {
        this.storeValues();
        if (this.getPropertyChangeListener().hasStateChanged()) {
            this.refreshViews();
        }
        try {
            InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.ui").flush();
            InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.core").flush();
        }
        catch (BackingStoreException backingStoreException) {}
        return true;
    }

    private void refreshViews() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] windows = CDebugUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
                IWorkbenchPage page = null;
                int i = 0;
                while (i < windows.length) {
                    page = windows[i].getActivePage();
                    if (page != null) {
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.debug.ui.ExpressionView");
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.debug.ui.VariableView");
                        CDebugPreferencePage.this.refreshViews(page, "org.eclipse.debug.ui.RegisterView");
                    }
                    ++i;
                }
            }
        });
    }

    protected void refreshViews(IWorkbenchPage page, String viewID) {
        Viewer viewer;
        IDebugView adapter;
        IViewPart part = page.findView(viewID);
        if (part != null && (adapter = (IDebugView)part.getAdapter(IDebugView.class)) != null && (viewer = adapter.getViewer()) instanceof StructuredViewer) {
            ((StructuredViewer)viewer).refresh();
        }
    }

    private void storeValues() {
        if (this.fCharsetEditor.presentsDefaultValue()) {
            InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.core").remove(ICDebugConstants.PREF_DEBUG_CHARSET);
        } else {
            this.fCharsetEditor.store();
            InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.core").put(ICDebugConstants.PREF_DEBUG_CHARSET, this.fCharsetEditor.getPreferenceStore().getString(ICDebugConstants.PREF_DEBUG_CHARSET));
        }
        if (this.fWideCharsetEditor.presentsDefaultValue()) {
            InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.core").remove(ICDebugConstants.PREF_DEBUG_WIDE_CHARSET);
        } else {
            this.fWideCharsetEditor.store();
            InstanceScope.INSTANCE.getNode("org.eclipse.cdt.debug.core").put(ICDebugConstants.PREF_DEBUG_WIDE_CHARSET, this.fWideCharsetEditor.getPreferenceStore().getString(ICDebugConstants.PREF_DEBUG_WIDE_CHARSET));
        }
        InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").putBoolean("org.eclipse.cdt.core.showSourceFilesInBinaries", this.fShowBinarySourceFilesButton.getSelection());
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fCharsetEditor.loadDefault();
        this.fWideCharsetEditor.loadDefault();
        this.fShowBinarySourceFilesButton.setSelection(DefaultScope.INSTANCE.getNode("org.eclipse.cdt.core").getBoolean("org.eclipse.cdt.core.showSourceFilesInBinaries", true));
    }

    private IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    protected class PropertyChangeListener
    implements IPropertyChangeListener {
        private boolean fHasStateChanged = false;

        protected PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(ICDebugPreferenceConstants.PREF_SHOW_HEX_VALUES)) {
                this.fHasStateChanged = true;
            } else if (event.getProperty().equals(ICDebugPreferenceConstants.PREF_SHOW_CHAR_VALUES)) {
                this.fHasStateChanged = true;
            } else if (event.getProperty().equals("field_editor_value")) {
                this.fHasStateChanged = true;
            } else if (event.getProperty().equals("field_editor_is_valid")) {
                CDebugPreferencePage.this.setValid(CDebugPreferencePage.this.fCharsetEditor.isValid() && CDebugPreferencePage.this.fWideCharsetEditor.isValid());
                if (!CDebugPreferencePage.this.fCharsetEditor.isValid()) {
                    CDebugPreferencePage.this.setErrorMessage(PreferenceMessages.getString("CDebugPreferencePage.19"));
                } else if (!CDebugPreferencePage.this.fWideCharsetEditor.isValid()) {
                    CDebugPreferencePage.this.setErrorMessage(PreferenceMessages.getString("CDebugPreferencePage.20"));
                } else {
                    CDebugPreferencePage.this.setErrorMessage(null);
                }
            }
        }

        protected boolean hasStateChanged() {
            return this.fHasStateChanged;
        }
    }
}

