/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.ICBreakpointListener;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.swt.widgets.Display;

public class CBreakpointUpdater
implements ICBreakpointListener {
    private static CBreakpointUpdater fInstance;

    public static CBreakpointUpdater getInstance() {
        if (fInstance == null) {
            fInstance = new CBreakpointUpdater();
        }
        return fInstance;
    }

    public boolean installingBreakpoint(IDebugTarget target, IBreakpoint breakpoint) {
        return true;
    }

    public void breakpointInstalled(IDebugTarget target, IBreakpoint breakpoint) {
    }

    public void breakpointChanged(IDebugTarget target, final IBreakpoint breakpoint, final Map attributes) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Boolean enabled = (Boolean)attributes.get("org.eclipse.debug.core.enabled");
                    breakpoint.setEnabled(enabled != null ? enabled : false);
                    Integer ignoreCount = (Integer)attributes.get("org.eclipse.cdt.debug.core.ignoreCount");
                    ((ICBreakpoint)breakpoint).setIgnoreCount(ignoreCount != null ? ignoreCount : 0);
                    String condition = (String)attributes.get("org.eclipse.cdt.debug.core.condition");
                    ((ICBreakpoint)breakpoint).setCondition(condition != null ? condition : "");
                }
                catch (CoreException e) {
                    CDebugUIPlugin.log(e.getStatus());
                }
            }
        });
    }

    public void breakpointsRemoved(IDebugTarget target, final IBreakpoint[] breakpoints) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < breakpoints.length) {
                    try {
                        if (((ICBreakpoint)breakpoints[i]).decrementInstallCount() == 0) {
                            DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged(breakpoints[i]);
                        }
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
            }
        });
    }

    public void dispose() {
    }

    private void asyncExec(Runnable r) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(r);
        }
    }
}

