/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    /*
     * Enabled aggressive block sorting
     */
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        String errorMessage = null;
        if (!(part instanceof ITextEditor)) {
            errorMessage = ActionMessages.getString("RunToLineAdapter.Operation_is_not_supported_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ITextEditor textEditor = (ITextEditor)part;
        IEditorInput input = textEditor.getEditorInput();
        if (input == null) {
            errorMessage = ActionMessages.getString("RunToLineAdapter.Empty_editor_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            errorMessage = ActionMessages.getString("RunToLineAdapter.Missing_document_1");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        String fileName = this.getFileName(input);
        Path path = new Path(fileName);
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine() + 1;
        if (!(target instanceof IAdaptable)) return;
        final IRunToLine runToLine = (IRunToLine)((IAdaptable)target).getAdapter(IRunToLine.class);
        if (runToLine == null) return;
        if (!runToLine.canRunToLine(path.toPortableString(), lineNumber)) return;
        Runnable r = new Runnable((IPath)path, lineNumber){
            private final /* synthetic */ IPath val$path;
            private final /* synthetic */ int val$lineNumber;
            {
                this.val$path = iPath;
                this.val$lineNumber = n;
            }

            @Override
            public void run() {
                try {
                    runToLine.runToLine(this.val$path.toPortableString(), this.val$lineNumber, DebugUITools.getPreferenceStore().getBoolean("org.eclipse.debug.ui.skip_breakpoints_during_run_to_line"));
                }
                catch (DebugException e) {
                    RunToLineAdapter.this.failed(e);
                }
            }
        };
        this.runInBackground(r);
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IAdaptable && part instanceof IEditorPart) {
            IRunToLine runToLine = (IRunToLine)((IAdaptable)target).getAdapter(IRunToLine.class);
            if (runToLine == null) {
                return false;
            }
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput input = editorPart.getEditorInput();
            if (input == null) {
                return false;
            }
            if (!(editorPart instanceof ITextEditor)) {
                return false;
            }
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                return false;
            }
            String fileName = null;
            try {
                fileName = this.getFileName(input);
            }
            catch (CoreException coreException) {}
            if (fileName == null) {
                return false;
            }
            Path path = new Path(fileName);
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            return runToLine.canRunToLine(path.toPortableString(), lineNumber);
        }
        return false;
    }

    private String getFileName(IEditorInput input) throws CoreException {
        return CDebugUIUtils.getEditorFilePath(input);
    }

    private void runInBackground(Runnable r) {
        DebugPlugin.getDefault().asyncExec(r);
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, ActionMessages.getString("RunToLineAdapter.0"), null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), e));
        CDebugUtils.error((IStatus)ms, (Object)this);
    }
}

