/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.HashMap;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointType;
import org.eclipse.cdt.debug.core.model.ICDebugElementStatus;
import org.eclipse.cdt.debug.core.model.ICDynamicPrintf;
import org.eclipse.cdt.debug.core.model.ICEventBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICTracepoint;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.core.model.IDummyStackFrame;
import org.eclipse.cdt.debug.core.model.IEnableDisableTarget;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceNotFoundElement;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.CDebugUIMessages;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.CValueDetailProvider;
import org.eclipse.cdt.debug.internal.ui.OverlayImageCache;
import org.eclipse.cdt.debug.internal.ui.OverlayImageDescriptor;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.CSourceNotFoundEditorInput;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IColorProvider {
    public static final String DISPLAY_FULL_PATHS = "DISPLAY_FULL_PATHS";
    private static final String DUMMY_STACKFRAME_LABEL = "...";
    protected HashMap<String, Object> fAttributes = new HashMap(3);
    protected CDebugImageDescriptorRegistry fDebugImageRegistry = CDebugUIPlugin.getImageDescriptorRegistry();
    private OverlayImageCache fImageCache = new OverlayImageCache();
    private static CDebugModelPresentation gfInstance = null;

    public static CDebugModelPresentation getDefault() {
        if (gfInstance == null) {
            gfInstance = new CDebugModelPresentation();
        }
        return gfInstance;
    }

    public void setAttribute(String attribute, Object value) {
        if (value == null) {
            return;
        }
        this.getAttributes().put(attribute, value);
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        CValueDetailProvider.getDefault().computeDetail(value, listener);
    }

    public IEditorInput getEditorInput(Object element) {
        IResource resource;
        if (element instanceof IMarker && (resource = ((IMarker)element).getResource()) instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ICBreakpoint) {
            IEditorInput editor;
            ICBreakpoint b = (ICBreakpoint)element;
            IMarker marker = b.getMarker();
            if (marker == null || !marker.exists()) {
                return null;
            }
            IFile file = (IFile)marker.getResource().getAdapter(IFile.class);
            if (file == null) {
                try {
                    File fsfile;
                    IProject project;
                    Path path;
                    String handle = b.getSourceHandle();
                    if (handle != null && Path.ROOT.isValidPath(handle) && ((file = ResourceLookup.selectFileForLocation((IPath)(path = new Path(handle)), (IProject)(project = marker.getResource().getProject()))) == null || !file.isAccessible()) && (fsfile = new File(handle)).isFile() && fsfile.exists()) {
                        if (project != null) {
                            ICProject cproject = CoreModel.getDefault().create(project);
                            String id = CoreModel.getRegistedContentTypeId((IProject)project, (String)path.lastSegment());
                            ExternalTranslationUnit tu = new ExternalTranslationUnit((ICElement)cproject, URIUtil.toURI((IPath)path), id);
                            return new ExternalEditorInput((ITranslationUnit)tu);
                        }
                        return new ExternalEditorInput((IPath)path);
                    }
                }
                catch (CoreException e) {
                    CDebugCorePlugin.log((Throwable)e);
                }
            }
            if (file != null) {
                return new FileEditorInput(file);
            }
            ISourcePresentation srcPres = (ISourcePresentation)Platform.getAdapterManager().getAdapter((Object)b, ISourcePresentation.class);
            if (srcPres != null && (editor = srcPres.getEditorInput((Object)b)) != null) {
                return editor;
            }
        }
        if (element instanceof FileStorage || element instanceof LocalFileStorage) {
            return new ExternalEditorInput(((IStorage)element).getFullPath());
        }
        if (element instanceof ExternalTranslationUnit) {
            ExternalTranslationUnit etu = (ExternalTranslationUnit)element;
            return new ExternalEditorInput((ITranslationUnit)etu);
        }
        if (element instanceof CSourceNotFoundElement) {
            return new CSourceNotFoundEditorInput(element);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (element instanceof CSourceNotFoundElement) {
            return ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
        }
        String id = null;
        if (input != null) {
            String lid;
            ISourcePresentation sourcePres;
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
            id = "org.eclipse.cdt.ui.editor.CEditor";
            if (descriptor != null) {
                id = descriptor.getId();
            } else if (element instanceof ICBreakpoint && (sourcePres = (ISourcePresentation)Platform.getAdapterManager().getAdapter(element, ISourcePresentation.class)) != null && (lid = sourcePres.getEditorId(input, element)) != null) {
                id = lid;
            }
        }
        return id;
    }

    public Image getImage(Object element) {
        Image baseImage = this.getBaseImage(element);
        if (baseImage != null) {
            ImageDescriptor[] overlays = new ImageDescriptor[4];
            if (element instanceof ICDebugElementStatus && !((ICDebugElementStatus)element).isOK()) {
                switch (((ICDebugElementStatus)element).getSeverity()) {
                    case 1: {
                        overlays[2] = CDebugImages.DESC_OVRS_WARNING;
                        break;
                    }
                    case 2: {
                        overlays[2] = CDebugImages.DESC_OVRS_ERROR;
                    }
                }
            }
            if (element instanceof IWatchExpression && ((IWatchExpression)element).hasErrors()) {
                overlays[2] = CDebugImages.DESC_OVRS_ERROR;
            }
            return this.getImageCache().getImageFor(new OverlayImageDescriptor(baseImage, overlays));
        }
        return null;
    }

    private Image getBaseImage(Object element) {
        IBreakpoint bp;
        if (element instanceof IMarker && (bp = this.getBreakpoint((IMarker)element)) != null && bp instanceof ICBreakpoint) {
            return this.getBreakpointImage((ICBreakpoint)bp);
        }
        if (element instanceof ICBreakpoint) {
            return this.getBreakpointImage((ICBreakpoint)element);
        }
        if (element instanceof IRegisterGroup) {
            return this.getRegisterGroupImage((IRegisterGroup)element);
        }
        if (element instanceof IExpression) {
            return this.getExpressionImage((IExpression)element);
        }
        if (element instanceof ICModule) {
            return this.getModuleImage((ICModule)element);
        }
        if (element instanceof ICSignal) {
            return this.getSignalImage((ICSignal)element);
        }
        return super.getImage(element);
    }

    protected Image getSignalImage(ICSignal signal) {
        return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SIGNAL);
    }

    protected Image getRegisterGroupImage(IRegisterGroup element) {
        IEnableDisableTarget target = (IEnableDisableTarget)element.getAdapter(IEnableDisableTarget.class);
        if (target != null && !target.isEnabled()) {
            return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER_GROUP_DISABLED);
        }
        return this.fDebugImageRegistry.get(CDebugImages.DESC_OBJS_REGISTER_GROUP);
    }

    protected Image getBreakpointImage(ICBreakpoint breakpoint) {
        Image image;
        ILabelProvider adapter = (ILabelProvider)Platform.getAdapterManager().getAdapter((Object)breakpoint, ILabelProvider.class);
        if (adapter != null && (image = adapter.getImage((Object)breakpoint)) != null) {
            return image;
        }
        try {
            if (breakpoint instanceof ICTracepoint) {
                return this.getTracepointImage((ICTracepoint)breakpoint);
            }
            if (breakpoint instanceof ICDynamicPrintf) {
                return this.getDynamicPrintfImage((ICDynamicPrintf)breakpoint);
            }
            if (breakpoint instanceof ICLineBreakpoint) {
                ICBreakpointType breakpointType;
                if (breakpoint instanceof ICBreakpointType && ((breakpointType = (ICBreakpointType)breakpoint).getType() & 2) != 0) {
                    return this.getHWBreakpointImage((ICLineBreakpoint)breakpoint);
                }
                return this.getLineBreakpointImage((ICLineBreakpoint)breakpoint);
            }
            if (breakpoint instanceof ICWatchpoint) {
                return this.getWatchpointImage((ICWatchpoint)breakpoint);
            }
            if (breakpoint instanceof ICEventBreakpoint) {
                return this.getEventBreakpointImage((ICEventBreakpoint)breakpoint);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected Image getHWBreakpointImage(ICLineBreakpoint breakpoint) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = breakpoint.isEnabled() ? CDebugImages.DESC_OBJS_HWBREAKPOINT_ENABLED : CDebugImages.DESC_OBJS_HWBREAKPOINT_DISABLED;
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeOverlays((ICBreakpoint)breakpoint)));
    }

    protected Image getDynamicPrintfImage(ICDynamicPrintf dynamicPrintf) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = dynamicPrintf.isEnabled() ? CDebugImages.DESC_OBJS_DYNAMICPRINTF_ENABLED : CDebugImages.DESC_OBJS_DYNAMICPRINTF_DISABLED;
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeOverlays((ICBreakpoint)dynamicPrintf)));
    }

    protected Image getTracepointImage(ICTracepoint tracepoint) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = tracepoint.isEnabled() ? CDebugImages.DESC_OBJS_TRACEPOINT_ENABLED : CDebugImages.DESC_OBJS_TRACEPOINT_DISABLED;
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeOverlays((ICBreakpoint)tracepoint)));
    }

    protected Image getLineBreakpointImage(ICLineBreakpoint breakpoint) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = breakpoint.isEnabled() ? CDebugImages.DESC_OBJS_BREAKPOINT_ENABLED : CDebugImages.DESC_OBJS_BREAKPOINT_DISABLED;
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeOverlays((ICBreakpoint)breakpoint)));
    }

    protected Image getWatchpointImage(ICWatchpoint watchpoint) throws CoreException {
        ImageDescriptor descriptor = null;
        descriptor = watchpoint.isEnabled() ? (watchpoint.isReadType() && !watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_ENABLED : (!watchpoint.isReadType() && watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_ENABLED : CDebugImages.DESC_OBJS_WATCHPOINT_ENABLED)) : (watchpoint.isReadType() && !watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_READ_WATCHPOINT_DISABLED : (!watchpoint.isReadType() && watchpoint.isWriteType() ? CDebugImages.DESC_OBJS_WRITE_WATCHPOINT_DISABLED : CDebugImages.DESC_OBJS_WATCHPOINT_DISABLED));
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeOverlays((ICBreakpoint)watchpoint)));
    }

    protected Image getEventBreakpointImage(ICEventBreakpoint evtBreakpoint) throws CoreException {
        ImageDescriptor descriptor = evtBreakpoint.isEnabled() ? CDebugImages.DESC_OBJS_EVENTBREAKPOINT_ENABLED : CDebugImages.DESC_OBJS_EVENTBREAKPOINT_DISABLED;
        return this.getImageCache().getImageFor(new OverlayImageDescriptor(this.fDebugImageRegistry.get(descriptor), this.computeOverlays((ICBreakpoint)evtBreakpoint)));
    }

    public String getText(Object element) {
        String bt = this.getBaseText(element);
        if (bt == null) {
            return null;
        }
        return CDebugUIUtils.decorateText(element, bt);
    }

    private String getBaseText(Object element) {
        StringBuilder label;
        boolean showQualified;
        block18: {
            showQualified = this.isShowQualifiedNames();
            label = new StringBuilder();
            if (element instanceof ICModule) {
                label.append(this.getModuleText((ICModule)element, showQualified));
                return label.toString();
            }
            if (element instanceof ICSignal) {
                label.append(this.getSignalText((ICSignal)element));
                return label.toString();
            }
            if (element instanceof IRegisterGroup) {
                label.append(((IRegisterGroup)element).getName());
                return label.toString();
            }
            if (element instanceof IWatchExpression) {
                return this.getWatchExpressionText((IWatchExpression)element);
            }
            if (element instanceof IValue) {
                label.append(this.getValueText((IValue)element));
                return label.toString();
            }
            if (element instanceof IStackFrame) {
                label.append(this.getStackFrameText((IStackFrame)element, showQualified));
                return label.toString();
            }
            if (element instanceof CSourceNotFoundElement) {
                return this.getBaseText(((CSourceNotFoundElement)element).getElement());
            }
            if (!(element instanceof IMarker)) break block18;
            IBreakpoint breakpoint = this.getBreakpoint((IMarker)element);
            if (breakpoint != null) {
                return CDebugUtils.getBreakpointText((IBreakpoint)breakpoint, (boolean)showQualified);
            }
            return null;
        }
        try {
            if (element instanceof IBreakpoint) {
                String text;
                ILabelProvider adapter = (ILabelProvider)Platform.getAdapterManager().getAdapter(element, ILabelProvider.class);
                if (adapter != null && (text = adapter.getText(element)) != null) {
                    return text;
                }
                return CDebugUtils.getBreakpointText((IBreakpoint)((IBreakpoint)element), (boolean)showQualified);
            }
            if (element instanceof IDebugTarget) {
                label.append(this.getTargetText((IDebugTarget)element, showQualified));
            }
            if (element instanceof ITerminate && ((ITerminate)element).isTerminated()) {
                label.insert(0, CDebugUIMessages.getString("CDTDebugModelPresentation.0"));
                return label.toString();
            }
            if (element instanceof IDisconnect && ((IDisconnect)element).isDisconnected()) {
                label.insert(0, CDebugUIMessages.getString("CDTDebugModelPresentation.1"));
                return label.toString();
            }
            if (label.length() > 0) {
                return label.toString();
            }
        }
        catch (DebugException e) {
            return MessageFormat.format((String)CDebugUIMessages.getString("CDTDebugModelPresentation.2"), (Object[])new Object[]{e.getMessage()});
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
        return null;
    }

    protected String getModuleText(ICModule module, boolean qualified) {
        StringBuilder sb = new StringBuilder();
        IPath path = module.getImageName();
        if (!path.isEmpty()) {
            sb.append(path.lastSegment());
        } else {
            sb.append(CDebugUIMessages.getString("CDebugModelPresentation.unknown_1"));
        }
        return sb.toString();
    }

    protected String getRegisterGroupText(IRegisterGroup group) {
        String name = CDebugUIMessages.getString("CDebugModelPresentation.not_available_1");
        try {
            name = group.getName();
        }
        catch (DebugException e) {
            CDebugUIPlugin.log(e.getStatus());
        }
        return name;
    }

    protected boolean isShowQualifiedNames() {
        Boolean showQualified = (Boolean)this.getAttributes().get(DISPLAY_FULL_PATHS);
        showQualified = showQualified == null ? Boolean.FALSE : showQualified;
        return showQualified;
    }

    private HashMap<String, Object> getAttributes() {
        return this.fAttributes;
    }

    private OverlayImageCache getImageCache() {
        return this.fImageCache;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    private ImageDescriptor[] computeOverlays(ICBreakpoint breakpoint) {
        ImageDescriptor[] overlays = new ImageDescriptor[4];
        try {
            if (CDebugCorePlugin.getDefault().getBreakpointActionManager().breakpointHasActions((IBreakpoint)breakpoint)) {
                ImageDescriptor imageDescriptor = overlays[3] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_WITH_ACTIONS : CDebugImages.DESC_OVRS_BREAKPOINT_WITH_ACTIONS_DISABLED;
            }
            if (breakpoint.isConditional()) {
                ImageDescriptor imageDescriptor = overlays[0] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL : CDebugImages.DESC_OVRS_BREAKPOINT_CONDITIONAL_DISABLED;
            }
            if (breakpoint.isInstalled()) {
                ImageDescriptor imageDescriptor = overlays[2] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED : CDebugImages.DESC_OVRS_BREAKPOINT_INSTALLED_DISABLED;
            }
            if (breakpoint instanceof ICAddressBreakpoint) {
                ImageDescriptor imageDescriptor = overlays[1] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT : CDebugImages.DESC_OVRS_ADDRESS_BREAKPOINT_DISABLED;
            }
            if (breakpoint instanceof ICFunctionBreakpoint) {
                overlays[1] = breakpoint.isEnabled() ? CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT : CDebugImages.DESC_OVRS_FUNCTION_BREAKPOINT_DISABLED;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log(e);
        }
        return overlays;
    }

    protected Image getExpressionImage(IExpression element) {
        return this.fDebugImageRegistry.get(DebugUITools.getImageDescriptor((String)"IMG_OBJS_EXPRESSION"));
    }

    protected Image getModuleImage(ICModule element) {
        switch (element.getType()) {
            case 1: {
                if (element.areSymbolsLoaded()) {
                    return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_EXECUTABLE_WITH_SYMBOLS);
                }
                return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_EXECUTABLE);
            }
            case 2: {
                if (element.areSymbolsLoaded()) {
                    return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SHARED_LIBRARY_WITH_SYMBOLS);
                }
                return CDebugUIPlugin.getImageDescriptorRegistry().get(CDebugImages.DESC_OBJS_SHARED_LIBRARY);
            }
        }
        return null;
    }

    protected String getValueText(IValue value) {
        return CDebugUIUtils.getValueText(value);
    }

    protected String getSignalText(ICSignal signal) {
        StringBuilder sb = new StringBuilder(CDebugUIMessages.getString("CDTDebugModelPresentation.12"));
        try {
            String name = signal.getName();
            sb.append(" '").append(name).append('\'');
        }
        catch (DebugException debugException) {}
        return sb.toString();
    }

    protected String getWatchExpressionText(IWatchExpression expression) {
        StringBuilder result = new StringBuilder();
        result.append('\"').append(expression.getExpressionText()).append('\"');
        if (expression.isPending()) {
            result.append(" = ").append(DUMMY_STACKFRAME_LABEL);
        } else {
            IValue value = expression.getValue();
            if (value instanceof ICValue) {
                String valueString;
                String typeName;
                ICType type = null;
                try {
                    type = ((ICValue)value).getType();
                }
                catch (DebugException debugException) {}
                if (type != null && this.isShowVariableTypeNames() && !this.isEmpty(typeName = CDebugUIUtils.getVariableTypeName(type))) {
                    result.insert(0, String.valueOf(typeName) + ' ');
                }
                if (expression.isEnabled() && (valueString = this.getValueText(value)).length() > 0) {
                    result.append(" = ").append(valueString);
                }
            }
        }
        if (!expression.isEnabled()) {
            result.append(' ');
            result.append(CDebugUIMessages.getString("CDTDebugModelPresentation.22"));
        }
        return result.toString();
    }

    protected String getTargetText(IDebugTarget target, boolean qualified) throws DebugException {
        return target.getName();
    }

    protected String getStackFrameText(IStackFrame f, boolean qualified) throws DebugException {
        if (f instanceof ICStackFrame) {
            ICStackFrame frame = (ICStackFrame)f;
            StringBuilder label = new StringBuilder();
            label.append(frame.getLevel());
            label.append(' ');
            String function = frame.getFunction();
            if (this.isEmpty(function)) {
                label.append(CDebugUIMessages.getString("CDTDebugModelPresentation.21"));
            } else {
                Path path;
                function = function.trim();
                label.append(function);
                label.append("() ");
                if (frame.getFile() != null && !(path = new Path(frame.getFile())).isEmpty()) {
                    label.append(qualified ? path.toOSString() : path.lastSegment());
                    label.append(':');
                    if (frame.getFrameLineNumber() != 0) {
                        label.append(frame.getFrameLineNumber());
                    }
                }
            }
            IAddress address = frame.getAddress();
            if (address != null) {
                label.append(' ');
                label.append(address.toHexAddressString());
            }
            return label.toString();
        }
        return f.getAdapter(IDummyStackFrame.class) != null ? this.getDummyStackFrameLabel(f) : f.getName();
    }

    private String getDummyStackFrameLabel(IStackFrame stackFrame) {
        return DUMMY_STACKFRAME_LABEL;
    }

    protected boolean isShowVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get("org.eclipse.debug.ui.displayVariableTypeNames");
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    public static String getFormattedString(String key, String arg) {
        return CDebugModelPresentation.getFormattedString(key, new String[]{arg});
    }

    public static String getFormattedString(String string, String[] args) {
        return MessageFormat.format((String)string, (Object[])args);
    }

    public Color getForeground(Object element) {
        IColorProvider colorProv = (IColorProvider)Platform.getAdapterManager().getAdapter(element, IColorProvider.class);
        if (colorProv != null) {
            return colorProv.getForeground(element);
        }
        return null;
    }

    public Color getBackground(Object element) {
        IColorProvider colorProv = (IColorProvider)Platform.getAdapterManager().getAdapter(element, IColorProvider.class);
        if (colorProv != null) {
            return colorProv.getBackground(element);
        }
        return null;
    }
}

