/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.resource.sdk.core;

import com.nxp.s32ds.cle.runtime.resource.internal.sdk.core.Messages;
import com.nxp.s32ds.cle.runtime.resource.internal.sdk.core.ResourceSdkCoreActivator;
import com.nxp.s32ds.cle.runtime.resource.sdk.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.resource.sdk.ResourceSdkKind;
import com.nxp.s32ds.cle.runtime.resource.sdk.ResourceSdkRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;

public class ResourceSdkDescriptors {
    public static ResourceSdkRegistry getResourceSdkRegistry() {
        return ResourceSdkCoreActivator.getDefault().getResourceSdkRegistry();
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptors() {
        return ResourceSdkDescriptors.getResourceSdkRegistry().getResourceSdkDescriptors();
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptorsByResourceId(String resourceId) {
        return ResourceSdkDescriptors.getResourceSdkRegistry().getResourceSdkDescriptorsByResourceId(resourceId);
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptorsBySdkId(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkRegistry().getResourceSdkDescriptorsBySdkId(sdkId);
    }

    public static void addResourceSdkDescriptor(ResourceSdkDescriptor descriptor) {
        ResourceSdkDescriptors.getResourceSdkRegistry().addResourceSdkDescriptor(descriptor);
        ResourceSdkCoreActivator.logInfo(NLS.bind((String)Messages.ResourceSdkDescriptors_register_descriptor_message, (Object)descriptor.getResourceId(), (Object)descriptor.getSdkId()));
    }

    public static void removeResourceSdkDescriptor(ResourceSdkDescriptor descriptor) {
        ResourceSdkDescriptors.getResourceSdkRegistry().removeResourceSdkDescriptor(descriptor);
        ResourceSdkCoreActivator.logInfo(NLS.bind((String)Messages.ResourceSdkDescriptors_unregister_descriptor_message, (Object)descriptor.getResourceId(), (Object)descriptor.getSdkId()));
    }

    public static void removeResourceSdkDescriptors(String sdkId) {
        ResourceSdkDescriptors.getResourceSdkRegistry().removeResourceSdkDescriptorsBySdkId(sdkId);
        ResourceSdkCoreActivator.logInfo(NLS.bind((String)Messages.ResourceSdkDescriptors_unregister_descriptors_message, (Object)sdkId));
    }

    public static List<ResourceSdkDescriptor> getBinaryFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.BINARY_FILE);
    }

    public static List<ResourceSdkDescriptor> getHeaderFolderSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.HEADER_FOLDER);
    }

    public static List<ResourceSdkDescriptor> getHeaderFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.HEADER_FILE);
    }

    public static List<ResourceSdkDescriptor> getLinkerLdFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.LINKER_FILE);
    }

    public static List<ResourceSdkDescriptor> getResourceFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.RESOURCE_FILE);
    }

    public static List<ResourceSdkDescriptor> getSourceFolderSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.SOURCE_FOLDER);
    }

    public static List<ResourceSdkDescriptor> getSourceFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.SOURCE_FILE);
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptorsBySdkIdAndType(String sdkId, ResourceSdkKind kind) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId(sdkId).stream().filter(r -> kind == r.getKind()).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptorsBySdkIdAndToolChainId(String sdkId, String toolChainId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId(sdkId).stream().filter(r -> toolChainId.equals(r.getToolChainId())).collect(Collectors.toList());
    }
}

