/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.internal.ui;

import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.debug.ide.core.AttributeReadingUtils;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.internal.ui.S32DebuggerTabMessages;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerAttributesValidator;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import com.nxp.s32ds.debug.ide.ui.DebuggerTabMessages;
import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class S32DebuggerTab
extends AbstractLaunchConfigurationTab {
    private static final int COMBOS_WIDTH_HINT = 350;
    private static final String CMSISDAP_DEFAULT_SPEED = "5000";
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "com.nxp.s32ds.debug.ide.ui.internal.debuggertab";
    private Group hardware;
    private Label device;
    private Label core;
    private Text initializationScript;
    private Button initialCore;
    private Group debugProbeConnection;
    private Combo debugInterface;
    private Combo deviceUSB;
    private Button refresh;
    private Text hostNameOrIp;
    private Group targetCommunicationSpeed;
    private Text jtagSpeed;
    private Text remoteTimeout;
    private Button resetAndDelay;
    private Text delay;
    private Group gdbServer;
    private Button launchServer;
    private Text serverPort;
    private Button enableLog;
    private Group gdbClient;
    private Text clientExecutable;
    private Text clientCommands;
    private Group semihosting;
    private Button enableSemihosting;
    private Text semihostingPort;
    private Group secureDebugger;
    private Button btnEnableSecureDebugging;
    private Combo cmbSecureType;
    private boolean doLaunchServer = true;
    private boolean isLogEnabled = false;
    private boolean isSemihostingEnabled = true;
    private Button forceThreadListUpdateOnSuspend;
    private String jtagLCBaseSpeed;

    public void createControl(Composite parent) {
        ScrolledComposite scrolledComposite = SWTUtils.createScrolledComposite((Composite)parent);
        this.setControl((Control)scrolledComposite);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createHardwareGroup(composite);
        this.createDebugProbeConnectionGroup(composite);
        this.createTargetCommunicationSpeedGroup(composite);
        this.createGdbServerGroup(composite);
        this.createGdbClientGroup(composite);
        this.createSemihostingGroup(composite);
        this.createSecureDebuggingGroup(composite);
    }

    private void createHardwareGroup(Composite parent) {
        this.hardware = SWTUtils.createGroup((Composite)parent, (int)5, (String)DebuggerTabMessages.DebuggerTab_hardware_group);
        int hardwareInfoLabelsWidth = 150;
        SWTUtils.createLabel((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_device_label);
        this.device = SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)"Select device", (int)hardwareInfoLabelsWidth);
        SWTUtils.createLabel((Composite)this.hardware, (String)S32DebuggerTabMessages.S32DebuggerTab_core_label);
        this.core = SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)"Select core", (int)hardwareInfoLabelsWidth);
        Button selectDeviceAndCore = SWTUtils.createButton((Composite)this.hardware, (String)S32DebuggerTabMessages.S32DebuggerTab_select_device_and_core_button, (int)0);
        Composite local = SWTUtils.createGridCellComposite((Composite)this.hardware, (int)5, (int)4);
        SWTUtils.createLabel((Composite)local, (String)DebuggerTabMessages.DebuggerTab_initialization_script_label);
        this.initializationScript = SWTUtils.createWideText((Composite)local, (int)2052, (boolean)true, (int)1);
        this.initializationScript.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        selectDeviceAndCore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object firstResult;
                ILabelProvider decoratingProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(S32DebuggerTab.this.getShell(), decoratingProvider);
                dialog.setTitle(S32DebuggerTabMessages.S32DebuggerTab_select_target_device_and_core_dialog);
                dialog.setMessage(DebuggerTabMessages.DebuggerTab_select_target_dialog_text_hint);
                dialog.setMultipleSelection(false);
                Object[] cores = DebuggerUtils.retrieveDeviceCoreDebuggerDescriptors((String)S32DebuggerTab.this.getDebuggerID());
                dialog.setElements(cores);
                dialog.setIgnoreCase(true);
                if (dialog.open() == 0 && (firstResult = dialog.getFirstResult()) instanceof DeviceCoreDescriptor) {
                    DeviceCoreDescriptor deviceCoreDescriptor = (DeviceCoreDescriptor)firstResult;
                    S32DebuggerTab.this.device.setText(deviceCoreDescriptor.getDeviceId());
                    S32DebuggerTab.this.core.setText(deviceCoreDescriptor.getName());
                    S32DebuggerTab.this.clientExecutable.setText(DebuggerUtils.retrieveGdbClientVariable((String)DebuggerUtils.retrieveCoreType((DeviceCoreDescriptor)deviceCoreDescriptor), (String)S32DebuggerTab.this.getDebuggerID()));
                    S32DebuggerTab.this.initializationScript.setText(DebuggerUtils.retrieveInitializationScriptPath((DeviceCoreDescriptor)deviceCoreDescriptor, (String)S32DebuggerTab.this.getDebuggerID()));
                    String registeredClientCommand = (String)S32DebuggerCoreActivator.getDeviceClientCommands().get(deviceCoreDescriptor.getId());
                    if (registeredClientCommand != null) {
                        S32DebuggerTab.this.clientCommands.setText(registeredClientCommand);
                    } else {
                        S32DebuggerTab.this.clientCommands.setText("");
                    }
                }
                S32DebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browse = SWTUtils.createButton((Composite)local, (String)DebuggerTabMessages.DebuggerTab_browse_button, (int)0);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.browseButtonSelected(DebuggerTabMessages.DebuggerTab_browse_initialization_script_title, S32DebuggerTab.this.initializationScript);
            }
        });
        Button variables = SWTUtils.createButton((Composite)local, (String)DebuggerTabMessages.DebuggerTab_variable_button, (int)0);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.variablesButtonSelected(S32DebuggerTab.this.initializationScript);
            }
        });
        this.initialCore = SWTUtils.createButton((Composite)local, (String)DebuggerTabMessages.DebuggerTab_initial_core, (int)32);
        this.initialCore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.initialCoreStateChanged();
            }
        });
    }

    private void initialCoreStateChanged() {
        boolean areInitialCoreSettingsEnabled = this.initialCore.getSelection();
        this.debugInterface.setEnabled(areInitialCoreSettingsEnabled);
        this.jtagSpeed.setEnabled(areInitialCoreSettingsEnabled);
        this.resetAndDelay.setEnabled(areInitialCoreSettingsEnabled);
        this.launchServer.setEnabled(areInitialCoreSettingsEnabled);
        this.enableSemihosting.setEnabled(areInitialCoreSettingsEnabled);
        if (areInitialCoreSettingsEnabled) {
            boolean isEthernetChosen = DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet.equals(this.debugInterface.getText());
            this.deviceUSB.setEnabled(!isEthernetChosen);
            this.refresh.setEnabled(!isEthernetChosen);
            this.hostNameOrIp.setEnabled(isEthernetChosen);
            this.delay.setEnabled(this.resetAndDelay.getSelection());
            this.launchServer.setSelection(this.doLaunchServer);
            this.enableSemihosting.setSelection(this.isSemihostingEnabled);
            this.enableLog.setSelection(this.isLogEnabled);
        } else {
            this.deviceUSB.setEnabled(false);
            this.refresh.setEnabled(false);
            this.hostNameOrIp.setEnabled(false);
            this.delay.setEnabled(false);
            this.doLaunchServer = this.launchServer.getSelection();
            this.launchServer.setSelection(false);
            this.isSemihostingEnabled = this.enableSemihosting.getSelection();
            this.enableSemihosting.setSelection(false);
            this.isLogEnabled = this.enableLog.getSelection();
            this.enableLog.setSelection(false);
            this.btnEnableSecureDebugging.setSelection(false);
        }
        this.enableLog.setEnabled(this.launchServer.getSelection());
        this.btnEnableSecureDebugging.setEnabled(areInitialCoreSettingsEnabled);
        this.cmbSecureType.setEnabled(this.btnEnableSecureDebugging.getSelection());
        this.scheduleUpdateJob();
    }

    private void createDebugProbeConnectionGroup(Composite parent) {
        this.debugProbeConnection = SWTUtils.createGroup((Composite)parent, (int)3, (String)DebuggerTabMessages.DebuggerTab_debug_probe_connection_group);
        SWTUtils.createLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_interface_label);
        this.debugInterface = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.debugProbeConnection, (int)8, (int)350, (int)2);
        this.debugInterface.setItems(new String[]{DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet, DebuggerTabMessages.DebuggerTab_interface_s32probe_usb});
        this.debugInterface.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.debugInterfaceChanged(S32DebuggerTab.this.debugInterface.getText());
            }
        });
        SWTUtils.createLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_device);
        this.deviceUSB = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.debugProbeConnection, (int)8, (int)350, (int)1);
        this.deviceUSB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.refresh = SWTUtils.createButtonWithHorizontalSpan((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_refresh_button, (int)0, (int)1);
        this.refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String curDevice = S32DebuggerTab.this.deviceUSB.getText();
                S32DebuggerTab.this.updateUSBDevices(S32DebuggerTab.this.debugInterface.getText());
                if (!curDevice.isEmpty()) {
                    S32DebuggerTab.this.setUSBDevice(curDevice);
                } else if (S32DebuggerTab.this.deviceUSB.getItemCount() > 0) {
                    S32DebuggerTab.this.deviceUSB.select(0);
                }
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_hostname_or_ip_label);
        this.hostNameOrIp = SWTUtils.createTextWithWidthHint((Composite)this.debugProbeConnection, (int)2048, (int)364, (int)2);
        this.hostNameOrIp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
    }

    private void debugInterfaceChanged(String selectedInterface) {
        boolean isUsbUsed = !DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet.equals(this.debugInterface.getText());
        this.deviceUSB.setEnabled(isUsbUsed);
        this.refresh.setEnabled(isUsbUsed);
        this.hostNameOrIp.setEnabled(!isUsbUsed);
        String curDevice = this.deviceUSB.getText();
        this.updateUSBDevices(selectedInterface);
        this.setUSBDevice(curDevice);
        if (this.deviceUSB.getText().isEmpty() && this.deviceUSB.getItemCount() > 0) {
            this.deviceUSB.select(0);
        }
        this.scheduleUpdateJob();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        S32DebuggerAttributesValidator validator = new S32DebuggerAttributesValidator();
        S32DebuggerParams debuggerParams = S32DebuggerParams.getParams((ILaunchConfiguration)config);
        ArrayList errorsAndWarnings = validator.validateDebuggerParameters(debuggerParams, false);
        ArrayList errors = (ArrayList)errorsAndWarnings.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (errors.size() != 0) {
            this.setErrorMessage(((IStatus)errors.get(0)).getMessage());
            return false;
        }
        if (errorsAndWarnings.size() != 0) {
            this.setWarningMessage(((IStatus)errorsAndWarnings.get(0)).getMessage());
            return true;
        }
        return true;
    }

    private void createTargetCommunicationSpeedGroup(Composite parent) {
        this.targetCommunicationSpeed = SWTUtils.createGroup((Composite)parent, (int)5, (String)DebuggerTabMessages.DebuggerTab_target_communication_speed_group);
        SWTUtils.createLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_jtag_speed_label);
        int widthHint = 50;
        this.jtagSpeed = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)widthHint, (int)1);
        this.jtagSpeed.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabelWithHorizontalIndent((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_timeout_label, (int)25);
        this.remoteTimeout = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)widthHint, (int)1);
        this.remoteTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_timeout_unit_of_measure_label);
        this.resetAndDelay = SWTUtils.createButton((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_reset_and_delay_button, (int)32);
        this.resetAndDelay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.delay.setEnabled(((Button)e.getSource()).getSelection());
                S32DebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.delay = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)widthHint, (int)1);
        this.delay.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_delay_unit_of_measure_label);
    }

    private void createGdbServerGroup(Composite parent) {
        this.gdbServer = SWTUtils.createGroup((Composite)parent, (int)2, (String)DebuggerTabMessages.DebuggerTab_gdb_server_group);
        this.launchServer = SWTUtils.createButtonWithHorizontalSpan((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_launch_server_button, (int)32, (int)2);
        this.launchServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isServerLaunched = S32DebuggerTab.this.launchServer.getSelection();
                S32DebuggerTab.this.enableLog.setEnabled(isServerLaunched);
                if (!isServerLaunched) {
                    S32DebuggerTab.this.isLogEnabled = S32DebuggerTab.this.enableLog.getSelection();
                    S32DebuggerTab.this.enableLog.setSelection(false);
                } else {
                    S32DebuggerTab.this.enableLog.setSelection(S32DebuggerTab.this.isLogEnabled);
                }
                S32DebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label serverPortNumberLabel = SWTUtils.createLabel((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_server_port_number_label);
        SWTUtils.createControlDecoration((Label)serverPortNumberLabel, (String)DebuggerTabMessages.DebuggerTab_server_port_tooltip, (String)"DEC_INFORMATION", (int)131072);
        this.serverPort = SWTUtils.createTextWithHorizontalIndentAndWidthHint((Composite)this.gdbServer, (int)2052, (int)5, (int)40);
        this.serverPort.setTextLimit(5);
        this.serverPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String serverPortText = S32DebuggerTab.this.serverPort.getText().trim();
                if (serverPortText.isEmpty()) {
                    S32DebuggerTab.this.semihostingPort.setText("");
                } else {
                    Integer serverPortNumber = null;
                    try {
                        serverPortNumber = Integer.parseInt(serverPortText);
                    }
                    catch (NumberFormatException numberFormatException) {
                        S32DebuggerTab.this.semihostingPort.setText("");
                    }
                    S32DebuggerTab.this.semihostingPort.setText(Integer.toString(serverPortNumber + 1));
                }
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.enableLog = SWTUtils.createButton((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_enable_log, (int)32);
        this.enableLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createGdbClientGroup(Composite parent) {
        this.gdbClient = SWTUtils.createGroup((Composite)parent, (int)4, (String)DebuggerTabMessages.DebuggerTab_gdb_client_group);
        SWTUtils.createLabel((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_executable_label);
        this.clientExecutable = SWTUtils.createWideText((Composite)this.gdbClient, (int)2052, (boolean)true, (int)1);
        this.clientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        Button browse = SWTUtils.createButton((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_browse_button, (int)0);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.browseButtonSelected(DebuggerTabMessages.DebuggerTab_browse_gdb_client_title, S32DebuggerTab.this.clientExecutable);
            }
        });
        Button variables = SWTUtils.createButton((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_variable_button, (int)0);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.variablesButtonSelected(S32DebuggerTab.this.clientExecutable);
            }
        });
        SWTUtils.createLabelWithVerticalAlignment((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_commands_label, (int)1);
        this.clientCommands = SWTUtils.createWideTextWithHeightHint((Composite)this.gdbClient, (int)2626, (boolean)true, (int)3, (int)60);
        this.clientCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.forceThreadListUpdateOnSuspend = SWTUtils.createButtonWithHorizontalSpan((Composite)this.gdbClient, (String)S32DebuggerTabMessages.S32DebuggerTab_force_thread_list_update_on_suspend, (int)32, (int)4);
        this.forceThreadListUpdateOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createSemihostingGroup(Composite parent) {
        this.semihosting = SWTUtils.createGroup((Composite)parent, (int)2, (String)S32DebuggerTabMessages.S32DebuggerTab_semihosting_group);
        this.enableSemihosting = SWTUtils.createButtonWithHorizontalSpan((Composite)this.semihosting, (String)S32DebuggerTabMessages.S32DebuggerTab_enable_semihosting_button, (int)32, (int)2);
        this.enableSemihosting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.semihosting, (String)S32DebuggerTabMessages.S32DebuggerTab_semihosting_port_label);
        this.semihostingPort = SWTUtils.createTextWithHorizontalIndentAndWidthHint((Composite)this.semihosting, (int)2052, (int)5, (int)40);
        this.semihostingPort.setTextLimit(5);
        this.semihostingPort.setEnabled(false);
        this.semihostingPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
    }

    private void createSecureDebuggingGroup(Composite parent) {
        this.secureDebugger = SWTUtils.createGroup((Composite)parent, (int)2, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_group);
        this.btnEnableSecureDebugging = SWTUtils.createButtonWithHorizontalSpan((Composite)this.secureDebugger, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_button, (int)32, (int)2);
        this.btnEnableSecureDebugging.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (S32DebuggerTab.this.btnEnableSecureDebugging.getSelection()) {
                    S32DebuggerTab.this.cmbSecureType.setEnabled(true);
                    if (S32DebuggerTab.this.cmbSecureType.getText().isEmpty()) {
                        S32DebuggerTab.this.cmbSecureType.select(0);
                    }
                } else {
                    S32DebuggerTab.this.cmbSecureType.setEnabled(false);
                }
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.secureDebugger, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_type);
        this.cmbSecureType = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.secureDebugger, (int)8, (int)350, (int)1);
        this.cmbSecureType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerTab.this.scheduleUpdateJob();
            }
        });
        this.cmbSecureType.setItems(new String[]{DebuggerTabMessages.DebuggerTab_secure_debugging_PwD, DebuggerTabMessages.DebuggerTab_secure_debugging_C_R});
        this.cmbSecureType.setEnabled(false);
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.setText(dialog.getVariableExpression());
        }
    }

    public String getName() {
        return TAB_NAME;
    }

    public String getId() {
        return TAB_ID;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerParams.applyDefaults((ILaunchConfigurationWorkingCopy)lc);
    }

    private void setDefaultElementForCombo(Combo combo, String text) {
        String[] comboItems = combo.getItems();
        if (!text.isEmpty()) {
            int i = 0;
            while (i < comboItems.length) {
                if (text.contains(comboItems[i])) {
                    combo.select(i);
                    return;
                }
                ++i;
            }
        }
        combo.select(0);
    }

    public void initializeFrom(ILaunchConfiguration lc) {
        boolean isUSBUsed;
        S32DebuggerParams debuggerParams = S32DebuggerParams.getParams((ILaunchConfiguration)lc);
        this.device.setText(debuggerParams.getDevice());
        this.core.setText(debuggerParams.getCore());
        this.initializationScript.setText(debuggerParams.getInitializationScript());
        this.initialCore.setSelection(debuggerParams.isInitialCore());
        boolean bl = isUSBUsed = !debuggerParams.isUseEthernet();
        if (!isUSBUsed) {
            this.setDefaultElementForCombo(this.debugInterface, DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet);
            this.hostNameOrIp.setText(debuggerParams.getProbeHostnameOrIP());
        } else {
            this.deviceUSB.setItems(new String[0]);
            boolean deviceFound = false;
            String devicePort = debuggerParams.getDevicePort();
            Collection activeDevices = DebuggerUtils.getActiveUSBCmsisDapDevices();
            for (String device : activeDevices) {
                if (!device.contains(devicePort)) continue;
                this.setDefaultElementForCombo(this.debugInterface, DebuggerTabMessages.DebuggerTab_interface_cmsisdap_usb);
                this.addUSBDevices(activeDevices);
                this.setDefaultElementForCombo(this.deviceUSB, device);
                deviceFound = true;
                break;
            }
            activeDevices = DebuggerUtils.getActiveUSBS32DebuggerTapDevices();
            for (String device : activeDevices) {
                if (!device.contains(devicePort)) continue;
                this.setDefaultElementForCombo(this.debugInterface, DebuggerTabMessages.DebuggerTab_interface_s32probe_usb);
                this.addUSBDevices(activeDevices);
                this.setDefaultElementForCombo(this.deviceUSB, device);
                deviceFound = true;
                break;
            }
            if (!deviceFound) {
                this.setDefaultElementForCombo(this.debugInterface, DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet);
                isUSBUsed = false;
            }
        }
        this.deviceUSB.setEnabled(isUSBUsed);
        this.refresh.setEnabled(isUSBUsed);
        this.hostNameOrIp.setEnabled(!isUSBUsed);
        this.jtagLCBaseSpeed = debuggerParams.getJtagSpeedKHz();
        this.jtagSpeed.setText(this.jtagLCBaseSpeed);
        this.remoteTimeout.setText(debuggerParams.getRemoteTimeoutInSeconds());
        this.resetAndDelay.setSelection(debuggerParams.isDoResetAndDelay());
        this.delay.setText(debuggerParams.getDelayInMSeconds());
        this.doLaunchServer = debuggerParams.isDoLaunchServer();
        this.launchServer.setSelection(this.doLaunchServer);
        this.serverPort.setText(debuggerParams.getServerPort());
        this.isLogEnabled = debuggerParams.isLogEnabled();
        this.enableLog.setSelection(debuggerParams.isLogEnabled());
        this.clientExecutable.setText(debuggerParams.getClientExecutable());
        this.clientCommands.setText(debuggerParams.getClientCommands());
        this.isSemihostingEnabled = debuggerParams.isSemihostingEnabled();
        this.enableSemihosting.setSelection(this.isSemihostingEnabled);
        this.semihostingPort.setText(debuggerParams.getSemihostingPort());
        this.forceThreadListUpdateOnSuspend.setSelection(debuggerParams.isForceThreadListUpdateOnSuspend());
        boolean useSecureDebugging = debuggerParams.isUseSecureDebugging();
        this.btnEnableSecureDebugging.setSelection(useSecureDebugging);
        this.cmbSecureType.setEnabled(useSecureDebugging);
        if (useSecureDebugging) {
            String secureType = debuggerParams.getSecureDebuggingType();
            if ("CR".equals(secureType)) {
                this.setDefaultElementForCombo(this.cmbSecureType, DebuggerTabMessages.DebuggerTab_secure_debugging_C_R);
            } else {
                this.setDefaultElementForCombo(this.cmbSecureType, DebuggerTabMessages.DebuggerTab_secure_debugging_PwD);
            }
        }
        this.initialCoreStateChanged();
        ArrayList readErrors = debuggerParams.getReadErrors();
        if (!readErrors.isEmpty()) {
            AttributeReadingUtils.handleAttributeReadingFailure((IStatus)ErrorStatuses.getAttributesReadingFailedStatus((List)readErrors));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerParams debuggerParams = new S32DebuggerParams();
        debuggerParams.setDevice(this.device.getText());
        debuggerParams.setCore(this.core.getText());
        debuggerParams.setInitializationScript(this.initializationScript.getText().trim());
        debuggerParams.setInitialCore(this.initialCore.getSelection());
        debuggerParams.setUseEthernet(DebuggerTabMessages.DebuggerTab_interface_s32probe_ethernet.equals(this.debugInterface.getText()));
        debuggerParams.setDevicePort("");
        if (debuggerParams.isUseEthernet()) {
            debuggerParams.setProbeHostnameOrIP(this.hostNameOrIp.getText().trim());
        } else {
            Collection devices = null;
            if (DebuggerTabMessages.DebuggerTab_interface_s32probe_usb.equals(this.debugInterface.getText())) {
                devices = DebuggerUtils.getActiveUSBS32DebuggerTapDevices();
            }
            if (DebuggerTabMessages.DebuggerTab_interface_cmsisdap_usb.equals(this.debugInterface.getText())) {
                devices = DebuggerUtils.getActiveUSBCmsisDapDevices();
            }
            for (String device : devices) {
                if (!device.contains(this.deviceUSB.getText())) continue;
                debuggerParams.setDevicePort(device);
                break;
            }
        }
        debuggerParams.setJtagSpeedKHz(this.jtagSpeed.getText().trim());
        debuggerParams.setRemoteTimeoutInSeconds(this.remoteTimeout.getText().trim());
        debuggerParams.setDoResetAndDelay(this.resetAndDelay.getSelection());
        debuggerParams.setDelayInMSeconds(this.delay.getText().trim());
        debuggerParams.setDoLaunchServer(this.launchServer.getSelection());
        debuggerParams.setServerPort(this.serverPort.getText().trim());
        debuggerParams.setClientExecutable(this.clientExecutable.getText().trim());
        debuggerParams.setClientCommands(this.clientCommands.getText());
        debuggerParams.setForceThreadListUpdateOnSuspend(this.forceThreadListUpdateOnSuspend.getSelection());
        debuggerParams.setLogEnabled(this.enableLog.getSelection());
        debuggerParams.setSemihostingEnabled(this.enableSemihosting.getSelection());
        debuggerParams.setSemihostingPort(this.semihostingPort.getText().trim());
        boolean useSecureDebugging = this.btnEnableSecureDebugging.getSelection();
        debuggerParams.setUseSecureDebugging(useSecureDebugging);
        if (useSecureDebugging) {
            String secureType = this.cmbSecureType.getText();
            if (DebuggerTabMessages.DebuggerTab_secure_debugging_C_R.equals(secureType)) {
                debuggerParams.setSecureDebuggingType("CR");
            } else {
                debuggerParams.setSecureDebuggingType("PWD");
            }
        } else {
            debuggerParams.setSecureDebuggingType("");
        }
        debuggerParams.applyParams(lc);
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    private void addUSBDevices(Collection<String> activeDevices) {
        for (String device : activeDevices) {
            String[] deviceStrings = device.split("--");
            this.deviceUSB.add(deviceStrings[2]);
        }
    }

    private void updateUSBDevices(String selectedInterface) {
        this.deviceUSB.setItems(new String[0]);
        if (selectedInterface.equals(DebuggerTabMessages.DebuggerTab_interface_cmsisdap_usb)) {
            Collection activeDevicesCMSISDap = DebuggerUtils.getActiveUSBCmsisDapDevices();
            this.addUSBDevices(activeDevicesCMSISDap);
            this.jtagSpeed.setText(CMSISDAP_DEFAULT_SPEED);
        } else {
            this.jtagSpeed.setText(this.jtagLCBaseSpeed);
        }
        if (selectedInterface.equals(DebuggerTabMessages.DebuggerTab_interface_s32probe_usb)) {
            Collection activeDevicesS32DebuggerTap = DebuggerUtils.getActiveUSBS32DebuggerTapDevices();
            this.addUSBDevices(activeDevicesS32DebuggerTap);
        }
    }

    private void setUSBDevice(String oldDevice) {
        String[] stringArray = this.deviceUSB.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String curDevice = stringArray[n2];
            if (oldDevice.equals(curDevice)) {
                this.deviceUSB.select(this.deviceUSB.indexOf(curDevice));
                break;
            }
            ++n2;
        }
    }

    protected String getDebuggerID() {
        return "s32debugger";
    }
}

