/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.scripting;

import com.nxp.s32ds.cle.uct.core.ISDKProjectHandler;
import com.nxp.s32ds.cle.uct.internal.core.ProjectPropertiesManager;
import com.nxp.s32ds.cle.uct.internal.core.ToolchainSettingsUtils;
import com.nxp.swtools.periphs.controller.scripting.PeripheralsScriptProfile;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;

public class ToolchainScriptProfile
extends PeripheralsScriptProfile {
    private ToolchainSettingsUtils toolchainUtils;
    private IProject project;
    private ISDKProjectHandler projectHandler;
    public static final String STORAGE_ID = "com.nxp.s32ds.cle.uct.internal.core.toolchainScriptProfile";

    public ToolchainScriptProfile(IMcu mcu, PeriphsProfile profile, IProject project, ISDKProjectHandler projectHandler) {
        super(mcu, profile);
        this.toolchainUtils = new ToolchainSettingsUtils(project);
        this.project = project;
        this.projectHandler = projectHandler;
    }

    public ISDKProjectHandler getProjectHandler() {
        return this.projectHandler;
    }

    public void add_C_Compiler_Includes(String newEntry) {
        this.toolchainUtils.addCCompilerIncludes(newEntry);
    }

    public void add_C_Linker_Library(String newEntry) {
        this.toolchainUtils.addCOption(newEntry, "gnu.c.link.option.libs", "COND_TOOLCHAIN_LIBRARIES");
    }

    public void add_C_Linker_LibraryPath(String newEntry) {
        this.toolchainUtils.addCOption(newEntry, "gnu.c.link.option.paths", "COND_TOOLCHAIN_LIBRARIES_PATHS");
    }

    public void add_C_Compiler_Symbol(String newEntry) {
        this.toolchainUtils.addCOption(newEntry, "gnu.c.compiler.option.preprocessor.def.symbols", "COND_TOOLCHAIN_DEFINES");
    }

    public void add_C_Assembler_Symbol(String newEntry) {
        this.toolchainUtils.addCOption(newEntry, ToolchainSettingsUtils.getAssemblerSymbolOption(this.project), "COND_TOOLCHAIN_ASM_DEFINES");
    }

    public void add_C_Option(String newEntry, String cOption) {
        this.toolchainUtils.addCCustomOption(newEntry, cOption, "COND_TOOLCHAIN_CUSTOM_OPTION");
    }

    public boolean addAllComponents(List<String> compIds, boolean standalone, boolean importOtherFiles) {
        String oldToolchainOps = ProjectPropertiesManager.getOneEntry(this.project, "COND_TOOLCHAIN_COMPONENTS_OPTION", STORAGE_ID);
        if (oldToolchainOps == null) {
            oldToolchainOps = "";
        }
        if (compIds.isEmpty()) {
            return false;
        }
        ArrayList<String> currentDependencies = new ArrayList<String>(Arrays.asList(oldToolchainOps.split(";")));
        for (String compId : compIds) {
            if (currentDependencies.contains(compId)) continue;
            oldToolchainOps = String.valueOf(oldToolchainOps) + compId + ";";
            currentDependencies.add(compId);
        }
        ProjectPropertiesManager.addOneEntry(this.project, "COND_TOOLCHAIN_COMPONENTS_OPTION", oldToolchainOps, STORAGE_ID);
        return true;
    }

    public boolean addComponents(String id, boolean standalone, boolean importOtherFiles) {
        return this.addAllComponents(new ArrayList<String>(Arrays.asList(id)), standalone, importOtherFiles);
    }
}

