/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.providers;

import com.nxp.s32ds.cle.uct.core.Activator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class XSLTUtils {
    public static final String RES_BASE = "rsc/";
    public static final String XSLT_SVD = "rsc/SVDTranslate.xslt";
    public static final String BUNDLED_PERIPHERALS_PARAM = "internal.peripherals";

    public static boolean cortexPeripheralsEnabled() {
        return false;
    }

    public static void svdTranslate(Source source, Result result, String bundledPeripherals) throws FileNotFoundException, IOException, TransformerException {
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(XSLT_SVD), null);
        TransformerFactory factory = TransformerFactory.newInstance();
        Templates template = factory.newTemplates(new StreamSource(new FileInputStream(FileLocator.toFileURL((URL)url).getPath())));
        Transformer xformer = template.newTransformer();
        if (XSLTUtils.cortexPeripheralsEnabled() && bundledPeripherals != null && !bundledPeripherals.isEmpty()) {
            url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(RES_BASE + bundledPeripherals), null);
            URL fileURL = FileLocator.resolve((URL)FileLocator.toFileURL((URL)url));
            xformer.setParameter(BUNDLED_PERIPHERALS_PARAM, fileURL.getPath());
        }
        xformer.setErrorListener(new ErrorListener(){

            @Override
            public void warning(TransformerException exception) throws TransformerException {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", exception.getMessage(), (Throwable)exception));
            }

            @Override
            public void fatalError(TransformerException exception) throws TransformerException {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", exception.getMessage(), (Throwable)exception));
            }

            @Override
            public void error(TransformerException exception) throws TransformerException {
                if (Platform.inDebugMode()) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", exception.getMessage(), (Throwable)exception));
                }
            }
        });
        xformer.transform(source, result);
    }

    public static void xsltTranslate(Source source, Result result, URL url, URIResolver uriResolver, Properties params) throws FileNotFoundException, IOException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Templates template = factory.newTemplates(new StreamSource(new FileInputStream(FileLocator.toFileURL((URL)url).getPath())));
        Transformer xformer = template.newTransformer();
        xformer.setErrorListener(new ErrorListener(){

            @Override
            public void warning(TransformerException exception) throws TransformerException {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", exception.getMessage(), (Throwable)exception));
            }

            @Override
            public void fatalError(TransformerException exception) throws TransformerException {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", exception.getMessage(), (Throwable)exception));
            }

            @Override
            public void error(TransformerException exception) throws TransformerException {
                if (Platform.inDebugMode()) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.nxp.s32ds.cle.uct.core", exception.getMessage(), (Throwable)exception));
                }
            }
        });
        if (uriResolver != null) {
            xformer.setURIResolver(uriResolver);
        }
        if (params != null) {
            Enumeration<?> properties = params.propertyNames();
            while (properties.hasMoreElements()) {
                Object key = properties.nextElement();
                xformer.setParameter(key.toString(), params.getProperty(key.toString()));
            }
        }
        xformer.transform(source, result);
    }
}

