/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.providers;

import com.nxp.s32ds.cle.uct.core.Activator;
import com.nxp.s32ds.cle.uct.core.IPreferenceConstants;
import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.manifest.xml.FileType;
import com.nxp.s32ds.cle.uct.manifest.xml.IdentifiableType;
import com.nxp.s32ds.cle.uct.manifest.xml.SourceType;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.providers.SDKManifestProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SDKUIUtils {
    public static final int ID_DELETE = 0;
    public static final String LABEL_DELETE = ISDKManifest.COMPONENT_DELETE_POLICY.DELETE.value();
    public static final int ID_DEL_SKIP = 1;
    public static final String LABEL_DEL_SKIP = ISDKManifest.COMPONENT_DELETE_POLICY.SKIP.value();
    public static final int ID_DEL_COMPARE = 2;
    public static final String LABEL_DEL_COMPARE = ISDKManifest.COMPONENT_DELETE_POLICY.COMPARE.value();
    public static final int ID_OVERWRITE = 0;
    public static final String LABEL_OVERWRITE = ISDKManifest.COMPONENT_ADD_POLICY.OVERWRITE.value();
    public static final int ID_SKIP = 1;
    public static final String LABEL_SKIP = ISDKManifest.COMPONENT_ADD_POLICY.SKIP.value();
    public static final int ID_COMPARE = 2;
    public static final String LABEL_COMPARE = ISDKManifest.COMPONENT_ADD_POLICY.COMPARE.value();
    private static Color DEPENDENCY_COLOR = null;

    private static MessageDialogWithToggle buildDialog(Shell activeShell, String dialogTitle, String message, String toggleMessage, boolean toggleState, IPreferenceStore store, String key) {
        CompareDialogQuestion dialog = new CompareDialogQuestion(activeShell, dialogTitle, message, toggleMessage, toggleState, store, key, new String[]{LABEL_OVERWRITE, LABEL_SKIP, LABEL_COMPARE}, 2);
        dialog.open();
        return dialog;
    }

    private static MessageDialogWithToggle buildConfirmDialog(Shell activeShell, String dialogTitle, String message, String toggleMessage, boolean toggleState, IPreferenceStore store, String key, Map<ComponentType, List<SourceType>> map) {
        ConfirmDialog dialog = new ConfirmDialog(activeShell, dialogTitle, message, toggleMessage, toggleState, store, key, map);
        dialog.open();
        return dialog;
    }

    private static MessageDialogWithToggle buildDeleteDialog(Shell activeShell, String dialogTitle, String message, String toggleMessage, boolean toggleState, IPreferenceStore store, String key) {
        CompareDialogQuestion dialog = new CompareDialogQuestion(activeShell, dialogTitle, message, toggleMessage, toggleState, store, key, new String[]{LABEL_DELETE, LABEL_DEL_SKIP, LABEL_DEL_COMPARE}, 2);
        dialog.open();
        return dialog;
    }

    public static ISDKManifest.COMPONENT_ADD_POLICY openOverwritePrompt(final IFile file, boolean forceOverwrite) {
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        final boolean[] toggleState = new boolean[]{store.getBoolean("sdk.component.overwrite.ask")};
        if (forceOverwrite) {
            return ISDKManifest.COMPONENT_ADD_POLICY.OVERWRITE;
        }
        if (!toggleState[0]) {
            final int[] retCode = new int[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    String message = NLS.bind((String)Messages.SDKUIItils_FileExists, (Object)file.getProjectRelativePath().toPortableString());
                    MessageDialogWithToggle dialog = SDKUIUtils.buildDialog(Display.getCurrent().getActiveShell(), Messages.SDKProjectHandler_SDKCompManagement, message, IPreferenceConstants.L_SDK_COMP_POLICY_ASK, toggleState[0], store, "sdk.component.overwrite.ask");
                    retCode[0] = dialog.getReturnCode();
                    toggleState[0] = dialog.getToggleState();
                }
            });
            ISDKManifest.COMPONENT_ADD_POLICY policy = ISDKManifest.COMPONENT_ADD_POLICY.COMPARE;
            switch (retCode[0]) {
                case 0: {
                    policy = ISDKManifest.COMPONENT_ADD_POLICY.OVERWRITE;
                    break;
                }
                case 1: {
                    policy = ISDKManifest.COMPONENT_ADD_POLICY.SKIP;
                    break;
                }
                case 2: {
                    policy = ISDKManifest.COMPONENT_ADD_POLICY.COMPARE;
                    break;
                }
            }
            if (toggleState[0]) {
                store.setValue("sdk.component.overwrite.ask", true);
                if (policy != null) {
                    store.setValue("sdk.component.overwrite.policy", policy.value());
                }
            }
            return policy;
        }
        return ISDKManifest.COMPONENT_ADD_POLICY.fromValue(store.getString("sdk.component.overwrite.policy"));
    }

    public static ISDKManifest.COMPONENT_DELETE_POLICY openDeletePrompt(final IFile file) {
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        final boolean[] toggleState = new boolean[]{store.getBoolean("sdk.component.delete.ask")};
        if (!toggleState[0]) {
            final int[] retCode = new int[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    String message = NLS.bind((String)Messages.SDKManifest_DifferentFiles, (Object)file.getProjectRelativePath().toPortableString());
                    MessageDialogWithToggle dialog = SDKUIUtils.buildDeleteDialog(Display.getCurrent().getActiveShell(), Messages.SDKProjectHandler_SDKCompManagement, message, IPreferenceConstants.L_SDK_COMP_DEL_POLICY_ASK, toggleState[0], store, "sdk.component.delete.ask");
                    retCode[0] = dialog.getReturnCode();
                    toggleState[0] = dialog.getToggleState();
                }
            });
            ISDKManifest.COMPONENT_DELETE_POLICY policy = ISDKManifest.COMPONENT_DELETE_POLICY.COMPARE;
            switch (retCode[0]) {
                case 0: {
                    policy = ISDKManifest.COMPONENT_DELETE_POLICY.DELETE;
                    break;
                }
                case 1: {
                    policy = ISDKManifest.COMPONENT_DELETE_POLICY.SKIP;
                    break;
                }
                case 2: {
                    policy = ISDKManifest.COMPONENT_DELETE_POLICY.COMPARE;
                    break;
                }
            }
            if (toggleState[0]) {
                store.setValue("sdk.component.delete.ask", true);
                if (policy != null) {
                    store.setValue("sdk.component.delete.policy", policy.value());
                }
            }
            return policy;
        }
        return ISDKManifest.COMPONENT_DELETE_POLICY.fromValue(store.getString("sdk.component.delete.policy"));
    }

    public static boolean openConfirmPrompt(final String message, final Map<ComponentType, List<SourceType>> map) {
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        final boolean[] toggleState = new boolean[]{store.getBoolean("sdk.component.confirm")};
        if (!toggleState[0]) {
            final int[] retCode = new int[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle dialog = SDKUIUtils.buildConfirmDialog(Display.getCurrent().getActiveShell(), Messages.SDKUIUtils_ManifestLoc, message, IPreferenceConstants.L_SDK_COMP_CONFIRM, toggleState[0], store, "sdk.component.confirm", map);
                    retCode[0] = dialog.getReturnCode();
                    toggleState[0] = dialog.getToggleState();
                }
            });
            if (toggleState[0]) {
                store.setValue("sdk.component.confirm", true);
            }
            return retCode[0] == 2;
        }
        return store.getBoolean("sdk.component.confirm");
    }

    public static class CompareDialogQuestion
    extends MessageDialogWithToggle {
        public CompareDialogQuestion(Shell parentShell, String dialogTitle, String message, String toggleMessage, boolean toggleState, IPreferenceStore store, String key, String[] labels, int defSelection) {
            super(parentShell, dialogTitle, null, message, 6, labels, defSelection, toggleMessage, toggleState);
            int style = 0;
            this.setShellStyle(this.getShellStyle() | style);
            this.setPrefStore(store);
            this.setPrefKey(key);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            String[] labels = this.getButtonLabels();
            Button[] btns = new Button[labels.length];
            int defIndex = this.getDefaultButtonIndex();
            int suggestedId = 256;
            int i = 0;
            while (i < labels.length) {
                Button button;
                String label = labels[i];
                int id = this.mapButtonLabelToButtonID(label, suggestedId);
                if (id == suggestedId) {
                    ++suggestedId;
                }
                btns[i] = button = this.createButton(parent, id, label, defIndex == i);
                ++i;
            }
            this.setButtons(btns);
        }

        private int mapButtonLabelToButtonID(String buttonLabel, int defaultId) {
            if (LABEL_DELETE.equals(buttonLabel)) {
                return 0;
            }
            if (LABEL_OVERWRITE.equals(buttonLabel)) {
                return 0;
            }
            if (LABEL_SKIP.equals(buttonLabel)) {
                return 1;
            }
            if (LABEL_COMPARE.equals(buttonLabel)) {
                return 2;
            }
            return defaultId;
        }
    }

    public static class ConfirmDialog
    extends MessageDialogWithToggle {
        private static final int DIALOG_DEFAULT_HEIGHT = 400;
        private Map<ComponentType, List<SourceType>> map;

        public ConfirmDialog(Shell parentShell, String dialogTitle, String message, String toggleMessage, boolean toggleState, IPreferenceStore store, String key, Map<ComponentType, List<SourceType>> map) {
            super(parentShell, dialogTitle, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, toggleMessage, toggleState);
            int style = 0;
            this.setShellStyle(this.getShellStyle() | style);
            this.setPrefStore(store);
            this.setPrefKey(key);
            this.map = map;
        }

        private boolean isDependency(Object element) {
            if (this.map != null) {
                if (element instanceof ComponentType) {
                    return this.isComponentDependency((ComponentType)element);
                }
                if (element instanceof SourceType) {
                    return this.isSourceDependency((SourceType)element);
                }
                if (element instanceof FileType) {
                    return this.isFileDependency((FileType)element);
                }
            }
            return false;
        }

        private boolean isFileDependency(FileType element) {
            Set<ComponentType> keys = this.map.keySet();
            for (ComponentType key : keys) {
                List<SourceType> list = this.map.get(key);
                for (SourceType source : list) {
                    if (!source.getFiles().contains(element)) continue;
                    return this.isComponentDependency(key);
                }
            }
            return false;
        }

        private boolean isSourceDependency(SourceType element) {
            Set<ComponentType> keys = this.map.keySet();
            for (ComponentType key : keys) {
                List<SourceType> list = this.map.get(key);
                if (!list.contains(element)) continue;
                return this.isComponentDependency(key);
            }
            return false;
        }

        private boolean isComponentDependency(ComponentType element) {
            Set<ComponentType> components = this.map.keySet();
            for (ComponentType component : components) {
                if (!component.getDependency().contains(element)) continue;
                return true;
            }
            return false;
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createCustomArea(Composite parent) {
            String[] properties = new String[]{"Component source", "Project Path(s)", "Info"};
            int[] widths = new int[]{60, 20, 15};
            Composite composite = new Composite(parent, 0);
            TreeColumnLayout treeLayout = new TreeColumnLayout();
            composite.setLayout((Layout)treeLayout);
            GridData layout = new GridData(4, 4, true, true);
            layout.minimumHeight = 400;
            layout.heightHint = 400;
            composite.setLayoutData((Object)layout);
            TreeViewer detailsViewer = new TreeViewer(composite, 768);
            detailsViewer.setContentProvider((IContentProvider)new TreeDetailsContentProvider());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)detailsViewer, (int)2);
            Tree tree = detailsViewer.getTree();
            tree.setHeaderVisible(true);
            tree.setLayout((Layout)new FillLayout());
            tree.setLayoutData((Object)new GridData(4, 4, true, true));
            detailsViewer.setColumnProperties(properties);
            int i = 0;
            while (i < properties.length) {
                String columnProperty = properties[i];
                TreeViewerColumn tvc = new TreeViewerColumn(detailsViewer, 0);
                tvc.setLabelProvider((CellLabelProvider)new SDKLabelProvider(i));
                TreeColumn column = tvc.getColumn();
                column.setText(columnProperty);
                column.setResizable(true);
                column.setMoveable(false);
                treeLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(widths[i], true));
                ++i;
            }
            detailsViewer.setInput(this.map);
            detailsViewer.expandAll();
            return composite;
        }

        private class SDKLabelProvider
        extends StyledCellLabelProvider {
            private final Activator activator = Activator.getDefault();
            private final Image IMG_COMPONENT = this.activator.getImage("img.view.sdk.component");
            private final Image IMG_MASK = this.activator.getImage("img.examples.mask");
            private int column;

            public SDKLabelProvider(int column) {
                this.column = column;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof ComponentType && columnIndex == 0) {
                    return this.IMG_COMPONENT;
                }
                if (element instanceof SourceType && columnIndex == 0) {
                    return this.IMG_MASK;
                }
                if (element instanceof FileType && columnIndex == 0) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                Object item;
                if (element instanceof SourceType) {
                    item = (SourceType)element;
                    switch (columnIndex) {
                        case 0: {
                            return ((SourceType)item).getPath();
                        }
                        case 1: {
                            return ((SourceType)item).getTargetPath();
                        }
                        case 2: {
                            return ((SourceType)item).getType().toString();
                        }
                    }
                } else if (element instanceof FileType) {
                    item = (FileType)element;
                    switch (columnIndex) {
                        case 0: {
                            return ((FileType)item).getMask();
                        }
                    }
                }
                if (element instanceof IdentifiableType) {
                    item = (IdentifiableType)element;
                    switch (columnIndex) {
                        case 0: {
                            return ((IdentifiableType)item).getName();
                        }
                        case 1: {
                            if (item instanceof ComponentType) {
                                return SDKManifestProvider.adaptFolders((ComponentType)item);
                            }
                            return null;
                        }
                        case 2: {
                            return ((IdentifiableType)item).getVersion();
                        }
                    }
                }
                return null;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                String text = this.getColumnText(element, this.column);
                Image image = this.getColumnImage(element, this.column);
                cell.setStyleRanges(null);
                if (text != null) {
                    cell.setText(text);
                }
                if (image != null) {
                    cell.setImage(image);
                }
                if (ConfirmDialog.this.isDependency(element) && text != null) {
                    Font italicFont;
                    ArrayList<StyleRange> styleRange = new ArrayList<StyleRange>();
                    if (DEPENDENCY_COLOR == null) {
                        DEPENDENCY_COLOR = Display.getDefault().getSystemColor(15);
                    }
                    StyleRange myStyledRange = new StyleRange(0, text.length(), DEPENDENCY_COLOR, null);
                    FontDescriptor italicDescriptor = FontDescriptor.createFrom((FontData[])cell.getFont().getFontData()).setStyle(2);
                    myStyledRange.font = italicFont = italicDescriptor.createFont((Device)Display.getCurrent());
                    styleRange.add(myStyledRange);
                    cell.setStyleRanges(styleRange.toArray(new StyleRange[styleRange.size()]));
                }
            }
        }

        private class TreeDetailsContentProvider
        implements ITreeContentProvider {
            private Map<ComponentType, List<SourceType>> map;

            private TreeDetailsContentProvider() {
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                Assert.isTrue((boolean)(inputElement instanceof Map));
                this.map = (Map)inputElement;
                ArrayList<ComponentType> children = new ArrayList<ComponentType>();
                Set<ComponentType> keys = this.map.keySet();
                for (ComponentType key : keys) {
                    List<SourceType> value = this.map.get(key);
                    if (value.isEmpty()) continue;
                    children.add(key);
                }
                return children.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                ArrayList<Object> children = new ArrayList<Object>();
                this.getChildren(parentElement, children);
                return children.toArray();
            }

            public boolean hasChildren(Object element) {
                ArrayList<Object> children = new ArrayList<Object>();
                this.getChildren(element, children);
                return !children.isEmpty();
            }

            private void getChildren(Object element, List<Object> children) {
                if (element instanceof ComponentType) {
                    List<SourceType> sources = this.map.get(element);
                    children.addAll(sources);
                } else if (element instanceof SourceType) {
                    SourceType entry = (SourceType)element;
                    children.addAll(entry.getFiles());
                }
            }
        }
    }
}

