/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.providers;

import com.nxp.s32ds.cle.uct.core.Activator;
import com.nxp.s32ds.cle.uct.core.IPreferenceConstants;
import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.s32ds.cle.uct.exceptions.ISDKListener;
import com.nxp.s32ds.cle.uct.exceptions.SDKErrorListener;
import com.nxp.s32ds.cle.uct.exceptions.SDKException;
import com.nxp.s32ds.cle.uct.manifest.xml.BoardType;
import com.nxp.s32ds.cle.uct.manifest.xml.BuildConfigurationType;
import com.nxp.s32ds.cle.uct.manifest.xml.CompilerEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CompilerType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentTypeEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CoreEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.CoreType;
import com.nxp.s32ds.cle.uct.manifest.xml.DebugConfigurationType;
import com.nxp.s32ds.cle.uct.manifest.xml.DefineType;
import com.nxp.s32ds.cle.uct.manifest.xml.DeviceType;
import com.nxp.s32ds.cle.uct.manifest.xml.ExampleType;
import com.nxp.s32ds.cle.uct.manifest.xml.ExamplesType;
import com.nxp.s32ds.cle.uct.manifest.xml.FileType;
import com.nxp.s32ds.cle.uct.manifest.xml.IdentifiableType;
import com.nxp.s32ds.cle.uct.manifest.xml.IncludeType;
import com.nxp.s32ds.cle.uct.manifest.xml.Manifest;
import com.nxp.s32ds.cle.uct.manifest.xml.MetadataType;
import com.nxp.s32ds.cle.uct.manifest.xml.MethodTypeEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.OptionType;
import com.nxp.s32ds.cle.uct.manifest.xml.OptionTypeEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.PackageType;
import com.nxp.s32ds.cle.uct.manifest.xml.RoleType;
import com.nxp.s32ds.cle.uct.manifest.xml.SourceType;
import com.nxp.s32ds.cle.uct.manifest.xml.SourceTypeEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainEnum;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainSettingRefType;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainSettingType;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainSettingsType;
import com.nxp.s32ds.cle.uct.manifest.xml.ToolchainType;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.providers.InstallLocationComparator;
import com.nxp.s32ds.cle.uct.providers.OptionValueHolder;
import com.nxp.s32ds.cle.uct.providers.ProjectParameters;
import com.nxp.s32ds.cle.uct.providers.SDKManifest;
import com.nxp.s32ds.cle.uct.providers.SDKManifestFactory;
import com.nxp.s32ds.cle.uct.providers.SDKManifestFilter;
import com.nxp.s32ds.cle.uct.providers.SDKSoftwareProvider;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ACExclusionFilterEntry;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.xml.sax.SAXException;

public class SDKManifestProvider {
    public static final String BUILD_REGEX = "\\[Build\\s*(.*?)\\]";
    public static final String DEFAULT_BOARD_FOLDER = "board";
    private static final String SDK_BUILDER_NATURE = "com.nxp.s32ds.addons.sdkbuilder.sdkProjectNature";
    public static final String PROJECT_PART_SUPPORT_FOLDER = "part-support";
    public static final String TEMP_FOLDER = "temp";
    public static final String KEY_PRODUCT_BUILD = "product.build";
    public static final String KEY_PRODUCT_VERSION = "product.version";
    public static final String KEY_PRODUCT_NAME = "product.name";
    private static final String QUOTE = "\"";
    private static final String LIB_REGEX = "^lib(.*)\\.a$";
    public static final String $_PROJ_NAME;
    public static final String WORKSPACE_LOC_END = "}";
    public static final String WORKSPACE_LOC = "${workspace_loc:/${ProjName}";
    public static final String OPTION_GNU_CPP_LIB = "gnu.cpp.link.option.libs";
    public static final String OPTION_GNU_C_LIB = "gnu.c.link.option.libs";
    public static final String OPTION_GNU_CPP_LIBPATH = "gnu.cpp.link.option.paths";
    public static final String OPTION_GNU_C_LIBPATH = "gnu.c.link.option.paths";
    public static final String[] DEFAULT_GNU_C_LINK_OTHER;
    public static final String[] DEFAULT_GNU_CPP_LINK_OTHER;
    public static final String OPTION_GNU_CPP_LINK_OTHER = "gnu.cpp.link.option.other";
    public static final String OPTION_GNU_C_LINK_OTHER = "gnu.c.link.option.other";
    public static final String OPTION_GNU_CPP_USEROBJ = "gnu.cpp.link.option.userobjs";
    public static final String OPTION_GNU_C_USEROBJ = "gnu.c.link.option.userobjs";
    public static final String OPTION_CPP_LINK_MNG = "com.crt.advproject.link.cpp.manage";
    public static final String OPTION_C_LINK_MNG = "com.crt.advproject.link.manage";
    public static final String OPTION_CPP_LINK_SCRIPT = "com.crt.advproject.link.cpp.script";
    public static final String OPTION_C_LINK_SCRIPT = "com.crt.advproject.link.script";
    public static final String OPTION_CPP_LINK_SCRIPT_DIR = "com.crt.advproject.link.cpp.scriptdir";
    public static final String OPTION_C_LINK_SCRIPT_DIR = "com.crt.advproject.link.scriptdir";
    public static final String OPTION_DEFINE_CPP = "gnu.cpp.compiler.option.preprocessor.def";
    public static final String OPTION_DEFINE_C = "gnu.c.compiler.option.preprocessor.def.symbols";
    public static final String OPTION_MISC_C = "gnu.c.compiler.option.misc.other";
    public static final String OPTION_MISC_CPP = "gnu.cpp.compiler.option.misc.other";
    public static final String SYMBOL_USE_CMSIS = "__USE_CMSIS";
    public static final String SYMBOL_ITM_REDIRECT = "SDK_DEBUGCONSOLE_ITM";
    public static final String SYMBOL_UART_REDIRECT = "SDK_DEBUGCONSOLE_UART";
    public static final String SYMBOL_CR_INTEGER_PRINTF = "CR_INTEGER_PRINTF";
    public static final String SYMBOL_FLOAT_PRINTF = "PRINTF_FLOAT_ENABLE";
    public static final String SYMBOL_FLOAT_SCANF = "SCANF_FLOAT_ENABLE";
    public static final String SYMBOL_CR_PRINTF_CHAR = "CR_PRINTF_CHAR";
    public static final String SYMBOL_SDK_DEBUGCONSOLE = "SDK_DEBUGCONSOLE";
    public static final String SYMBOL_NDEBUG = "NDEBUG";
    public static final String SYMBOL_DEBUG = "DEBUG";
    public static final String BOARDS_FOLDER = "boards";
    public static final String FOLDER_SRC = "/src";
    public static final String FOLDER_DOC = "/doc";
    public static final String FOLDER_BOARD = "board";
    public static final String FOLDER_LIB = "/libs";
    public static final String SEPARATOR = ";";
    public static final String ELEM_DEVICE_CORE = "core";
    public static final String ELEM_DEVICE_CORE_ROLE = "role";
    public static final String ELEM_MANIFEST_NAME = "sdkName";
    public static final String ELEM_PACKAGE_NAME = "package";
    public static final String ELEM_MANIFEST_SDK_VERSION = "sdkVersion";
    public static final String ELEM_SDK_EXAMPLE = "sdkExample";
    public static final String ELEM_PROJECT_COMPONENTS = "sdkComponents";
    public static final String ELEM_PROJECT_BOARD = "boardId";
    public static final String SDK_STORAGE_ID = "com.nxp.s32ds.cle.uct";
    public static final QualifiedName PROP_RESET;
    public static final QualifiedName MANIFEST_NAME_PROPERTY;
    public static final String MARKER_TARGET_CONFIG_ERROR = "target.config.error";
    private Semaphore semaphore = new Semaphore(2, true);
    private static List<SDKManifestProvider> instances;
    private static String README_TXT;
    private static Map<ISDKManifest, String> messages;
    private static String cachedPaths;
    private static List<SDKManifestProvider> cachedInstance;
    private static List<SDKManifestProvider> internal;
    private File location;
    private static final Map<String, List<ISDKManifest>> manifestsDB;
    private final Map<String, ISDKManifest> packs = new HashMap<String, ISDKManifest>();
    private final List<ISDKManifest> obsolete = new ArrayList<ISDKManifest>();
    private final List<ISDKListener> errorListeners = new ArrayList<ISDKListener>();
    private final List<ISDKListener> listeners = new ArrayList<ISDKListener>();
    private static boolean projectRefreshEnabled;
    public static final int FOLDER_COMP_NAME = 0;
    public static boolean forceFilesOverwrite;
    private static boolean addedListener;
    private static Job refreshProjectsJob;
    private SDKProviderType providerType = SDKProviderType.PROVIDER_NORMAL;
    public static final Map<String, String> MANIFEST_BUILD_DEBUG_MAP;
    protected static final Logger LOGGER;
    static final IResourceChangeListener listener;
    public static List<IOption> supportedOptions;
    public static final int SKIP_HDRLIB = 1;
    public static final String[] SKIP_HDRLIB_VALUES;
    public static final String[] SKIP_OPTIONS;

    static {
        IProjectType[] projectsTypes;
        $_PROJ_NAME = CdtVariableResolver.createVariableReference((String)"ProjName");
        DEFAULT_GNU_C_LINK_OTHER = new String[]{"-Map=\"${BuildArtifactFileBaseName}.map\"", "--gc-sections", "-print-memory-usage", "--sort-section=alignment"};
        DEFAULT_GNU_CPP_LINK_OTHER = DEFAULT_GNU_C_LINK_OTHER;
        PROP_RESET = new QualifiedName("com.nxp.s32ds", "project.reset");
        MANIFEST_NAME_PROPERTY = new QualifiedName("com.nxp.s32ds", "project.manifest");
        README_TXT = Messages.SDKManifestProvider_14;
        messages = new HashMap<ISDKManifest, String>();
        internal = new ArrayList<SDKManifestProvider>();
        manifestsDB = new HashMap<String, List<ISDKManifest>>();
        projectRefreshEnabled = true;
        forceFilesOverwrite = false;
        addedListener = false;
        MANIFEST_BUILD_DEBUG_MAP = new HashMap<String, String>();
        LOGGER = LogManager.getLogger(SDKManifestProvider.class);
        listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResource res = event.getResource();
                if (res == null) {
                    return;
                }
                switch (event.getType()) {
                    case 1: {
                        IProject project = res.getProject();
                        IFolder folder = project.getFolder(SDKManifestProvider.PROJECT_PART_SUPPORT_FOLDER);
                        if (!folder.exists() || !folder.getProjectRelativePath().isPrefixOf(res.getProjectRelativePath())) break;
                        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                        store.firePropertyChangeEvent("sdk.paths.pref", null, (Object)store.getString("sdk.paths.pref"));
                        break;
                    }
                    case 2: 
                    case 4: {
                        IProject project = res.getProject();
                        IFolder folder = project.getFolder(SDKManifestProvider.PROJECT_PART_SUPPORT_FOLDER);
                        try {
                            if (!folder.exists()) break;
                            SDKManifestProvider.remSDKManifestProvider(folder.getLocation().toPortableString());
                            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                            store.firePropertyChangeEvent("sdk.paths.pref", null, (Object)store.getString("sdk.paths.pref"));
                            break;
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
            }
        };
        supportedOptions = new ArrayList<IOption>();
        SKIP_HDRLIB_VALUES = new String[]{".none", ".nohost", ".semihost", ".nohost.nf", ".semihost.nf"};
        SKIP_OPTIONS = new String[]{".specs", ".hdrlib", ".arch", ".thumb", ".fpu", OPTION_C_LINK_MNG, OPTION_C_LINK_SCRIPT, OPTION_CPP_LINK_MNG, OPTION_CPP_LINK_SCRIPT};
        IProjectType[] iProjectTypeArray = projectsTypes = ManagedBuildManager.getDefinedProjectTypes();
        int n = projectsTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectType type = iProjectTypeArray[n2];
            if (type.getId().equals("com.crt.advproject.projecttype.exe")) {
                IConfiguration[] iConfigurationArray = type.getConfigurations();
                int n3 = iConfigurationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfiguration conf = iConfigurationArray[n4];
                    IToolChain toolchain = conf.getToolChain();
                    ITool[] iToolArray = toolchain.getTools();
                    int n5 = iToolArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ITool tool = iToolArray[n6];
                        IOption[] iOptionArray = tool.getOptions();
                        int n7 = iOptionArray.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            IOption opt = iOptionArray[n8];
                            supportedOptions.add(opt);
                            ++n8;
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public SDKProviderType getProviderType() {
        return this.providerType;
    }

    public void setProviderType(SDKProviderType providerType) {
        this.providerType = providerType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SDKManifestProvider) {
            return this.location.equals(((SDKManifestProvider)obj).getLocation());
        }
        return super.equals(obj);
    }

    public static SDKManifestProvider addSDKManifestProvider(String location, SDKProviderType type) throws IOException {
        File file = new File(location);
        if (!file.exists() && !file.isDirectory()) {
            String message = NLS.bind((String)Messages.SDKManifestProvider_16, (Object)location);
            throw new IOException(message);
        }
        for (SDKManifestProvider i : internal) {
            if (!i.getLocation().equals(file)) continue;
            return i;
        }
        SDKManifestProvider provider = new SDKManifestProvider(location);
        provider.setProviderType(type);
        internal.add(provider);
        SDKManifestProvider.getInstance().remove(provider);
        if (!addedListener) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 7);
            addedListener = true;
        }
        return provider;
    }

    public static void remSDKManifestProvider(String location) throws IOException {
        File file = new File(location);
        if (!file.exists() && !file.isDirectory()) {
            String message = NLS.bind((String)Messages.SDKManifestProvider_16, (Object)location);
            throw new IOException(message);
        }
        SDKManifestProvider toRemove = null;
        for (SDKManifestProvider provider : internal) {
            if (!location.replace("\\", "/").equalsIgnoreCase(provider.getLocation().getAbsolutePath().replace("\\", "/"))) continue;
            toRemove = provider;
        }
        if (toRemove != null) {
            internal.remove(toRemove);
            if (cachedInstance != null) {
                cachedInstance.remove(toRemove);
            }
            if (instances != null) {
                instances.remove(toRemove);
            }
        }
    }

    public SDKManifestProvider(String location) throws IOException {
        MANIFEST_BUILD_DEBUG_MAP.put("com.nxp.s32ds.ide.build_config.debug", "com.nxp.s32ds.cle.arm.mbs.arm32.bare.exe.debug");
        MANIFEST_BUILD_DEBUG_MAP.put("com.nxp.s32ds.ide.build_config.release", "com.nxp.s32ds.cle.arm.mbs.arm32.bare.exe.release");
        SDKManifestProvider.updateDefaultInstallPath();
        File file = new File(location);
        if (file.exists() && file.isDirectory()) {
            this.location = file;
        } else if (!file.exists() && file.isDirectory()) {
            file.mkdir();
        } else {
            String message = NLS.bind((String)Messages.SDKManifestProvider_16, (Object)location);
            throw new IOException(message);
        }
        if (SDKManifestProvider.getInstance() == null) {
            SDKManifestProvider.setInstances(new ArrayList<SDKManifestProvider>());
        }
        SDKManifestProvider.getInstance().add(this);
        if (SDKManifestProvider.updateDefaultInstallPath() != null && location.equals(new File(SDKManifestProvider.getDefaultPath()).getAbsolutePath())) {
            this.providerType = SDKProviderType.PROVIDER_DEFAULT;
        }
    }

    public static String updateDefaultInstallPath() {
        String paths;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        File file = new File(SDKManifestProvider.getDefaultPath());
        String path = file.getAbsolutePath();
        if (!file.exists()) {
            String basePath = String.valueOf(System.getProperty("user.home")) + File.separator + ToolchainEnum.DSGCC.value();
            SDKManifestProvider.addPreviousVersion(store, basePath);
            file.mkdirs();
        }
        if (!(paths = store.getString("sdk.paths.pref")).toLowerCase().contains(path.toLowerCase())) {
            store.setValue("sdk.paths.pref", String.valueOf(paths) + File.pathSeparator + path);
        }
        return SDKManifestProvider.getDefaultPath();
    }

    public static void addPreviousVersion(IPreferenceStore store, String basePath) {
        String paths;
        final ArrayList folders = new ArrayList();
        if (new File(basePath).exists()) {
            try {
                Files.walkFileTree(Paths.get(basePath, new String[0]), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                        String name = dir.getFileName().toString();
                        if (name.matches("([0-9][0-9])?")) {
                            folders.add(name);
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        Collections.sort(folders, new InstallLocationComparator());
        String sdkPackages = String.valueOf(basePath) + File.separator + IPreferenceConstants.V_PATH;
        if (!folders.isEmpty() && !basePath.endsWith((String)folders.get(folders.size() - 1))) {
            sdkPackages = String.valueOf(basePath) + File.separator + (String)folders.get(folders.size() - 1);
        }
        if (new File(sdkPackages).exists() && new File(sdkPackages).listFiles().length > 0 && !(paths = store.getString("sdk.paths.pref")).toLowerCase().contains(sdkPackages.toLowerCase())) {
            store.setValue("sdk.paths.pref", String.valueOf(sdkPackages) + File.pathSeparator + paths);
        }
    }

    public boolean isDefaultProvider() {
        return this.providerType == SDKProviderType.PROVIDER_DEFAULT;
    }

    public boolean isMCUXpressoProvider() {
        String basePath = String.valueOf(System.getProperty("user.home")) + File.separator + ToolchainEnum.MCUXPRESSO.value();
        boolean isLegacyProvider = this.getLocation().toString().contains(basePath);
        return this.isDefaultProvider() || isLegacyProvider;
    }

    private static synchronized void setInstances(List<SDKManifestProvider> instances) {
        SDKManifestProvider.instances = instances;
    }

    public void acquire() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void release() {
        this.semaphore.release();
    }

    public static synchronized List<SDKManifestProvider> getInstance() {
        if (instances == null) {
            internal.clear();
            SDKManifestProvider.updateDefaultInstallPath();
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String paths = store.getString("sdk.paths.pref");
            if (!paths.equals(cachedPaths)) {
                IProject[] projects;
                String[] entries;
                SDKManifestProvider.setInstances(new ArrayList<SDKManifestProvider>());
                String[] stringArray = entries = paths.split(File.pathSeparator);
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    String entry = stringArray[n2];
                    try {
                        if (entry.length() != 0) {
                            new SDKManifestProvider(entry);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                    ++n2;
                }
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject[] iProjectArray = projects = root.getProjects();
                int n3 = projects.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject project = iProjectArray[n4];
                    if (project.isOpen() && project.isAccessible()) {
                        String location;
                        IFolder folder = project.getFolder(PROJECT_PART_SUPPORT_FOLDER);
                        if (folder.exists()) {
                            location = folder.getLocation().toPortableString();
                            try {
                                SDKManifestProvider.addSDKManifestProvider(location, SDKProviderType.PROVIDER_PROJECT);
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        try {
                            if (project.hasNature(SDK_BUILDER_NATURE)) {
                                location = project.getLocation().toOSString();
                                SDKManifestProvider.addSDKManifestProvider(location, SDKProviderType.PROVIDER_INTERNAL);
                            }
                        }
                        catch (IOException | CoreException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    ++n4;
                }
                cachedPaths = paths;
                instances.addAll(internal);
                cachedInstance = instances;
            } else {
                SDKManifestProvider.setInstances(cachedInstance);
            }
        }
        return instances;
    }

    public static void clearCache() {
        cachedPaths = null;
        cachedInstance = null;
    }

    public File getLocation() {
        return this.location;
    }

    public IPath getRepoPath() {
        return new Path(this.location.getAbsolutePath());
    }

    public static Map<ISDKManifest, String> getMessages() {
        return messages;
    }

    public static void clearMessages() {
        messages.clear();
    }

    public void refresh() throws IOException, SAXException, JAXBException, SDKException {
        final SDKException ex = new SDKException();
        this.acquire();
        java.nio.file.Path directory = Paths.get(this.location.getPath(), new String[0]);
        File mainDir = directory.toFile();
        if (mainDir.exists() && SDKManifestProvider.containsPackDesc(mainDir)) {
            try {
                this.addToMap(mainDir);
            }
            catch (SDKException | JAXBException | SAXException e) {
                try {
                    ex.addWrongManifest(new SDKManifest(mainDir.getAbsolutePath(), this));
                    ex.getExList().add((Exception)e);
                }
                catch (SDKException | SAXException exception) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        if (mainDir.exists()) {
            try {
                Files.walkFileTree(directory, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                        File dirFile = dir.toFile();
                        if (dirFile.exists() && SDKManifestProvider.containsPackDesc(dirFile)) {
                            try {
                                SDKManifestProvider.this.addToMap(dirFile);
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            catch (SDKException | JAXBException | SAXException e) {
                                try {
                                    ex.addWrongManifest(new SDKManifest(dirFile.getAbsolutePath(), SDKManifestProvider.this));
                                    ex.getExList().add((Exception)e);
                                }
                                catch (SDKException | SAXException e1) {
                                    LOGGER.log(Level.SEVERE, e1.getMessage(), e1);
                                }
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                        }
                        if (!dirFile.exists()) {
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                        File item = file.toFile();
                        if (item.exists() && item.getName().endsWith(".zip")) {
                            if (SDKManifestProvider.containsPackDesc(item)) {
                                try {
                                    SDKManifestProvider.this.addToMap(item);
                                }
                                catch (SDKException | JAXBException | SAXException e) {
                                    try {
                                        ex.addWrongManifest(new SDKManifest(item.getAbsolutePath(), SDKManifestProvider.this));
                                        ex.getExList().add((Exception)e);
                                    }
                                    catch (SDKException | SAXException exception) {
                                        LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                                    }
                                }
                            } else {
                                String message = NLS.bind((String)Messages.SDKManifestProvider_4, (Object)item);
                                SDKException e = new SDKException(message);
                                try {
                                    e.addWrongManifest(new SDKManifest(item.getAbsolutePath(), SDKManifestProvider.this));
                                    ex.getExList().add(e);
                                }
                                catch (SDKException | SAXException exception) {
                                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                                }
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (!ex.getExList().isEmpty()) {
            this.release();
            SDKManifestProvider.refreshProjects();
            this.fireListeners();
            throw ex;
        }
        this.release();
        SDKManifestProvider.refreshProjects();
        this.fireListeners();
    }

    private void fireListeners() {
        for (ISDKListener listener : this.listeners) {
            listener.handle(null);
        }
    }

    public static void enableProjectRefresh(boolean enabled) {
        projectRefreshEnabled = enabled;
    }

    public static void refreshProjects() {
        if (!projectRefreshEnabled) {
            return;
        }
        if (refreshProjectsJob != null) {
            refreshProjectsJob.cancel();
            refreshProjectsJob = null;
        }
        if (refreshProjectsJob == null) {
            refreshProjectsJob = new Job(Messages.SDKStartupImport_5){

                protected IStatus run(IProgressMonitor monitor) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IProject[] projects = root.getProjects();
                    monitor.beginTask(Messages.SDKStartupImport_6, projects.length);
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block13: {
                            IMarker marker;
                            IProject project = iProjectArray[n2];
                            monitor.setTaskName(String.valueOf(Messages.SDKStartupImport_8) + project.getName());
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            try {
                                if (!project.isAccessible()) break block13;
                                try {
                                    IMarker[] markers;
                                    IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.core.resources.problemmarker", false, 1);
                                    int n3 = markers.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        marker = iMarkerArray[n4];
                                        if (monitor.isCanceled()) {
                                            return Status.CANCEL_STATUS;
                                        }
                                        if (marker.getAttribute(SDKManifestProvider.MARKER_TARGET_CONFIG_ERROR) != null) {
                                            marker.delete();
                                        }
                                        ++n4;
                                    }
                                }
                                catch (Exception e1) {
                                    LOGGER.log(Level.SEVERE, e1.getMessage(), e1);
                                }
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                            }
                            catch (Exception e) {
                                if (SDKManifestProvider.alreadyReported(project)) break block13;
                                try {
                                    marker = project.createMarker("org.eclipse.core.resources.problemmarker");
                                    if (marker != null) {
                                        marker.setAttribute(SDKManifestProvider.MARKER_TARGET_CONFIG_ERROR, true);
                                        marker.setAttribute("message", (Object)e.getMessage());
                                        marker.setAttribute("priority", 2);
                                        marker.setAttribute("severity", 2);
                                    }
                                }
                                catch (CoreException coreException) {}
                                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        ++n2;
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            refreshProjectsJob.setUser(false);
            refreshProjectsJob.setSystem(false);
        }
        refreshProjectsJob.schedule();
    }

    public List<ISDKManifest> getObsolete() {
        return this.obsolete;
    }

    protected static boolean alreadyReported(IProject project) {
        boolean reported = false;
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.core.resources.problemmarker", false, 1);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                if (marker.getAttribute(MARKER_TARGET_CONFIG_ERROR) != null) {
                    reported = true;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return reported;
    }

    private void addToMap(File item) throws IOException, SAXException, JAXBException, SDKException {
        String path = item.getAbsolutePath();
        try {
            ISDKManifest manifest = this.addDatabase(item, path);
            if (manifest != null && item.exists() && !this.packs.containsKey(path)) {
                if (manifest.getInstance() != null) {
                    Manifest.Toolchains toolchains = manifest.getInstance().getToolchains();
                    if (!SDKManifestProvider.isToolchainSupported(toolchains.getToolchain())) {
                        String message = NLS.bind((String)Messages.SDKManifestProvider_1, (Object)manifest.getManifestSimpleName());
                        SDKException ex = new SDKException(message);
                        if (manifest != null) {
                            ex.addWrongManifest(manifest);
                        }
                        throw ex;
                    }
                    Manifest.Compilers compilers = manifest.getInstance().getCompilers();
                    if (!SDKManifestProvider.isCompilerSupported(compilers.getCompiler())) {
                        String message = NLS.bind((String)Messages.SDKManifestProvider_2, (Object)manifest.getManifestSimpleName());
                        SDKException ex = new SDKException(message);
                        if (manifest != null) {
                            ex.addWrongManifest(manifest);
                        }
                        throw ex;
                    }
                    if (Activator.getDefault().getPreferenceStore().getBoolean("sdk.manifests.versions.enabled")) {
                        if (this.isSelectedSDK(manifest)) {
                            this.packs.put(path, manifest);
                        } else if (!this.hasUserSelection(manifest) && !this.packs.containsKey(path) && SDKManifestProvider.checkVersion(manifest, this.obsolete)) {
                            this.packs.put(path, manifest);
                        }
                    } else if (SDKManifestProvider.checkVersion(manifest, this.obsolete) && !this.packs.containsKey(path)) {
                        this.packs.put(path, manifest);
                    }
                } else if (!this.packs.containsKey(path)) {
                    this.packs.put(path, manifest);
                }
            }
        }
        catch (IOException | JAXBException e) {
            throw new SDKException(String.valueOf(path) + Messages.SDKManifestProvider_0, e);
        }
    }

    private ISDKManifest addDatabase(File item, String path) throws IOException, SAXException, JAXBException, SDKException {
        ISDKManifest manifest = SDKManifestFactory.getInstance().createPackage(path, this);
        String id = manifest.getManifestSimpleName();
        List<ISDKManifest> list = null;
        if (manifest.getInstance() != null) {
            Manifest.Compilers compilers = manifest.getInstance().getCompilers();
            Manifest.Toolchains toolchains = manifest.getInstance().getToolchains();
            if (SDKManifestProvider.isToolchainSupported(toolchains.getToolchain()) && SDKManifestProvider.isCompilerSupported(compilers.getCompiler())) {
                if (manifestsDB.containsKey(id)) {
                    list = manifestsDB.get(id);
                } else {
                    list = new ArrayList<ISDKManifest>();
                    manifestsDB.put(id, list);
                }
            }
        }
        if (list != null && !list.contains(manifest) && SDKManifestProvider.checkDBVersion(manifest, list)) {
            list.add(manifest);
        }
        return manifest;
    }

    public static boolean checkDBVersion(ISDKManifest manifest, List<ISDKManifest> list) {
        Version version = manifest.getVersion();
        String name = manifest.getManifestSimpleName();
        for (ISDKManifest m : list) {
            Version v1;
            String n1 = m.getManifestSimpleName();
            if (m.equals(manifest) || !name.equals(n1) || version.compareTo(v1 = m.getVersion()) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean checkVersion(ISDKManifest manifest, List<ISDKManifest> obsolete) {
        Version version = manifest.getVersion();
        String name = manifest.getManifestSimpleName();
        for (SDKManifestProvider instance : instances) {
            for (ISDKManifest m : instance.getManifests()) {
                String n1 = m.getManifestSimpleName();
                if (m.equals(manifest) || !name.equals(n1)) continue;
                Version v1 = m.getVersion();
                if (SDKProviderType.PROVIDER_PROJECT.equals((Object)m.getProvider().getProviderType()) || SDKProviderType.PROVIDER_PROJECT.equals((Object)manifest.getProvider().getProviderType())) {
                    ISDKManifest toRemove = null;
                    ISDKManifest toSave = null;
                    if (SDKProviderType.PROVIDER_PROJECT.equals((Object)m.getProvider().getProviderType())) {
                        toRemove = m;
                        toSave = manifest;
                    } else {
                        toRemove = manifest;
                        toSave = m;
                    }
                    String message = NLS.bind((String)"The project specific SDK ''{0}'' has been skipped, since there is an already installed matching SDK ''{1}''.", (Object[])new Object[]{toRemove.getManifestName(), toSave.getManifestSimpleName()});
                    SDKManifestProvider.addMessage(message, null);
                    if (toRemove.equals(m)) {
                        SDKManifestProvider.removeManifest(toRemove, v1);
                    }
                    return !toRemove.equals(manifest);
                }
                if (version.compareTo(v1) > 0) {
                    String message = NLS.bind((String)Messages.SDKManifestProvider_18, (Object[])new Object[]{name, version});
                    SDKManifestProvider.addMessage(message, m);
                    SDKManifestProvider.removeManifest(m, v1);
                    obsolete.add(m);
                    return true;
                }
                if (version.compareTo(v1) < 0) {
                    String message = NLS.bind((String)Messages.SDKManifestProvider_21, (Object[])new Object[]{n1, version, v1});
                    SDKManifestProvider.addMessage(message, manifest);
                    obsolete.add(manifest);
                    return false;
                }
                if (version.compareTo(v1) != 0) continue;
                String message = NLS.bind((String)Messages.SDKManifestProvider_24, (Object[])new Object[]{name, version, m.isZip() ? "zip" : Messages.SDKManifestProvider_10});
                SDKManifestProvider.addMessage(message, manifest);
                obsolete.add(manifest);
                return false;
            }
        }
        return true;
    }

    private static void addMessage(String message, ISDKManifest data) {
        messages.put(data, message);
    }

    private static void removeManifest(ISDKManifest manifest, Version version) {
        String name = manifest.getManifestSimpleName();
        ArrayList<ISDKManifest> toRemove = new ArrayList<ISDKManifest>();
        for (SDKManifestProvider instance : instances) {
            for (ISDKManifest m : instance.getManifests()) {
                Version v1;
                String n1 = m.getManifestSimpleName();
                if (!name.equals(n1) || version.compareTo(v1 = m.getVersion()) > 0) continue;
                toRemove.add(m);
            }
        }
        for (SDKManifestProvider instance : instances) {
            instance.getManifests().removeAll(toRemove);
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean containsPackDesc(File item) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Collection<ISDKManifest> getManifests() {
        return this.packs.values();
    }

    public ISDKManifest getManifest(String manifestName) {
        for (ISDKManifest pack : this.getManifests()) {
            if (!pack.isActive() || !pack.getManifestSimpleName().equals(manifestName)) continue;
            return pack;
        }
        return null;
    }

    public RoleType getExampleRole(ISDKManifest pack, ExampleType example) {
        RoleType role = null;
        if (!example.getSlaveRole().isEmpty()) {
            RoleType ref = example.getSlaveRole().get(0);
            if (ref instanceof Manifest.ExternalDefinitions.Definition) {
                RoleType refRole = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)ref), RoleType.class);
                if (refRole != null) {
                    role = refRole;
                }
            } else if (ref instanceof RoleType) {
                role = ref;
            }
        }
        return role;
    }

    public CoreType getExampleCore(ISDKManifest pack, ExampleType example, DeviceType device) {
        CoreType core = device.getCore().get(0);
        if (!example.getDeviceCore().isEmpty()) {
            CoreType ref = example.getDeviceCore().get(0);
            if (ref instanceof Manifest.ExternalDefinitions.Definition) {
                CoreType refCore = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)ref), CoreType.class);
                if (refCore != null) {
                    core = refCore;
                }
            } else if (ref instanceof CoreType) {
                core = ref;
            }
        }
        return core;
    }

    public static void adaptCMSIS(ISDKManifest pack, List<ComponentType> components, DeviceType device, CoreType core) {
        List<ComponentType> list = pack.getComponents(ComponentTypeEnum.CMSIS_INCLUDE, device);
        if (list != null && !list.isEmpty()) {
            for (ComponentType cmsisComponent : list) {
                if (!SDKManifestProvider.isCoreSupported(cmsisComponent.getDeviceCores(), core, null)) continue;
                components.add(cmsisComponent);
            }
        } else {
            for (ComponentType c : pack.getComponents(ComponentTypeEnum.CMSIS, device)) {
                if (!c.getId().equals("CMSIS_Include") || components.contains(c)) continue;
                components.add(c);
                break;
            }
        }
    }

    public static ExampleType useExternalExample(ISDKManifest pack, DeviceType device, BoardType board, ExampleType example) throws SDKException, IOException, Exception, JAXBException, SAXException, FileNotFoundException {
        ISDKManifest boardManifest;
        List<ToolchainType> manifestToolchain = example.getToolchain();
        if (!pack.getBoards().contains(board) && (boardManifest = SDKSoftwareProvider.getBoardManifest(board)) != null) {
            pack = boardManifest;
        }
        if (pack.getDataCache().containsKey(example)) {
            return (ExampleType)pack.getDataCache().get(example);
        }
        boolean found = false;
        SDKManifestFilter filter = new SDKManifestFilter(device, board != null ? board.getPackage().getName() : null, null);
        SourceType external = example.getExternal();
        String path = external.getPath();
        List<FileType> sourceFiles = external.getFiles();
        for (FileType file : sourceFiles) {
            ArrayList<String> files = new ArrayList<String>();
            String mask = file.getMask();
            String osPath = String.valueOf(pack.getManifestName()) + File.separator;
            String basePath = filter.basePath(path);
            File folder = new File(String.valueOf(osPath) + basePath);
            pack.scan(files, folder, filter, filter.adapt(path, mask));
            if (!files.isEmpty()) {
                InputStream stream;
                Unmarshaller um;
                String result;
                block8: {
                    result = (String)files.get(0);
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ExamplesType.class});
                    um = jc.createUnmarshaller();
                    stream = null;
                    try {
                        stream = pack.getResourceStream(result, false);
                    }
                    catch (Exception exception) {
                        if (new File(result).exists()) break block8;
                        String message = NLS.bind((String)Messages.SDKManifestProvider_12, (Object)example.getName(), (Object)result);
                        throw new Exception(message);
                    }
                }
                SDKManifest.validateSchema(new ArrayList<Status>(), um, null, null);
                JAXBElement root = um.unmarshal((Source)new StreamSource(stream), ExamplesType.class);
                ExamplesType examples = (ExamplesType)root.getValue();
                for (ExampleType e : examples.getExample()) {
                    if (!e.getId().equals(example.getId())) continue;
                    found = true;
                    pack.getDataCache().put(example, e);
                    example = e;
                    SDKManifestProvider.setMetadata(example, "internal.base.path", pack.getManifestName());
                    SDKManifestProvider.setMetadata(example, "internal.example.path", path);
                    break;
                }
                if (found) continue;
                String message = NLS.bind((String)Messages.SDKManifestProvider_13, (Object[])new Object[]{example.getName(), result});
                throw new Exception(message);
            }
            String message = NLS.bind((String)Messages.SDKManifestProvider_15, (Object)example.getName());
            throw new Exception(message);
        }
        if (example != null) {
            example.getToolchain().clear();
            example.getToolchain().addAll(manifestToolchain);
        }
        return example;
    }

    private static void addDefaultOption(Map<String, OptionValueHolder> options, String key, String value) {
        OptionValueHolder holder;
        if (options.containsKey(key)) {
            holder = options.get(key);
        } else {
            holder = new OptionValueHolder();
            options.put(key, holder);
        }
        Set<String> values = holder.getValues("com.nxp.s32ds.default.config");
        ArrayList<String> newValues = new ArrayList<String>();
        newValues.add(value);
        SDKManifestProvider.merge(values, newValues);
    }

    private static void removeDefaultOption(Map<String, OptionValueHolder> options, String key, String value) {
        OptionValueHolder holder;
        if (options.containsKey(key)) {
            holder = options.get(key);
        } else {
            holder = new OptionValueHolder();
            options.put(key, holder);
        }
        String toRemove = "";
        Set<String> values = holder.getValues("com.nxp.s32ds.default.config");
        for (String v : values) {
            if (!v.startsWith(value)) continue;
            toRemove = v;
            break;
        }
        values.remove(toRemove);
    }

    public void addDependency(ISDKManifest pack, DeviceType device, CoreType core, String role, String name, Map<ComponentType, List<SourceType>> sources, List<ComponentType> dependencies, List<ComponentType> cBuffer, boolean isExample, boolean addDependencies, ProjectParameters projectParameters) throws Exception {
        if (dependencies != null) {
            for (ComponentType dep : dependencies) {
                ArrayList<CoreType> listCompCores = new ArrayList<CoreType>();
                List<CoreType> cores = dep.getDeviceCores();
                List<Object> items = new ArrayList();
                if (isExample && dep.getType().equals((Object)ComponentTypeEnum.PROJECT_TEMPLATE) && !this.missingBoardComponent(dep, projectParameters) || dep.getType().equals((Object)ComponentTypeEnum.CMSIS) && !dep.getId().equals("CMSIS_Include") && !dep.getId().equals("platform.Include_common")) continue;
                SDKManifestProvider.buildCoresList(pack, listCompCores, cores);
                if (!SDKManifestProvider.isCoreSupported(listCompCores, core, role)) {
                    String message = NLS.bind((String)Messages.SDKManifestProvider_23, (Object[])new Object[]{dep.getName(), core.getType().value(), role != null ? " ('" + role + "')" : ""});
                    LOGGER.log(Level.WARNING, message);
                    continue;
                }
                if (cBuffer.contains(dep)) continue;
                cBuffer.add(dep);
                items.clear();
                if (sources.containsKey(dep)) {
                    items = sources.get(dep);
                }
                if (SDKManifestProvider.isDeviceSupported(dep, device)) {
                    for (SourceType source : dep.getSource()) {
                        ArrayList<CompilerType> listCompilers = new ArrayList<CompilerType>();
                        ArrayList<CoreType> listCores = new ArrayList<CoreType>();
                        List<CompilerType> compilers = source.getCompiler();
                        cores = source.getDeviceCores();
                        SDKManifestProvider.buildCoresList(pack, listCores, cores);
                        for (CompilerType compilerObj : compilers) {
                            CompilerType compiler = null;
                            if (compilerObj instanceof CompilerType) {
                                compiler = compilerObj;
                            } else if (compilerObj instanceof Manifest.ExternalDefinitions.Definition && (compiler = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)compilerObj), CompilerType.class)) == null) {
                                compiler = new CompilerType();
                                compiler.setType(CompilerEnum.IAR);
                            }
                            if (compiler == null) continue;
                            listCompilers.add(compiler);
                        }
                        List<ToolchainType> toolchains = source.getToolchain();
                        if (!toolchains.isEmpty() && toolchains.get(0) instanceof Manifest.ExternalDefinitions.Definition) {
                            ArrayList<ToolchainType> list = new ArrayList<ToolchainType>();
                            for (ToolchainType def : toolchains) {
                                ToolchainType toolchain = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)def), ToolchainType.class);
                                if (toolchain == null) continue;
                                list.add(toolchain);
                            }
                            toolchains = list;
                        } else if (!toolchains.isEmpty() && !(toolchains.get(0) instanceof ToolchainType)) {
                            toolchains = new ArrayList<ToolchainType>();
                        }
                        if (!SDKManifestProvider.isToolchainSupported(toolchains) || !SDKManifestProvider.isCompilerSupported(listCompilers) || !SDKManifestProvider.isCoreSupported(listCores, core, role)) continue;
                        items.add(source);
                    }
                }
                sources.put(dep, items);
                if (!addDependencies) continue;
                this.addDependency(pack, device, core, role, dep.getName(), sources, dep.getDependency(), cBuffer, isExample, addDependencies, projectParameters);
            }
        }
    }

    private boolean missingBoardComponent(ComponentType dep, ProjectParameters projectParameters) {
        if (projectParameters != null) {
            ComponentType boardComponent;
            BoardType board = projectParameters.getBoard();
            ISDKManifest manifest = projectParameters.getPack();
            if (board != null && projectParameters.getExample() != null && (boardComponent = manifest.getBoardComponent(board.getId(), projectParameters.getDevice())) != null && dep.getId().equals(boardComponent.getId())) {
                boolean missing = true;
                for (SourceType exampleSource : projectParameters.getExample().getSource()) {
                    if (!"board".equals(exampleSource.getTargetPath())) continue;
                    missing = false;
                    break;
                }
                return missing;
            }
        }
        return false;
    }

    public static void buildCoresList(ISDKManifest pack, List<CoreType> listCores, List<CoreType> cores) {
        for (CoreType coreObj : cores) {
            CoreType coreItem = null;
            if (coreObj instanceof CoreType) {
                coreItem = coreObj;
            } else if (coreObj instanceof Manifest.ExternalDefinitions.Definition && (coreItem = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)coreObj), CoreType.class)) == null) {
                coreItem = new CoreType();
            }
            if (coreItem == null) continue;
            listCores.add(coreItem);
        }
    }

    private String getMetadata(IdentifiableType identifiable, String key) {
        List<MetadataType> entries;
        IdentifiableType.MetadataSet set = identifiable.getMetadataSet();
        if (set != null && (entries = set.getMetadata()) != null) {
            for (MetadataType entry : entries) {
                if (!entry.getKey().equals(key)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public static void fillOptions(ProjectParameters projectParameters) {
        ToolchainSettingType parent;
        List<ToolchainSettingType> refs;
        Map<String, OptionValueHolder> options = projectParameters.getOptions();
        DeviceType.ToolchainSettings deviceToolchainSettings = projectParameters.getDevice().getToolchainSettings();
        BoardType.ToolchainSettings boardToolchainSettings = projectParameters.getBoard() != null ? projectParameters.getBoard().getToolchainSettings() : null;
        ExampleType.ToolchainSettings exampleToolchainSettings = projectParameters.getExample() != null ? projectParameters.getExample().getToolchainSettings() : null;
        ToolchainSettingsType toolchainSettings = projectParameters.getPack().getInstance().getToolchainSettings();
        ISDKManifest pack = projectParameters.getPack();
        boolean isCpp = "org.eclipse.cdt.core.ccnature".equals(projectParameters.getNature());
        if (toolchainSettings.getToolchainSetting() != null) {
            if (!toolchainSettings.getToolchainSetting().isEmpty()) {
                for (ToolchainSettingType toolchain : toolchainSettings.getToolchainSetting()) {
                    if (!SDKManifestProvider.isToolchainSupported(toolchain.getToolchain()) || !SDKManifestProvider.isCompilerSupported(toolchain.getCompiler())) continue;
                    SDKManifestProvider.buildOption(options, toolchain.getOption(), projectParameters.getNature());
                }
            } else if (toolchainSettings.getExternal() != null) {
                for (ToolchainSettingType toolchain : pack.handleExternal(toolchainSettings.getExternal(), ToolchainSettingType.class)) {
                    if (!SDKManifestProvider.isToolchainSupported(toolchain.getToolchain()) || !SDKManifestProvider.isCompilerSupported(toolchain.getCompiler())) continue;
                    SDKManifestProvider.buildOption(options, toolchain.getOption(), projectParameters.getNature());
                }
            }
        }
        IdentifiableType.Defines defines = projectParameters.getPack().getInstance().getDefines();
        SDKManifestProvider.addDefines(options, isCpp, defines);
        if (deviceToolchainSettings != null && deviceToolchainSettings.getToolchainSetting() != null) {
            for (ToolchainSettingRefType toolchain : deviceToolchainSettings.getToolchainSetting()) {
                refs = SDKManifestProvider.retrieveReferences(pack, toolchain);
                for (ToolchainSettingType ref : refs) {
                    Assert.isTrue((boolean)(ref instanceof ToolchainSettingType));
                    parent = ref;
                    if (!SDKManifestProvider.isToolchainSupported(parent.getToolchain()) || !SDKManifestProvider.isCompilerSupported(parent.getCompiler())) continue;
                    SDKManifestProvider.buildOption(options, toolchain.getOption(), projectParameters.getNature());
                }
            }
        }
        defines = projectParameters.getDevice().getDefines();
        SDKManifestProvider.addDefines(options, isCpp, defines);
        defines = projectParameters.getPkg().getDefines();
        SDKManifestProvider.addDefines(options, isCpp, defines);
        defines = projectParameters.getCore().getDefines();
        SDKManifestProvider.addDefines(options, isCpp, defines);
        if (boardToolchainSettings != null && boardToolchainSettings.getToolchainSetting() != null) {
            for (ToolchainSettingRefType toolchain : boardToolchainSettings.getToolchainSetting()) {
                refs = SDKManifestProvider.retrieveReferences(pack, toolchain);
                for (ToolchainSettingType ref : refs) {
                    Assert.isTrue((boolean)(ref instanceof ToolchainSettingType));
                    parent = ref;
                    if (!SDKManifestProvider.isToolchainSupported(parent.getToolchain()) || !SDKManifestProvider.isCompilerSupported(parent.getCompiler())) continue;
                    SDKManifestProvider.buildOption(options, toolchain.getOption(), projectParameters.getNature());
                }
            }
        }
        if (projectParameters.getBoard() != null) {
            defines = projectParameters.getBoard().getDefines();
            SDKManifestProvider.addDefines(options, isCpp, defines);
        }
        if (projectParameters.getComponents() != null) {
            for (ComponentType component : projectParameters.getComponents()) {
                defines = component.getDefines();
                SDKManifestProvider.addDefines(options, isCpp, defines);
            }
        }
        if (projectParameters.getEnabledComponents() != null) {
            for (ComponentType component : projectParameters.getEnabledComponents()) {
                defines = component.getDefines();
                SDKManifestProvider.addDefines(options, isCpp, defines);
            }
        }
        if (exampleToolchainSettings != null && exampleToolchainSettings.getToolchainSetting() != null) {
            for (ToolchainSettingRefType toolchain : exampleToolchainSettings.getToolchainSetting()) {
                refs = SDKManifestProvider.retrieveReferences(pack, toolchain);
                for (ToolchainSettingType ref : refs) {
                    Assert.isTrue((boolean)(ref instanceof ToolchainSettingType));
                    parent = ref;
                    if (!SDKManifestProvider.isToolchainSupported(parent.getToolchain()) || !SDKManifestProvider.isCompilerSupported(parent.getCompiler())) continue;
                    SDKManifestProvider.buildOption(options, toolchain.getOption(), projectParameters.getNature());
                }
            }
        }
        if (projectParameters.getExample() != null) {
            defines = projectParameters.getExample().getDefines();
            SDKManifestProvider.addDefines(options, isCpp, defines);
        }
    }

    public static void addDefines(Map<String, OptionValueHolder> options, boolean isCpp, IdentifiableType.Defines defines) {
        if (defines != null && defines.getDefine() != null) {
            for (DefineType define : defines.getDefine()) {
                SDKManifestProvider.addDefine(options, isCpp, define);
            }
        }
    }

    public static void buildOption(Map<String, OptionValueHolder> options, List<OptionType> list, String nature) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean enableOptionsCheck = store.getBoolean("sdk.options.check");
        for (OptionType option : list) {
            OptionValueHolder holder;
            if (!SDKManifestProvider.isSupportedOption(option, list, nature) && enableOptionsCheck) continue;
            if (options.containsKey(option.getId())) {
                holder = options.get(option.getId());
            } else {
                holder = new OptionValueHolder();
                options.put(option.getId(), holder);
            }
            for (String configId : SDKManifestProvider.getConfigIds(option.getBuildConfigs())) {
                Set<String> values = null;
                values = holder.getConfigs().contains(configId) ? holder.getValues(configId) : holder.addConfig(configId);
                if (!option.getType().equals((Object)OptionTypeEnum.STRING_LIST)) {
                    values.clear();
                    values.addAll(option.getValue());
                    continue;
                }
                SDKManifestProvider.merge(values, option.getValue());
            }
        }
    }

    private static List<String> getConfigIds(List<Object> configs) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object config : configs) {
            Manifest.ExternalDefinitions.Definition definition;
            if (config instanceof Manifest.ExternalDefinitions.Definition) {
                definition = (Manifest.ExternalDefinitions.Definition)config;
                list.add(SDKManifestProvider.mapDefault(definition.getExtID()));
                continue;
            }
            if (config instanceof Manifest.ExternalDefinitions.Definition) {
                definition = (Manifest.ExternalDefinitions.Definition)config;
                list.add(SDKManifestProvider.mapDefault(definition.getExtID()));
                continue;
            }
            if (config instanceof BuildConfigurationType) {
                BuildConfigurationType buildConfig = (BuildConfigurationType)config;
                list.add(SDKManifestProvider.mapDefault(buildConfig.getId()));
                continue;
            }
            if (config instanceof DebugConfigurationType) {
                DebugConfigurationType debugConfig = (DebugConfigurationType)config;
                list.add(SDKManifestProvider.mapDefault(debugConfig.getId()));
                continue;
            }
            LOGGER.log(Level.SEVERE, "Unable to find build configuration reference for " + config);
        }
        if (list.isEmpty()) {
            list.add("com.nxp.s32ds.default.config");
        }
        return list;
    }

    private static String mapDefault(String id) {
        if (MANIFEST_BUILD_DEBUG_MAP.containsKey(id)) {
            return MANIFEST_BUILD_DEBUG_MAP.get(id);
        }
        return id;
    }

    public static void merge(Set<String> values, Collection<String> newValues) {
        HashSet<String> toRemove = new HashSet<String>();
        for (String newValue : newValues) {
            if (values.contains(newValue)) continue;
            if (newValue.contains("=")) {
                String itemToRemove = SDKManifestProvider.findItem(newValue, values);
                if (itemToRemove != null) {
                    toRemove.add(itemToRemove);
                }
                values.add(newValue);
                continue;
            }
            values.add(newValue);
        }
        values.removeAll(toRemove);
    }

    private static String findItem(String newValue, Set<String> values) {
        String[] tokens = newValue.split("=");
        if (tokens.length == 2) {
            for (String oldValue : values) {
                String[] oldTokens = oldValue.split("=");
                if (oldTokens.length != 2 || !oldTokens[0].equals(tokens[0]) || oldTokens[1].equals(tokens[1])) continue;
                return oldValue;
            }
        }
        return null;
    }

    private static boolean isSupportedOption(OptionType option, List<OptionType> list, String nature) {
        String optType;
        String reqType;
        String message;
        boolean defaultValue;
        boolean valid;
        boolean supported;
        block35: {
            supported = false;
            valid = false;
            defaultValue = false;
            message = "";
            reqType = "";
            optType = "";
            try {
                for (Object opt : supportedOptions) {
                    if (option.getId().equals(opt.getBaseId())) {
                        supported = true;
                        optType = option.getType().toString();
                        switch (opt.getValueType()) {
                            case 0: {
                                reqType = OptionTypeEnum.BOOLEAN.toString();
                                break;
                            }
                            case 2: {
                                reqType = OptionTypeEnum.STRING.toString();
                                break;
                            }
                            case -5: 
                            case 3: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 9: {
                                reqType = OptionTypeEnum.STRING_LIST.toString();
                                break;
                            }
                            case 1: {
                                reqType = OptionTypeEnum.ENUM.toString();
                                break;
                            }
                        }
                    }
                    if (!supported) continue;
                    block7 : switch (opt.getValueType()) {
                        case 0: {
                            if (option.getType().equals((Object)OptionTypeEnum.BOOLEAN)) {
                                if (opt.getDefaultValue() != null && option.getValue().contains(opt.getDefaultValue().toString())) {
                                    defaultValue = true;
                                }
                                valid = true;
                                break;
                            }
                            break block35;
                        }
                        case 2: {
                            if (option.getType().equals((Object)OptionTypeEnum.STRING)) {
                                if (opt.getDefaultValue() != null && option.getValue().contains(opt.getDefaultValue().toString())) {
                                    defaultValue = true;
                                }
                                valid = true;
                                break;
                            }
                            break block35;
                        }
                        case -5: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 9: {
                            if (option.getType().equals((Object)OptionTypeEnum.STRING_LIST)) {
                                valid = true;
                                break;
                            }
                            break block35;
                        }
                        case 1: {
                            if (!option.getType().equals((Object)OptionTypeEnum.ENUM)) break block35;
                            valid = true;
                            if (opt.getDefaultValue() != null && option.getValue().contains(opt.getDefaultValue().toString())) {
                                defaultValue = true;
                            }
                            for (String val : option.getValue()) {
                                if (message.isEmpty()) {
                                    ArrayList<String> ids = new ArrayList<String>();
                                    String[] stringArray = opt.getApplicableValues();
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String optVal = stringArray[n2];
                                        if (val.equals(optVal)) {
                                            ids.clear();
                                            break;
                                        }
                                        ids.add(opt.getEnumeratedId(optVal));
                                        ++n2;
                                    }
                                    if (ids.isEmpty() || ids.contains(val)) continue;
                                    message = String.valueOf(Messages.SDKManifestProvider_44) + val + Messages.SDKManifestProvider_45 + ids;
                                    valid = false;
                                    break block7;
                                }
                                break block35;
                            }
                            break block35;
                        }
                    }
                    break;
                }
            }
            catch (BuildException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (!supported) {
            SDKManifestProvider.err(String.valueOf(Messages.SDKManifestProvider_46) + option.getId() + Messages.SDKManifestProvider_47);
        } else if (!valid) {
            message = String.valueOf(message) + Messages.SDKManifestProvider_48 + optType + Messages.SDKManifestProvider_49 + reqType;
            SDKManifestProvider.err(String.valueOf(Messages.SDKManifestProvider_50) + option.getId() + Messages.SDKManifestProvider_51 + message);
        }
        if (defaultValue) {
            SDKManifestProvider.warning(String.valueOf(Messages.SDKManifestProvider_52) + option.getId() + Messages.SDKManifestProvider_53);
        }
        if (supported && valid) {
            String[] stringArray = SKIP_OPTIONS;
            int n = SKIP_OPTIONS.length;
            int n3 = 0;
            while (n3 < n) {
                Object opt;
                opt = stringArray[n3];
                if (option.getId().equals(opt) || option.getId().endsWith((String)opt)) {
                    List<String> complete = SDKManifestProvider.isOptionComplete((String)opt, list, nature);
                    if (!complete.isEmpty()) {
                        SDKManifestProvider.err(String.valueOf(Messages.SDKManifestProvider_56) + option.getId() + Messages.SDKManifestProvider_57 + complete);
                        return false;
                    }
                    List<String> aligned = SDKManifestProvider.isOptionAligned(option, (String)opt, list, nature);
                    if (!aligned.isEmpty()) {
                        SDKManifestProvider.err(String.valueOf(Messages.SDKManifestProvider_58) + option.getId() + Messages.SDKManifestProvider_59 + aligned);
                        return false;
                    }
                }
                ++n3;
            }
        }
        return supported && valid;
    }

    private static void err(String message) {
        if (Platform.inDevelopmentMode()) {
            LOGGER.log(Level.SEVERE, message);
        }
    }

    private static void warning(String message) {
        Platform.inDevelopmentMode();
    }

    public static List<String> isOptionAligned(OptionType option, String optStr, List<OptionType> list, String nature) {
        boolean isCpp = !"org.eclipse.cdt.core.cnature".equals(nature);
        ArrayList<IOption> complete = new ArrayList<IOption>();
        block5: for (IOption opt : supportedOptions) {
            if (!opt.getBaseId().equals(optStr) && !opt.getBaseId().endsWith(optStr)) continue;
            ITool tool = (ITool)opt.getOptionHolder();
            switch (tool.getNatureFilter()) {
                case 0: {
                    if (isCpp || complete.contains(opt)) continue block5;
                    complete.add(opt);
                    break;
                }
                case 1: {
                    if (!isCpp || complete.contains(opt)) continue block5;
                    complete.add(opt);
                    break;
                }
                case 2: {
                    if (complete.contains(opt)) break;
                    complete.add(opt);
                    break;
                }
            }
        }
        List<String> values = option.getValue();
        boolean isComplete = true;
        if (values != null && !values.isEmpty()) {
            String value = values.get(0);
            if (value.contains(".")) {
                value = SDKManifestProvider.adaptHdrLibCheckOption(optStr, value);
                String token = value.substring(value.lastIndexOf(46));
                for (OptionType item : list) {
                    List<String> itemValues = item.getValue();
                    if (item.equals(option) || !item.getId().endsWith(optStr)) continue;
                    if (itemValues != null && !itemValues.isEmpty()) {
                        String itemValue = itemValues.get(0);
                        if ((itemValue = SDKManifestProvider.adaptHdrLibCheckOption(optStr, itemValue)).endsWith(token)) continue;
                        isComplete = false;
                    } else {
                        isComplete = false;
                    }
                    break;
                }
            } else {
                isComplete = false;
            }
        } else {
            isComplete = false;
        }
        ArrayList<String> related = new ArrayList<String>();
        if (!isComplete) {
            for (IOption item : complete) {
                if (item.getBaseId().equals(option.getId())) continue;
                related.add(item.getBaseId());
            }
        }
        return related;
    }

    private static String adaptHdrLibCheckOption(String optStr, String value) {
        if (optStr.equals(SKIP_OPTIONS[1])) {
            String[] stringArray = SKIP_HDRLIB_VALUES;
            int n = SKIP_HDRLIB_VALUES.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (value.endsWith(item)) {
                    value = value.replace(item, "");
                }
                ++n2;
            }
        }
        return value;
    }

    public static List<String> isOptionComplete(String optStr, List<OptionType> list, String nature) {
        boolean isCpp = !"org.eclipse.cdt.core.cnature".equals(nature);
        ArrayList<String> complete = new ArrayList<String>();
        block5: for (IOption opt : supportedOptions) {
            if (!opt.getBaseId().equals(optStr) && !opt.getBaseId().endsWith(optStr)) continue;
            ITool tool = (ITool)opt.getOptionHolder();
            switch (tool.getNatureFilter()) {
                case 0: {
                    if (isCpp || complete.contains(opt.getBaseId())) continue block5;
                    complete.add(opt.getBaseId());
                    break;
                }
                case 1: {
                    if (!isCpp || complete.contains(opt.getBaseId())) continue block5;
                    complete.add(opt.getBaseId());
                    break;
                }
                case 2: {
                    if (complete.contains(opt.getBaseId())) break;
                    complete.add(opt.getBaseId());
                    break;
                }
            }
        }
        for (OptionType item : list) {
            complete.remove(item.getId());
        }
        return complete;
    }

    public static List<ToolchainSettingType> retrieveReferences(ISDKManifest manifest, ToolchainSettingRefType toolchain) {
        ArrayList<ToolchainSettingType> settings = new ArrayList<ToolchainSettingType>();
        for (Object ref : toolchain.getIdRefs()) {
            if (ref instanceof ToolchainSettingType) {
                settings.add((ToolchainSettingType)ref);
                continue;
            }
            if (!(ref instanceof Manifest.ExternalDefinitions.Definition)) continue;
            Manifest.ExternalDefinitions.Definition definition = (Manifest.ExternalDefinitions.Definition)ref;
            ToolchainSettingsType manifestSettings = manifest.getInstance().getToolchainSettings();
            for (ToolchainSettingType manifestSetting : manifestSettings.getToolchainSetting()) {
                if (!SDKManifestProvider.isToolchainSupported(manifestSetting.getToolchain()) || !SDKManifestProvider.isCompilerSupported(manifestSetting.getCompiler()) || !manifestSetting.getId().equals(definition.getExtID())) continue;
                settings.add(manifestSetting);
            }
        }
        return settings;
    }

    public static boolean isCompilerSupported(CompilerType compiler) {
        if (compiler == null) {
            return true;
        }
        CompilerEnum type = compiler.getType();
        if (type == null) {
            return true;
        }
        return type.equals((Object)CompilerEnum.GCC);
    }

    public static boolean isCoreSupported(CoreType core, CoreType selectedCore, String role) {
        if (core == null || selectedCore == null) {
            return true;
        }
        CoreEnum type = core.getType();
        if (type == null) {
            return false;
        }
        if (role == null) {
            return type.equals((Object)selectedCore.getType()) && core.getId().equals(selectedCore.getId());
        }
        for (RoleType slaveRole : selectedCore.getSlaveRoles()) {
            if (!type.equals((Object)selectedCore.getType()) || !core.getId().equals(selectedCore.getId()) || !slaveRole.getId().equals(role)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeviceSupported(ComponentType component, DeviceType device) {
        if (device == null) {
            return true;
        }
        if (component == null) {
            return true;
        }
        if (component.getDevices().isEmpty()) {
            return true;
        }
        for (DeviceType d : component.getDevices()) {
            if (!d.getId().equals(device.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolchainSupported(ToolchainType toolchain) {
        if (toolchain == null) {
            return true;
        }
        ToolchainEnum type = toolchain.getType();
        return ToolchainEnum.DSGCC.equals((Object)type);
    }

    public static boolean isToolchainSupported(List<ToolchainType> toolchains) {
        if (toolchains.isEmpty()) {
            return true;
        }
        for (ToolchainType toolchain : toolchains) {
            if (!SDKManifestProvider.isToolchainSupported(toolchain)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompilerSupported(List<CompilerType> compilers) {
        if (compilers.isEmpty()) {
            return true;
        }
        for (CompilerType compiler : compilers) {
            if (!SDKManifestProvider.isCompilerSupported(compiler)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCoreSupported(List<CoreType> cores, CoreType selectedCore, String role) {
        if (cores.isEmpty()) {
            return true;
        }
        for (CoreType core : cores) {
            if (!SDKManifestProvider.isCoreSupported(core, selectedCore, role)) continue;
            return true;
        }
        return false;
    }

    public CIncludePathEntry createIncludeEntry(String entry, String projectName, IncludeType include, ComponentType component, List<ICSettingEntry> entries) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        try {
            if (include != null && include.isRelative() && !component.getName().equals(projectName)) {
                if (!component.getType().equals((Object)ComponentTypeEnum.SCR) || component.getType().equals((Object)ComponentTypeEnum.SCR)) {
                    entry = component.getTargetPath() != null ? String.valueOf(component.getTargetPath()) + "/" + entry.replace(projectName, "") : String.valueOf(SDKManifestProvider.adaptFolders(component)) + "/" + entry.replace(projectName, "");
                    this.generateFolders((IContainer)project, entry.replace(projectName, ""));
                }
            } else {
                IFolder folder = this.generateFolders((IContainer)project, entry.replace(projectName, ""));
                if (entries != null && folder != null) {
                    this.addSourceEntry(entries, (IContainer)folder);
                }
            }
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        if (entry.contains(projectName)) {
            entry = entry.replace(projectName, $_PROJ_NAME);
            return CDataUtil.createCIncludePathEntry((String)entry, (int)9);
        }
        return CDataUtil.createCIncludePathEntry((String)entry, (int)17);
    }

    void handleIncludeEntries(List<ICSettingEntry> entries, ISDKManifest pack, List<String> files, String base) {
        Iterator<String> iterator = files.iterator();
        block2: while (iterator.hasNext()) {
            int endIndex;
            String file;
            String path = file = iterator.next();
            while ((endIndex = path.lastIndexOf(File.separator)) != -1 && !(path = path.substring(0, endIndex)).equals(base) && !(String.valueOf(path) + File.separator).equals(base)) {
                try {
                    String variable;
                    if (path.contains(base)) {
                        variable = pack.getVariableName(false);
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IPathVariableManager pathMan = workspace.getPathVariableManager();
                        URI uri = pathMan.convertToRelative(new File(path).toURI(), true, variable);
                        String varPath = uri.getPath().replace(variable, pack.getVariableName(true));
                        entries.add((ICSettingEntry)CDataUtil.createCIncludePathEntry((String)varPath, (int)1));
                    } else {
                        variable = pack.getVariableName(true);
                        entries.add((ICSettingEntry)CDataUtil.createCIncludePathEntry((String)(String.valueOf(variable) + "/" + path), (int)1));
                    }
                }
                catch (CoreException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                if (!path.replace(base, "").isEmpty()) continue;
                continue block2;
            }
        }
    }

    public List<IFile> handleFiles(IContainer folder, boolean standalone, ISDKManifest pack, List<String> files, boolean external, boolean forceOverwrite, IProgressMonitor monitor) throws CoreException, IOException, URISyntaxException {
        ArrayList<IFile> destFiles = new ArrayList<IFile>();
        for (String file : files) {
            monitor.subTask(String.valueOf(Messages.SDKManifestProvider_35) + file);
            if (monitor.isCanceled()) break;
            try {
                IFile res = standalone ? pack.copyFiles(folder, file, external, forceOverwrite) : pack.linkFiles(folder, file, external, forceOverwrite);
                destFiles.add(res);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return destFiles;
    }

    public void deleteFiles(IContainer folder, ISDKManifest pack, List<String> files, boolean external, IProgressMonitor monitor) throws CoreException, IOException, URISyntaxException {
        for (String file : files) {
            monitor.subTask(String.valueOf(Messages.SDKManifestProvider_35a) + file);
            if (monitor.isCanceled()) break;
            try {
                pack.deleteFiles(folder, file, external);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void handleFiles(ProjectParameters projectParameters, boolean includeOnly, IProgressMonitor monitor) throws Exception {
        Map<ComponentType, List<SourceType>> sources = projectParameters.getSources();
        Set<ComponentType> components = sources.keySet();
        Iterator<ComponentType> it = components.iterator();
        ArrayList<ComponentType> types = new ArrayList<ComponentType>();
        boolean isLib = projectParameters.getProjectType().equals("com.crt.advproject.projecttype.lib");
        while (it.hasNext()) {
            ComponentType component = it.next();
            types.add(component);
        }
        for (ComponentType type : types) {
            if (ComponentTypeEnum.STARTUP.equals((Object)type.getType()) && isLib) continue;
            boolean forceOverwrite = projectParameters.isExample() && types.indexOf(type) == types.size() - 1;
            this.handleSources(projectParameters, type, includeOnly, forceOverwrite, monitor);
            if (projectParameters.getPack().getBoards().contains(projectParameters.getBoard())) continue;
            SDKSoftwareProvider.handleSources(projectParameters, type, includeOnly, true, monitor);
        }
        SDKManifestProvider.checkSourceEntries(projectParameters.getBuilderEntries());
        this.handleComponentsIncludes(projectParameters, monitor, projectParameters.getPack());
    }

    public void handleComponentsIncludes(ProjectParameters projectParameters, IProgressMonitor monitor, ISDKManifest pack) throws Exception {
        List<ComponentType> enabledComponents = projectParameters.getEnabledComponents();
        List<ICSettingEntry> entries = projectParameters.getBuilderEntries();
        for (ComponentType component : enabledComponents) {
            ComponentType.IncludePaths includes = component.getIncludePaths();
            if (includes == null) continue;
            for (IncludeType include : includes.getIncludePath()) {
                List<CompilerType> compilerObj = include.getCompiler();
                CompilerType compiler = null;
                if (compilerObj instanceof CompilerType) {
                    compiler = (CompilerType)((Object)compilerObj);
                } else if (compilerObj instanceof Manifest.ExternalDefinitions.Definition) {
                    compiler = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)compilerObj), CompilerType.class);
                }
                List<ToolchainType> toolchains = include.getToolchain();
                if (!toolchains.isEmpty() && toolchains.get(0) instanceof Manifest.ExternalDefinitions.Definition) {
                    ArrayList<ToolchainType> list = new ArrayList<ToolchainType>();
                    for (ToolchainType def : toolchains) {
                        ToolchainType toolchain = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)def), ToolchainType.class);
                        if (toolchain == null) continue;
                        list.add(toolchain);
                    }
                    toolchains = list;
                }
                if (!SDKManifestProvider.isToolchainSupported(toolchains) || !SDKManifestProvider.isCompilerSupported(compiler) || !projectParameters.isStandalone() && !pack.isZip()) continue;
                entries.add((ICSettingEntry)this.createIncludeEntry(include.getPath(), projectParameters.getProjectName(), include, component, projectParameters.getBuilderEntries()));
            }
        }
    }

    public void handleSources(ProjectParameters projectParameters, ComponentType component, boolean includeOnly, boolean forceOverwrite, IProgressMonitor monitor) throws Exception {
        Map<ComponentType, List<SourceType>> sources = projectParameters.getSources();
        List<ComponentType> enabledComponents = projectParameters.getEnabledComponents();
        IProject container = projectParameters.getProject();
        IFolder srcFolder = projectParameters.getSourceFolder();
        IFolder docFolder = projectParameters.getDocFolder();
        List<ICSettingEntry> entries = projectParameters.getBuilderEntries();
        final SDKManifestFilter filter = projectParameters.getFilter();
        ISDKManifest pack = projectParameters.getPack();
        String nature = projectParameters.getNature();
        boolean standalone = projectParameters.isStandalone();
        Map<String, OptionValueHolder> options = projectParameters.getOptions();
        for (SourceType source : sources.get(component)) {
            SourceTypeEnum type = source.getType();
            if (!this.hasRequired(pack, source, enabledComponents)) continue;
            ArrayList<CompilerType> listCompilers = new ArrayList<CompilerType>();
            List<CompilerType> compilers = source.getCompiler();
            for (CompilerType compilerObj : compilers) {
                CompilerType compiler = null;
                if (compilerObj instanceof CompilerType) {
                    compiler = compilerObj;
                } else if (compilerObj instanceof Manifest.ExternalDefinitions.Definition && (compiler = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)compilerObj), CompilerType.class)) == null) {
                    compiler = new CompilerType();
                    compiler.setType(CompilerEnum.IAR);
                }
                if (compiler == null) continue;
                listCompilers.add(compiler);
            }
            List<ToolchainType> toolchains = source.getToolchain();
            if (!toolchains.isEmpty() && toolchains.get(0) instanceof Manifest.ExternalDefinitions.Definition) {
                ArrayList<ToolchainType> list = new ArrayList<ToolchainType>();
                for (ToolchainType def : toolchains) {
                    ToolchainType toolchain = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)def), ToolchainType.class);
                    if (toolchain != null) {
                        list.add(toolchain);
                        continue;
                    }
                    ToolchainType notFound = new ToolchainType();
                    notFound.setId(((Manifest.ExternalDefinitions.Definition)((Object)def)).getExtID());
                    notFound.setType(ToolchainEnum.LPCX);
                    list.add(notFound);
                }
                toolchains = list;
            } else if (!toolchains.isEmpty() && !(toolchains.get(0) instanceof ToolchainType)) {
                toolchains = new ArrayList<ToolchainType>();
            }
            if (!SDKManifestProvider.isToolchainSupported(toolchains) || !SDKManifestProvider.isCompilerSupported(listCompilers)) continue;
            Object parentFolder = srcFolder;
            if (!component.getType().equals((Object)ComponentTypeEnum.SCR) || component.getType().equals((Object)ComponentTypeEnum.SCR) && source.getTargetPath() != null) {
                if (source.getTargetPath() != null && !source.isRelative()) {
                    parentFolder = container;
                } else if (component.getTargetPath() != null) {
                    parentFolder = this.generateFolders((IContainer)container, component.getTargetPath());
                    this.addSourceEntry(entries, (IContainer)parentFolder);
                } else {
                    parentFolder = container.getFolder(SDKManifestProvider.adaptFolders(component));
                }
            }
            if (!includeOnly && !parentFolder.exists() && parentFolder instanceof IFolder) {
                ICSourceEntry sourceEntry = this.containsSourceEntry(entries, parentFolder.getName());
                parentFolder.create(true, true, monitor);
                entries.add((ICSettingEntry)this.createIncludeEntry(parentFolder.getProjectRelativePath().toPortableString(), projectParameters.getProjectName(), null, null, null));
                if (sourceEntry == null) {
                    this.addSourceEntry(entries, (IContainer)parentFolder);
                }
            }
            IProject destFolder = null;
            if (source.getTargetPath() != null) {
                if (type.equals((Object)SourceTypeEnum.DOC)) {
                    parentFolder = source.getTargetPath().equals(docFolder.getName()) ? container : docFolder;
                }
                if (source.getTargetPath().equals(".") || source.getTargetPath().equals("./")) {
                    destFolder = container;
                } else {
                    destFolder = this.generateFolders((IContainer)parentFolder, source.getTargetPath());
                    ICSourceEntry sourceEntry = this.containsSourceEntry(entries, destFolder.getName());
                    if (sourceEntry == null && !type.equals((Object)SourceTypeEnum.DOC)) {
                        this.addSourceEntry(entries, (IContainer)destFolder);
                    }
                }
            } else if (type.equals((Object)SourceTypeEnum.LIB) || type.equals((Object)SourceTypeEnum.LIB_C) || type.equals((Object)SourceTypeEnum.LIB_CPP) || type.equals((Object)SourceTypeEnum.OBJECT) || type.equals((Object)SourceTypeEnum.OBJECT_C) || type.equals((Object)SourceTypeEnum.OBJECT_CPP)) {
                destFolder = container.getFolder((IPath)new Path(FOLDER_LIB));
                if (!destFolder.exists() && destFolder instanceof IFolder) {
                    ((IFolder)destFolder).create(true, true, null);
                }
            } else {
                destFolder = parentFolder;
            }
            final String path = source.getPath();
            String basePath = filter.basePath(path);
            List<FileType> sourceFiles = source.getFiles();
            boolean exclude = source.isExclude() == Boolean.TRUE;
            block12: for (FileType file : sourceFiles) {
                final ArrayList<String> files = new ArrayList<String>();
                final String mask = file.getMask();
                boolean external = false;
                if (monitor.isCanceled()) {
                    return;
                }
                String osPath = String.valueOf(pack.getManifestName()) + File.separator;
                File folder = new File(String.valueOf(osPath) + basePath);
                if (projectParameters.getLookupLocation() != null && !projectParameters.getLookupLocation().isEmpty()) {
                    folder = new File(String.valueOf(projectParameters.getLookupLocation()) + File.separator + basePath);
                    String user = this.getMetadata(component, "internal.example.user");
                    String externalPath = this.getMetadata(component, "internal.example.path");
                    if (Boolean.TRUE.equals(Boolean.valueOf(user)) && externalPath != null) {
                        folder = new File(externalPath);
                    }
                    if (folder.exists()) {
                        external = true;
                        java.nio.file.Path directory = Paths.get(folder.toString(), new String[0]);
                        Files.walkFileTree(directory, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                                String fileMask = filter.adapt(path, mask);
                                String name = file.toString();
                                if (SDKManifestFilter.match(name, fileMask)) {
                                    files.add(name);
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                }
                if (!external || files.isEmpty()) {
                    external = false;
                    pack.scan(files, folder, filter, filter.adapt(path, mask));
                }
                if (type.equals((Object)SourceTypeEnum.CPP_INCLUDE) && !nature.equals("org.eclipse.cdt.core.ccnature")) continue;
                if (type.equals((Object)SourceTypeEnum.C_INCLUDE)) {
                    nature.equals("org.eclipse.cdt.core.ccnature");
                }
                if (type.equals((Object)SourceTypeEnum.SRC_CPP) && !nature.equals("org.eclipse.cdt.core.ccnature") || type.equals((Object)SourceTypeEnum.SRC_C) && nature.equals("org.eclipse.cdt.core.ccnature")) continue;
                if (type.equals((Object)SourceTypeEnum.C_INCLUDE) || type.equals((Object)SourceTypeEnum.CPP_INCLUDE)) {
                    this.handleFiles((IContainer)destFolder, standalone, pack, files, external, forceOverwrite, monitor);
                    entries.add((ICSettingEntry)this.createIncludeEntry(destFolder.getProjectRelativePath().toPortableString(), projectParameters.getProjectName(), null, null, null));
                    continue;
                }
                switch (type) {
                    case ASM_INCLUDE: {
                        this.handleFiles((IContainer)destFolder, standalone, pack, files, external, forceOverwrite, monitor);
                        break;
                    }
                    case C_INCLUDE: 
                    case CPP_INCLUDE: {
                        if (pack.isZip() || standalone) {
                            this.handleFiles((IContainer)destFolder, standalone, pack, files, external, forceOverwrite, monitor);
                            entries.add((ICSettingEntry)this.createIncludeEntry(destFolder.getProjectRelativePath().toPortableString(), projectParameters.getProjectName(), null, null, null));
                            break;
                        }
                        this.handleIncludeEntries(entries, pack, files, osPath);
                        break;
                    }
                    case LINKER: {
                        this.handleFiles((IContainer)destFolder, true, pack, files, external, forceOverwrite, monitor);
                        for (String script : files) {
                            String name = SDKManifestProvider.getSimpleName(script);
                            String scriptDir = "../" + destFolder.getProjectRelativePath();
                            if (nature.equals("org.eclipse.cdt.core.cnature")) {
                                SDKManifestProvider.addDefaultOption(options, OPTION_C_LINK_SCRIPT, name);
                                SDKManifestProvider.addDefaultOption(options, OPTION_C_LINK_SCRIPT_DIR, scriptDir);
                                continue;
                            }
                            if (!nature.equals("org.eclipse.cdt.core.ccnature")) continue;
                            SDKManifestProvider.addDefaultOption(options, OPTION_CPP_LINK_SCRIPT, name);
                            SDKManifestProvider.addDefaultOption(options, OPTION_CPP_LINK_SCRIPT_DIR, scriptDir);
                        }
                        continue block12;
                    }
                    case OBJECT: 
                    case OBJECT_C: 
                    case OBJECT_CPP: {
                        this.handleObjects(monitor, pack, standalone, options, source, type, (IContainer)destFolder, files, external, forceOverwrite);
                        break;
                    }
                    case LIB: 
                    case LIB_C: 
                    case LIB_CPP: {
                        this.handleLibraries(monitor, pack, standalone, options, source, type, (IContainer)destFolder, files, external, forceOverwrite);
                        break;
                    }
                    case SRC: 
                    case SRC_C: 
                    case SRC_CPP: {
                        this.handleFiles((IContainer)destFolder, standalone, pack, files, external, forceOverwrite, monitor);
                        if (!exclude || includeOnly) continue block12;
                        ICSourceEntry existingEntry = this.containsSourceEntry(entries, destFolder.getName());
                        if (existingEntry == null) {
                            existingEntry = this.addSourceEntry(entries, (IContainer)destFolder);
                        }
                        this.handleExcludeEntry(entries, existingEntry, (IContainer)destFolder, files);
                        break;
                    }
                    case DOC: {
                        this.handleFiles((IContainer)destFolder, pack.isZip(), pack, files, external, forceOverwrite, monitor);
                        break;
                    }
                    default: {
                        if (!projectParameters.isUseOtherFiles()) continue block12;
                        this.handleFiles((IContainer)destFolder, standalone, pack, files, external, forceOverwrite, monitor);
                    }
                }
            }
        }
    }

    private void handleLibraries(IProgressMonitor monitor, ISDKManifest pack, boolean standalone, Map<String, OptionValueHolder> options, SourceType source, SourceTypeEnum type, IContainer destFolder, List<String> files, boolean external, boolean forceOverwrite) throws CoreException, IOException, URISyntaxException {
        block8: {
            block7: {
                MethodTypeEnum method = source.getMethod();
                if (method == null) break block7;
                switch (method) {
                    case COPY: {
                        List<IFile> destFiles = this.handleFiles(destFolder, true, pack, files, external, forceOverwrite, monitor);
                        this.doLibFile(pack, options, type, destFiles);
                        break;
                    }
                    case LINK: {
                        if (!pack.isZip()) {
                            this.handleFiles(destFolder, false, pack, files, external, forceOverwrite, monitor);
                            for (String f : files) {
                                int index = f.lastIndexOf("\\");
                                if (index == -1) {
                                    index = f.lastIndexOf("/");
                                }
                                String name = f.substring(index + 1, f.length());
                                String path = f.substring(0, index);
                                this.addLibOption(options, type, path, name);
                            }
                        }
                        break block8;
                    }
                    default: {
                        List<IFile> destFiles = this.handleFiles(destFolder, standalone, pack, files, external, forceOverwrite, monitor);
                        this.doLibFile(pack, options, type, destFiles);
                        break;
                    }
                }
                break block8;
            }
            List<IFile> destFiles = this.handleFiles(destFolder, standalone, pack, files, external, forceOverwrite, monitor);
            this.doLibFile(pack, options, type, destFiles);
        }
    }

    private void doLibFile(ISDKManifest pack, Map<String, OptionValueHolder> options, SourceTypeEnum type, List<IFile> destFiles) throws CoreException, MalformedURLException, URISyntaxException, IOException {
        for (IFile f : destFiles) {
            String varPath = this.getPathSubstitution(pack, f);
            if (varPath.contains(pack.getVariableName(false))) {
                this.addLibOption(options, type, varPath, f.getName());
                continue;
            }
            this.addLibOption(options, type, WORKSPACE_LOC + File.separator + f.getParent().getProjectRelativePath() + WORKSPACE_LOC_END, f.getName());
        }
    }

    private void handleObjects(IProgressMonitor monitor, ISDKManifest pack, boolean standalone, Map<String, OptionValueHolder> options, SourceType source, SourceTypeEnum type, IContainer destFolder, List<String> files, boolean external, boolean forceOverwrite) throws CoreException, IOException, URISyntaxException {
        block7: {
            block6: {
                MethodTypeEnum method = source.getMethod();
                if (method == null) break block6;
                switch (method) {
                    case COPY: {
                        List<IFile> destFiles = this.handleFiles(destFolder, true, pack, files, external, forceOverwrite, monitor);
                        this.doObjFile(pack, options, type, destFiles);
                        break;
                    }
                    case LINK: {
                        if (!pack.isZip()) {
                            this.handleFiles(destFolder, false, pack, files, external, forceOverwrite, monitor);
                            for (String f : files) {
                                this.addObjOption(options, type, String.valueOf(pack.getManifestName()) + File.separator + f);
                            }
                        }
                        break block7;
                    }
                    default: {
                        List<IFile> destFiles = this.handleFiles(destFolder, standalone, pack, files, external, forceOverwrite, monitor);
                        this.doObjFile(pack, options, type, destFiles);
                        break;
                    }
                }
                break block7;
            }
            List<IFile> destFiles = this.handleFiles(destFolder, standalone, pack, files, external, forceOverwrite, monitor);
            this.doObjFile(pack, options, type, destFiles);
        }
    }

    private void doObjFile(ISDKManifest pack, Map<String, OptionValueHolder> options, SourceTypeEnum type, List<IFile> destFiles) throws CoreException, MalformedURLException, URISyntaxException, IOException {
        for (IFile f : destFiles) {
            String varPath = this.getPathSubstitution(pack, f);
            if (varPath.contains(pack.getVariableName(false))) {
                this.addObjOption(options, type, varPath);
                continue;
            }
            this.addObjOption(options, type, WORKSPACE_LOC + File.separator + f.getParent().getProjectRelativePath() + WORKSPACE_LOC_END);
        }
    }

    private String getPathSubstitution(ISDKManifest pack, IFile f) throws CoreException, MalformedURLException, URISyntaxException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPathVariableManager pathMan = workspace.getPathVariableManager();
        IPath path = f.getLocation();
        URI uri = pathMan.convertToRelative(new File(path.toOSString()).toURI(), true, pack.getVariableName(false));
        String varPath = uri.getPath().replace(pack.getVariableName(false), pack.getVariableName(true));
        return varPath.replace(f.getName(), "");
    }

    private void addLibOption(Map<String, OptionValueHolder> options, SourceTypeEnum type, String path, String name) {
        Matcher matcher = Pattern.compile(LIB_REGEX).matcher(name);
        if (options == null) {
            return;
        }
        if (matcher.find() && matcher.groupCount() == 1) {
            String libName = matcher.group(1);
            switch (type) {
                case LIB: {
                    this.addOptionValue(OPTION_GNU_C_LIB, libName, options);
                    this.addOptionValue(OPTION_GNU_C_LIBPATH, path, options);
                    this.addOptionValue(OPTION_GNU_CPP_LIB, libName, options);
                    this.addOptionValue(OPTION_GNU_CPP_LIBPATH, path, options);
                    break;
                }
                case LIB_C: {
                    this.addOptionValue(OPTION_GNU_C_LIB, libName, options);
                    this.addOptionValue(OPTION_GNU_C_LIBPATH, path, options);
                    break;
                }
                case LIB_CPP: {
                    this.addOptionValue(OPTION_GNU_CPP_LIB, libName, options);
                    this.addOptionValue(OPTION_GNU_CPP_LIBPATH, path, options);
                    break;
                }
            }
        } else {
            String message = NLS.bind((String)Messages.SDKManifestProvider_8, (Object)name, (Object)path);
            LOGGER.log(Level.SEVERE, message);
        }
    }

    private void addObjOption(Map<String, OptionValueHolder> options, SourceTypeEnum type, String value) {
        switch (type) {
            case OBJECT: {
                this.addOptionValue(OPTION_GNU_C_USEROBJ, value, options);
                this.addOptionValue(OPTION_GNU_CPP_USEROBJ, value, options);
                break;
            }
            case OBJECT_C: {
                this.addOptionValue(OPTION_GNU_C_USEROBJ, value, options);
                break;
            }
            case OBJECT_CPP: {
                this.addOptionValue(OPTION_GNU_CPP_USEROBJ, value, options);
                break;
            }
        }
    }

    public static void checkSourceEntries(List<ICSettingEntry> entries) {
        HashMap<String, ICSourceEntry> sources = new HashMap<String, ICSourceEntry>();
        ArrayList<ICSettingEntry> toRemove = new ArrayList<ICSettingEntry>();
        for (ICSettingEntry entry : entries) {
            if (!(entry instanceof ACExclusionFilterEntry)) continue;
            toRemove.add(entry);
            ACExclusionFilterEntry existing = (ACExclusionFilterEntry)sources.get(entry.getName());
            if (existing != null) {
                IPath item;
                ArrayList<IPath> list = new ArrayList<IPath>();
                IPath[] iPathArray = existing.getExclusionPatterns();
                int n = iPathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    item = iPathArray[n2];
                    list.add(item);
                    ++n2;
                }
                iPathArray = ((ACExclusionFilterEntry)entry).getExclusionPatterns();
                n = iPathArray.length;
                n2 = 0;
                while (n2 < n) {
                    item = iPathArray[n2];
                    list.add(item);
                    ++n2;
                }
                ICSourceEntry excluded = CDataUtil.addExcludePaths((ICSourceEntry)((ICSourceEntry)entry), list, (boolean)false);
                sources.put(excluded.getName(), excluded);
                continue;
            }
            sources.put(entry.getName(), (ICSourceEntry)entry);
        }
        entries.removeAll(toRemove);
        entries.addAll(sources.values());
    }

    private void addOptionValue(String id, String value, Map<String, OptionValueHolder> options) {
        OptionValueHolder holder;
        if (options.containsKey(id)) {
            holder = options.get(id);
        } else {
            holder = new OptionValueHolder();
            options.put(id, holder);
        }
        holder.add(value);
    }

    private ICSourceEntry addSourceEntry(List<ICSettingEntry> entries, IContainer parentFolder) {
        IContainer baseContainer = this.getBaseParent(parentFolder);
        ICSourceEntry sourceEntry = this.containsSourceEntry(entries, baseContainer.getName());
        if (sourceEntry == null && baseContainer.getProject().exists((IPath)new Path(baseContainer.getName()))) {
            sourceEntry = new CSourceEntry(baseContainer.getName(), null, 4);
            entries.add((ICSettingEntry)sourceEntry);
        }
        return sourceEntry;
    }

    private IContainer getBaseParent(IContainer parent) {
        if (parent instanceof IProject) {
            return parent;
        }
        IProject project = parent.getProject();
        IContainer folder = parent;
        while (folder.getParent() != project) {
            folder = folder.getParent();
        }
        return folder;
    }

    private ICSourceEntry containsSourceEntry(List<ICSettingEntry> entries, String name) {
        for (ICSettingEntry entry : entries) {
            if (entry.getKind() != 128 || !entry.getName().equals(name)) continue;
            return (ICSourceEntry)entry;
        }
        return null;
    }

    public IFolder generateFolders(IContainer container, String targetPath) throws CoreException {
        String[] folders = targetPath.split("[\\/]");
        IContainer parent = container;
        if (!parent.exists() && parent instanceof IFolder) {
            ((IFolder)parent).create(true, true, null);
        }
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            if (!folder.trim().isEmpty()) {
                IFolder item = parent.getFolder((IPath)new Path(folder));
                if (!item.exists()) {
                    item.create(true, true, null);
                }
                parent = item;
            }
            ++n2;
        }
        if (parent instanceof IFolder) {
            return (IFolder)parent;
        }
        return null;
    }

    private void handleExcludeEntry(List<ICSettingEntry> entries, ICSourceEntry sourceEntry, IContainer destFolder, List<String> files) {
        ICSourceEntry excludedEntry = sourceEntry;
        for (String file : files) {
            String fileName = SDKManifestProvider.getSimpleName(file);
            ArrayList<Path> paths = new ArrayList<Path>();
            try {
                Path path;
                if (destFolder.findMember((IPath)new Path(fileName)) == null) continue;
                String folderName = destFolder.getName();
                if (folderName.equals(excludedEntry.getName())) {
                    path = new Path(fileName);
                    paths.add(path);
                    excludedEntry = CDataUtil.addExcludePaths((ICSourceEntry)excludedEntry, paths, (boolean)false);
                    continue;
                }
                path = destFolder.getFile((IPath)new Path(fileName)).getProjectRelativePath();
                paths.add(path);
                excludedEntry = CDataUtil.addExcludePaths((ICSourceEntry)excludedEntry, paths, (boolean)true);
                break;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        entries.add((ICSettingEntry)excludedEntry);
    }

    private boolean hasRequired(ISDKManifest manifest, SourceType source, List<ComponentType> enabledComponents) {
        List<ComponentType> requiredList = source.getCondition();
        if (requiredList.isEmpty()) {
            return true;
        }
        for (ComponentType item : requiredList) {
            if (item instanceof Manifest.ExternalDefinitions.Definition) {
                ComponentType component = manifest.findReference((Manifest.ExternalDefinitions.Definition)((Object)item), ComponentType.class);
                if (enabledComponents == null || !enabledComponents.contains(component)) continue;
                return true;
            }
            if (enabledComponents == null || !enabledComponents.contains(item)) continue;
            return true;
        }
        return false;
    }

    public static ICLanguageSettingEntry[] getIncludes(List<ICSettingEntry> entries) {
        ArrayList<ICLanguageSettingEntry> includes = new ArrayList<ICLanguageSettingEntry>();
        for (ICSettingEntry entry : entries) {
            if (entry.getKind() != 1 || !(entry instanceof ICLanguageSettingEntry)) continue;
            includes.add((ICLanguageSettingEntry)entry);
        }
        return includes.toArray(new ICLanguageSettingEntry[includes.size()]);
    }

    public static ICSourceEntry[] getSources(List<ICSettingEntry> entries) {
        ArrayList<ICSourceEntry> includes = new ArrayList<ICSourceEntry>();
        for (ICSettingEntry entry : entries) {
            if (entry.getKind() != 128 || !(entry instanceof ICSourceEntry)) continue;
            includes.add((ICSourceEntry)entry);
        }
        return includes.toArray(new ICSourceEntry[includes.size()]);
    }

    public static void removeDefine(Map<String, OptionValueHolder> perConfOptions, boolean isCpp, DefineType define) {
        String value = define.getName();
        if (isCpp) {
            SDKManifestProvider.removeDefaultOption(perConfOptions, OPTION_DEFINE_CPP, value);
            SDKManifestProvider.removeDefaultOption(perConfOptions, OPTION_DEFINE_C, value);
        } else {
            SDKManifestProvider.removeDefaultOption(perConfOptions, OPTION_DEFINE_C, value);
        }
    }

    public static void addDefine(Map<String, OptionValueHolder> perConfOptions, boolean isCpp, DefineType define) {
        String value = String.valueOf(define.getName()) + (define.getValue() != null && define.getValue().length() != 0 ? "=" + define.getValue() : "");
        if (isCpp) {
            SDKManifestProvider.addDefaultOption(perConfOptions, OPTION_DEFINE_CPP, value);
            SDKManifestProvider.addDefaultOption(perConfOptions, OPTION_DEFINE_C, value);
        } else {
            SDKManifestProvider.addDefaultOption(perConfOptions, OPTION_DEFINE_C, value);
        }
    }

    public static OptionValueHolder setOption(IConfiguration conf, Map<String, OptionValueHolder> options, IHoldsOptions holder) throws Exception {
        IOption[] iOptionArray = holder.getOptions();
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Set<String> manifestOption;
            IOption opt = iOptionArray[n2];
            OptionValueHolder optionHolder = options.get(opt.getBaseId());
            if (optionHolder != null && (manifestOption = optionHolder.getValues(conf.getBaseId())) != null) {
                IOption optToSet = holder.getOptionToSet(opt, false);
                if (!manifestOption.isEmpty()) {
                    switch (opt.getValueType()) {
                        case 0: {
                            String value = manifestOption.iterator().next();
                            OptionValueHolder op = new OptionValueHolder();
                            op.addConfig(opt.getBaseId());
                            op.add(((Boolean)opt.getValue()).toString());
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (boolean)Boolean.parseBoolean(value));
                            return op;
                        }
                        case 2: {
                            String value = manifestOption.iterator().next();
                            OptionValueHolder op = new OptionValueHolder();
                            op.addConfig(opt.getBaseId());
                            op.add((String)opt.getValue());
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String)SDKManifestProvider.cleanValueString(value));
                            return op;
                        }
                        case 6: {
                            String item;
                            String[] libs = optToSet.getLibraries();
                            ArrayList<String> val = new ArrayList<String>();
                            String[] stringArray = libs;
                            int n3 = libs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                item = stringArray[n4];
                                val.add(SDKManifestProvider.cleanValueString(item));
                                ++n4;
                            }
                            for (String option : manifestOption) {
                                if (val.contains(SDKManifestProvider.cleanValueString(option))) continue;
                                val.add(SDKManifestProvider.cleanValueString(option));
                            }
                            String[] array = val.toArray(new String[val.size()]);
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String[])array);
                            break;
                        }
                        case 9: {
                            String item;
                            String[] paths = optToSet.getBasicStringListValue();
                            ArrayList<String> val = new ArrayList();
                            String[] stringArray = paths;
                            int n3 = paths.length;
                            int n5 = 0;
                            while (n5 < n3) {
                                item = stringArray[n5];
                                String string = SDKManifestProvider.cleanValueString(item);
                                if (string != null && !string.startsWith(QUOTE)) {
                                    string = QUOTE + string + QUOTE;
                                }
                                if (!val.contains(string)) {
                                    val.add(string);
                                }
                                ++n5;
                            }
                            for (String option : manifestOption) {
                                String string = SDKManifestProvider.cleanValueString(option);
                                if (string != null && !string.startsWith(QUOTE)) {
                                    string = QUOTE + string + QUOTE;
                                }
                                if (val.contains(string)) continue;
                                val.add(string);
                            }
                            String[] array = val.toArray(new String[val.size()]);
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String[])array);
                            break;
                        }
                        case 7: {
                            String item;
                            String[] paths = optToSet.getUserObjects();
                            ArrayList<String> val = new ArrayList();
                            String[] stringArray = paths;
                            int n3 = paths.length;
                            int n6 = 0;
                            while (n6 < n3) {
                                item = stringArray[n6];
                                val.add(SDKManifestProvider.cleanValueString(item));
                                ++n6;
                            }
                            for (String option : manifestOption) {
                                if (val.contains(SDKManifestProvider.cleanValueString(option))) continue;
                                val.add(SDKManifestProvider.cleanValueString(option));
                            }
                            String[] array = val.toArray(new String[val.size()]);
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String[])array);
                            break;
                        }
                        case 3: {
                            List val = (List)optToSet.getValue();
                            for (String item : manifestOption) {
                                val.add(SDKManifestProvider.cleanValueString(item));
                            }
                            for (String option : manifestOption) {
                                if (val.contains(SDKManifestProvider.cleanValueString(option))) continue;
                                val.add(SDKManifestProvider.cleanValueString(option));
                            }
                            String[] array = val.toArray(new String[val.size()]);
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String[])array);
                            break;
                        }
                        case 1: {
                            String value = manifestOption.iterator().next();
                            OptionValueHolder op = new OptionValueHolder();
                            op.addConfig(opt.getBaseId());
                            op.add((String)opt.getValue());
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String)value);
                            return op;
                        }
                        case -5: 
                        case 5: {
                            List val = (List)optToSet.getValue();
                            for (String option : manifestOption) {
                                if (val.contains(option)) continue;
                                val.add(option);
                            }
                            String[] array = val.toArray(new String[val.size()]);
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String[])array);
                            break;
                        }
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public static void removeOption(IConfiguration conf, Map<String, OptionValueHolder> options, IHoldsOptions holder) throws Exception {
        IOption[] iOptionArray = holder.getOptions();
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Set<String> manifestOption;
            IOption opt = iOptionArray[n2];
            OptionValueHolder optionHolder = options.get(opt.getBaseId());
            if (optionHolder != null && (manifestOption = optionHolder.getValues(conf.getBaseId())) != null) {
                IOption optToSet = holder.getOptionToSet(opt, false);
                if (!manifestOption.isEmpty()) {
                    switch (opt.getValueType()) {
                        case 0: {
                            String value = manifestOption.iterator().next();
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (boolean)Boolean.parseBoolean(value));
                            break;
                        }
                        case 2: {
                            String value = manifestOption.iterator().next();
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String)SDKManifestProvider.cleanValueString(value));
                            break;
                        }
                        case 6: {
                            String item;
                            String[] libs = optToSet.getLibraries();
                            ArrayList<String> val = new ArrayList<String>();
                            String[] stringArray = libs;
                            int n3 = libs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                item = stringArray[n4];
                                val.add(SDKManifestProvider.cleanValueString(item));
                                ++n4;
                            }
                            for (String option : manifestOption) {
                                if (!val.contains(SDKManifestProvider.cleanValueString(option))) continue;
                                val.remove(SDKManifestProvider.cleanValueString(option));
                            }
                            String[] array = val.toArray(new String[val.size()]);
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String[])array);
                            break;
                        }
                        case 9: {
                            String item;
                            String[] paths = optToSet.getBasicStringListValue();
                            ArrayList<String> val = new ArrayList();
                            String[] stringArray = paths;
                            int n3 = paths.length;
                            int n5 = 0;
                            while (n5 < n3) {
                                item = stringArray[n5];
                                String string = SDKManifestProvider.cleanValueString(item);
                                if (string != null && !string.startsWith(QUOTE)) {
                                    string = QUOTE + string + QUOTE;
                                }
                                if (!val.contains(string)) {
                                    val.add(string);
                                }
                                ++n5;
                            }
                            for (String option : manifestOption) {
                                String string = SDKManifestProvider.cleanValueString(option);
                                if (string != null && !string.startsWith(QUOTE)) {
                                    string = QUOTE + string + QUOTE;
                                }
                                if (!val.contains(string)) continue;
                                val.remove(string);
                            }
                            String[] array = val.toArray(new String[val.size()]);
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String[])array);
                            break;
                        }
                        case 7: {
                            String item;
                            String[] paths = optToSet.getUserObjects();
                            ArrayList<String> val = new ArrayList();
                            String[] stringArray = paths;
                            int n3 = paths.length;
                            int n6 = 0;
                            while (n6 < n3) {
                                item = stringArray[n6];
                                val.add(SDKManifestProvider.cleanValueString(item));
                                ++n6;
                            }
                            for (String option : manifestOption) {
                                if (val.contains(SDKManifestProvider.cleanValueString(option))) continue;
                                val.remove(SDKManifestProvider.cleanValueString(option));
                            }
                            String[] array = val.toArray(new String[val.size()]);
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String[])array);
                            break;
                        }
                        case 3: {
                            List val = (List)optToSet.getValue();
                            for (String item : manifestOption) {
                                val.add(SDKManifestProvider.cleanValueString(item));
                            }
                            for (String option : manifestOption) {
                                if (!val.contains(SDKManifestProvider.cleanValueString(option))) continue;
                                val.remove(SDKManifestProvider.cleanValueString(option));
                            }
                            String[] array = val.toArray(new String[val.size()]);
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String[])array);
                            break;
                        }
                        case 1: {
                            String value = manifestOption.iterator().next();
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String)value);
                            break;
                        }
                        case -5: 
                        case 5: {
                            List val = (List)optToSet.getValue();
                            for (String option : manifestOption) {
                                if (!val.contains(option)) continue;
                                val.remove(option);
                            }
                            String[] array = val.toArray(new String[val.size()]);
                            ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)holder, (IOption)optToSet, (String[])array);
                            break;
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private static String cleanValueString(String value) {
        return value.replace("\\", "/");
    }

    public void addListener(ISDKListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void remListener(ISDKListener listener) {
        this.listeners.add(listener);
    }

    public void addErrorListener(SDKErrorListener listener) {
        this.errorListeners.add(listener);
    }

    public static String getSimpleName(String fileName) {
        String[] tokens = fileName.split("[\\\\/]");
        return tokens[tokens.length - 1];
    }

    public static Object getMetadata(IdentifiableType type, String key, boolean content) {
        IdentifiableType.MetadataSet set = type.getMetadataSet();
        if (set != null) {
            for (MetadataType m : set.getMetadata()) {
                if (!m.getKey().equals(key)) continue;
                if (content && m.getSpecific() != null) {
                    return m.getSpecific().getContent();
                }
                return m.getValue();
            }
        }
        return null;
    }

    public static String getFamilyPrefix(DeviceType device) {
        Object metaFamily = SDKManifestProvider.getMetadata(device, "vendor.device.family", false);
        if (metaFamily instanceof String) {
            return (String)metaFamily;
        }
        String name = device.getId();
        Matcher matcher = Pattern.compile("\\d+").matcher(name);
        matcher.find();
        int index = matcher.start();
        String buildFamily = String.valueOf(name.substring(0, index)) + "xx";
        if (buildFamily.contains("LPC")) {
            return "LPC";
        }
        return buildFamily;
    }

    public static String getDefaultPath() {
        String basePath = SDKManifestProvider.getBasePath();
        return String.valueOf(basePath) + IPreferenceConstants.V_PATH;
    }

    public static File getBaseSupportFolder() throws IOException {
        File readMe;
        SDKManifestProvider.updateDefaultInstallPath();
        IPath wsLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        String pathSupport = String.valueOf(wsLocation.toOSString()) + File.separator + ".s32ds_packages_support";
        File dir = new File(pathSupport);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(readMe = new File(dir, "readme.txt")).exists()) {
            readMe.createNewFile();
        }
        FileWriter fw = new FileWriter(readMe.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(README_TXT);
        bw.close();
        return dir;
    }

    private static String getBasePath() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String productVersion = "01";
        String basePath = String.valueOf(System.getProperty("user.home")) + File.separator + ToolchainEnum.DSGCC.value() + File.separator + productVersion + File.separator;
        String installLocation = store.getString("sdk.install.location");
        if ("sdk.install.shared".equals(installLocation)) {
            basePath = String.valueOf(System.getProperty("user.home")) + File.separator + ToolchainEnum.DSGCC.value() + File.separator + productVersion + File.separator;
        } else if ("sdk.install.workspace".equals(installLocation)) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IPath wsLocation = root.getLocation();
            basePath = String.valueOf(wsLocation.toOSString()) + File.separator + ToolchainEnum.DSGCC.value() + File.separator;
        } else if ("sdk.install.user".equals(installLocation)) {
            String userPath = store.getString("sdk.install.location.user");
            File userLocation = new File(userPath);
            if (userLocation.isDirectory() && userLocation.exists()) {
                basePath = String.valueOf(userPath) + File.separator;
            } else {
                LOGGER.log(Level.SEVERE, "Wrong preference for SDK Install User location: " + userPath + ". Using shared location!");
            }
        } else {
            LOGGER.log(Level.SEVERE, "Wrong preference for SDK Install location: " + installLocation + ". Using shared location!");
        }
        return basePath;
    }

    public static String buildExampleName(ISDKManifest manifest, String prefix, String category, String exampleName, String suffix) {
        Version version;
        StringBuffer buffer = new StringBuffer();
        if (prefix != null) {
            buffer.append(prefix);
        }
        if (manifest != null && !manifest.getSchemaVersion().isEmpty() && (version = new Version(manifest.getSchemaVersion())).compareTo(ISDKManifest.MANIFEST_LEGACY_VERSION) <= 0 && category != null) {
            category = category.replace("/", "_").replace("\\", "_");
            buffer.append(category);
        }
        if (exampleName != null) {
            if (buffer.length() != 0) {
                buffer.append("_");
            }
            buffer.append(exampleName);
        }
        if (suffix != null && !suffix.isEmpty()) {
            if (buffer.length() != 0) {
                buffer.append("_");
            }
            buffer.append(suffix);
        }
        return buffer.toString();
    }

    public static String adaptFolders(ComponentType component) {
        String adapted = component.getType().value();
        Object value = null;
        if (component != null) {
            switch (component.getType()) {
                case STARTUP: 
                case LINKER: 
                case HAL: 
                case OTHER: 
                case UTILITIES: 
                case DEBUGGER: 
                case TOOLS: 
                case EULA: 
                case SCR: 
                case DOCUMENTATION: 
                case TEMPLATE: 
                case PAL: {
                    break;
                }
                case CMSIS: 
                case CMSIS_INCLUDE: {
                    value = "CMSIS";
                    break;
                }
                case DRIVER: {
                    value = "drivers";
                    break;
                }
                case MIDDLEWARE: {
                    value = 0;
                    break;
                }
                case OS: {
                    value = 0;
                    break;
                }
                case PROJECT_TEMPLATE: {
                    value = "board";
                }
            }
            if (value instanceof Integer) {
                switch ((Integer)value) {
                    case 0: {
                        return component.getName();
                    }
                }
            } else if (value instanceof String) {
                adapted = (String)value;
            }
        }
        return adapted;
    }

    public static String getDeviceSupportName(DeviceType device) {
        return device.getId();
    }

    public static void fillDefaultSemihostOptions(Map<String, OptionValueHolder> options, boolean isCpp, int value) {
        String nature;
        String string = nature = isCpp ? "org.eclipse.cdt.core.ccnature" : "org.eclipse.cdt.core.cnature";
        if (isCpp) {
            SDKManifestProvider.addDefaultOption(options, OPTION_DEFINE_CPP, "SDK_DEBUGCONSOLE=" + value);
        } else {
            SDKManifestProvider.addDefaultOption(options, OPTION_DEFINE_C, "SDK_DEBUGCONSOLE=" + value);
        }
        if (!SDKManifestProvider.isDefineSet(SYMBOL_CR_INTEGER_PRINTF, false, false, nature, options) && !SDKManifestProvider.isDefineSet(SYMBOL_FLOAT_PRINTF, true, false, nature, options)) {
            SDKManifestProvider.addDefaultOption(options, OPTION_DEFINE_C, SYMBOL_CR_INTEGER_PRINTF);
        } else if (SDKManifestProvider.isDefineSet(SYMBOL_CR_INTEGER_PRINTF, false, false, nature, options) && SDKManifestProvider.isDefineSet(SYMBOL_FLOAT_PRINTF, true, false, nature, options)) {
            LOGGER.log(Level.WARNING, String.valueOf(Messages.SDKManifestProvider_77) + SYMBOL_CR_INTEGER_PRINTF + Messages.SDKManifestProvider_78 + SYMBOL_FLOAT_PRINTF + Messages.SDKManifestProvider_79 + SYMBOL_CR_INTEGER_PRINTF);
            DefineType define = new DefineType();
            define.setName(SYMBOL_FLOAT_PRINTF);
            SDKManifestProvider.removeDefine(options, isCpp, define);
            SDKManifestProvider.addDefaultOption(options, OPTION_DEFINE_C, SYMBOL_CR_INTEGER_PRINTF);
        }
    }

    public static boolean isDefineSet(String define, boolean useValue, boolean neg, String nature, Map<String, OptionValueHolder> options) {
        block4: {
            Set<String> defs;
            block3: {
                Set<String> defs2;
                boolean isCpp = "org.eclipse.cdt.core.ccnature".equals(nature);
                if (!isCpp) break block3;
                OptionValueHolder holder = options.get(OPTION_DEFINE_CPP);
                if (holder == null || (defs2 = holder.getValues("com.nxp.s32ds.default.config")) == null) break block4;
                for (String def : defs2) {
                    String[] tokens = def.split("=");
                    if (!(useValue && tokens.length > 1 ? tokens[0].equals(define) && tokens[1].equals("1") : tokens[0].equals(define))) continue;
                    return true;
                }
                break block4;
            }
            OptionValueHolder holder = options.get(OPTION_DEFINE_C);
            if (holder != null && (defs = holder.getValues("com.nxp.s32ds.default.config")) != null) {
                for (String def : defs) {
                    String[] tokens = def.split("=");
                    if (!(useValue && tokens.length > 1 ? tokens[0].equals(define) && tokens[1].equals("1") : tokens[0].equals(define))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean getDefineValue(String define, boolean useValue, boolean neg, String nature, Map<String, OptionValueHolder> options) {
        block6: {
            block5: {
                boolean isCpp = "org.eclipse.cdt.core.ccnature".equals(nature);
                if (!isCpp) break block5;
                OptionValueHolder holder = options.get(OPTION_DEFINE_CPP);
                if (holder == null) break block6;
                Set<String> defs = holder.getValues("com.nxp.s32ds.default.config");
                for (String def : defs) {
                    String[] tokens = def.split("=");
                    if (!tokens[0].equals(define)) continue;
                    if (useValue && tokens.length == 2) {
                        return neg ? tokens[1].equals("1") : tokens[1].equals("0");
                    }
                    return true;
                }
                break block6;
            }
            OptionValueHolder holder = options.get(OPTION_DEFINE_C);
            if (holder != null) {
                Set<String> defs = holder.getValues("com.nxp.s32ds.default.config");
                for (String def : defs) {
                    String[] tokens = def.split("=");
                    if (!tokens[0].equals(define)) continue;
                    if (useValue && tokens.length == 2) {
                        return neg ? tokens[1].equals("1") : tokens[1].equals("0");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasUserSelection(ISDKManifest manifest) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String list = store.getString("sdk.versions.pref");
        String manifestName = manifest.getManifestSimpleName();
        return list.contains(manifestName);
    }

    private boolean isSelectedSDK(ISDKManifest manifest) {
        String pattern;
        Pattern regex;
        Matcher m;
        String manifestName;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String list = store.getString("sdk.versions.pref");
        if (list.contains(manifestName = manifest.getManifestSimpleName()) && (m = (regex = Pattern.compile(pattern = String.valueOf(manifestName) + "=" + "([0-9]+\\.[0-9]+\\.[0-9]+)[;]?")).matcher(list)).find()) {
            String versionToMatch = m.group(1);
            return versionToMatch.equals(manifest.getVersion().toString());
        }
        return false;
    }

    public static List<ISDKManifest> getManifestsDB(String id) {
        return manifestsDB.get(id);
    }

    public static void setActiveSDKVersion(ISDKManifest manifest) {
        String manifestName;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String list = store.getString("sdk.versions.pref");
        if (list.contains(manifestName = manifest.getManifestSimpleName())) {
            String pattern = String.valueOf(manifestName) + "=" + "[0-9]+\\.[0-9]+\\.[0-9]+;";
            list = list.replaceAll(pattern, String.valueOf(manifestName) + "=" + manifest.getVersion().toString() + SEPARATOR);
        } else {
            list = String.valueOf(list) + manifestName + "=" + manifest.getVersion().toString() + SEPARATOR;
        }
        store.setValue("sdk.versions.pref", list);
        store.needsSaving();
    }

    public static boolean isNonDefault(ISDKManifest manifest) {
        String id = manifest.getManifestSimpleName();
        Version maxVersion = manifest.getVersion();
        if (manifestsDB.containsKey(id)) {
            for (ISDKManifest item : manifestsDB.get(id)) {
                if (maxVersion.compareTo(item.getVersion()) >= 0) continue;
                maxVersion = item.getVersion();
            }
        }
        return manifest.getVersion().compareTo(maxVersion) != 0;
    }

    public static void setMetadata(IdentifiableType type, String key, String value) {
        MetadataType m2;
        IdentifiableType.MetadataSet set = type.getMetadataSet();
        if (set == null) {
            set = new IdentifiableType.MetadataSet();
            type.setMetadataSet(set);
        }
        for (MetadataType m2 : set.getMetadata()) {
            if (!m2.getKey().equals(key)) continue;
            m2.setValue(value);
            return;
        }
        m2 = new MetadataType();
        m2.setKey(key);
        m2.setValue(value);
        set.getMetadata().add(m2);
    }

    public static DeviceType getDevice(PackageType pkg) {
        for (SDKManifestProvider provider : instances) {
            for (ISDKManifest manifest : provider.getManifests()) {
                for (DeviceType device : manifest.getDevices()) {
                    for (PackageType devicePkg : device.getPackage()) {
                        if (!devicePkg.getId().equals(pkg.getId())) continue;
                        return device;
                    }
                }
            }
        }
        return null;
    }

    public static List<ISDKManifest> getCompatibleSDKs(String chip) {
        ArrayList<ISDKManifest> list = new ArrayList<ISDKManifest>();
        for (SDKManifestProvider provider : SDKManifestProvider.getInstance()) {
            if (!provider.isDefaultProvider() && !provider.isMCUXpressoProvider()) continue;
            block1: for (ISDKManifest manifest : provider.getManifests()) {
                if (!manifest.isActive()) continue;
                for (DeviceType device : manifest.getDevices()) {
                    if (!device.getId().equals(chip)) continue;
                    list.add(manifest);
                    continue block1;
                }
            }
        }
        return list;
    }

    public void deleteFiles(ProjectParameters projectParameters, IProgressMonitor monitor) throws Exception {
        Map<ComponentType, List<SourceType>> sources = projectParameters.getSources();
        Set<ComponentType> components = sources.keySet();
        Iterator<ComponentType> it = components.iterator();
        ArrayList<ComponentType> types = new ArrayList<ComponentType>();
        while (it.hasNext()) {
            ComponentType component = it.next();
            types.add(component);
        }
        for (ComponentType type : types) {
            this.deleteSources(projectParameters, type, monitor);
        }
    }

    private void deleteSources(ProjectParameters projectParameters, ComponentType component, IProgressMonitor monitor) throws Exception {
        Map<ComponentType, List<SourceType>> sources = projectParameters.getSources();
        List<ComponentType> enabledComponents = projectParameters.getEnabledComponents();
        IProject container = projectParameters.getProject();
        IFolder srcFolder = projectParameters.getSourceFolder();
        IFolder docFolder = projectParameters.getDocFolder();
        SDKManifestFilter filter = projectParameters.getFilter();
        ISDKManifest pack = projectParameters.getPack();
        String nature = projectParameters.getNature();
        for (SourceType source : sources.get(component)) {
            SourceTypeEnum type = source.getType();
            if (!this.hasRequired(pack, source, enabledComponents)) continue;
            ArrayList<CompilerType> listCompilers = new ArrayList<CompilerType>();
            List<CompilerType> compilers = source.getCompiler();
            for (CompilerType compilerObj : compilers) {
                CompilerType compiler = null;
                if (compilerObj instanceof CompilerType) {
                    compiler = compilerObj;
                } else if (compilerObj instanceof Manifest.ExternalDefinitions.Definition && (compiler = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)compilerObj), CompilerType.class)) == null) {
                    compiler = new CompilerType();
                    compiler.setType(CompilerEnum.IAR);
                }
                if (compiler == null) continue;
                listCompilers.add(compiler);
            }
            List<ToolchainType> toolchains = source.getToolchain();
            if (!toolchains.isEmpty() && toolchains.get(0) instanceof Manifest.ExternalDefinitions.Definition) {
                ArrayList<ToolchainType> list = new ArrayList<ToolchainType>();
                for (ToolchainType def : toolchains) {
                    ToolchainType toolchain = pack.findReference((Manifest.ExternalDefinitions.Definition)((Object)def), ToolchainType.class);
                    if (toolchain != null) {
                        list.add(toolchain);
                        continue;
                    }
                    ToolchainType notFound = new ToolchainType();
                    notFound.setId(((Manifest.ExternalDefinitions.Definition)((Object)def)).getExtID());
                    notFound.setType(ToolchainEnum.LPCX);
                    list.add(notFound);
                }
                toolchains = list;
            }
            if (!SDKManifestProvider.isToolchainSupported(toolchains) || !SDKManifestProvider.isCompilerSupported(listCompilers)) continue;
            Object parentFolder = srcFolder;
            if (!component.getType().equals((Object)ComponentTypeEnum.SCR) || component.getType().equals((Object)ComponentTypeEnum.SCR) && source.getTargetPath() != null) {
                parentFolder = source.getTargetPath() != null && !source.isRelative() ? container : (component.getTargetPath() != null ? this.generateFolders((IContainer)container, component.getTargetPath()) : container.getFolder(SDKManifestProvider.adaptFolders(component)));
            }
            Object destFolder = null;
            if (source.getTargetPath() != null) {
                if (type.equals((Object)SourceTypeEnum.DOC)) {
                    parentFolder = source.getTargetPath().equals(docFolder.getName()) ? container : docFolder;
                }
                destFolder = source.getTargetPath().equals(".") || source.getTargetPath().equals("./") ? container : this.generateFolders((IContainer)parentFolder, source.getTargetPath());
            } else if (type.equals((Object)SourceTypeEnum.LIB) || type.equals((Object)SourceTypeEnum.LIB_C) || type.equals((Object)SourceTypeEnum.LIB_CPP) || type.equals((Object)SourceTypeEnum.OBJECT) || type.equals((Object)SourceTypeEnum.OBJECT_C) || type.equals((Object)SourceTypeEnum.OBJECT_CPP)) {
                destFolder = container.getFolder((IPath)new Path(FOLDER_LIB));
                if (!destFolder.exists() && destFolder instanceof IFolder) {
                    ((IFolder)destFolder).create(true, true, null);
                }
            } else {
                destFolder = parentFolder;
            }
            String path = source.getPath();
            final String basePath = filter.basePath(path);
            List<FileType> sourceFiles = source.getFiles();
            for (FileType file : sourceFiles) {
                final ArrayList<String> files = new ArrayList<String>();
                final String mask = file.getMask();
                boolean external = false;
                if (monitor.isCanceled()) {
                    return;
                }
                String osPath = String.valueOf(pack.getManifestName()) + File.separator;
                File folder = new File(String.valueOf(osPath) + basePath);
                if (projectParameters.getLookupLocation() != null && !projectParameters.getLookupLocation().isEmpty() && (folder = new File(String.valueOf(projectParameters.getLookupLocation()) + File.separator + basePath)).exists()) {
                    external = true;
                    java.nio.file.Path directory = Paths.get(folder.toString(), new String[0]);
                    Files.walkFileTree(directory, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                            if (SDKManifestFilter.match(file.toString(), String.valueOf(basePath.endsWith(File.separator) ? basePath : String.valueOf(basePath) + File.separator) + mask)) {
                                files.add(file.toString());
                            } else if (SDKManifestFilter.match(file.toString(), basePath)) {
                                files.add(file.toString());
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                if (!external || files.isEmpty()) {
                    folder = new File(String.valueOf(osPath) + basePath);
                    external = false;
                    pack.scan(files, folder, filter, filter.adapt(path, mask));
                }
                if (type.equals((Object)SourceTypeEnum.CPP_INCLUDE) && !nature.equals("org.eclipse.cdt.core.ccnature")) continue;
                if (type.equals((Object)SourceTypeEnum.C_INCLUDE)) {
                    nature.equals("org.eclipse.cdt.core.ccnature");
                }
                if (type.equals((Object)SourceTypeEnum.SRC_CPP) && !nature.equals("org.eclipse.cdt.core.ccnature") || type.equals((Object)SourceTypeEnum.SRC_C) && nature.equals("org.eclipse.cdt.core.ccnature")) continue;
                this.deleteFiles((IContainer)destFolder, pack, files, external, monitor);
                if (destFolder.exists() && destFolder.members().length == 0) {
                    this.updateEntries((IContainer)destFolder, projectParameters.getProject());
                    destFolder.delete(true, monitor);
                }
                if (!destFolder.getParent().exists() || destFolder.getParent().members().length != 0) continue;
                this.updateEntries(destFolder.getParent(), projectParameters.getProject());
                destFolder.getParent().delete(true, monitor);
            }
        }
    }

    private void updateEntries(IContainer destFolder, IProject project) throws CoreException {
        ICConfigurationDescription[] configDecriptions;
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.createProjectDescription(project, true);
        ArrayList<ICLanguageSettingEntry> includeEntries = new ArrayList<ICLanguageSettingEntry>();
        ArrayList<ICSourceEntry> sourceEntries = new ArrayList<ICSourceEntry>();
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDecriptions = des.getConfigurations();
        int n = configDecriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting[] settings;
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            ICFolderDescription projectRoot = configDescription.getRootFolderDescription();
            ICLanguageSetting[] iCLanguageSettingArray = settings = projectRoot.getLanguageSettings();
            int n3 = settings.length;
            int n4 = 0;
            while (n4 < n3) {
                ICLanguageSettingEntry[] oldEntries;
                ICLanguageSetting setting = iCLanguageSettingArray[n4];
                ICLanguageSettingEntry[] iCLanguageSettingEntryArray = oldEntries = setting.getSettingEntries(1);
                int n5 = oldEntries.length;
                int n6 = 0;
                while (n6 < n5) {
                    ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n6];
                    if (entry instanceof ICIncludePathEntry) {
                        ICIncludePathEntry path = (ICIncludePathEntry)entry;
                        if (path.getFullPath() != null && !path.getFullPath().toPortableString().endsWith(destFolder.getProjectRelativePath().toPortableString())) {
                            includeEntries.add(entry);
                        } else if (path.getFullPath() == null) {
                            includeEntries.add(entry);
                        }
                    }
                    ++n6;
                }
                setting.setSettingEntries(1, includeEntries.toArray(new ICLanguageSettingEntry[includeEntries.size()]));
                ++n4;
            }
            CConfigurationData data = configDescription.getConfigurationData();
            ICSourceEntry[] iCSourceEntryArray = data.getSourceEntries();
            int n7 = iCSourceEntryArray.length;
            n3 = 0;
            while (n3 < n7) {
                ICSourceEntry entry = iCSourceEntryArray[n3];
                if (!sourceEntries.contains(entry) && entry.getFullPath() != null && !entry.getFullPath().toPortableString().endsWith(destFolder.getProjectRelativePath().toPortableString())) {
                    sourceEntries.add(entry);
                }
                ++n3;
            }
            data.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[sourceEntries.size()]));
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(project, des);
    }

    public static enum SDKProviderType {
        PROVIDER_NORMAL,
        PROVIDER_DEFAULT,
        PROVIDER_INTERNAL,
        PROVIDER_PROJECT;

    }
}

