/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.internal.core;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.uct.core.ISDKProjectHandler;
import com.nxp.s32ds.cle.uct.core.Messages;
import com.nxp.s32ds.cle.uct.core.ProjectContextHelper;
import com.nxp.s32ds.cle.uct.core.ProjectUtils;
import com.nxp.s32ds.cle.uct.exceptions.SDKException;
import com.nxp.s32ds.cle.uct.internal.core.ProjectPropertiesManager;
import com.nxp.s32ds.cle.uct.manifest.xml.ComponentType;
import com.nxp.s32ds.cle.uct.manifest.xml.CoreType;
import com.nxp.s32ds.cle.uct.manifest.xml.DebugConfigurationType;
import com.nxp.s32ds.cle.uct.manifest.xml.DefineType;
import com.nxp.s32ds.cle.uct.manifest.xml.DeviceType;
import com.nxp.s32ds.cle.uct.manifest.xml.IdentifiableType;
import com.nxp.s32ds.cle.uct.manifest.xml.PackageType;
import com.nxp.s32ds.cle.uct.manifest.xml.SourceType;
import com.nxp.s32ds.cle.uct.providers.ISDKManifest;
import com.nxp.s32ds.cle.uct.providers.OptionValueHolder;
import com.nxp.s32ds.cle.uct.providers.ProjectParameters;
import com.nxp.s32ds.cle.uct.providers.SDKManifestProvider;
import com.nxp.s32ds.cle.uct.providers.SDKUIUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

public class SDKProjectHandler
implements ISDKProjectHandler {
    private IProject project;
    private ProjectContextHelper prjHelper;
    private Map<String, String> context;
    private ISharedConfiguration sharedCfg = SharedConfigurationFactory.getSharedConfigurationSingleton();
    private ISDKManifest manifest;
    private SDKManifestProvider provider;
    private DeviceType device;
    private CoreType core;
    protected static final Logger LOGGER = LogManager.getLogger(SDKProjectHandler.class);
    private static final String KEY_CORE_ID = "coreId";
    private static final String KEY_PROCESSOR = "processor";
    private static final String KEY_PART_NUMBER = "partNumber";
    private static final String KEY_TOOLCHAIN = "toolchain";
    private static final String KEY_TOOLCHAIN_ID = "toolchainId";
    private static final String KEY_SDK_PATH = "sdkPath";
    private static final String KEY_SDK_EXTERNAL_ID = "sdkExternalId";

    public SDKProjectHandler(IProject project, Map<String, String> context) {
        this.project = project;
        this.prjHelper = new ProjectContextHelper(project);
        this.context = this.resolveContext(context);
    }

    public SDKProjectHandler(IProject project) {
        this(project, null);
    }

    private Map<String, String> resolveContext(Map<String, String> context) {
        HashMap<String, String> resolved = new HashMap<String, String>();
        resolved.put(KEY_TOOLCHAIN, "Design Studio GCC");
        resolved.put(KEY_TOOLCHAIN_ID, "dsgcc");
        if (context != null) {
            DeviceCoreDescriptor descriptor;
            String deviceCoreId;
            String sdkPath;
            String sdkLocation = "";
            String sdkId = context.get("uctSdk");
            if (sdkId != null && !sdkId.isEmpty() && (sdkPath = context.get(sdkId)) != null) {
                try {
                    sdkLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(sdkPath, true);
                    resolved.put(KEY_SDK_PATH, sdkLocation);
                }
                catch (CoreException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (context.containsKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id") && (deviceCoreId = context.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id")) != null && !deviceCoreId.isEmpty() && (descriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId)) != null) {
                resolved.put(KEY_PROCESSOR, descriptor.getDeviceId());
                resolved.put(KEY_CORE_ID, descriptor.getCoreId());
                resolved.put(KEY_PART_NUMBER, descriptor.getId());
            }
            for (String key : context.keySet()) {
                String value = context.get(key);
                if ("core".equals(key)) {
                    DeviceCoreDescriptor descriptor2;
                    if (value == null || value.isEmpty() || (descriptor2 = DeviceDescriptors.getDeviceCoreDescriptor((String)value)) == null) continue;
                    resolved.put(KEY_PROCESSOR, descriptor2.getDeviceId());
                    resolved.put(KEY_CORE_ID, descriptor2.getCoreId());
                    resolved.put(KEY_PART_NUMBER, descriptor2.getId());
                    continue;
                }
                if (!KEY_SDK_EXTERNAL_ID.equals(key)) continue;
                resolved.put(KEY_SDK_EXTERNAL_ID, value);
            }
        }
        return resolved;
    }

    @Override
    public String getProjectName() {
        if (this.project != null) {
            return this.project.getName();
        }
        return null;
    }

    @Override
    public String getToolchainId() {
        String value = this.context.get(KEY_TOOLCHAIN_ID);
        if (value != null) {
            return value;
        }
        return null;
    }

    @Override
    public String getToolchain() {
        String value = this.context.get(KEY_TOOLCHAIN);
        if (value != null) {
            return value;
        }
        return null;
    }

    @Override
    public String getProcessor() {
        String value = this.context.get(KEY_PROCESSOR);
        if (value != null) {
            return value;
        }
        value = this.sharedCfg.getCommonConfig().getMcu();
        if (value != null) {
            return value;
        }
        return this.prjHelper.getProcessor();
    }

    @Override
    public String getPartNumber() {
        String value = this.context.get(KEY_PART_NUMBER);
        if (value != null) {
            return value;
        }
        return this.sharedCfg.getCommonConfig().getPackage();
    }

    @Override
    public String getSDKId() {
        ISDK sdk;
        String sdkId = this.context.get(KEY_SDK_EXTERNAL_ID);
        if (sdkId == null && (sdk = this.prjHelper.getSDK()) != null) {
            return sdk.getExternalId();
        }
        return sdkId;
    }

    @Override
    public String getSDKPath() {
        IEnvironment env;
        ISDK sdk;
        String path = this.context.get(KEY_SDK_PATH);
        if (path == null && (sdk = this.prjHelper.getSDK()) != null && (env = sdk.getHeader().getEnv()) != null && env.exists()) {
            try {
                return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(env.getValue(), true);
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return path;
    }

    @Override
    public String getCoreId() {
        String value = this.context.get(KEY_CORE_ID);
        if (value != null) {
            return value;
        }
        return null;
    }

    @Override
    public String getCoreId(Collection<ProcessorCore> cores) {
        return this.prjHelper.getCoreId(cores);
    }

    @Override
    public boolean addComponent(final List<String> ids, final boolean standalone, final boolean importOtherFiles, boolean updateCompMap, final boolean dontShowDialog) throws NullPointerException {
        final boolean[] result = new boolean[1];
        if (ids == null) {
            throw new NullPointerException();
        }
        result[0] = true;
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true);
        IRunnableWithProgress runnableProcess = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("S32 Config Tool project update: " + SDKProjectHandler.this.project.getName(), -1);
                    ArrayList components = new ArrayList();
                    ArrayList enabledComponents = new ArrayList();
                    ProjectParameters projectParameters = SDKProjectHandler.this.setupOperation(ids, components, enabledComponents, standalone, importOtherFiles, true, monitor);
                    projectParameters.setOptions(new HashMap<String, OptionValueHolder>());
                    if (!ids.isEmpty() && SDKProjectHandler.this.hasSources(projectParameters.getSources()) && (dontShowDialog || SDKUIUtils.openConfirmPrompt(Messages.SDKProjectHandler_AddFiles, projectParameters.getSources()))) {
                        SDKProjectHandler.this.provider.handleFiles(projectParameters, false, monitor);
                        SDKProjectHandler.this.setupEntries(projectParameters, true);
                        SDKProjectHandler.this.updateLibs(projectParameters);
                        SDKProjectHandler.this.updateDefines(components, projectParameters);
                        SDKProjectHandler.this.updateComponentsMap(enabledComponents, true);
                        SDKProjectHandler.this.project.refreshLocal(2, monitor);
                    }
                    monitor.done();
                    result[0] = true;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    result[0] = false;
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, true, runnableProcess);
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, Messages.SDKProjectHandler_SDKCompManagement, e);
            result[0] = false;
        }
        return result[0];
    }

    private void updateComponentsMap(List<ComponentType> enabledComponents, boolean add) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer buffer = new StringBuffer();
        String ec = ProjectPropertiesManager.getEntry(this.project, "sdkComponents");
        if (ec != null) {
            buffer.append(ec.trim());
        }
        String result = "";
        if (add) {
            for (ComponentType item : enabledComponents) {
                if (buffer.toString().contains(item.getId())) continue;
                buffer.append(String.valueOf(item.getId()) + ";");
            }
            result = buffer.toString();
        } else {
            result = buffer.toString();
            for (ComponentType item : enabledComponents) {
                if ((result = result.replace(String.valueOf(item.getId()) + ";", "")).length() != 0) continue;
                result = " ";
            }
        }
        map.put("sdkComponents", result);
        ProjectPropertiesManager.save(this.project, null, map, CoreModel.getDefault().getProjectDescription(this.project));
    }

    private void updateDefines(List<ComponentType> components, ProjectParameters projectParameters) throws CoreException, Exception {
        ICProject cProject = CoreModel.getDefault().create(this.project);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription desC = mngr.createProjectDescription(cProject.getProject(), true);
        boolean isCpp = ProjectUtils.isCppProject(desC.getProject());
        ArrayList<ComponentType> elements = new ArrayList<ComponentType>();
        elements.addAll(components);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = desC.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgs = iCConfigurationDescriptionArray[n2];
            IConfiguration conf = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgs);
            IToolChain toolchain = conf.getToolChain();
            HashMap<String, OptionValueHolder> options = new HashMap<String, OptionValueHolder>();
            IOption option = null;
            ITool[] iToolArray = toolchain.getTools();
            int n3 = iToolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool iTool = iToolArray[n4];
                option = isCpp ? iTool.getOptionById("gnu.cpp.compiler.option.preprocessor.def") : iTool.getOptionById("gnu.c.compiler.option.preprocessor.def.symbols");
                if (option != null) {
                    String[] values = (option = iTool.getOptionToSet(option, false)).getDefinedSymbols();
                    if (values == null) break;
                    OptionValueHolder holder = new OptionValueHolder();
                    String[] stringArray = values;
                    int n5 = values.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String value = stringArray[n6];
                        holder.add(value.replace("\"", "").trim());
                        ++n6;
                    }
                    options.put(option.getBaseId(), holder);
                    break;
                }
                ++n4;
            }
            for (IdentifiableType identifiableType : elements) {
                IdentifiableType.Defines defines = identifiableType.getDefines();
                if (defines == null || defines.getDefine() == null) continue;
                for (DefineType define : defines.getDefine()) {
                    if (define.getIdRefs().isEmpty()) {
                        SDKManifestProvider.addDefine(options, isCpp, define);
                        continue;
                    }
                    for (Object ref : define.getIdRefs()) {
                        if (!(ref instanceof DebugConfigurationType)) continue;
                        DebugConfigurationType debugCfg = (DebugConfigurationType)ref;
                        if (!cfgs.getId().toLowerCase().contains(debugCfg.getId())) continue;
                        SDKManifestProvider.addDefine(options, isCpp, define);
                    }
                }
            }
            if (option != null) {
                OptionValueHolder optionValueHolder = (OptionValueHolder)options.get(option.getBaseId());
                String[] array = optionValueHolder.getValues("com.nxp.s32ds.default.config").toArray(new String[optionValueHolder.getValues("com.nxp.s32ds.default.config").size()]);
                ManagedBuildManager.setOption((IConfiguration)conf, (IHoldsOptions)option.getOptionHolder(), (IOption)option, (String[])array);
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(this.project, desC);
        ManagedBuildManager.saveBuildInfo((IProject)this.project, (boolean)true);
    }

    private void updateLibs(ProjectParameters projectParameters) throws Exception {
        ICProject cProject = CoreModel.getDefault().create(this.project);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription desC = mngr.createProjectDescription(cProject.getProject(), true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = desC.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgs = iCConfigurationDescriptionArray[n2];
            IConfiguration conf = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgs);
            IToolChain toolchain = conf.getToolChain();
            ITool[] iToolArray = toolchain.getTools();
            int n3 = iToolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool tool = iToolArray[n4];
                SDKManifestProvider.setOption(conf, projectParameters.getOptions(), (IHoldsOptions)tool);
                ++n4;
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(this.project, desC);
        ManagedBuildManager.saveBuildInfo((IProject)this.project, (boolean)true);
    }

    private void setupEntries(ProjectParameters projectParameters, boolean add) throws CoreException {
        ICConfigurationDescription[] configDecriptions;
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.createProjectDescription(projectParameters.getProject(), true);
        List<ICSettingEntry> entries = projectParameters.getBuilderEntries();
        ArrayList<ICLanguageSettingEntry> includeEntries = new ArrayList<ICLanguageSettingEntry>();
        ICLanguageSettingEntry[] iCLanguageSettingEntryArray = SDKManifestProvider.getIncludes(entries);
        int n = iCLanguageSettingEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSettingEntry entry = iCLanguageSettingEntryArray[n2];
            includeEntries.add(entry);
            ++n2;
        }
        ArrayList<ICSourceEntry> newSourceEntries = new ArrayList<ICSourceEntry>();
        ICSourceEntry[] iCSourceEntryArray = SDKManifestProvider.getSources(entries);
        int n3 = iCSourceEntryArray.length;
        n = 0;
        while (n < n3) {
            ICSourceEntry entry = iCSourceEntryArray[n];
            newSourceEntries.add(entry);
            ++n;
        }
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDecriptions = des.getConfigurations();
        int n4 = configDecriptions.length;
        n3 = 0;
        while (n3 < n4) {
            ICLanguageSetting[] settings;
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n3];
            ICFolderDescription projectRoot = configDescription.getRootFolderDescription();
            ICLanguageSetting[] iCLanguageSettingArray = settings = projectRoot.getLanguageSettings();
            int n5 = settings.length;
            int n6 = 0;
            while (n6 < n5) {
                ICLanguageSettingEntry[] oldEntries;
                ICLanguageSetting setting = iCLanguageSettingArray[n6];
                ICLanguageSettingEntry[] iCLanguageSettingEntryArray2 = oldEntries = setting.getSettingEntries(1);
                int n7 = oldEntries.length;
                int n8 = 0;
                while (n8 < n7) {
                    ICLanguageSettingEntry entry = iCLanguageSettingEntryArray2[n8];
                    if (add) {
                        if (!includeEntries.contains(entry)) {
                            includeEntries.add(entry);
                        }
                    } else {
                        boolean entryFound = false;
                        Object[] objectArray = includeEntries.toArray();
                        int n9 = objectArray.length;
                        int n10 = 0;
                        while (n10 < n9) {
                            Object obj = objectArray[n10];
                            ICLanguageSettingEntry en = (ICLanguageSettingEntry)obj;
                            if (en.getValue().equals(entry.getValue())) {
                                includeEntries.remove(en);
                                entryFound = true;
                            }
                            ++n10;
                        }
                        if (!entryFound) {
                            includeEntries.add(entry);
                        }
                    }
                    ++n8;
                }
                setting.setSettingEntries(1, includeEntries.toArray(new ICLanguageSettingEntry[includeEntries.size()]));
                ++n6;
            }
            CConfigurationData data = configDescription.getConfigurationData();
            ArrayList<ICSourceEntry> sourceEntries = new ArrayList<ICSourceEntry>(Arrays.asList(data.getSourceEntries()));
            boolean newSourceEntryFound = false;
            for (ICSourceEntry entry : newSourceEntries) {
                if (this.sourceEntryExists(sourceEntries, entry)) continue;
                sourceEntries.add(entry);
                newSourceEntryFound = true;
            }
            if (newSourceEntryFound) {
                data.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[sourceEntries.size()]));
            }
            ++n3;
        }
        CoreModel.getDefault().setProjectDescription(projectParameters.getProject(), des);
    }

    private boolean sourceEntryExists(List<ICSourceEntry> entries, ICSourceEntry entry) {
        for (ICSourceEntry e : entries) {
            if (!e.getName().equals(entry.getName())) continue;
            return true;
        }
        return entries.contains(entry);
    }

    private ProjectParameters setupOperation(List<String> ids, List<ComponentType> components, List<ComponentType> enabledComponents, boolean standalone, boolean importOtherFiles, boolean addDependencies, IProgressMonitor monitor) throws Exception {
        String[] natures;
        if (this.manifest == null) {
            this.loadManifest();
        }
        for (String id : ids) {
            List<ComponentType> result = this.manifest.getComponentsById(id, false);
            if (!result.isEmpty()) {
                components.addAll(result);
                continue;
            }
            String message = NLS.bind((String)Messages.SDKProjectHandler_CannotFindComp, (Object)id, (Object)this.manifest.getManifestSimpleName());
            LOGGER.log(Level.WARNING, message);
        }
        String nature = "";
        IProjectDescription des = this.project.getDescription();
        String[] stringArray = natures = des.getNatureIds();
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (n3.equals("org.eclipse.cdt.core.cnature")) {
                nature = "org.eclipse.cdt.core.cnature";
                break;
            }
            if (n3.equals("org.eclipse.cdt.core.ccnature")) {
                nature = "org.eclipse.cdt.core.ccnature";
                break;
            }
            ++n2;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.project, (boolean)true);
        String pType = info.getManagedProject().getProjectType().getId();
        if (this.device == null) {
            this.device = SDKProjectHandler.getDevice(this.manifest, this.getProcessor());
        }
        PackageType pkg = this.device.getPackage().get(0);
        ArrayList<ICSettingEntry> entries = new ArrayList<ICSettingEntry>();
        ProjectParameters projectParameters = new ProjectParameters(this.manifest, this.device, this.core, pkg, null, this.project.getName(), null, nature, pType, standalone, components, false, null, true);
        projectParameters.setUseOtherFiles(importOtherFiles);
        IFolder srcFolder = this.project.getFolder("/src");
        if (!srcFolder.exists()) {
            srcFolder.create(true, true, monitor);
            entries.add((ICSettingEntry)new CSourceEntry(srcFolder.getName(), null, 4));
            entries.add((ICSettingEntry)this.provider.createIncludeEntry(srcFolder.getFullPath().toPortableString(), this.project.getName(), null, null, null));
        }
        IFolder docFolder = this.project.getFolder("/doc");
        srcFolder.refreshLocal(2, monitor);
        projectParameters.setSourceFolder(srcFolder);
        projectParameters.setDocFolder(docFolder);
        projectParameters.setProject(this.project);
        HashMap<ComponentType, List<SourceType>> sources = new HashMap<ComponentType, List<SourceType>>();
        this.provider.addDependency(this.manifest, this.device, this.core, null, "", sources, components, enabledComponents, false, addDependencies, null);
        projectParameters.setSources(sources);
        projectParameters.setBuilderEntries(entries);
        projectParameters.setEnabledComponents(enabledComponents);
        return projectParameters;
    }

    protected boolean hasSources(Map<ComponentType, List<SourceType>> map) {
        Set<ComponentType> keys = map.keySet();
        Iterator<ComponentType> it = keys.iterator();
        boolean hasSources = false;
        while (it.hasNext()) {
            ComponentType key = it.next();
            List<SourceType> value = map.get(key);
            if (value.isEmpty()) continue;
            hasSources = true;
        }
        return hasSources;
    }

    private void loadManifest() {
        this.manifest = this.getManifest();
        if (this.manifest != null) {
            this.provider = this.manifest.getProvider();
        }
    }

    @Override
    public ISDKManifest getLoadedManifest() {
        if (this.manifest == null) {
            this.loadManifest();
        }
        return this.manifest;
    }

    public ISDKManifest getManifest() {
        String sdkLocation = this.getSDKPath();
        if (sdkLocation != null) {
            SDKManifestProvider newProvider = null;
            try {
                for (SDKManifestProvider manProv : SDKManifestProvider.getInstance()) {
                    String currentLoc = new File(sdkLocation).getCanonicalPath();
                    if (!manProv.getLocation().getCanonicalPath().equals(currentLoc)) continue;
                    for (ISDKManifest pack : manProv.getManifests()) {
                        if (!pack.isActive()) continue;
                        return pack;
                    }
                }
                newProvider = new SDKManifestProvider(sdkLocation);
                newProvider.refresh();
            }
            catch (SDKException | IOException | JAXBException | SAXException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            if (newProvider != null) {
                for (ISDKManifest pack : newProvider.getManifests()) {
                    if (!pack.isActive()) continue;
                    return pack;
                }
            }
        } else {
            LOGGER.log(Level.SEVERE, "Error: could not find sdk path");
        }
        return null;
    }

    protected static String getEntry(ICStorageElement storage, String entry) {
        ICStorageElement[] settings = storage.getChildrenByName(entry);
        if (settings != null && settings.length != 0) {
            return settings[0].getValue();
        }
        return null;
    }

    public static DeviceType getDevice(ISDKManifest manifest, String chip) {
        DeviceType device = null;
        if (chip != null && manifest != null && manifest.isActive()) {
            for (DeviceType d : manifest.getDevices()) {
                if (!d.getId().equals(chip)) continue;
                device = d;
                break;
            }
        }
        return device;
    }

    @Override
    public boolean remComponent(final List<String> ids, final boolean dontShowDialog) throws NullPointerException {
        final boolean[] result = new boolean[1];
        if (ids == null) {
            throw new NullPointerException(Messages.SDKProjectHandler_NonNullIds);
        }
        result[0] = true;
        IRunnableWithProgress runnableProcess = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(String.valueOf(Messages.SDKProjectHandler_DelComponents) + SDKProjectHandler.this.project.getName(), -1);
                    ArrayList components = new ArrayList();
                    ArrayList enabledComponents = new ArrayList();
                    ProjectParameters projectParameters = SDKProjectHandler.this.setupOperation(ids, components, enabledComponents, true, true, true, monitor);
                    projectParameters.setOptions(new HashMap<String, OptionValueHolder>());
                    if (!ids.isEmpty() && SDKProjectHandler.this.hasSources(projectParameters.getSources()) && (dontShowDialog || SDKUIUtils.openConfirmPrompt(Messages.SDKProjectHandler_RemoveFiles, projectParameters.getSources()))) {
                        SDKProjectHandler.this.provider.handleFiles(projectParameters, false, monitor);
                        SDKProjectHandler.this.provider.deleteFiles(projectParameters, monitor);
                        SDKProjectHandler.this.setupEntries(projectParameters, false);
                        SDKProjectHandler.this.updateComponentsMap(enabledComponents, false);
                        SDKProjectHandler.this.project.refreshLocal(2, monitor);
                    }
                    monitor.done();
                    result[0] = true;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    result[0] = false;
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, true, runnableProcess);
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, Messages.SDKProjectHandler_SDKCompManagement, e);
            result[0] = false;
        }
        return result[0];
    }
}

