/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.internal.core;

import com.nxp.s32ds.cle.uct.providers.SDKManifestProvider;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ProjectPropertiesManager {
    public static final String COND_TOOLCHAIN_INCLUDES = "COND_TOOLCHAIN_INCLUDES";
    public static final String COND_TOOLCHAIN_LIBS = "COND_TOOLCHAIN_LIBRARIES";
    public static final String COND_TOOLCHAIN_LIBS_PATHS = "COND_TOOLCHAIN_LIBRARIES_PATHS";
    public static final String COND_TOOLCHAIN_DEFINES = "COND_TOOLCHAIN_DEFINES";
    public static final String COND_TOOLCHAIN_ASM_DEFINES = "COND_TOOLCHAIN_ASM_DEFINES";
    public static final String COND_TOOLCHAIN_CUSTOM_OPTION = "COND_TOOLCHAIN_CUSTOM_OPTION";
    public static final String COND_TOOLCHAIN_COMPONENTS_OPTION = "COND_TOOLCHAIN_COMPONENTS_OPTION";
    public static final String SEPARATOR = ";";
    public static final String CUSTOM_OP_SEPARATOR = "#";
    public static final String CUSTOM_OP_CONF_SEPARATOR = "$";
    public static final String EMPTY_STRING = "";
    public static final String LIBS_LINKER_OPTION = "gnu.c.link.option.libs";
    public static final String LIBS_PATH_LINKER_OPTION = "gnu.c.link.option.paths";
    public static final String DEFINE_CPP_OPTION = "gnu.cpp.compiler.option.preprocessor.def";
    public static final String DEFINE_C_OPTION = "gnu.c.compiler.option.preprocessor.def.symbols";
    public static final String DEFINE_ASM_OPTION = "com.freescale.s32ds.cross.gnu.tool.assembler.option.defs";
    public static final String DEFINE_ASM_OPTION_STRING = "option.defs";
    private static final Logger LOGGER = LogManager.getLogger(ProjectPropertiesManager.class);

    public static String getEntry(ICStorageElement storage, String entry) {
        ICStorageElement[] settings = storage.getChildrenByName(entry);
        if (settings != null && settings.length != 0) {
            return settings[0].getValue();
        }
        return null;
    }

    public static String getOneEntry(IProject project, String entry, String storageId) {
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project);
        return ProjectPropertiesManager.getOneEntry(project, projectDescription, entry, storageId);
    }

    public static String getOneEntry(IProject project, ICProjectDescription projectDescription, String entry, String storageId) {
        if (projectDescription != null) {
            try {
                ICStorageElement storage = projectDescription.getStorage(storageId, false);
                if (storage != null) {
                    return ProjectPropertiesManager.getEntry(storage, entry);
                }
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    public static String getEntry(IProject project, String entry) {
        ICProjectDescription projectDescription;
        if (project != null && "sdkName".equals(entry)) {
            try {
                String name = (String)project.getSessionProperty(SDKManifestProvider.MANIFEST_NAME_PROPERTY);
                if (name != null) {
                    return name;
                }
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if ((projectDescription = CoreModel.getDefault().getProjectDescription(project)) != null) {
            try {
                ICStorageElement storage = projectDescription.getStorage("com.nxp.s32ds.cle.uct.core", false);
                if (storage != null) {
                    String configEntry = ProjectPropertiesManager.getEntry(storage, entry);
                    return configEntry;
                }
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    public static void addOneEntry(IProject project, String entry, String value, String storageId) {
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project);
        if (projectDescription != null) {
            ProjectPropertiesManager.addOneEntry(project, projectDescription, entry, value, storageId);
            try {
                CoreModel.getDefault().setProjectDescription(project, projectDescription);
            }
            catch (CoreException e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    public static void addOneEntry(IProject project, ICProjectDescription projectDescription, String entry, String value, String storageId) {
        if (projectDescription != null) {
            try {
                ICStorageElement storage = projectDescription.getStorage(storageId, true);
                if (storage != null) {
                    ProjectPropertiesManager.addEntry(value, storage, entry);
                }
            }
            catch (CoreException e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    protected static void addEntry(String value, ICStorageElement storage, String entry) {
        ICStorageElement settings = null;
        ICStorageElement[] kids = storage.getChildren();
        int i = kids.length;
        while (i > 0) {
            if (kids[i - 1].getName().equals(entry)) {
                settings = kids[i - 1];
                break;
            }
            --i;
        }
        if (settings == null) {
            settings = storage.createChild(entry);
        }
        if (settings != null) {
            settings.setValue(value);
        }
    }

    public static void save(IProject project, Object data, Map<String, String> map, ICProjectDescription cachedProjectDescription) {
        try {
            ICProjectDescription projectDescription;
            boolean isCached = cachedProjectDescription != null;
            ICProjectDescription iCProjectDescription = projectDescription = isCached ? cachedProjectDescription : CoreModel.getDefault().getProjectDescription(project);
            if (projectDescription != null) {
                boolean reset;
                String inferred = (String)project.getSessionProperty(SDKManifestProvider.MANIFEST_NAME_PROPERTY);
                boolean bl = reset = project.getSessionProperty(SDKManifestProvider.PROP_RESET) != null ? (Boolean)project.getSessionProperty(SDKManifestProvider.PROP_RESET) : false;
                if (inferred != null && !reset) {
                    return;
                }
                ICStorageElement storage = projectDescription.getStorage("com.nxp.s32ds.cle.uct.core", true);
                if (storage != null) {
                    String role;
                    String core;
                    String pkg;
                    String boardId;
                    String components;
                    String exampleId = map.get("sdkExample");
                    if (exampleId != null && exampleId.length() != 0) {
                        ProjectPropertiesManager.addEntry(exampleId, storage, "sdkExample");
                    }
                    if ((components = map.get("sdkComponents")) != null && components.length() != 0) {
                        ProjectPropertiesManager.addEntry(components, storage, "sdkComponents");
                    }
                    if ((boardId = map.get("boardId")) != null && boardId.length() != 0) {
                        ProjectPropertiesManager.addEntry(boardId, storage, "boardId");
                    }
                    if ((pkg = map.get("package")) != null && pkg.length() != 0) {
                        ProjectPropertiesManager.addEntry(pkg, storage, "package");
                    }
                    if ((core = map.get("core")) != null && core.length() != 0) {
                        ProjectPropertiesManager.addEntry(core, storage, "core");
                    }
                    if ((role = map.get("role")) != null && role.length() != 0) {
                        ProjectPropertiesManager.addEntry(role, storage, "role");
                    }
                    CoreModel.getDefault().setProjectDescription(project, projectDescription);
                }
            }
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

