/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.core;

import com.freescale.s32ds.cross.core.ProjectContextSaver;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.nxp.s32ds.cle.uct.core.ProjectUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;

public class ProjectContextHelper {
    private IProject project;
    private ProjectContextSaver context;
    private static final String REXP_HWM_CORE_NAME = "cortex\\S*?(\\w+)";
    private static final String REXP_HWM_CORE_INDEX = "_(\\d{0,1}_*\\d{0,1})$";
    private static final String REXP_CORE_INDEX = "core(\\d{1})";
    private static final Logger LOGGER = LogManager.getLogger(ProjectContextHelper.class);

    public ProjectContextHelper(IProject project) {
        this.project = project;
        this.context = new ProjectContextSaver(project);
    }

    public String getCoreId(Collection<ProcessorCore> cores) {
        ProcessorCore core;
        int index;
        if (cores == null) {
            LOGGER.log(Level.INFO, "Cannot detect the core id, user will choose it");
            return null;
        }
        String hwCoreName = ProjectUtils.getStringByRegx(this.context.load("com.nxp.s32ds.cle.runtime.hardware.registry.core.id"), REXP_HWM_CORE_NAME);
        String hwCoreIndex = ProjectContextHelper.getCoreIndex(this.context.load("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id"), REXP_HWM_CORE_INDEX);
        String hwCoreIndexInBinary = null;
        try {
            hwCoreIndexInBinary = Integer.toString(Integer.parseInt(hwCoreIndex, 2));
        }
        catch (NumberFormatException numberFormatException) {}
        ArrayList<ProcessorCore> coresList = new ArrayList<ProcessorCore>();
        for (ProcessorCore core2 : cores) {
            String coreName = ProjectUtils.getStringByRegx(core2.getName(), REXP_HWM_CORE_NAME);
            if (hwCoreName == null || !hwCoreName.equalsIgnoreCase(coreName)) continue;
            if (hwCoreIndex == null || hwCoreIndex.equalsIgnoreCase(ProjectContextHelper.getCoreIndex(core2.getID(), REXP_HWM_CORE_INDEX))) {
                return core2.getID();
            }
            String coreIndex = ProjectContextHelper.getCoreIndex(core2.getID(), REXP_CORE_INDEX);
            if (coreIndex != null) {
                if (coreIndex.equalsIgnoreCase(hwCoreIndex)) {
                    return core2.getID();
                }
                if (coreIndex.equalsIgnoreCase(hwCoreIndexInBinary)) {
                    return core2.getID();
                }
            }
            coresList.add(core2);
        }
        if (hwCoreIndex != null && (index = Integer.parseInt(hwCoreIndex)) < coresList.size() && (core = (ProcessorCore)coresList.get(index)) != null) {
            return core.getID();
        }
        return null;
    }

    private static String getCoreIndex(String core, String rexp) {
        String c = ProjectUtils.getStringByRegx(core, rexp);
        if (c == null) {
            return null;
        }
        if (c.contains("_")) {
            return c.replaceFirst("_", "");
        }
        return c;
    }

    public ISDK getSDK() {
        ISDK sdk = null;
        String message = "";
        List sdksAttached = SDKAttach.getAttached((IProject)this.project);
        List sdksAll = SDKUtils.filter((ISDKFilter)SDKUtils.NO_FILTER);
        ISharedConfiguration cfg = SharedConfigurationFactory.getSharedConfigurationSingleton();
        String cfgProcessor = cfg.getCommonConfig().getMcuIdentification().getMcu();
        String cfgSdkVersion = cfg.getCommonConfig().getSdkVersion();
        if (!sdksAttached.isEmpty() && !cfg.isEmpty()) {
            sdk = this.getSdkFromConfig(sdksAttached, cfgProcessor, cfgSdkVersion);
            message = "(attached sdk, configuration created)";
        } else if (!sdksAttached.isEmpty() && cfg.isEmpty()) {
            sdk = this.getSdkFromProject(sdksAttached);
            message = "(attached sdk, no configuration created)";
        } else if (sdksAttached.isEmpty() && !cfg.isEmpty()) {
            sdk = this.getSdkFromConfig(sdksAll, cfgProcessor, cfgSdkVersion);
            message = "(no attached sdk, configuration created)";
        } else {
            sdk = this.getSdkFromProject(sdksAll);
        }
        message = sdk == null ? "SDK was not found (no attached sdk, no configuration created)" : "SDK was found " + sdk.getName() + " " + message;
        LOGGER.log(Level.INFO, message);
        return sdk;
    }

    private ISDK getSdkFromConfig(List<ISDK> sdks, String proc, String ver) {
        for (ISDK sdk : sdks) {
            String name = sdk.getName();
            String sdkId = sdk.getExternalId();
            if (name == null || !name.contains(proc) || !ver.equals(sdkId)) continue;
            return sdk;
        }
        return null;
    }

    private ISDK getSdkFromProject(List<ISDK> sdks) {
        String deviceCoreId = this.getProjectSaverValue("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        String deviceId = this.getProjectSaverValue("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        if (deviceCoreId.isEmpty() || deviceId.isEmpty()) {
            return null;
        }
        for (ISDK sdk : sdks) {
            String name = sdk.getName();
            if (name == null) {
                return null;
            }
            if (!name.matches(deviceCoreId) && !name.startsWith(deviceId)) continue;
            return sdk;
        }
        return null;
    }

    private String getProjectSaverValue(String key) {
        return this.context.load(key);
    }

    public String getProcessor() {
        return this.getProjectSaverValue("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
    }
}

