/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.debugger.internal.registry;

import com.nxp.s32ds.cle.ide.debugger.internal.registry.Messages;
import com.nxp.s32ds.cle.ide.debugger.registry.ArchetypeDebuggerLaunchConfigurationRegistry;
import com.nxp.s32ds.cle.ide.debugger.registry.descriptor.ArchetypeDebuggerLaunchConfigurationDescriptor;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ArchetypeDebuggerLaunchConfigurationRegistryImplementation
extends BaseRegistry
implements ArchetypeDebuggerLaunchConfigurationRegistry {
    Map<String, Collection<ArchetypeDebuggerLaunchConfigurationDescriptor>> archetype2descriptor = new HashMap<String, Collection<ArchetypeDebuggerLaunchConfigurationDescriptor>>();
    Map<String, Collection<ArchetypeDebuggerLaunchConfigurationDescriptor>> configuration2descriptor = new HashMap<String, Collection<ArchetypeDebuggerLaunchConfigurationDescriptor>>();

    @Override
    public Collection<ArchetypeDebuggerLaunchConfigurationDescriptor> getArchetypeDebugerConfigurationDescriptorByArchetype(String archetypeId) {
        return this.archetype2descriptor.get(archetypeId);
    }

    @Override
    public Collection<ArchetypeDebuggerLaunchConfigurationDescriptor> getArchetypeDebugerConfigurationDescriptorByConfigurationType(String configurationId) {
        return this.configuration2descriptor.get(configurationId);
    }

    @Override
    public ArchetypeDebuggerLaunchConfigurationDescriptor getArchetypeDebugerConfigurationDescriptor(String archetypeId, String configurationTypeId) {
        Collection<ArchetypeDebuggerLaunchConfigurationDescriptor> descriptorbyArchetype = this.archetype2descriptor.get(archetypeId);
        if (descriptorbyArchetype != null) {
            Optional<ArchetypeDebuggerLaunchConfigurationDescriptor> descriptor = descriptorbyArchetype.stream().filter(p -> p.getLaunchConfigurationTypeId().equals(configurationTypeId)).findFirst();
            if (descriptor.isPresent()) {
                return descriptor.get();
            }
            this.log(1, Messages.ArchetypeDebugerConfigurationRegistry_descriptor_not_found_error);
        } else {
            this.log(1, Messages.ArchetypeDebugerConfigurationRegistry_descriptor_not_found_error);
        }
        return null;
    }

    @Override
    public void addArchetypeDebugerConfigurationDescriptor(ArchetypeDebuggerLaunchConfigurationDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.archetype2descriptor, this.configuration2descriptor, ArchetypeDebuggerLaunchConfigurationDescriptor.class);
    }

    @Override
    public void remArchetypeDebugerConfigurationDescriptor(ArchetypeDebuggerLaunchConfigurationDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.archetype2descriptor, this.configuration2descriptor, ArchetypeDebuggerLaunchConfigurationDescriptor.class);
    }
}

