/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote;

import com.jcraft.jsch.Channel;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.internal.launch.remote.Activator;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteProcessAdapter;
import org.eclipse.remote.internal.jsch.core.JSchProcessBuilder;

public class RemoteHelper {
    private static final String EXIT_CMD = "exit";
    private static final String CMD_DELIMITER = ";";
    private static final String LOGOUT = "logout";

    public static IRemoteConnection getRemoteConnectionByName(String remoteConnection) {
        if (remoteConnection == null) {
            return null;
        }
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        if (manager == null) {
            return null;
        }
        List conns = manager.getAllRemoteConnections();
        for (IRemoteConnection conn : conns) {
            if (!conn.getName().contentEquals(remoteConnection)) continue;
            return conn;
        }
        return null;
    }

    public static IRemoteFileService getFileSubsystem(IRemoteConnection conn) {
        if (conn == null) {
            return null;
        }
        return (IRemoteFileService)conn.getService(IRemoteFileService.class);
    }

    public static IRemoteConnection[] getSuitableConnections() {
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        if (manager == null) {
            return null;
        }
        ArrayList<IRemoteConnection> suitableConnections = new ArrayList<IRemoteConnection>();
        List allConnections = manager.getAllRemoteConnections();
        for (IRemoteConnection conn : allConnections) {
            if (!conn.hasService(IRemoteCommandShellService.class)) continue;
            suitableConnections.add(conn);
        }
        return suitableConnections.toArray(new IRemoteConnection[0]);
    }

    public static void remoteFileDownload(ILaunchConfiguration config, ILaunch launch, String localExePath, String remoteExePath, IProgressMonitor monitor) throws CoreException {
        boolean skipDownload = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
        if (skipDownload) {
            return;
        }
        monitor.beginTask(Messages.RemoteRunLaunchDelegate_2, 100);
        try {
            IRemoteConnection conn = RemoteHelper.getCurrentConnection(config);
            IRemoteFileService fs = (IRemoteFileService)conn.getService(IRemoteFileService.class);
            IFileStore remoteFile = fs.getResource(remoteExePath);
            IFileSystem localfs = EFS.getLocalFileSystem();
            IFileStore localFile = localfs.getStore((IPath)new Path(localExePath));
            if (!localFile.fetchInfo().exists()) {
                return;
            }
            try {
                localFile.copy(remoteFile, 2, monitor);
                Process p = RemoteHelper.remoteShellExec(config, "", "chmod", "+x " + RemoteHelper.spaceEscapify(remoteExePath), (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                try {
                    int timeOut = 10;
                    boolean exited = p.waitFor(timeOut, TimeUnit.SECONDS);
                    if (!exited) {
                        Status status = new Status(4, "org.eclipse.cdt.launch.remote", 4, "Failed to change file permissions in the remote system, path: " + remoteExePath, null);
                        throw new CoreException((IStatus)status);
                    }
                }
                catch (InterruptedException e) {
                    Status status = new Status(4, "org.eclipse.cdt.launch.remote", 4, "Interrupted while changing file permissions in the remote system, path: " + remoteExePath, (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            catch (CoreException e) {
                RemoteHelper.abort(Messages.RemoteRunLaunchDelegate_6, e, 150);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    public static IRemoteConnection getCurrentConnection(ILaunchConfiguration config) throws CoreException {
        String remoteConnection = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, "");
        IRemoteConnection connection = RemoteHelper.getRemoteConnectionByName(remoteConnection);
        if (connection == null) {
            RemoteHelper.abort(Messages.RemoteRunLaunchDelegate_13, null, 150);
        }
        return connection;
    }

    public static Process remoteShellExec(ILaunchConfiguration config, String prelaunchCmd, String remoteCommandPath, String arguments, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.RemoteRunLaunchDelegate_8, (Object)remoteCommandPath, (Object)arguments), 10);
        String realRemoteCommand = arguments == null ? RemoteHelper.spaceEscapify(remoteCommandPath) : String.valueOf(RemoteHelper.spaceEscapify(remoteCommandPath)) + " " + arguments;
        String remoteCommand = String.valueOf(realRemoteCommand) + CMD_DELIMITER + EXIT_CMD + "\r\n";
        if (!prelaunchCmd.trim().equals("")) {
            remoteCommand = String.valueOf(prelaunchCmd) + CMD_DELIMITER + remoteCommand;
        }
        IRemoteConnection conn = RemoteHelper.getCurrentConnection(config);
        IRemoteCommandShellService shellService = (IRemoteCommandShellService)conn.getService(IRemoteCommandShellService.class);
        IRemoteProcess remoteProcess = null;
        RemoteProcessAdapter p = null;
        try {
            remoteProcess = shellService.getCommandShell(1);
            p = new RemoteProcessAdapter(remoteProcess);
            OutputStream os = remoteProcess.getOutputStream();
            InputStream is = p.getInputStream();
            os.write(remoteCommand.getBytes());
            RemoteHelper.waitForShellPrompt(((JSchProcessBuilder)remoteProcess.getProcessBuilder()).getChannel(), is);
            os.flush();
        }
        catch (Exception e) {
            RemoteHelper.abort(Messages.RemoteRunLaunchDelegate_7, e, 150);
        }
        monitor.done();
        return p;
    }

    public static IRemoteProcess execCmdInRemoteShell(ILaunchConfiguration config, String prelaunchCmd, String remoteCommandPath, String arguments, IProgressMonitor monitor) throws Exception {
        IRemoteConnection conn;
        monitor.beginTask(NLS.bind((String)Messages.RemoteRunLaunchDelegate_8, (Object)remoteCommandPath, (Object)arguments), 10);
        String realRemoteCommand = arguments == null ? RemoteHelper.spaceEscapify(remoteCommandPath) : String.valueOf(RemoteHelper.spaceEscapify(remoteCommandPath)) + " " + arguments;
        String remoteCommand = String.valueOf(realRemoteCommand) + CMD_DELIMITER + EXIT_CMD + "\r\n";
        if (!prelaunchCmd.trim().equals("")) {
            remoteCommand = String.valueOf(prelaunchCmd) + CMD_DELIMITER + remoteCommand;
        }
        if (!(conn = RemoteHelper.getCurrentConnection(config)).isOpen()) {
            conn.open(monitor);
        }
        IRemoteCommandShellService shellService = (IRemoteCommandShellService)conn.getService(IRemoteCommandShellService.class);
        IRemoteProcess p = null;
        p = shellService.getCommandShell(1);
        OutputStream os = p.getOutputStream();
        InputStream is = p.getInputStream();
        os.write(remoteCommand.getBytes());
        RemoteHelper.waitForShellPrompt(((JSchProcessBuilder)p.getProcessBuilder()).getChannel(), is);
        os.flush();
        monitor.done();
        return p;
    }

    public static String getRemoteHostname(ILaunchConfiguration config) throws CoreException {
        IRemoteConnection currentConnection = RemoteHelper.getCurrentConnection(config);
        IRemoteConnectionHostService hostService = (IRemoteConnectionHostService)currentConnection.getService(IRemoteConnectionHostService.class);
        return hostService.getHostname();
    }

    public static void abort(String message, Throwable exception, int code) throws CoreException {
        Status status;
        if (exception != null) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.cdt.launch.remote", code, message, exception);
            multiStatus.add((IStatus)new Status(4, "org.eclipse.cdt.launch.remote", code, exception.getLocalizedMessage(), exception));
            status = multiStatus;
        } else {
            status = new Status(4, "org.eclipse.cdt.launch.remote", code, message, null);
        }
        throw new CoreException((IStatus)status);
    }

    public static void waitForShellPrompt(Channel channel, InputStream is) throws Exception {
        int SIZE = 1024;
        byte[] buffer = new byte[SIZE];
        String line = "";
        while (true) {
            if (is.available() > 0) {
                int i = is.read(buffer, 0, 1024);
                if (i >= 0) {
                    line = new String(buffer, 0, i);
                    line = line.trim();
                    continue;
                }
            }
            if (line.contains(LOGOUT) || channel.isClosed() || !line.isEmpty() && (line.endsWith("#") || line.endsWith(">") || line.endsWith("$") || line.endsWith(":"))) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                RemoteHelper.abort(Messages.RemoteRunLaunchDelegate_7, e, 150);
            }
        }
    }
}

