/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.hardware.registry.core;

import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class HardwareRegistryCore {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.cle.ide.hardware.registry.core";
    static final String QUALIFIER_CROSSS_WIZARD = "com.freescale.s32ds.cross.wizard";
    static final String PROCESSOR_KEY = "processor";
    static final String CORE_KEY = "core";
    private static final String VALUE_DEFAULT = "";

    public static List<DeviceCoreDescriptor> getDeviceCoreDescriptors(IProject project) {
        String processorId = HardwareRegistryCore.getStoredProcessor(project);
        String coreId = HardwareRegistryCore.getStoredCore(project);
        List deviceCoreDescriptors = DeviceDescriptors.getDeviceRegistry().getDeviceCoreDescriptorsByDeviceId(processorId);
        for (DeviceCoreDescriptor deviceCoreDescriptor : deviceCoreDescriptors) {
            if (!deviceCoreDescriptor.getId().equals(coreId)) continue;
            return Collections.singletonList(deviceCoreDescriptor);
        }
        return Collections.emptyList();
    }

    static String getStoredProcessor(IProject project) {
        return HardwareRegistryCore.getCrossWizardValue(project, PROCESSOR_KEY);
    }

    static String getStoredCore(IProject project) {
        return HardwareRegistryCore.getCrossWizardValue(project, CORE_KEY);
    }

    static String getStoredCoreType(IProject project) {
        return HardwareRegistryCore.getCrossWizardValue(project, CORE_KEY);
    }

    static String getCrossWizardValue(IProject project, String key) {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        IScopeContext[] contexts = new IScopeContext[]{new ProjectScope(project)};
        String value = preferencesService.getString(QUALIFIER_CROSSS_WIZARD, key, VALUE_DEFAULT, contexts);
        return value;
    }
}

