/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.ui;

import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import com.nxp.s32ds.debug.ide.ui.SecureDebugDialogMessages;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SecureDebugDialog
extends TitleAreaDialog {
    private static final int SIGNIFICANT_SYMBOLS_NUMBER = 32;
    private static final Pattern PATTERN_HEX = Pattern.compile(String.format("^(0x)??(\\p{XDigit}{%d})$", 32));
    private final int DIALOG_WIDTH = 550;
    private final int DIALOG_HEIGHT = 30;
    private Button butOK;
    private Text txtPassword;
    private String keyWord = "";

    public SecureDebugDialog(Shell parentShell) {
        super(parentShell);
    }

    public Control createDialogArea(Composite parent) {
        Composite innerComposite = SWTUtils.createGridCellCompositeWithVerticalAndHorizontalMargin(parent, 1, 2, 5, 5);
        GridDataFactory.swtDefaults().hint(550, 30).applyTo((Control)innerComposite);
        SWTUtils.createLabelWithHorizontalSpan(innerComposite, SecureDebugDialogMessages.SecureDebugDialogKeyword_message, 1);
        this.txtPassword = SWTUtils.createWideText(innerComposite, 0x400804, true, 1);
        this.txtPassword.setEditable(true);
        this.txtPassword.addModifyListener(listener -> this.validate());
        this.getShell().setText(SecureDebugDialogMessages.SecureDebugDialogTitle_message);
        this.setHelpAvailable(false);
        this.setMessage(null);
        return innerComposite;
    }

    private void validate() {
        String pass = this.txtPassword.getText();
        if (this.butOK != null) {
            if (pass.isEmpty()) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(SecureDebugDialogMessages.SecureDebugDialogNoKeyword_message);
            } else if (!PATTERN_HEX.matcher(pass).matches()) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(SecureDebugDialogMessages.SecureDebugDialogKeywordWrongFormat_message);
            } else {
                this.butOK.setEnabled(true);
                this.setErrorMessage(null);
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        this.validate();
        this.getShell().pack();
        return butBar;
    }

    protected void okPressed() {
        this.keyWord = this.txtPassword.getText();
        super.okPressed();
    }

    public String getKeyword() {
        return this.keyWord;
    }
}

